/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerationActivePowerDistributionStep
implements ActivePowerDistribution.Step {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerationActivePowerDistributionStep.class);
    private final ParticipationType participationType;
    private final boolean useActiveLimits;

    public GenerationActivePowerDistributionStep(ParticipationType pParticipationType, boolean useActiveLimits) {
        this.participationType = pParticipationType;
        this.useActiveLimits = useActiveLimits;
    }

    @Override
    public String getElementType() {
        return "generation";
    }

    @Override
    public List<ParticipatingElement> getParticipatingElements(Collection<LfBus> buses) {
        return buses.stream().filter(bus -> bus.isParticipating() && !bus.isDisabled() && !bus.isFictitious()).flatMap(bus -> bus.getGenerators().stream()).filter(generator -> this.isParticipating((LfGenerator)generator) && this.getParticipationFactor((LfGenerator)generator) != 0.0).map(generator -> new ParticipatingElement(generator, this.getParticipationFactor((LfGenerator)generator))).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public double run(List<ParticipatingElement> participatingElements, int iteration, double remainingMismatch) {
        ParticipatingElement.normalizeParticipationFactors(participatingElements);
        double done = 0.0;
        double mismatch = remainingMismatch;
        if (iteration == 0) {
            for (ParticipatingElement participatingGenerator : participatingElements) {
                LfGenerator generator = (LfGenerator)participatingGenerator.getElement();
                done += generator.getInitialTargetP() - generator.getTargetP();
                mismatch -= generator.getInitialTargetP() - generator.getTargetP();
                generator.setTargetP(generator.getInitialTargetP());
            }
        }
        int modifiedBuses = 0;
        int generatorsAtMax = 0;
        int generatorsAtMin = 0;
        Iterator<ParticipatingElement> it = participatingElements.iterator();
        while (it.hasNext()) {
            ParticipatingElement participatingGenerator = it.next();
            LfGenerator generator = (LfGenerator)participatingGenerator.getElement();
            double factor = participatingGenerator.getFactor();
            double minTargetP = this.useActiveLimits ? generator.getMinTargetP() : -1.7976931348623157E308;
            double maxTargetP = this.useActiveLimits ? generator.getMaxTargetP() : Double.MAX_VALUE;
            double targetP = generator.getTargetP();
            if (targetP < 0.0) {
                maxTargetP = Math.min(maxTargetP, 0.0);
            } else {
                minTargetP = Math.max(minTargetP, 0.0);
            }
            double newTargetP = targetP + mismatch * factor;
            if (mismatch > 0.0 && newTargetP > maxTargetP) {
                newTargetP = maxTargetP;
                ++generatorsAtMax;
                it.remove();
            } else if (mismatch < 0.0 && newTargetP < minTargetP) {
                newTargetP = minTargetP;
                ++generatorsAtMin;
                it.remove();
            }
            if (newTargetP == targetP) continue;
            LOGGER.trace("Rescale '{}' active power target: {} -> {}", new Object[]{generator.getId(), targetP * 100.0, newTargetP * 100.0});
            generator.setTargetP(newTargetP);
            done += newTargetP - targetP;
            ++modifiedBuses;
        }
        LOGGER.debug("{} MW / {} MW distributed at iteration {} to {} generators ({} at max power, {} at min power)", new Object[]{done * 100.0, mismatch * 100.0, iteration, modifiedBuses, generatorsAtMax, generatorsAtMin});
        return done;
    }

    private double getParticipationFactor(LfGenerator generator) {
        return switch (this.participationType) {
            default -> throw new IncompatibleClassChangeError();
            case ParticipationType.MAX -> generator.getMaxTargetP() / generator.getDroop();
            case ParticipationType.TARGET -> Math.abs(generator.getTargetP());
            case ParticipationType.PARTICIPATION_FACTOR -> generator.getParticipationFactor();
            case ParticipationType.REMAINING_MARGIN -> Math.max(0.0, generator.getMaxTargetP() - generator.getTargetP());
        };
    }

    private boolean isParticipating(LfGenerator generator) {
        if (!generator.isParticipating()) {
            return false;
        }
        switch (this.participationType) {
            case MAX: {
                return generator.getDroop() != 0.0;
            }
            case PARTICIPATION_FACTOR: {
                return generator.getParticipationFactor() > 0.0;
            }
            case TARGET: 
            case REMAINING_MARGIN: {
                return true;
            }
        }
        throw new UnsupportedOperationException("Unknown balance type mode: " + this.participationType);
    }

    public static enum ParticipationType {
        MAX,
        TARGET,
        PARTICIPATION_FACTOR,
        REMAINING_MARGIN;

    }
}

