/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadActivePowerDistributionStep
implements ActivePowerDistribution.Step {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadActivePowerDistributionStep.class);
    private final boolean loadPowerFactorConstant;

    public LoadActivePowerDistributionStep(boolean loadPowerFactorConstant) {
        this.loadPowerFactorConstant = loadPowerFactorConstant;
    }

    @Override
    public String getElementType() {
        return "load";
    }

    @Override
    public List<ParticipatingElement> getParticipatingElements(Collection<LfBus> buses) {
        return buses.stream().filter(bus -> bus.isParticipating() && !bus.isDisabled() && !bus.isFictitious()).flatMap(bus -> bus.getLoads().stream()).map(load -> new ParticipatingElement(load, this.getParticipationFactor((LfLoad)load))).collect(Collectors.toCollection(LinkedList::new));
    }

    private double getParticipationFactor(LfLoad load) {
        return load.getAbsVariableTargetP();
    }

    @Override
    public double run(List<ParticipatingElement> participatingElements, int iteration, double remainingMismatch) {
        ParticipatingElement.normalizeParticipationFactors(participatingElements);
        double done = 0.0;
        int modifiedBuses = 0;
        int loadsAtMin = 0;
        for (ParticipatingElement participatingBus : participatingElements) {
            LfLoad load = (LfLoad)participatingBus.getElement();
            double factor = participatingBus.getFactor();
            double loadTargetP = load.getTargetP();
            double newLoadTargetP = loadTargetP - remainingMismatch * factor;
            if (newLoadTargetP == loadTargetP) continue;
            LOGGER.trace("Rescale '{}' active power target: {} -> {}", new Object[]{load.getId(), loadTargetP * 100.0, newLoadTargetP * 100.0});
            if (this.loadPowerFactorConstant) {
                LoadActivePowerDistributionStep.ensurePowerFactorConstant(load, newLoadTargetP);
            }
            load.setTargetP(newLoadTargetP);
            done += loadTargetP - newLoadTargetP;
            ++modifiedBuses;
        }
        LOGGER.debug("{} MW / {} MW distributed at iteration {} to {} buses ({} at min consumption)", new Object[]{-done * 100.0, -remainingMismatch * 100.0, iteration, modifiedBuses, loadsAtMin});
        return done;
    }

    private static void ensurePowerFactorConstant(LfLoad load, double newLoadTargetP) {
        double newLoadTargetQ = load.ensurePowerFactorConstantByLoad() ? load.calculateNewTargetQ(newLoadTargetP - load.getInitialTargetP()) : newLoadTargetP * load.getTargetQ() / load.getTargetP();
        if (newLoadTargetQ != load.getTargetQ()) {
            LOGGER.trace("Rescale '{}' reactive power target on load: {} -> {}", new Object[]{load.getId(), load.getTargetQ() * 100.0, newLoadTargetQ * 100.0});
            load.setTargetQ(newLoadTargetQ);
        }
    }
}

