/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfLoad;
import java.util.List;

public class ParticipatingElement {
    private final Object element;
    private double factor;

    public ParticipatingElement(Object element, double factor) {
        this.element = element;
        this.factor = factor;
    }

    public Object getElement() {
        return this.element;
    }

    public double getFactor() {
        return this.factor;
    }

    public double getTargetP() {
        Object object = this.element;
        if (object instanceof LfGenerator) {
            LfGenerator generator = (LfGenerator)object;
            return generator.getTargetP();
        }
        object = this.element;
        if (object instanceof LfLoad) {
            LfLoad load = (LfLoad)object;
            return load.getTargetP();
        }
        return Double.NaN;
    }

    public static double participationFactorNorm(List<ParticipatingElement> participatingElements) {
        return participatingElements.stream().mapToDouble(participatingGenerator -> participatingGenerator.factor).sum();
    }

    public static void normalizeParticipationFactors(List<ParticipatingElement> participatingElements) {
        double factorSum = ParticipatingElement.participationFactorNorm(participatingElements);
        for (ParticipatingElement participatingElement : participatingElements) {
            participatingElement.factor /= factorSum;
        }
    }

    public LfBus getLfBus() {
        Object object = this.element;
        if (object instanceof LfGenerator) {
            LfGenerator generator = (LfGenerator)object;
            return generator.getBus();
        }
        object = this.element;
        if (object instanceof LfLoad) {
            LfLoad load = (LfLoad)object;
            return load.getBus();
        }
        return null;
    }
}

