/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LoadFlowModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;

public class ZeroImpedanceFlows {
    private final Graph<LfBus, LfBranch> graph;
    private final SpanningTreeAlgorithm.SpanningTree<LfBranch> tree;
    private final LoadFlowModel loadFlowModel;

    public ZeroImpedanceFlows(Graph<LfBus, LfBranch> zeroImpedanceSubGraph, SpanningTreeAlgorithm.SpanningTree<LfBranch> spanningTree, LoadFlowModel loadFlowModel) {
        this.graph = zeroImpedanceSubGraph;
        this.tree = spanningTree;
        this.loadFlowModel = loadFlowModel;
    }

    public void compute() {
        HashSet processed = new HashSet();
        this.graph.vertexSet().stream().sorted(Comparator.comparingInt(LfElement::getNum)).forEach(lfBus -> {
            if (processed.contains(lfBus)) {
                return;
            }
            TreeByLevels treeByLevels = new TreeByLevels(this.graph, this.tree, (LfBus)lfBus);
            treeByLevels.updateFlows(this.loadFlowModel);
            processed.addAll(treeByLevels.getProcessedLfBuses());
        });
        this.graph.edgeSet().stream().filter(branch -> !this.tree.getEdges().contains(branch)).forEach(branch -> branch.updateFlows(0.0, 0.0, 0.0, 0.0));
    }

    private static final class TreeByLevels {
        private final LfBus lfBus;
        private final List<List<LfBus>> levels;
        private final Map<LfBus, LfBranch> parent;
        private final List<LfBus> processedLfBuses;

        private TreeByLevels(Graph<LfBus, LfBranch> graph, SpanningTreeAlgorithm.SpanningTree<LfBranch> tree, LfBus lfBus) {
            this.lfBus = lfBus;
            this.levels = new ArrayList<List<LfBus>>();
            this.parent = new HashMap<LfBus, LfBranch>();
            this.processedLfBuses = new ArrayList<LfBus>();
            this.createTreeByLevels(graph, tree);
        }

        private List<LfBus> getProcessedLfBuses() {
            return this.processedLfBuses;
        }

        private void createTreeByLevels(Graph<LfBus, LfBranch> graph, SpanningTreeAlgorithm.SpanningTree<LfBranch> tree) {
            this.levels.add(new ArrayList<LfBus>(Collections.singleton(this.lfBus)));
            this.processedLfBuses.add(this.lfBus);
            for (int level = 0; level < this.levels.size(); ++level) {
                ArrayList nextLevel = new ArrayList();
                for (LfBus bus : this.levels.get(level)) {
                    graph.edgesOf((Object)bus).stream().filter(branch -> tree.getEdges().contains(branch) && !TreeByLevels.isParentBranch(this.parent, bus, branch)).forEach(childrenBranch -> {
                        LfBus otherBus = TreeByLevels.getOtherSideBus(childrenBranch, bus);
                        nextLevel.add(otherBus);
                        this.parent.put(otherBus, (LfBranch)childrenBranch);
                    });
                }
                if (nextLevel.isEmpty()) continue;
                this.levels.add(nextLevel);
                this.processedLfBuses.addAll(nextLevel);
            }
        }

        private static boolean isParentBranch(Map<LfBus, LfBranch> parent, LfBus bus, LfBranch branch) {
            return parent.containsKey(bus) && parent.get(bus).equals(branch);
        }

        private static LfBus getOtherSideBus(LfBranch branch, LfBus bus) {
            return branch.getBus1().equals(bus) ? branch.getBus2() : branch.getBus1();
        }

        private void updateFlows(LoadFlowModel loadFlowModel) {
            HashMap descendantZeroImpedanceFlow = new HashMap();
            for (int level = this.levels.size() - 1; level >= 1; --level) {
                this.levels.get(level).forEach(bus -> {
                    PQ balance = this.balanceWithImpedance((LfBus)bus, loadFlowModel);
                    PQ z0flow = this.getDescendantZeroImpedanceFlow(descendantZeroImpedanceFlow, (LfBus)bus);
                    PQ branchFlow = balance.add(z0flow);
                    LfBranch branch = this.parent.get(bus);
                    this.updateBranchFlows(branch, (LfBus)bus, branchFlow.negate(), branchFlow);
                    descendantZeroImpedanceFlow.merge(TreeByLevels.getOtherSideBus(branch, bus), branchFlow, PQ::add);
                });
            }
        }

        private PQ balanceWithImpedance(LfBus bus, LoadFlowModel loadFlowModel) {
            double pShunt = TreeByLevels.getPShunt(bus.getShunt()) + TreeByLevels.getPShunt(bus.getControllerShunt()) + TreeByLevels.getPShunt(bus.getSvcShunt());
            double qShunt = TreeByLevels.getQShunt(bus.getShunt()) + TreeByLevels.getQShunt(bus.getControllerShunt()) + TreeByLevels.getQShunt(bus.getSvcShunt());
            PQ balancePQ = new PQ(-bus.getP().eval() + pShunt, -bus.getQ().eval() + qShunt);
            List<LfBranch> adjacentBranchesWithImpedance = bus.getBranches().stream().filter(branch -> !branch.isZeroImpedance(loadFlowModel)).collect(Collectors.toList());
            adjacentBranchesWithImpedance.forEach(branch -> {
                PQ branchFlow = this.getBranchFlow((LfBranch)branch, bus);
                balancePQ.p += branchFlow.p;
                balancePQ.q += branchFlow.q;
            });
            return balancePQ;
        }

        private static double getPShunt(Optional<LfShunt> optionalLfShunt) {
            return optionalLfShunt.map(shunt -> shunt.getP().eval()).filter(val -> !Double.isNaN(val)).orElse(0.0);
        }

        private static double getQShunt(Optional<LfShunt> optionalLfShunt) {
            return optionalLfShunt.map(shunt -> shunt.getQ().eval()).filter(val -> !Double.isNaN(val)).orElse(0.0);
        }

        private PQ getDescendantZeroImpedanceFlow(Map<LfBus, PQ> descendantZeroImpedanceFlow, LfBus bus) {
            return descendantZeroImpedanceFlow.containsKey(bus) ? descendantZeroImpedanceFlow.get(bus) : new PQ(0.0, 0.0);
        }

        private void updateBranchFlows(LfBranch branch, LfBus bus, PQ pqBus, PQ pqOtherBus) {
            if (branch.getBus1() != null && branch.getBus1().equals(bus)) {
                branch.updateFlows(pqBus.p, pqBus.q, pqOtherBus.p, pqOtherBus.q);
            } else {
                branch.updateFlows(pqOtherBus.p, pqOtherBus.q, pqBus.p, pqBus.q);
            }
        }

        private PQ getBranchFlow(LfBranch branch, LfBus bus) {
            if (branch.getBus1() != null && branch.getBus1().equals(bus)) {
                return new PQ(branch.getP1().eval(), branch.getQ1().eval());
            }
            return new PQ(branch.getP2().eval(), branch.getQ2().eval());
        }
    }

    private static final class PQ {
        private double p;
        private double q;

        private PQ(double p, double q) {
            this.p = p;
            this.q = q;
        }

        private PQ add(PQ pq) {
            return new PQ(this.p + pq.p, this.q + pq.q);
        }

        private PQ negate() {
            return new PQ(-this.p, -this.q);
        }
    }
}

