/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.LfStarBus;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.monitor.StateMonitorIndex;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class AbstractNetworkResult {
    protected final LfNetwork network;
    protected final StateMonitorIndex monitorIndex;
    protected final boolean createResultExtension;
    protected final List<BusResult> busResults = new ArrayList<BusResult>();
    protected final List<ThreeWindingsTransformerResult> threeWindingsTransformerResults = new ArrayList<ThreeWindingsTransformerResult>();

    protected AbstractNetworkResult(LfNetwork network, StateMonitorIndex monitorIndex, boolean createResultExtension) {
        this.network = Objects.requireNonNull(network);
        this.monitorIndex = Objects.requireNonNull(monitorIndex);
        this.createResultExtension = createResultExtension;
    }

    protected void addResults(StateMonitor monitor, Consumer<LfBranch> branchConsumer) {
        Objects.requireNonNull(monitor);
        if (!monitor.getBranchIds().isEmpty()) {
            this.network.getBranches().stream().filter(lfBranch -> !lfBranch.isDisabled()).forEach(lfBranch -> {
                for (String originalId : lfBranch.getOriginalIds()) {
                    if (!monitor.getBranchIds().contains(originalId)) continue;
                    branchConsumer.accept((LfBranch)lfBranch);
                    break;
                }
            });
        }
        if (!monitor.getVoltageLevelIds().isEmpty()) {
            this.network.getBuses().stream().filter(lfBus -> monitor.getVoltageLevelIds().contains(lfBus.getVoltageLevelId())).filter(lfBus -> !lfBus.isDisabled()).forEach(lfBus -> this.busResults.addAll(lfBus.createBusResults()));
        }
        if (!monitor.getThreeWindingsTransformerIds().isEmpty()) {
            monitor.getThreeWindingsTransformerIds().stream().filter(id -> this.network.getBusById(LfStarBus.getId(id)) != null && !this.network.getBusById(LfStarBus.getId(id)).isDisabled()).forEach(id -> this.threeWindingsTransformerResults.add(LfLegBranch.createThreeWindingsTransformerResult(this.network, id, this.createResultExtension)));
        }
    }

    protected void clear() {
        this.busResults.clear();
        this.threeWindingsTransformerResults.clear();
    }

    public List<BusResult> getBusResults() {
        return this.busResults;
    }

    public List<ThreeWindingsTransformerResult> getThreeWindingsTransformerResults() {
        return this.threeWindingsTransformerResults;
    }

    public abstract List<BranchResult> getBranchResults();

    public abstract void update();
}

