/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.google.common.base.Stopwatch;
import com.powsybl.action.Action;
import com.powsybl.action.GeneratorAction;
import com.powsybl.action.HvdcAction;
import com.powsybl.action.LoadAction;
import com.powsybl.action.PhaseTapChangerTapPositionAction;
import com.powsybl.action.RatioTapChangerTapPositionAction;
import com.powsybl.action.ShuntCompensatorPositionAction;
import com.powsybl.action.SwitchAction;
import com.powsybl.action.TerminalsConnectionAction;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.CompletableFutureTask;
import com.powsybl.computation.ComputationManager;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.Contingency;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.lf.LoadFlowContext;
import com.powsybl.openloadflow.lf.LoadFlowEngine;
import com.powsybl.openloadflow.lf.LoadFlowResult;
import com.powsybl.openloadflow.network.LfAction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.NetworkState;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.network.impl.PropagatedContingencyCreationParameters;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.sa.LimitViolationManager;
import com.powsybl.openloadflow.sa.OpenSecurityAnalysisParameters;
import com.powsybl.openloadflow.sa.PostContingencyNetworkResult;
import com.powsybl.openloadflow.sa.PreContingencyNetworkResult;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationsResult;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.condition.AllViolationCondition;
import com.powsybl.security.condition.AtLeastOneViolationCondition;
import com.powsybl.security.limitreduction.LimitReduction;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.monitor.StateMonitorIndex;
import com.powsybl.security.results.ConnectivityResult;
import com.powsybl.security.results.NetworkResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.PreContingencyResult;
import com.powsybl.security.strategy.ConditionalActions;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityAnalysis<V extends Enum<V>, E extends Enum<E>, P extends AbstractLoadFlowParameters<P>, C extends LoadFlowContext<V, E, P>, R extends LoadFlowResult> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSecurityAnalysis.class);
    protected final Network network;
    protected final MatrixFactory matrixFactory;
    protected final GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory;
    protected final StateMonitorIndex monitorIndex;
    protected final ReportNode reportNode;
    private static final String NOT_FOUND = "' not found in the network";

    protected AbstractSecurityAnalysis(Network network, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, List<StateMonitor> stateMonitors, ReportNode reportNode) {
        this.network = Objects.requireNonNull(network);
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        this.connectivityFactory = Objects.requireNonNull(connectivityFactory);
        this.monitorIndex = new StateMonitorIndex(stateMonitors);
        this.reportNode = Objects.requireNonNull(reportNode);
    }

    protected static SecurityAnalysisResult createNoResult() {
        return new SecurityAnalysisResult(new LimitViolationsResult(Collections.emptyList()), LoadFlowResult.ComponentResult.Status.FAILED, Collections.emptyList());
    }

    public CompletableFuture<SecurityAnalysisReport> run(String workingVariantId, SecurityAnalysisParameters securityAnalysisParameters, ContingenciesProvider contingenciesProvider, ComputationManager computationManager, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions) {
        Objects.requireNonNull(workingVariantId);
        Objects.requireNonNull(securityAnalysisParameters);
        Objects.requireNonNull(contingenciesProvider);
        return CompletableFutureTask.runAsync(() -> {
            this.network.getVariantManager().setWorkingVariant(workingVariantId);
            return this.runSync(securityAnalysisParameters, contingenciesProvider, operatorStrategies, actions, limitReductions);
        }, (Executor)computationManager.getExecutor());
    }

    protected abstract ReportNode createSaRootReportNode();

    protected abstract boolean isShuntCompensatorVoltageControlOn(LoadFlowParameters var1);

    protected abstract P createParameters(LoadFlowParameters var1, OpenLoadFlowParameters var2, boolean var3);

    SecurityAnalysisReport runSync(SecurityAnalysisParameters securityAnalysisParameters, ContingenciesProvider contingenciesProvider, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions) {
        ReportNode saReportNode = this.createSaRootReportNode();
        Stopwatch stopwatch = Stopwatch.createStarted();
        LoadFlowParameters lfParameters = securityAnalysisParameters.getLoadFlowParameters();
        OpenLoadFlowParameters lfParametersExt = OpenLoadFlowParameters.get(securityAnalysisParameters.getLoadFlowParameters());
        OpenSecurityAnalysisParameters securityAnalysisParametersExt = OpenSecurityAnalysisParameters.getOrDefault(securityAnalysisParameters);
        AbstractSecurityAnalysis.checkActions(this.network, actions);
        LfTopoConfig topoConfig = new LfTopoConfig();
        AbstractSecurityAnalysis.findAllSwitchesToOperate(this.network, actions, topoConfig);
        AbstractSecurityAnalysis.findAllPtcToOperate(actions, topoConfig);
        AbstractSecurityAnalysis.findAllRtcToOperate(actions, topoConfig);
        AbstractSecurityAnalysis.findAllShuntsToOperate(actions, topoConfig);
        AbstractSecurityAnalysis.findAllBranchesToClose(this.network, actions, topoConfig);
        List contingencies = contingenciesProvider.getContingencies(this.network);
        PropagatedContingencyCreationParameters creationParameters = new PropagatedContingencyCreationParameters().setContingencyPropagation(securityAnalysisParametersExt.isContingencyPropagation()).setShuntCompensatorVoltageControlOn(this.isShuntCompensatorVoltageControlOn(lfParameters)).setSlackDistributionOnConformLoad(lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setHvdcAcEmulation(lfParameters.isHvdcAcEmulation());
        List<PropagatedContingency> propagatedContingencies = PropagatedContingency.createList(this.network, contingencies, topoConfig, creationParameters);
        P parameters = this.createParameters(lfParameters, lfParametersExt, topoConfig.isBreaker());
        try (LfNetworkList lfNetworks = Networks.load(this.network, ((AbstractLoadFlowParameters)parameters).getNetworkParameters(), topoConfig, saReportNode);){
            SecurityAnalysisResult result = lfNetworks.getLargest().filter(n -> n.getValidity() == LfNetwork.Validity.VALID).map(largestNetwork -> this.runSimulations((LfNetwork)largestNetwork, propagatedContingencies, parameters, securityAnalysisParameters, operatorStrategies, actions, limitReductions)).orElse(AbstractSecurityAnalysis.createNoResult());
            stopwatch.stop();
            LOGGER.info("Security analysis {} in {} ms", (Object)(Thread.currentThread().isInterrupted() ? "cancelled" : "done"), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            SecurityAnalysisReport securityAnalysisReport = new SecurityAnalysisReport(result);
            return securityAnalysisReport;
        }
    }

    protected abstract PostContingencyComputationStatus postContingencyStatusFromLoadFlowResult(R var1);

    protected static void checkActions(Network network, List<Action> actions) {
        block19: for (Action action : actions) {
            switch (action.getType()) {
                case "SWITCH": {
                    SwitchAction switchAction = (SwitchAction)action;
                    if (network.getSwitch(switchAction.getSwitchId()) != null) continue block19;
                    throw new PowsyblException("Switch '" + switchAction.getSwitchId() + NOT_FOUND);
                }
                case "TERMINALS_CONNECTION": {
                    TerminalsConnectionAction terminalsConnectionAction = (TerminalsConnectionAction)action;
                    if (network.getBranch(terminalsConnectionAction.getElementId()) != null) continue block19;
                    throw new PowsyblException("Branch '" + terminalsConnectionAction.getElementId() + NOT_FOUND);
                }
                case "PHASE_TAP_CHANGER_TAP_POSITION": 
                case "RATIO_TAP_CHANGER_TAP_POSITION": {
                    String transformerId = action.getType().equals("PHASE_TAP_CHANGER_TAP_POSITION") ? ((PhaseTapChangerTapPositionAction)action).getTransformerId() : ((RatioTapChangerTapPositionAction)action).getTransformerId();
                    if (network.getTwoWindingsTransformer(transformerId) != null || network.getThreeWindingsTransformer(transformerId) != null) continue block19;
                    throw new PowsyblException("Transformer '" + transformerId + NOT_FOUND);
                }
                case "LOAD": {
                    LoadAction loadAction = (LoadAction)action;
                    if (network.getLoad(loadAction.getLoadId()) != null) continue block19;
                    throw new PowsyblException("Load '" + loadAction.getLoadId() + NOT_FOUND);
                }
                case "GENERATOR": {
                    GeneratorAction generatorAction = (GeneratorAction)action;
                    if (network.getGenerator(generatorAction.getGeneratorId()) != null) continue block19;
                    throw new PowsyblException("Generator '" + generatorAction.getGeneratorId() + NOT_FOUND);
                }
                case "HVDC": {
                    HvdcAction hvdcAction = (HvdcAction)action;
                    if (network.getHvdcLine(hvdcAction.getHvdcId()) != null) continue block19;
                    throw new PowsyblException("Hvdc line '" + hvdcAction.getHvdcId() + NOT_FOUND);
                }
                case "SHUNT_COMPENSATOR_POSITION": {
                    ShuntCompensatorPositionAction shuntCompensatorPositionAction = (ShuntCompensatorPositionAction)action;
                    if (network.getShuntCompensator(shuntCompensatorPositionAction.getShuntCompensatorId()) != null) continue block19;
                    throw new PowsyblException("Shunt compensator '" + shuntCompensatorPositionAction.getShuntCompensatorId() + "' not found");
                }
            }
            throw new UnsupportedOperationException("Unsupported action type: " + action.getType());
        }
    }

    protected static Map<String, LfAction> createLfActions(LfNetwork lfNetwork, Set<Action> actions, Network network, LfNetworkParameters parameters) {
        return actions.stream().map(action -> LfAction.create(action, lfNetwork, network, parameters.isBreakers())).flatMap(Optional::stream).collect(Collectors.toMap(LfAction::getId, Function.identity()));
    }

    protected static Map<String, Action> indexActionsById(List<Action> actions) {
        return actions.stream().collect(Collectors.toMap(Action::getId, Function.identity(), (action1, action2) -> {
            throw new PowsyblException("An action '" + action1.getId() + "' already exist");
        }));
    }

    protected static Map<String, List<OperatorStrategy>> indexOperatorStrategiesByContingencyId(List<PropagatedContingency> propagatedContingencies, List<OperatorStrategy> operatorStrategies, Map<String, Action> actionsById, Set<Action> neededActions) {
        Set contingencyIds = propagatedContingencies.stream().map(propagatedContingency -> propagatedContingency.getContingency().getId()).collect(Collectors.toSet());
        HashMap<String, List<OperatorStrategy>> operatorStrategiesByContingencyId = new HashMap<String, List<OperatorStrategy>>();
        for (OperatorStrategy operatorStrategy : operatorStrategies) {
            if (contingencyIds.contains(operatorStrategy.getContingencyContext().getContingencyId())) {
                for (ConditionalActions conditionalActions : operatorStrategy.getConditionalActions()) {
                    for (String actionId : conditionalActions.getActionIds()) {
                        Action action = actionsById.get(actionId);
                        if (action == null) {
                            throw new PowsyblException("Operator strategy '" + operatorStrategy.getId() + "' is associated to action '" + actionId + "' but this action is not present in the list");
                        }
                        neededActions.add(action);
                    }
                }
                operatorStrategiesByContingencyId.computeIfAbsent(operatorStrategy.getContingencyContext().getContingencyId(), key -> new ArrayList()).add(operatorStrategy);
                continue;
            }
            throw new PowsyblException("Operator strategy '" + operatorStrategy.getId() + "' is associated to contingency '" + operatorStrategy.getContingencyContext().getContingencyId() + "' but this contingency is not present in the list");
        }
        return operatorStrategiesByContingencyId;
    }

    private static boolean checkCondition(ConditionalActions conditionalActions, Set<String> limitViolationEquipmentIds) {
        switch (conditionalActions.getCondition().getType()) {
            case "TRUE_CONDITION": {
                return true;
            }
            case "ANY_VIOLATION_CONDITION": {
                return !limitViolationEquipmentIds.isEmpty();
            }
            case "AT_LEAST_ONE_VIOLATION": {
                AtLeastOneViolationCondition atLeastCondition = (AtLeastOneViolationCondition)conditionalActions.getCondition();
                Set commonEquipmentIds = atLeastCondition.getViolationIds().stream().distinct().filter(limitViolationEquipmentIds::contains).collect(Collectors.toSet());
                return !commonEquipmentIds.isEmpty();
            }
            case "ALL_VIOLATION": {
                AllViolationCondition allCondition = (AllViolationCondition)conditionalActions.getCondition();
                Set commonEquipmentIds = allCondition.getViolationIds().stream().distinct().filter(limitViolationEquipmentIds::contains).collect(Collectors.toSet());
                return commonEquipmentIds.equals(new HashSet(allCondition.getViolationIds()));
            }
        }
        throw new UnsupportedOperationException("Unsupported condition type: " + conditionalActions.getCondition().getType());
    }

    protected List<String> checkCondition(OperatorStrategy operatorStrategy, LimitViolationsResult limitViolationsResult) {
        Set<String> limitViolationEquipmentIds = limitViolationsResult.getLimitViolations().stream().map(LimitViolation::getSubjectId).collect(Collectors.toSet());
        ArrayList<String> actionsIds = new ArrayList<String>();
        for (ConditionalActions conditionalActions : operatorStrategy.getConditionalActions()) {
            if (!AbstractSecurityAnalysis.checkCondition(conditionalActions, limitViolationEquipmentIds)) continue;
            actionsIds.addAll(conditionalActions.getActionIds());
        }
        return actionsIds;
    }

    protected static void findAllSwitchesToOperate(Network network, List<Action> actions, LfTopoConfig topoConfig) {
        actions.stream().filter(action -> action.getType().equals("SWITCH")).forEach(action -> {
            String switchId = ((SwitchAction)action).getSwitchId();
            Switch sw = network.getSwitch(switchId);
            boolean toOpen = ((SwitchAction)action).isOpen();
            if (sw.isOpen() && !toOpen) {
                topoConfig.getSwitchesToClose().add(sw);
            } else if (!sw.isOpen() && toOpen) {
                topoConfig.getSwitchesToOpen().add(sw);
            }
        });
    }

    protected static void findAllPtcToOperate(List<Action> actions, LfTopoConfig topoConfig) {
        for (Action action : actions) {
            if (!"PHASE_TAP_CHANGER_TAP_POSITION".equals(action.getType())) continue;
            PhaseTapChangerTapPositionAction ptcAction = (PhaseTapChangerTapPositionAction)action;
            ptcAction.getSide().ifPresentOrElse(side -> topoConfig.addBranchIdWithPtcToRetain(LfLegBranch.getId(side, ptcAction.getTransformerId())), () -> topoConfig.addBranchIdWithPtcToRetain(ptcAction.getTransformerId()));
        }
    }

    protected static void findAllRtcToOperate(List<Action> actions, LfTopoConfig topoConfig) {
        for (Action action : actions) {
            if (!"RATIO_TAP_CHANGER_TAP_POSITION".equals(action.getType())) continue;
            RatioTapChangerTapPositionAction rtcAction = (RatioTapChangerTapPositionAction)action;
            rtcAction.getSide().ifPresentOrElse(side -> topoConfig.addBranchIdWithRtcToRetain(LfLegBranch.getId(side, rtcAction.getTransformerId())), () -> topoConfig.addBranchIdWithRtcToRetain(rtcAction.getTransformerId()));
        }
    }

    protected static void findAllShuntsToOperate(List<Action> actions, LfTopoConfig topoConfig) {
        actions.stream().filter(action -> action.getType().equals("SHUNT_COMPENSATOR_POSITION")).forEach(action -> topoConfig.addShuntIdToOperate(((ShuntCompensatorPositionAction)action).getShuntCompensatorId()));
    }

    protected static void findAllBranchesToClose(Network network, List<Action> actions, LfTopoConfig topoConfig) {
        for (Action action : actions) {
            Branch branch;
            TerminalsConnectionAction terminalsConnectionAction;
            if (!"TERMINALS_CONNECTION".equals(action.getType()) || !(terminalsConnectionAction = (TerminalsConnectionAction)action).getSide().isEmpty() || terminalsConnectionAction.isOpen() || (branch = network.getBranch(terminalsConnectionAction.getElementId())) == null || branch instanceof TieLine || branch.getTerminal1().isConnected() || branch.getTerminal2().isConnected()) continue;
            topoConfig.getBranchIdsToClose().add(terminalsConnectionAction.getElementId());
        }
    }

    protected static void distributedMismatch(LfNetwork network, double mismatch, LoadFlowParameters loadFlowParameters, OpenLoadFlowParameters openLoadFlowParameters) {
        if (loadFlowParameters.isDistributedSlack() && Math.abs(mismatch) > 0.0) {
            ActivePowerDistribution activePowerDistribution = ActivePowerDistribution.create(loadFlowParameters.getBalanceType(), openLoadFlowParameters.isLoadPowerFactorConstant(), openLoadFlowParameters.isUseActiveLimits());
            activePowerDistribution.run(network, mismatch);
        }
    }

    protected abstract C createLoadFlowContext(LfNetwork var1, P var2);

    protected abstract LoadFlowEngine<V, E, P, R> createLoadFlowEngine(C var1);

    protected void afterPreContingencySimulation(P acParameters) {
    }

    protected SecurityAnalysisResult runSimulations(LfNetwork lfNetwork, List<PropagatedContingency> propagatedContingencies, P acParameters, SecurityAnalysisParameters securityAnalysisParameters, List<OperatorStrategy> operatorStrategies, List<Action> actions, List<LimitReduction> limitReductions) {
        Map<String, Action> actionsById = AbstractSecurityAnalysis.indexActionsById(actions);
        HashSet<Action> neededActions = new HashSet<Action>(actionsById.size());
        Map<String, List<OperatorStrategy>> operatorStrategiesByContingencyId = AbstractSecurityAnalysis.indexOperatorStrategiesByContingencyId(propagatedContingencies, operatorStrategies, actionsById, neededActions);
        Map<String, LfAction> lfActionById = AbstractSecurityAnalysis.createLfActions(lfNetwork, neededActions, this.network, ((AbstractLoadFlowParameters)acParameters).getNetworkParameters());
        LoadFlowParameters loadFlowParameters = securityAnalysisParameters.getLoadFlowParameters();
        OpenLoadFlowParameters openLoadFlowParameters = OpenLoadFlowParameters.get(loadFlowParameters);
        OpenSecurityAnalysisParameters openSecurityAnalysisParameters = OpenSecurityAnalysisParameters.getOrDefault(securityAnalysisParameters);
        boolean createResultExtension = openSecurityAnalysisParameters.isCreateResultExtension();
        try (C context = this.createLoadFlowContext(lfNetwork, acParameters);){
            ReportNode networkReportNode = lfNetwork.getReportNode();
            ReportNode preContSimReportNode = Reports.createPreContingencySimulation(networkReportNode);
            lfNetwork.setReportNode(preContSimReportNode);
            R preContingencyLoadFlowResult = this.createLoadFlowEngine(context).run();
            boolean preContingencyComputationOk = preContingencyLoadFlowResult.isSuccess();
            LimitViolationManager preContingencyLimitViolationManager = new LimitViolationManager(limitReductions);
            ArrayList postContingencyResults = new ArrayList();
            PreContingencyNetworkResult preContingencyNetworkResult = new PreContingencyNetworkResult(lfNetwork, this.monitorIndex, createResultExtension);
            ArrayList operatorStrategyResults = new ArrayList();
            if (preContingencyComputationOk) {
                this.afterPreContingencySimulation(acParameters);
                preContingencyNetworkResult.update();
                preContingencyLimitViolationManager.detectViolations(lfNetwork);
                NetworkState networkState = NetworkState.save(lfNetwork);
                Iterator<PropagatedContingency> contingencyIt = propagatedContingencies.iterator();
                while (contingencyIt.hasNext() && !Thread.currentThread().isInterrupted()) {
                    PropagatedContingency propagatedContingency = contingencyIt.next();
                    propagatedContingency.toLfContingency(lfNetwork).ifPresent(lfContingency -> {
                        ReportNode postContSimReportNode = Reports.createPostContingencySimulation(networkReportNode, lfContingency.getId());
                        lfNetwork.setReportNode(postContSimReportNode);
                        lfContingency.apply(loadFlowParameters.getBalanceType());
                        AbstractSecurityAnalysis.distributedMismatch(lfNetwork, lfContingency.getActivePowerLoss(), loadFlowParameters, openLoadFlowParameters);
                        PostContingencyResult postContingencyResult = this.runPostContingencySimulation(lfNetwork, context, propagatedContingency.getContingency(), (LfContingency)lfContingency, preContingencyLimitViolationManager, securityAnalysisParameters.getIncreasedViolationsParameters(), preContingencyNetworkResult, createResultExtension, limitReductions);
                        postContingencyResults.add(postContingencyResult);
                        List operatorStrategiesForThisContingency = (List)operatorStrategiesByContingencyId.get(lfContingency.getId());
                        if (operatorStrategiesForThisContingency != null) {
                            if (operatorStrategiesForThisContingency.size() == 1) {
                                OperatorStrategy operatorStrategy = (OperatorStrategy)operatorStrategiesForThisContingency.get(0);
                                ReportNode osSimReportNode = Reports.createOperatorStrategySimulation(postContSimReportNode, operatorStrategy.getId());
                                lfNetwork.setReportNode(osSimReportNode);
                                this.runActionSimulation(lfNetwork, context, operatorStrategy, preContingencyLimitViolationManager, securityAnalysisParameters.getIncreasedViolationsParameters(), lfActionById, createResultExtension, (LfContingency)lfContingency, postContingencyResult.getLimitViolationsResult(), acParameters.getNetworkParameters(), limitReductions).ifPresent(operatorStrategyResults::add);
                            } else {
                                NetworkState postContingencyNetworkState = NetworkState.save(lfNetwork);
                                for (OperatorStrategy operatorStrategy : operatorStrategiesForThisContingency) {
                                    ReportNode osSimReportNode = Reports.createOperatorStrategySimulation(postContSimReportNode, operatorStrategy.getId());
                                    lfNetwork.setReportNode(osSimReportNode);
                                    this.runActionSimulation(lfNetwork, context, operatorStrategy, preContingencyLimitViolationManager, securityAnalysisParameters.getIncreasedViolationsParameters(), lfActionById, createResultExtension, (LfContingency)lfContingency, postContingencyResult.getLimitViolationsResult(), acParameters.getNetworkParameters(), limitReductions).ifPresent(result -> {
                                        operatorStrategyResults.add(result);
                                        postContingencyNetworkState.restore();
                                    });
                                }
                            }
                        }
                        if (contingencyIt.hasNext()) {
                            networkState.restore();
                        }
                    });
                }
            }
            SecurityAnalysisResult securityAnalysisResult = new SecurityAnalysisResult(new PreContingencyResult(preContingencyLoadFlowResult.toComponentResultStatus().status(), new LimitViolationsResult(preContingencyLimitViolationManager.getLimitViolations()), preContingencyNetworkResult.getBranchResults(), preContingencyNetworkResult.getBusResults(), preContingencyNetworkResult.getThreeWindingsTransformerResults()), postContingencyResults, operatorStrategyResults);
            return securityAnalysisResult;
        }
    }

    private Optional<OperatorStrategyResult> runActionSimulation(LfNetwork network, C context, OperatorStrategy operatorStrategy, LimitViolationManager preContingencyLimitViolationManager, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters, Map<String, LfAction> lfActionById, boolean createResultExtension, LfContingency contingency, LimitViolationsResult postContingencyLimitViolations, LfNetworkParameters networkParameters, List<LimitReduction> limitReductions) {
        OperatorStrategyResult operatorStrategyResult = null;
        List<String> actionIds = this.checkCondition(operatorStrategy, postContingencyLimitViolations);
        if (!actionIds.isEmpty()) {
            operatorStrategyResult = this.runActionSimulation(network, context, operatorStrategy, actionIds, preContingencyLimitViolationManager, violationsParameters, lfActionById, createResultExtension, contingency, networkParameters, limitReductions);
        }
        return Optional.ofNullable(operatorStrategyResult);
    }

    protected PostContingencyResult runPostContingencySimulation(LfNetwork network, C context, Contingency contingency, LfContingency lfContingency, LimitViolationManager preContingencyLimitViolationManager, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters, PreContingencyNetworkResult preContingencyNetworkResult, boolean createResultExtension, List<LimitReduction> limitReductions) {
        LOGGER.info("Start post contingency '{}' simulation on network {}", (Object)lfContingency.getId(), (Object)network);
        LOGGER.debug("Contingency '{}' impact on network {}: remove {} buses, remove {} branches, remove {} generators, shift {} shunts, shift {} loads", new Object[]{lfContingency.getId(), network, lfContingency.getDisabledNetwork().getBuses(), lfContingency.getDisabledNetwork().getBranchesStatus(), lfContingency.getLostGenerators(), lfContingency.getShuntsShift(), lfContingency.getLostLoads()});
        Stopwatch stopwatch = Stopwatch.createStarted();
        PostContingencyComputationStatus status = this.runActionLoadFlow(context);
        LimitViolationManager postContingencyLimitViolationManager = new LimitViolationManager(preContingencyLimitViolationManager, limitReductions, violationsParameters);
        PostContingencyNetworkResult postContingencyNetworkResult = new PostContingencyNetworkResult(network, this.monitorIndex, createResultExtension, preContingencyNetworkResult, contingency);
        if (status.equals((Object)PostContingencyComputationStatus.CONVERGED)) {
            postContingencyNetworkResult.update();
            postContingencyLimitViolationManager.detectViolations(network);
        }
        stopwatch.stop();
        LOGGER.info("Post contingency '{}' simulation done on network {} in {} ms", new Object[]{lfContingency.getId(), network, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        ConnectivityResult connectivityResult = new ConnectivityResult(lfContingency.getCreatedSynchronousComponentsCount(), 0, lfContingency.getDisconnectedLoadActivePower() * 100.0, lfContingency.getDisconnectedGenerationActivePower() * 100.0, lfContingency.getDisconnectedElementIds());
        return new PostContingencyResult(contingency, status, new LimitViolationsResult(postContingencyLimitViolationManager.getLimitViolations()), postContingencyNetworkResult.getBranchResults(), postContingencyNetworkResult.getBusResults(), postContingencyNetworkResult.getThreeWindingsTransformerResults(), connectivityResult);
    }

    protected OperatorStrategyResult runActionSimulation(LfNetwork network, C context, OperatorStrategy operatorStrategy, List<String> actionsIds, LimitViolationManager preContingencyLimitViolationManager, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters, Map<String, LfAction> lfActionById, boolean createResultExtension, LfContingency contingency, LfNetworkParameters networkParameters, List<LimitReduction> limitReductions) {
        LOGGER.info("Start operator strategy {} after contingency '{}' simulation on network {}", new Object[]{operatorStrategy.getId(), operatorStrategy.getContingencyContext().getContingencyId(), network});
        List<LfAction> operatorStrategyLfActions = actionsIds.stream().map(lfActionById::get).filter(Objects::nonNull).collect(Collectors.toList());
        LfAction.apply(operatorStrategyLfActions, network, contingency, networkParameters);
        Stopwatch stopwatch = Stopwatch.createStarted();
        PostContingencyComputationStatus status = this.runActionLoadFlow(context);
        LimitViolationManager postActionsViolationManager = new LimitViolationManager(preContingencyLimitViolationManager, limitReductions, violationsParameters);
        PreContingencyNetworkResult postActionsNetworkResult = new PreContingencyNetworkResult(network, this.monitorIndex, createResultExtension);
        if (status.equals((Object)PostContingencyComputationStatus.CONVERGED)) {
            postActionsNetworkResult.update();
            postActionsViolationManager.detectViolations(network);
        }
        stopwatch.stop();
        LOGGER.info("Operator strategy {} after contingency '{}' simulation done on network {} in {} ms", new Object[]{operatorStrategy.getId(), operatorStrategy.getContingencyContext().getContingencyId(), network, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        return new OperatorStrategyResult(operatorStrategy, status, new LimitViolationsResult(postActionsViolationManager.getLimitViolations()), new NetworkResult(postActionsNetworkResult.getBranchResults(), postActionsNetworkResult.getBusResults(), postActionsNetworkResult.getThreeWindingsTransformerResults()));
    }

    protected void beforeActionLoadFlowRun(C context) {
    }

    protected PostContingencyComputationStatus runActionLoadFlow(C context) {
        this.beforeActionLoadFlowRun(context);
        R result = this.createLoadFlowEngine(context).run();
        return this.postContingencyStatusFromLoadFlowResult(result);
    }
}

