/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.AcloadFlowEngine;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import com.powsybl.openloadflow.sa.AbstractSecurityAnalysis;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.security.PostContingencyComputationStatus;
import com.powsybl.security.monitor.StateMonitor;
import java.util.List;

public class AcSecurityAnalysis
extends AbstractSecurityAnalysis<AcVariableType, AcEquationType, AcLoadFlowParameters, AcLoadFlowContext, AcLoadFlowResult> {
    protected AcSecurityAnalysis(Network network, MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, List<StateMonitor> stateMonitors, ReportNode reportNode) {
        super(network, matrixFactory, connectivityFactory, stateMonitors, reportNode);
    }

    @Override
    protected ReportNode createSaRootReportNode() {
        return Reports.createAcSecurityAnalysis(this.reportNode, this.network.getId());
    }

    @Override
    protected boolean isShuntCompensatorVoltageControlOn(LoadFlowParameters lfParameters) {
        return lfParameters.isShuntCompensatorVoltageControlOn();
    }

    @Override
    protected AcLoadFlowParameters createParameters(LoadFlowParameters lfParameters, OpenLoadFlowParameters lfParametersExt, boolean breakers) {
        AcLoadFlowParameters acParameters = OpenLoadFlowParameters.createAcParameters(this.network, lfParameters, lfParametersExt, this.matrixFactory, this.connectivityFactory, breakers, false);
        if (acParameters.getNetworkParameters().getMaxSlackBusCount() > 1) {
            LOGGER.warn("Multiple slack buses in a security analysis is not supported, force to 1");
        }
        acParameters.getNetworkParameters().setCacheEnabled(false).setReferenceBusSelector(ReferenceBusSelector.DEFAULT_SELECTOR).setMaxSlackBusCount(1);
        acParameters.setDetailedReport(lfParametersExt.getReportedFeatures().contains((Object)OpenLoadFlowParameters.ReportedFeatures.NEWTON_RAPHSON_SECURITY_ANALYSIS));
        return acParameters;
    }

    @Override
    protected AcLoadFlowContext createLoadFlowContext(LfNetwork lfNetwork, AcLoadFlowParameters parameters) {
        return new AcLoadFlowContext(lfNetwork, parameters);
    }

    protected AcloadFlowEngine createLoadFlowEngine(AcLoadFlowContext context) {
        return new AcloadFlowEngine(context);
    }

    @Override
    protected void afterPreContingencySimulation(AcLoadFlowParameters acParameters) {
        if (OpenLoadFlowParameters.SlackDistributionFailureBehavior.THROW == acParameters.getSlackDistributionFailureBehavior()) {
            acParameters.setSlackDistributionFailureBehavior(OpenLoadFlowParameters.SlackDistributionFailureBehavior.FAIL);
        }
    }

    public static PostContingencyComputationStatus postContingencyStatusFromAcLoadFlowResult(AcLoadFlowResult result) {
        if (result.getOuterLoopResult().status() == OuterLoopStatus.UNSTABLE) {
            return PostContingencyComputationStatus.MAX_ITERATION_REACHED;
        }
        if (result.getOuterLoopResult().status() == OuterLoopStatus.FAILED) {
            return PostContingencyComputationStatus.FAILED;
        }
        return switch (result.getSolverStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case AcSolverStatus.CONVERGED -> PostContingencyComputationStatus.CONVERGED;
            case AcSolverStatus.MAX_ITERATION_REACHED -> PostContingencyComputationStatus.MAX_ITERATION_REACHED;
            case AcSolverStatus.SOLVER_FAILED -> PostContingencyComputationStatus.SOLVER_FAILED;
            case AcSolverStatus.NO_CALCULATION -> PostContingencyComputationStatus.NO_IMPACT;
            case AcSolverStatus.UNREALISTIC_STATE -> PostContingencyComputationStatus.FAILED;
        };
    }

    @Override
    protected PostContingencyComputationStatus postContingencyStatusFromLoadFlowResult(AcLoadFlowResult result) {
        return AcSecurityAnalysis.postContingencyStatusFromAcLoadFlowResult(result);
    }

    @Override
    protected void beforeActionLoadFlowRun(AcLoadFlowContext context) {
        ((AcLoadFlowParameters)context.getParameters()).setVoltageInitializer(new PreviousValueVoltageInitializer(true));
    }
}

