/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.security.LimitViolation;
import com.powsybl.security.LimitViolationType;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.limitreduction.LimitReduction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.tuple.Pair;

public class LimitViolationManager {
    private final LimitViolationManager reference;
    private final LimitReductionManager limitReductionManager;
    private SecurityAnalysisParameters.IncreasedViolationsParameters parameters;
    private final Map<Object, LimitViolation> violations = new LinkedHashMap<Object, LimitViolation>();

    public LimitViolationManager(LimitViolationManager reference, List<LimitReduction> limitReductions, SecurityAnalysisParameters.IncreasedViolationsParameters parameters) {
        this.reference = reference;
        if (reference != null) {
            this.parameters = Objects.requireNonNull(parameters);
        }
        this.limitReductionManager = LimitReductionManager.create(limitReductions);
    }

    public LimitViolationManager(List<LimitReduction> limitReductions) {
        this(null, limitReductions, null);
    }

    public List<LimitViolation> getLimitViolations() {
        return new ArrayList<LimitViolation>(this.violations.values());
    }

    public void detectViolations(LfNetwork network) {
        Objects.requireNonNull(network);
        network.getBranches().stream().filter(b -> !b.isDisabled()).forEach(this::detectBranchViolations);
        network.getBuses().stream().filter(b -> !b.isDisabled()).forEach(this::detectBusViolations);
        network.getVoltageAngleLimits().stream().filter(limit -> !limit.getFrom().isDisabled() && !limit.getTo().isDisabled()).forEach(this::detectVoltageAngleLimitViolations);
    }

    private static Pair<String, ThreeSides> getSubjectIdSide(LimitViolation limitViolation) {
        return Pair.of((Object)limitViolation.getSubjectId(), (Object)limitViolation.getSide());
    }

    private void addLimitViolation(LimitViolation limitViolation, Object key) {
        if (this.reference != null) {
            LimitViolation referenceLimitViolation = this.reference.violations.get(key);
            if (referenceLimitViolation == null || !LimitViolationManager.violationWeakenedOrEquivalent(referenceLimitViolation, limitViolation, this.parameters)) {
                this.violations.put(key, limitViolation);
            }
        } else {
            this.violations.put(key, limitViolation);
        }
    }

    private void addBranchLimitViolation(LimitViolation limitViolation) {
        this.addLimitViolation(limitViolation, LimitViolationManager.getSubjectIdSide(limitViolation));
    }

    private void addBusLimitViolation(LimitViolation limitViolation, LfBus bus) {
        this.addLimitViolation(limitViolation, bus.getId());
    }

    private void addVoltageAngleLimitViolation(LimitViolation limitViolation, LfNetwork.LfVoltageAngleLimit voltageAngleLimit) {
        this.addLimitViolation(limitViolation, voltageAngleLimit.getId());
    }

    private void detectBranchSideViolations(LfBranch branch, LfBus bus, TriFunction<LfBranch, LimitType, LimitReductionManager, List<LfBranch.LfLimit>> limitsGetter, Function<LfBranch, Evaluable> iGetter, Function<LfBranch, Evaluable> pGetter, ToDoubleFunction<LfBranch> sGetter, TwoSides side) {
        double s;
        List limits = (List)limitsGetter.apply((Object)branch, (Object)LimitType.CURRENT, (Object)this.limitReductionManager);
        if (!limits.isEmpty()) {
            double i = iGetter.apply(branch).eval();
            limits.stream().filter(temporaryLimit -> i > temporaryLimit.getReducedValue()).findFirst().map(temporaryLimit -> LimitViolationManager.createLimitViolation(branch, temporaryLimit, LimitViolationType.CURRENT, PerUnit.ib(bus.getNominalV()), i, side)).ifPresent(this::addBranchLimitViolation);
        }
        if (!(limits = (List)limitsGetter.apply((Object)branch, (Object)LimitType.ACTIVE_POWER, (Object)this.limitReductionManager)).isEmpty()) {
            double p = pGetter.apply(branch).eval();
            limits.stream().filter(temporaryLimit -> Math.abs(p) > temporaryLimit.getReducedValue()).findFirst().map(temporaryLimit -> LimitViolationManager.createLimitViolation(branch, temporaryLimit, LimitViolationType.ACTIVE_POWER, 100.0, p, side)).ifPresent(this::addBranchLimitViolation);
        }
        if (!(limits = (List)limitsGetter.apply((Object)branch, (Object)LimitType.APPARENT_POWER, (Object)this.limitReductionManager)).isEmpty() && !Double.isNaN(s = sGetter.applyAsDouble(branch))) {
            limits.stream().filter(temporaryLimit -> s > temporaryLimit.getReducedValue()).findFirst().map(temporaryLimit -> LimitViolationManager.createLimitViolation(branch, temporaryLimit, LimitViolationType.APPARENT_POWER, 100.0, s, side)).ifPresent(this::addBranchLimitViolation);
        }
    }

    private void detectBranchViolations(LfBranch branch) {
        if (branch.getBus1() != null) {
            this.detectBranchSideViolations(branch, branch.getBus1(), (TriFunction<LfBranch, LimitType, LimitReductionManager, List<LfBranch.LfLimit>>)((TriFunction)LfBranch::getLimits1), LfBranch::getI1, LfBranch::getP1, LfBranch::computeApparentPower1, TwoSides.ONE);
        }
        if (branch.getBus2() != null) {
            this.detectBranchSideViolations(branch, branch.getBus2(), (TriFunction<LfBranch, LimitType, LimitReductionManager, List<LfBranch.LfLimit>>)((TriFunction)LfBranch::getLimits2), LfBranch::getI2, LfBranch::getP2, LfBranch::computeApparentPower2, TwoSides.TWO);
        }
    }

    private static LimitViolation createLimitViolation(LfBranch branch, LfBranch.LfLimit temporaryLimit, LimitViolationType type, double scale, double value, TwoSides side) {
        return new LimitViolation(branch.getId(), type, temporaryLimit.getName(), temporaryLimit.getAcceptableDuration(), temporaryLimit.getValue() * scale, temporaryLimit.getReduction(), value * scale, side);
    }

    private void detectBusViolations(LfBus bus) {
        double scale = bus.getNominalV();
        double busV = bus.getV();
        if (!Double.isNaN(bus.getHighVoltageLimit()) && busV > bus.getHighVoltageLimit()) {
            LimitViolation limitViolation1 = new LimitViolation(bus.getVoltageLevelId(), LimitViolationType.HIGH_VOLTAGE, bus.getHighVoltageLimit() * scale, 1.0, busV * scale);
            this.addBusLimitViolation(limitViolation1, bus);
        }
        if (!Double.isNaN(bus.getLowVoltageLimit()) && busV < bus.getLowVoltageLimit()) {
            LimitViolation limitViolation2 = new LimitViolation(bus.getVoltageLevelId(), LimitViolationType.LOW_VOLTAGE, bus.getLowVoltageLimit() * scale, 1.0, busV * scale);
            this.addBusLimitViolation(limitViolation2, bus);
        }
    }

    private void detectVoltageAngleLimitViolations(LfNetwork.LfVoltageAngleLimit limit) {
        double difference = limit.getTo().getAngle() - limit.getFrom().getAngle();
        if (!Double.isNaN(limit.getHighValue()) && difference > limit.getHighValue()) {
            LimitViolation limitViolation1 = new LimitViolation(limit.getId(), LimitViolationType.HIGH_VOLTAGE_ANGLE, Math.toDegrees(limit.getHighValue()), 1.0, Math.toDegrees(difference));
            this.addVoltageAngleLimitViolation(limitViolation1, limit);
        }
        if (!Double.isNaN(limit.getLowValue()) && difference < limit.getLowValue()) {
            LimitViolation limitViolation2 = new LimitViolation(limit.getId(), LimitViolationType.LOW_VOLTAGE_ANGLE, Math.toDegrees(limit.getLowValue()), 1.0, Math.toDegrees(difference));
            this.addVoltageAngleLimitViolation(limitViolation2, limit);
        }
    }

    public static boolean violationWeakenedOrEquivalent(LimitViolation violation1, LimitViolation violation2, SecurityAnalysisParameters.IncreasedViolationsParameters violationsParameters) {
        if (violation2 != null && violation1.getLimitType() == violation2.getLimitType()) {
            if (violation2.getLimit() < violation1.getLimit()) {
                return true;
            }
            if (violation2.getLimit() == violation1.getLimit()) {
                if (LimitViolationManager.isFlowViolation(violation2)) {
                    return Math.abs(violation2.getValue()) <= Math.abs(violation1.getValue()) * (1.0 + violationsParameters.getFlowProportionalThreshold());
                }
                if (violation2.getLimitType() == LimitViolationType.HIGH_VOLTAGE) {
                    double value = Math.min(violationsParameters.getHighVoltageAbsoluteThreshold(), violation1.getValue() * violationsParameters.getHighVoltageProportionalThreshold());
                    return violation2.getValue() <= violation1.getValue() + value;
                }
                if (violation2.getLimitType() == LimitViolationType.LOW_VOLTAGE) {
                    return violation2.getValue() >= violation1.getValue() - Math.min(violationsParameters.getLowVoltageAbsoluteThreshold(), violation1.getValue() * violationsParameters.getLowVoltageProportionalThreshold());
                }
                return false;
            }
        }
        return false;
    }

    private static boolean isFlowViolation(LimitViolation limit) {
        return limit.getLimitType() == LimitViolationType.CURRENT || limit.getLimitType() == LimitViolationType.ACTIVE_POWER || limit.getLimitType() == LimitViolationType.APPARENT_POWER;
    }
}

