/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.security.SecurityAnalysisParameters;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OpenSecurityAnalysisParameters
extends AbstractExtension<SecurityAnalysisParameters> {
    private boolean createResultExtension = false;
    private boolean contingencyPropagation = true;
    public static final String CREATE_RESULT_EXTENSION_PARAM_NAME = "createResultExtension";
    public static final boolean CREATE_RESULT_EXTENSION_DEFAULT_VALUE = false;
    public static final String CONTINGENCY_PROPAGATION_PARAM_NAME = "contingencyPropagation";
    public static final boolean CONTINGENCY_PROPAGATION_DEFAULT_VALUE = true;
    public static final List<String> SPECIFIC_PARAMETERS_NAMES = List.of("createResultExtension", "contingencyPropagation");

    public String getName() {
        return "open-security-analysis-parameters";
    }

    public boolean isCreateResultExtension() {
        return this.createResultExtension;
    }

    public OpenSecurityAnalysisParameters setCreateResultExtension(boolean createResultExtension) {
        this.createResultExtension = createResultExtension;
        return this;
    }

    public boolean isContingencyPropagation() {
        return this.contingencyPropagation;
    }

    public OpenSecurityAnalysisParameters setContingencyPropagation(boolean contingencyPropagation) {
        this.contingencyPropagation = contingencyPropagation;
        return this;
    }

    public static OpenSecurityAnalysisParameters getOrDefault(SecurityAnalysisParameters parameters) {
        OpenSecurityAnalysisParameters parametersExt = (OpenSecurityAnalysisParameters)parameters.getExtension(OpenSecurityAnalysisParameters.class);
        if (parametersExt == null) {
            parametersExt = new OpenSecurityAnalysisParameters();
        }
        return parametersExt;
    }

    public static OpenSecurityAnalysisParameters load() {
        return OpenSecurityAnalysisParameters.load(PlatformConfig.defaultConfig());
    }

    public static OpenSecurityAnalysisParameters load(PlatformConfig platformConfig) {
        OpenSecurityAnalysisParameters parameters = new OpenSecurityAnalysisParameters();
        platformConfig.getOptionalModuleConfig("open-security-analysis-default-parameters").ifPresent(config -> parameters.setCreateResultExtension(config.getBooleanProperty(CREATE_RESULT_EXTENSION_PARAM_NAME, false)).setContingencyPropagation(config.getBooleanProperty(CONTINGENCY_PROPAGATION_PARAM_NAME, true)));
        return parameters;
    }

    public static OpenSecurityAnalysisParameters load(Map<String, String> properties) {
        return new OpenSecurityAnalysisParameters().update(properties);
    }

    public OpenSecurityAnalysisParameters update(Map<String, String> properties) {
        Optional.ofNullable(properties.get(CREATE_RESULT_EXTENSION_PARAM_NAME)).ifPresent(value -> this.setCreateResultExtension(Boolean.parseBoolean(value)));
        Optional.ofNullable(properties.get(CONTINGENCY_PROPAGATION_PARAM_NAME)).ifPresent(value -> this.setContingencyPropagation(Boolean.parseBoolean(value)));
        return this;
    }
}

