/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.sa.AbstractNetworkResult;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.monitor.StateMonitorIndex;
import com.powsybl.security.results.BranchResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PreContingencyNetworkResult
extends AbstractNetworkResult {
    private final Map<String, BranchResult> branchResults = new HashMap<String, BranchResult>();

    public PreContingencyNetworkResult(LfNetwork network, StateMonitorIndex monitorIndex, boolean createResultExtension) {
        super(network, monitorIndex, createResultExtension);
    }

    @Override
    protected void clear() {
        super.clear();
        this.branchResults.clear();
    }

    private void addResults(StateMonitor monitor) {
        this.addResults(monitor, branch -> branch.createBranchResult(Double.NaN, Double.NaN, this.createResultExtension).forEach(branchResult -> this.branchResults.put(branchResult.getBranchId(), (BranchResult)branchResult)));
    }

    @Override
    public void update() {
        this.clear();
        this.addResults(this.monitorIndex.getNoneStateMonitor());
        this.addResults(this.monitorIndex.getAllStateMonitor());
    }

    public BranchResult getBranchResult(String branchId) {
        Objects.requireNonNull(branchId);
        return this.branchResults.get(branchId);
    }

    @Override
    public List<BranchResult> getBranchResults() {
        return new ArrayList<BranchResult>(this.branchResults.values());
    }
}

