/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.contingency.ContingencyContextType;
import com.powsybl.iidm.network.AbstractTerminalTopologyVisitor;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.Matrix;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.InjectionDerivable;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.network.DisabledNetwork;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.impl.HvdcConverterStations;
import com.powsybl.openloadflow.network.impl.LfDanglingLineBus;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.network.util.ActivePowerDistribution;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import com.powsybl.openloadflow.util.Derivable;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityFunctionType;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityVariableSet;
import com.powsybl.sensitivity.SensitivityVariableType;
import com.powsybl.sensitivity.WeightedSensitivityVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSensitivityAnalysis<V extends Enum<V>, E extends Enum<E>> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSensitivityAnalysis.class);
    protected final MatrixFactory matrixFactory;
    protected final GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory;
    protected SensitivityAnalysisParameters parameters;
    private static final String NOT_FOUND = "' not found";

    protected AbstractSensitivityAnalysis(MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, SensitivityAnalysisParameters parameters) {
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        this.connectivityFactory = Objects.requireNonNull(connectivityFactory);
        this.parameters = Objects.requireNonNull(parameters);
    }

    private static NotImplementedException createVariableTypeNotImplementedException(SensitivityVariableType variableType) {
        return new NotImplementedException("Variable type " + variableType + " is not implemented");
    }

    protected SensitivityFactorGroupList<V, E> createFactorGroups(List<LfSensitivityFactor<V, E>> factors) {
        LinkedHashMap<Pair, SensitivityFactorGroup> groupIndexedById = new LinkedHashMap<Pair, SensitivityFactorGroup>(factors.size());
        for (LfSensitivityFactor factor : factors) {
            Pair id = Pair.of((Object)factor.getVariableType(), (Object)factor.getVariableId());
            if (factor instanceof SingleVariableLfSensitivityFactor) {
                SingleVariableLfSensitivityFactor singleVarFactor = (SingleVariableLfSensitivityFactor)factor;
                SensitivityFactorGroup factorGroup = groupIndexedById.computeIfAbsent(id, k -> new SingleVariableFactorGroup(singleVarFactor.getVariableElement(), singleVarFactor.getVariableEquation(), factor.getVariableType()));
                factorGroup.addFactor(factor);
                factor.setGroup(factorGroup);
                continue;
            }
            if (!(factor instanceof MultiVariablesLfSensitivityFactor)) continue;
            SensitivityFactorGroup factorGroup = groupIndexedById.computeIfAbsent(id, k -> new MultiVariablesFactorGroup(((MultiVariablesLfSensitivityFactor)factor).getWeightedVariableElements(), factor.getVariableType()));
            factorGroup.addFactor(factor);
            factor.setGroup(factorGroup);
        }
        int index = 0;
        for (SensitivityFactorGroup factorGroup : groupIndexedById.values()) {
            factorGroup.setIndex(index++);
        }
        return new SensitivityFactorGroupList(new ArrayList(groupIndexedById.values()));
    }

    protected List<ParticipatingElement> getParticipatingElements(Collection<LfBus> buses, LoadFlowParameters.BalanceType balanceType, OpenLoadFlowParameters openLoadFlowParameters) {
        ActivePowerDistribution.Step step = ActivePowerDistribution.getStep(balanceType, openLoadFlowParameters.isLoadPowerFactorConstant(), openLoadFlowParameters.isUseActiveLimits());
        List<ParticipatingElement> participatingElements = step.getParticipatingElements(buses);
        ParticipatingElement.normalizeParticipationFactors(participatingElements);
        return participatingElements;
    }

    static <V extends Enum<V>, E extends Enum<E>> DenseMatrix initFactorsRhs(EquationSystem<V, E> equationSystem, SensitivityFactorGroupList<V, E> factorsGroups, Map<LfBus, Double> participationByBus) {
        int maxFactorsGroups;
        int equationCount = equationSystem.getIndex().getSortedEquationsToSolve().size();
        int factorsGroupCount = factorsGroups.getList().size();
        if (factorsGroupCount > (maxFactorsGroups = Integer.MAX_VALUE / (equationCount * 8))) {
            throw new PowsyblException("Too many factors groups " + factorsGroupCount + ", maximum is " + maxFactorsGroups + " for a system with " + equationCount + " equations");
        }
        DenseMatrix rhs = new DenseMatrix(equationCount, factorsGroupCount);
        AbstractSensitivityAnalysis.fillRhsSensitivityVariable(factorsGroups, (Matrix)rhs, participationByBus);
        return rhs;
    }

    protected static <V extends Enum<V>, E extends Enum<E>> void fillRhsSensitivityVariable(SensitivityFactorGroupList<V, E> factorGroups, Matrix rhs, Map<LfBus, Double> participationByBus) {
        for (SensitivityFactorGroup<V, E> factorGroup : factorGroups.getList()) {
            factorGroup.fillRhs(rhs, participationByBus);
        }
    }

    protected void setPredefinedResults(Collection<LfSensitivityFactor<V, E>> lfFactors, DisabledNetwork disabledNetwork, PropagatedContingency propagatedContingency) {
        for (LfSensitivityFactor<V, E> factor : lfFactors) {
            Pair<Optional<Double>, Optional<Double>> predefinedResults = this.getPredefinedResults(factor, disabledNetwork, propagatedContingency);
            ((Optional)predefinedResults.getLeft()).ifPresent(factor::setSensitivityValuePredefinedResult);
            ((Optional)predefinedResults.getRight()).ifPresent(factor::setFunctionPredefinedResult);
        }
    }

    protected Pair<Optional<Double>, Optional<Double>> getPredefinedResults(LfSensitivityFactor<V, E> factor, DisabledNetwork disabledNetwork, PropagatedContingency propagatedContingency) {
        Double sensitivityValuePredefinedResult = null;
        Double functionPredefinedResult = null;
        if (factor.getStatus() == LfSensitivityFactor.Status.VALID) {
            boolean variableConnected = factor.isVariableConnectedToSlackComponent(disabledNetwork) && !factor.isVariableInContingency(propagatedContingency);
            boolean functionConnectedToSlackComponent = factor.isFunctionConnectedToSlackComponent(disabledNetwork);
            if (variableConnected) {
                if (!functionConnectedToSlackComponent) {
                    sensitivityValuePredefinedResult = 0.0;
                    functionPredefinedResult = Double.NaN;
                }
            } else if (functionConnectedToSlackComponent) {
                sensitivityValuePredefinedResult = 0.0;
            } else {
                sensitivityValuePredefinedResult = Double.NaN;
                functionPredefinedResult = Double.NaN;
            }
        } else if (factor.getStatus() == LfSensitivityFactor.Status.VALID_ONLY_FOR_FUNCTION) {
            sensitivityValuePredefinedResult = 0.0;
            if (!factor.isFunctionConnectedToSlackComponent(disabledNetwork)) {
                functionPredefinedResult = Double.NaN;
            }
        } else {
            throw new IllegalStateException("Unexpected factor status: " + factor.getStatus());
        }
        return Pair.of(Optional.ofNullable(sensitivityValuePredefinedResult), Optional.ofNullable(functionPredefinedResult));
    }

    protected boolean rescaleGlsk(SensitivityFactorGroupList<V, E> factorGroups, Set<LfBus> nonConnectedBuses) {
        boolean rescaled = false;
        for (SensitivityFactorGroup<V, E> factorGroup : factorGroups.getList()) {
            if (!(factorGroup instanceof MultiVariablesFactorGroup)) continue;
            MultiVariablesFactorGroup multiVariablesFactorGroup = (MultiVariablesFactorGroup)factorGroup;
            rescaled |= multiVariablesFactorGroup.updateConnectivityWeights(nonConnectedBuses);
        }
        return rescaled;
    }

    protected SensitivityFactorHolder<V, E> writeInvalidFactors(SensitivityFactorHolder<V, E> factorHolder, SensitivityResultWriter resultWriter, List<PropagatedContingency> contingencies) {
        LinkedHashSet<String> skippedVariables = new LinkedHashSet<String>();
        SensitivityFactorHolder<V, E> validFactorHolder = new SensitivityFactorHolder<V, E>();
        HashMap contingencyIndexById = new HashMap();
        contingencies.stream().forEach(contingency -> contingencyIndexById.put(contingency.getContingency().getId(), contingency.getIndex()));
        for (LfSensitivityFactor factor : factorHolder.getAllFactors()) {
            Optional<Object> sensitivityVariableToWrite = Optional.empty();
            if (factor.getStatus() == LfSensitivityFactor.Status.ZERO) {
                if (!AbstractSensitivityAnalysis.filterSensitivityValue(0.0, factor.getVariableType(), factor.getFunctionType(), this.parameters)) {
                    sensitivityVariableToWrite = Optional.of(0.0);
                }
            } else if (factor.getStatus() == LfSensitivityFactor.Status.SKIP) {
                sensitivityVariableToWrite = Optional.of(Double.NaN);
                skippedVariables.add(factor.getVariableId());
            } else {
                validFactorHolder.addFactor(factor);
            }
            if (!sensitivityVariableToWrite.isPresent()) continue;
            double value = (Double)sensitivityVariableToWrite.get();
            if (factor.getContingencyContext().getContextType() == ContingencyContextType.NONE) {
                resultWriter.writeSensitivityValue(factor.getIndex(), -1, value, Double.NaN);
                continue;
            }
            if (factor.getContingencyContext().getContextType() == ContingencyContextType.SPECIFIC) {
                resultWriter.writeSensitivityValue(factor.getIndex(), ((Integer)contingencyIndexById.get(factor.getContingencyContext().getContingencyId())).intValue(), value, Double.NaN);
                continue;
            }
            if (factor.getContingencyContext().getContextType() != ContingencyContextType.ALL) continue;
            resultWriter.writeSensitivityValue(factor.getIndex(), -1, value, Double.NaN);
            contingencyIndexById.values().forEach(index -> resultWriter.writeSensitivityValue(factor.getIndex(), index.intValue(), value, Double.NaN));
        }
        if (!skippedVariables.isEmpty() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Skipping all factors with variables: '{}', as they cannot be found in the network", (Object)String.join((CharSequence)", ", skippedVariables));
        }
        return validFactorHolder;
    }

    protected void checkContingencies(List<PropagatedContingency> contingencies) {
        HashSet<String> contingenciesIds = new HashSet<String>();
        for (PropagatedContingency contingency : contingencies) {
            String contingencyId = contingency.getContingency().getId();
            if (contingenciesIds.contains(contingencyId)) {
                throw new PowsyblException("Contingency '" + contingencyId + "' already exists");
            }
            contingenciesIds.add(contingencyId);
        }
    }

    protected void checkLoadFlowParameters(LoadFlowParameters lfParameters) {
        if (!(lfParameters.getBalanceType().equals((Object)LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P_MAX) || lfParameters.getBalanceType().equals((Object)LoadFlowParameters.BalanceType.PROPORTIONAL_TO_LOAD) || lfParameters.getBalanceType().equals((Object)LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P))) {
            throw new UnsupportedOperationException("Unsupported balance type mode: " + lfParameters.getBalanceType());
        }
    }

    private static LfBranch checkAndGetBranchOrLeg(Network network, String branchId, SensitivityFunctionType fType, LfNetwork lfNetwork) {
        Branch branch = network.getBranch(branchId);
        if (branch != null) {
            return lfNetwork.getBranchById(branchId);
        }
        DanglingLine danglingLine = network.getDanglingLine(branchId);
        if (danglingLine != null && !danglingLine.isPaired()) {
            return lfNetwork.getBranchById(branchId);
        }
        ThreeWindingsTransformer twt = network.getThreeWindingsTransformer(branchId);
        if (twt != null) {
            return lfNetwork.getBranchById(LfLegBranch.getId(branchId, AbstractSensitivityAnalysis.getLegNumber(fType)));
        }
        TieLine line = network.getTieLine(branchId);
        if (line != null) {
            return lfNetwork.getBranchById(branchId);
        }
        throw new PowsyblException("Branch, tie line, dangling line or leg of '" + branchId + NOT_FOUND);
    }

    private static void checkBus(Network network, String busId, Map<String, Bus> busCache, boolean breakers) {
        Bus bus2;
        if (busCache.isEmpty()) {
            Networks.getBuses(network, breakers).forEach(bus -> busCache.put(bus.getId(), (Bus)bus));
        }
        if ((bus2 = busCache.get(busId)) == null) {
            throw new PowsyblException("Bus '" + busId + NOT_FOUND);
        }
    }

    private static void checkPhaseShifter(Network network, String transformerId) {
        TwoWindingsTransformer twt = network.getTwoWindingsTransformer(transformerId);
        if (twt == null) {
            throw new PowsyblException("Two windings transformer '" + transformerId + NOT_FOUND);
        }
        if (twt.getPhaseTapChanger() == null) {
            throw new PowsyblException("Two windings transformer '" + transformerId + "' is not a phase shifter");
        }
    }

    private static void checkThreeWindingsTransformerPhaseShifter(Network network, String transformerId, SensitivityVariableType type) {
        ThreeWindingsTransformer twt = network.getThreeWindingsTransformer(transformerId);
        if (twt == null) {
            throw new PowsyblException("Three windings transformer '" + transformerId + NOT_FOUND);
        }
        ThreeWindingsTransformer.Leg l = (ThreeWindingsTransformer.Leg)twt.getLegs().get(AbstractSensitivityAnalysis.getLegNumber(type) - 1);
        if (l.getPhaseTapChanger() == null) {
            throw new PowsyblException("Three windings transformer '" + transformerId + "' leg on side '" + type + "' has no phase tap changer");
        }
    }

    private static void checkRegulatingTerminal(Network network, String equipmentId) {
        Optional<Terminal> terminal = Networks.getEquipmentRegulatingTerminal(network, equipmentId);
        if (terminal.isEmpty()) {
            throw new PowsyblException("Regulating terminal for '" + equipmentId + NOT_FOUND);
        }
    }

    private static PowsyblException createFunctionTypeNotSupportedException(SensitivityFunctionType functionType) {
        return new PowsyblException("Function type " + functionType + " not supported");
    }

    private static PowsyblException createVariableTypeNotSupportedWithFunctionTypeException(SensitivityVariableType variableType, SensitivityFunctionType functionType) {
        return new PowsyblException("Variable type " + variableType + " not supported with function type " + functionType);
    }

    protected SensitivityFactorHolder<V, E> readAndCheckFactors(Network network, Map<String, SensitivityVariableSet> variableSetsById, SensitivityFactorReader factorReader, LfNetwork lfNetwork, boolean breakers) {
        SensitivityFactorHolder factorHolder = new SensitivityFactorHolder();
        LinkedHashMap injectionBusesByVariableId = new LinkedHashMap();
        LinkedHashMap originalVariableSetIdsByVariableId = new LinkedHashMap();
        HashMap busCache = new HashMap();
        InjectionVariableIdToBusIdCache injectionVariableIdToBusIdCache = new InjectionVariableIdToBusIdCache();
        int[] factorIndex = new int[1];
        factorReader.read((functionType, functionId, variableType, variableId, variableSet, contingencyContext) -> {
            block21: {
                LfElement variableElement;
                LfBus functionElement;
                block24: {
                    block25: {
                        block23: {
                            block22: {
                                LfBus lfBus2;
                                LfBus lfBus1;
                                block20: {
                                    if (!variableSet) break block20;
                                    if (!AbstractSensitivityAnalysis.isActivePowerFunctionType(functionType)) throw AbstractSensitivityAnalysis.createFunctionTypeNotSupportedException(functionType);
                                    if (variableType != SensitivityVariableType.INJECTION_ACTIVE_POWER) throw AbstractSensitivityAnalysis.createVariableTypeNotSupportedWithFunctionTypeException(variableType, functionType);
                                    LfBranch branch = AbstractSensitivityAnalysis.checkAndGetBranchOrLeg(network, functionId, functionType, lfNetwork);
                                    LfBranch functionElement2 = branch != null && branch.getBus1() != null && branch.getBus2() != null ? branch : null;
                                    LinkedHashMap<LfElement, Double> injectionLfBuses = (LinkedHashMap<LfElement, Double>)injectionBusesByVariableId.get(variableId);
                                    HashSet<String> originalVariableSetIds = (HashSet<String>)originalVariableSetIdsByVariableId.get(variableId);
                                    if (injectionLfBuses == null && originalVariableSetIds == null) {
                                        injectionLfBuses = new LinkedHashMap<LfElement, Double>();
                                        originalVariableSetIds = new HashSet<String>();
                                        injectionBusesByVariableId.put(variableId, injectionLfBuses);
                                        originalVariableSetIdsByVariableId.put(variableId, originalVariableSetIds);
                                        SensitivityVariableSet set = (SensitivityVariableSet)variableSetsById.get(variableId);
                                        if (set == null) {
                                            throw new PowsyblException("Variable set '" + variableId + NOT_FOUND);
                                        }
                                        ArrayList<String> skippedInjection = new ArrayList<String>(set.getVariables().size());
                                        for (WeightedSensitivityVariable variable : set.getVariables()) {
                                            LfBus injectionLfBus;
                                            String injectionBusId = injectionVariableIdToBusIdCache.getBusId(network, variable.getId(), breakers);
                                            LfBus lfBus = injectionLfBus = injectionBusId != null ? lfNetwork.getBusById(injectionBusId) : null;
                                            if (injectionLfBus == null) {
                                                skippedInjection.add(variable.getId());
                                                continue;
                                            }
                                            injectionLfBuses.put(injectionLfBus, injectionLfBuses.getOrDefault(injectionLfBus, 0.0) + variable.getWeight());
                                            originalVariableSetIds.add(variable.getId());
                                        }
                                        if (!skippedInjection.isEmpty() && LOGGER.isWarnEnabled()) {
                                            LOGGER.warn("Injections {} cannot be found for glsk {} and will be ignored", (Object)String.join((CharSequence)", ", skippedInjection), (Object)variableId);
                                        }
                                    }
                                    factorHolder.addFactor(new MultiVariablesLfSensitivityFactor(factorIndex[0], variableId, functionId, functionElement2, functionType, injectionLfBuses, variableType, contingencyContext, originalVariableSetIds));
                                    break block21;
                                }
                                if (!AbstractSensitivityAnalysis.isActivePowerFunctionType(functionType) || variableType != SensitivityVariableType.HVDC_LINE_ACTIVE_POWER) break block22;
                                LfBranch branch = AbstractSensitivityAnalysis.checkAndGetBranchOrLeg(network, functionId, functionType, lfNetwork);
                                LfBranch functionElement3 = branch != null && branch.getBus1() != null && branch.getBus2() != null ? branch : null;
                                HvdcLine hvdcLine = network.getHvdcLine(variableId);
                                if (hvdcLine == null) {
                                    throw new PowsyblException("HVDC line '" + variableId + "' cannot be found in the network.");
                                }
                                Bus bus1 = Networks.getBus(hvdcLine.getConverterStation1().getTerminal(), breakers);
                                Bus bus2 = Networks.getBus(hvdcLine.getConverterStation2().getTerminal(), breakers);
                                HashMap<LfElement, Double> injectionLfBuses = new HashMap<LfElement, Double>(2);
                                HashSet<String> originalVariableSetIds = new HashSet<String>(2);
                                if (bus1 != null && (lfBus1 = lfNetwork.getBusById(bus1.getId())) != null) {
                                    injectionLfBuses.put(lfBus1, HvdcConverterStations.getActivePowerSetpointMultiplier(hvdcLine.getConverterStation1()));
                                    originalVariableSetIds.add(hvdcLine.getConverterStation1().getId());
                                }
                                if (bus2 != null && (lfBus2 = lfNetwork.getBusById(bus2.getId())) != null) {
                                    injectionLfBuses.put(lfBus2, HvdcConverterStations.getActivePowerSetpointMultiplier(hvdcLine.getConverterStation2()));
                                    originalVariableSetIds.add(hvdcLine.getConverterStation2().getId());
                                }
                                factorHolder.addFactor(new MultiVariablesLfSensitivityFactor(factorIndex[0], variableId, functionId, functionElement3, functionType, injectionLfBuses, variableType, contingencyContext, originalVariableSetIds));
                                break block21;
                            }
                            if (!AbstractSensitivityAnalysis.isActivePowerFunctionType(functionType) && !AbstractSensitivityAnalysis.isCurrentFunctionType(functionType)) break block23;
                            LfBranch branch = AbstractSensitivityAnalysis.checkAndGetBranchOrLeg(network, functionId, functionType, lfNetwork);
                            functionElement = branch != null && branch.getBus1() != null && branch.getBus2() != null ? branch : null;
                            switch (variableType) {
                                case INJECTION_ACTIVE_POWER: {
                                    String injectionBusId = injectionVariableIdToBusIdCache.getBusId(network, variableId, breakers);
                                    variableElement = injectionBusId != null ? lfNetwork.getBusById(injectionBusId) : null;
                                    break;
                                }
                                case TRANSFORMER_PHASE: {
                                    AbstractSensitivityAnalysis.checkPhaseShifter(network, variableId);
                                    LfBranch twt = lfNetwork.getBranchById(variableId);
                                    variableElement = twt != null && twt.getBus1() != null && twt.getBus2() != null ? twt : null;
                                    break;
                                }
                                case TRANSFORMER_PHASE_1: 
                                case TRANSFORMER_PHASE_2: 
                                case TRANSFORMER_PHASE_3: {
                                    AbstractSensitivityAnalysis.checkThreeWindingsTransformerPhaseShifter(network, variableId, variableType);
                                    LfBranch leg = lfNetwork.getBranchById(LfLegBranch.getId(variableId, AbstractSensitivityAnalysis.getLegNumber(variableType)));
                                    variableElement = leg != null && leg.getBus1() != null && leg.getBus2() != null ? leg : null;
                                    break;
                                }
                                case BUS_TARGET_VOLTAGE: {
                                    variableElement = AbstractSensitivityAnalysis.findBusTargetVoltageVariableElement(network, variableId, breakers, lfNetwork);
                                    break;
                                }
                                default: {
                                    throw AbstractSensitivityAnalysis.createVariableTypeNotSupportedWithFunctionTypeException(variableType, functionType);
                                }
                            }
                            break block24;
                        }
                        if (functionType != SensitivityFunctionType.BUS_VOLTAGE) break block25;
                        AbstractSensitivityAnalysis.checkBus(network, functionId, busCache, breakers);
                        functionElement = lfNetwork.getBusById(functionId);
                        switch (variableType) {
                            case BUS_TARGET_VOLTAGE: {
                                variableElement = AbstractSensitivityAnalysis.findBusTargetVoltageVariableElement(network, variableId, breakers, lfNetwork);
                                break block24;
                            }
                            case INJECTION_REACTIVE_POWER: {
                                String injectionBusId = injectionVariableIdToBusIdCache.getBusId(network, variableId, breakers);
                                variableElement = injectionBusId != null ? lfNetwork.getBusById(injectionBusId) : null;
                                break block24;
                            }
                            default: {
                                throw AbstractSensitivityAnalysis.createVariableTypeNotSupportedWithFunctionTypeException(variableType, functionType);
                            }
                        }
                    }
                    if (AbstractSensitivityAnalysis.isReactivePowerFunctionType(functionType)) {
                        LfBranch branch = AbstractSensitivityAnalysis.checkAndGetBranchOrLeg(network, functionId, functionType, lfNetwork);
                        LfElement lfElement = functionElement = branch != null && branch.getBus1() != null && branch.getBus2() != null ? branch : null;
                        if (variableType != SensitivityVariableType.BUS_TARGET_VOLTAGE) throw AbstractSensitivityAnalysis.createVariableTypeNotSupportedWithFunctionTypeException(variableType, functionType);
                        variableElement = AbstractSensitivityAnalysis.findBusTargetVoltageVariableElement(network, variableId, breakers, lfNetwork);
                    } else {
                        if (functionType != SensitivityFunctionType.BUS_REACTIVE_POWER) throw AbstractSensitivityAnalysis.createFunctionTypeNotSupportedException(functionType);
                        String injectionBusId = injectionVariableIdToBusIdCache.getBusId(network, functionId, breakers);
                        LfBus lfBus = functionElement = injectionBusId != null ? lfNetwork.getBusById(injectionBusId) : null;
                        if (variableType != SensitivityVariableType.BUS_TARGET_VOLTAGE) throw AbstractSensitivityAnalysis.createVariableTypeNotSupportedWithFunctionTypeException(variableType, functionType);
                        variableElement = AbstractSensitivityAnalysis.findBusTargetVoltageVariableElement(network, variableId, breakers, lfNetwork);
                    }
                }
                factorHolder.addFactor(new SingleVariableLfSensitivityFactor(factorIndex[0], variableId, functionId, functionElement, functionType, variableElement, variableType, contingencyContext));
            }
            factorIndex[0] = factorIndex[0] + 1;
        });
        return factorHolder;
    }

    protected static LfElement findBusTargetVoltageVariableElement(Network network, String variableId, boolean breakers, LfNetwork lfNetwork) {
        AbstractSensitivityAnalysis.checkRegulatingTerminal(network, variableId);
        Terminal regulatingTerminal = Networks.getEquipmentRegulatingTerminal(network, variableId).orElseThrow();
        Bus regulatedBus = Networks.getBus(regulatingTerminal, breakers);
        return regulatedBus != null ? lfNetwork.getBusById(regulatedBus.getId()) : null;
    }

    private static boolean isActivePowerFunctionType(SensitivityFunctionType functionType) {
        return functionType == SensitivityFunctionType.BRANCH_ACTIVE_POWER_1 || functionType == SensitivityFunctionType.BRANCH_ACTIVE_POWER_2 || functionType == SensitivityFunctionType.BRANCH_ACTIVE_POWER_3;
    }

    private static boolean isReactivePowerFunctionType(SensitivityFunctionType functionType) {
        return functionType == SensitivityFunctionType.BRANCH_REACTIVE_POWER_1 || functionType == SensitivityFunctionType.BRANCH_REACTIVE_POWER_2 || functionType == SensitivityFunctionType.BRANCH_REACTIVE_POWER_3;
    }

    private static boolean isCurrentFunctionType(SensitivityFunctionType functionType) {
        return functionType == SensitivityFunctionType.BRANCH_CURRENT_1 || functionType == SensitivityFunctionType.BRANCH_CURRENT_2 || functionType == SensitivityFunctionType.BRANCH_CURRENT_3;
    }

    protected Pair<Boolean, Boolean> hasBusTargetVoltage(SensitivityFactorReader factorReader, Network network) {
        AtomicBoolean hasBusTargetVoltage = new AtomicBoolean(false);
        AtomicBoolean hasTransformerBusTargetVoltage = new AtomicBoolean(false);
        factorReader.read((functionType, functionId, variableType, variableId, variableSet, contingencyContext) -> {
            if (variableType == SensitivityVariableType.BUS_TARGET_VOLTAGE) {
                hasBusTargetVoltage.set(true);
                Identifiable equipment = network.getIdentifiable(variableId);
                if (equipment instanceof TwoWindingsTransformer || equipment instanceof ThreeWindingsTransformer) {
                    hasTransformerBusTargetVoltage.set(true);
                }
            }
        });
        return Pair.of((Object)hasBusTargetVoltage.get(), (Object)hasTransformerBusTargetVoltage.get());
    }

    protected static boolean isDistributedSlackOnGenerators(DcLoadFlowParameters lfParameters) {
        return lfParameters.isDistributedSlack() && (lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P_MAX || lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P);
    }

    protected static boolean isDistributedSlackOnLoads(DcLoadFlowParameters lfParameters) {
        return lfParameters.isDistributedSlack() && (lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_LOAD || lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD);
    }

    private static <V extends Enum<V>, E extends Enum<E>> double getFunctionBaseValue(LfSensitivityFactor<V, E> factor) {
        return switch (factor.getFunctionType()) {
            case SensitivityFunctionType.BRANCH_ACTIVE_POWER_1, SensitivityFunctionType.BRANCH_ACTIVE_POWER_3, SensitivityFunctionType.BRANCH_ACTIVE_POWER_2, SensitivityFunctionType.BRANCH_REACTIVE_POWER_1, SensitivityFunctionType.BRANCH_REACTIVE_POWER_3, SensitivityFunctionType.BRANCH_REACTIVE_POWER_2, SensitivityFunctionType.BUS_REACTIVE_POWER -> 100.0;
            case SensitivityFunctionType.BRANCH_CURRENT_1, SensitivityFunctionType.BRANCH_CURRENT_3 -> {
                LfBranch branch = (LfBranch)factor.getFunctionElement();
                yield PerUnit.ib(branch.getBus1().getNominalV());
            }
            case SensitivityFunctionType.BRANCH_CURRENT_2 -> {
                LfBranch branch2 = (LfBranch)factor.getFunctionElement();
                if (branch2 instanceof LfLegBranch) {
                    yield PerUnit.ib(branch2.getBus1().getNominalV());
                }
                yield PerUnit.ib(branch2.getBus2().getNominalV());
            }
            case SensitivityFunctionType.BUS_VOLTAGE -> ((LfBus)factor.getFunctionElement()).getNominalV();
            default -> throw new UnsupportedOperationException("Function type not supported: " + factor.getFunctionType());
        };
    }

    private static <V extends Enum<V>, E extends Enum<E>> double getVariableBaseValue(LfSensitivityFactor<V, E> factor) {
        switch (factor.getVariableType()) {
            case INJECTION_ACTIVE_POWER: 
            case HVDC_LINE_ACTIVE_POWER: 
            case INJECTION_REACTIVE_POWER: {
                return 100.0;
            }
            case TRANSFORMER_PHASE: 
            case TRANSFORMER_PHASE_1: 
            case TRANSFORMER_PHASE_2: 
            case TRANSFORMER_PHASE_3: {
                return 1.0;
            }
            case BUS_TARGET_VOLTAGE: {
                LfBus bus = (LfBus)((SingleVariableLfSensitivityFactor)factor).getVariableElement();
                return bus.getNominalV();
            }
        }
        throw new IllegalArgumentException("Unknown variable type " + factor.getVariableType());
    }

    protected static <V extends Enum<V>, E extends Enum<E>> double unscaleSensitivity(LfSensitivityFactor<V, E> factor, double sensitivity) {
        return sensitivity * AbstractSensitivityAnalysis.getFunctionBaseValue(factor) / AbstractSensitivityAnalysis.getVariableBaseValue(factor);
    }

    protected static <V extends Enum<V>, E extends Enum<E>> double unscaleFunction(LfSensitivityFactor<V, E> factor, double value) {
        return value * AbstractSensitivityAnalysis.getFunctionBaseValue(factor);
    }

    protected static int getLegNumber(SensitivityFunctionType type) {
        return type.getSide().orElseThrow(() -> new PowsyblException("Cannot convert function type " + type + " to a leg number"));
    }

    protected static int getLegNumber(SensitivityVariableType type) {
        return type.getSide().orElseThrow(() -> new PowsyblException("Cannot convert variable type " + type + " to a leg number"));
    }

    public abstract void analyse(Network var1, List<PropagatedContingency> var2, List<SensitivityVariableSet> var3, SensitivityFactorReader var4, SensitivityResultWriter var5, ReportNode var6, LfTopoConfig var7);

    protected static boolean filterSensitivityValue(double value, SensitivityVariableType variable, SensitivityFunctionType function, SensitivityAnalysisParameters parameters) {
        switch (variable) {
            case INJECTION_ACTIVE_POWER: 
            case HVDC_LINE_ACTIVE_POWER: {
                return AbstractSensitivityAnalysis.isFlowFunction(function) && Math.abs(value) < parameters.getFlowFlowSensitivityValueThreshold();
            }
            case INJECTION_REACTIVE_POWER: {
                return function == SensitivityFunctionType.BUS_VOLTAGE && Math.abs(value) < parameters.getFlowVoltageSensitivityValueThreshold();
            }
            case TRANSFORMER_PHASE: 
            case TRANSFORMER_PHASE_1: 
            case TRANSFORMER_PHASE_2: 
            case TRANSFORMER_PHASE_3: {
                return AbstractSensitivityAnalysis.isFlowFunction(function) && Math.abs(value) < parameters.getAngleFlowSensitivityValueThreshold();
            }
            case BUS_TARGET_VOLTAGE: {
                return AbstractSensitivityAnalysis.filterBusTargetVoltageVariable(value, function, parameters);
            }
        }
        return false;
    }

    protected static boolean filterBusTargetVoltageVariable(double value, SensitivityFunctionType function, SensitivityAnalysisParameters parameters) {
        return switch (function) {
            case SensitivityFunctionType.BRANCH_CURRENT_1, SensitivityFunctionType.BRANCH_CURRENT_3, SensitivityFunctionType.BRANCH_CURRENT_2, SensitivityFunctionType.BUS_REACTIVE_POWER -> {
                if (Math.abs(value) < parameters.getFlowVoltageSensitivityValueThreshold()) {
                    yield true;
                }
                yield false;
            }
            case SensitivityFunctionType.BUS_VOLTAGE -> {
                if (Math.abs(value) < parameters.getVoltageVoltageSensitivityValueThreshold()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected static boolean isFlowFunction(SensitivityFunctionType function) {
        return switch (function) {
            case SensitivityFunctionType.BRANCH_ACTIVE_POWER_1, SensitivityFunctionType.BRANCH_ACTIVE_POWER_3, SensitivityFunctionType.BRANCH_ACTIVE_POWER_2, SensitivityFunctionType.BRANCH_CURRENT_1, SensitivityFunctionType.BRANCH_CURRENT_3, SensitivityFunctionType.BRANCH_CURRENT_2 -> true;
            default -> false;
        };
    }

    protected static interface LfSensitivityFactor<V extends Enum<V>, E extends Enum<E>> {
        public int getIndex();

        public String getVariableId();

        public SensitivityVariableType getVariableType();

        public String getFunctionId();

        public LfElement getFunctionElement();

        public SensitivityFunctionType getFunctionType();

        public ContingencyContext getContingencyContext();

        public Derivable<V> getFunctionEquationTerm();

        public Double getSensitivityValuePredefinedResult();

        public Double getFunctionPredefinedResult();

        public void setSensitivityValuePredefinedResult(Double var1);

        public void setFunctionPredefinedResult(Double var1);

        public double getFunctionReference();

        public void setFunctionReference(double var1);

        public double getBaseSensitivityValue();

        public void setBaseCaseSensitivityValue(double var1);

        public Status getStatus();

        public void setStatus(Status var1);

        public boolean isVariableConnectedToSlackComponent(DisabledNetwork var1);

        public boolean isFunctionConnectedToSlackComponent(DisabledNetwork var1);

        public boolean isVariableInContingency(PropagatedContingency var1);

        public SensitivityFactorGroup<V, E> getGroup();

        public void setGroup(SensitivityFactorGroup<V, E> var1);

        public static enum Status {
            VALID,
            SKIP,
            VALID_ONLY_FOR_FUNCTION,
            ZERO;

        }
    }

    protected static class SingleVariableLfSensitivityFactor<V extends Enum<V>, E extends Enum<E>>
    extends AbstractLfSensitivityFactor<V, E> {
        private final LfElement variableElement;

        protected SingleVariableLfSensitivityFactor(int index, String variableId, String functionId, LfElement functionElement, SensitivityFunctionType functionType, LfElement variableElement, SensitivityVariableType variableType, ContingencyContext contingencyContext) {
            super(index, variableId, functionId, functionElement, functionType, variableType, contingencyContext);
            this.variableElement = variableElement;
            if (variableElement == null) {
                this.status = functionElement == null ? LfSensitivityFactor.Status.SKIP : LfSensitivityFactor.Status.VALID_ONLY_FOR_FUNCTION;
            }
        }

        protected LfElement getVariableElement() {
            return this.variableElement;
        }

        protected Equation<V, E> getVariableEquation() {
            switch (this.variableType) {
                case TRANSFORMER_PHASE: 
                case TRANSFORMER_PHASE_1: 
                case TRANSFORMER_PHASE_2: 
                case TRANSFORMER_PHASE_3: {
                    LfBranch lfBranch = (LfBranch)this.variableElement;
                    return ((EquationTerm)lfBranch.getA1()).getEquation();
                }
                case BUS_TARGET_VOLTAGE: {
                    LfBus lfBus = (LfBus)this.variableElement;
                    return ((EquationTerm)lfBus.getCalculatedV()).getEquation();
                }
            }
            return null;
        }

        @Override
        public boolean isVariableConnectedToSlackComponent(DisabledNetwork disabledNetwork) {
            return this.isElementConnectedToSlackComponent(this.variableElement, disabledNetwork);
        }

        @Override
        public boolean isFunctionConnectedToSlackComponent(DisabledNetwork disabledNetwork) {
            return this.isElementConnectedToSlackComponent(this.functionElement, disabledNetwork);
        }

        @Override
        public boolean isVariableInContingency(PropagatedContingency contingency) {
            if (contingency != null) {
                switch (this.variableType) {
                    case INJECTION_ACTIVE_POWER: 
                    case HVDC_LINE_ACTIVE_POWER: {
                        return contingency.getGeneratorIdsToLose().contains(this.variableId) || contingency.getLoadIdsToLoose().containsKey(this.variableId);
                    }
                    case BUS_TARGET_VOLTAGE: {
                        return contingency.getGeneratorIdsToLose().contains(this.variableId) || contingency.getBranchIdsToOpen().containsKey(this.variableId);
                    }
                    case TRANSFORMER_PHASE: {
                        return contingency.getBranchIdsToOpen().containsKey(this.variableId);
                    }
                }
                return false;
            }
            return false;
        }
    }

    protected static interface SensitivityFactorGroup<V extends Enum<V>, E extends Enum<E>> {
        public List<LfSensitivityFactor<V, E>> getFactors();

        public int getIndex();

        public void setIndex(int var1);

        public void addFactor(LfSensitivityFactor<V, E> var1);

        public void fillRhs(Matrix var1, Map<LfBus, Double> var2);
    }

    protected static class MultiVariablesLfSensitivityFactor<V extends Enum<V>, E extends Enum<E>>
    extends AbstractLfSensitivityFactor<V, E> {
        private final Map<LfElement, Double> weightedVariableElements;
        private final Set<String> originalVariableSetIds;

        protected MultiVariablesLfSensitivityFactor(int index, String variableId, String functionId, LfElement functionElement, SensitivityFunctionType functionType, Map<LfElement, Double> weightedVariableElements, SensitivityVariableType variableType, ContingencyContext contingencyContext, Set<String> originalVariableSetIds) {
            super(index, variableId, functionId, functionElement, functionType, variableType, contingencyContext);
            this.weightedVariableElements = weightedVariableElements;
            if (weightedVariableElements.isEmpty()) {
                this.status = functionElement == null ? LfSensitivityFactor.Status.SKIP : LfSensitivityFactor.Status.VALID_ONLY_FOR_FUNCTION;
            }
            this.originalVariableSetIds = originalVariableSetIds;
        }

        protected Map<LfElement, Double> getWeightedVariableElements() {
            return this.weightedVariableElements;
        }

        protected Collection<LfElement> getVariableElements() {
            return this.weightedVariableElements.keySet();
        }

        @Override
        public boolean isVariableConnectedToSlackComponent(DisabledNetwork disabledNetwork) {
            for (LfElement lfElement : this.getVariableElements()) {
                if (!this.isElementConnectedToSlackComponent(lfElement, disabledNetwork)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isFunctionConnectedToSlackComponent(DisabledNetwork disabledNetwork) {
            return this.isElementConnectedToSlackComponent(this.functionElement, disabledNetwork);
        }

        @Override
        public boolean isVariableInContingency(PropagatedContingency contingency) {
            if (contingency != null) {
                int sizeCommonIds = (int)Stream.concat(contingency.getGeneratorIdsToLose().stream(), contingency.getLoadIdsToLoose().keySet().stream()).distinct().filter(this.originalVariableSetIds::contains).count();
                return sizeCommonIds == this.originalVariableSetIds.size();
            }
            return false;
        }
    }

    protected static class SensitivityFactorGroupList<V extends Enum<V>, E extends Enum<E>> {
        private final List<SensitivityFactorGroup<V, E>> list;
        private final boolean multiVariables;

        protected SensitivityFactorGroupList(List<SensitivityFactorGroup<V, E>> list) {
            this.list = Objects.requireNonNull(list);
            this.multiVariables = list.stream().anyMatch(MultiVariablesFactorGroup.class::isInstance);
        }

        protected List<SensitivityFactorGroup<V, E>> getList() {
            return this.list;
        }

        protected boolean hasMultiVariables() {
            return this.multiVariables;
        }
    }

    protected static class MultiVariablesFactorGroup<V extends Enum<V>, E extends Enum<E>>
    extends AbstractSensitivityFactorGroup<V, E> {
        private Map<LfElement, Double> variableElements;
        private Map<LfElement, Double> mainComponentWeights;

        protected MultiVariablesFactorGroup(Map<LfElement, Double> variableElements, SensitivityVariableType variableType) {
            super(variableType);
            this.variableElements = variableElements;
            this.mainComponentWeights = variableElements;
        }

        protected Map<LfElement, Double> getVariableElements() {
            return this.variableElements;
        }

        @Override
        public void fillRhs(Matrix rhs, Map<LfBus, Double> participationByBus) {
            double weightSum = this.mainComponentWeights.values().stream().mapToDouble(Math::abs).sum();
            switch (this.variableType) {
                case INJECTION_ACTIVE_POWER: {
                    for (Map.Entry<LfBus, Double> lfBusAndParticipationFactor : participationByBus.entrySet()) {
                        LfBus lfBus = lfBusAndParticipationFactor.getKey();
                        double injection = lfBusAndParticipationFactor.getValue();
                        this.addBusInjection(rhs, lfBus, injection);
                    }
                    for (Map.Entry<LfElement, Double> variableElementAndWeight : this.mainComponentWeights.entrySet()) {
                        LfElement variableElement = variableElementAndWeight.getKey();
                        double weight = variableElementAndWeight.getValue();
                        this.addBusInjection(rhs, (LfBus)variableElement, weight / weightSum);
                    }
                    break;
                }
                case HVDC_LINE_ACTIVE_POWER: {
                    assert (this.mainComponentWeights.size() <= 2);
                    double balanceDiff = this.mainComponentWeights.values().stream().mapToDouble(x -> x).sum();
                    for (Map.Entry<LfBus, Double> lfBusAndParticipationFactor : participationByBus.entrySet()) {
                        LfBus lfBus = lfBusAndParticipationFactor.getKey();
                        double injection = lfBusAndParticipationFactor.getValue() * balanceDiff;
                        this.addBusInjection(rhs, lfBus, injection);
                    }
                    for (Map.Entry<LfElement, Double> variableElementAndWeight : this.mainComponentWeights.entrySet()) {
                        LfElement variableElement = variableElementAndWeight.getKey();
                        double weight = variableElementAndWeight.getValue();
                        this.addBusInjection(rhs, (LfBus)variableElement, weight);
                    }
                    break;
                }
                default: {
                    throw AbstractSensitivityAnalysis.createVariableTypeNotImplementedException(this.variableType);
                }
            }
        }

        protected boolean updateConnectivityWeights(Set<LfBus> nonConnectedBuses) {
            this.mainComponentWeights = this.variableElements.entrySet().stream().filter(entry -> !nonConnectedBuses.contains((LfBus)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return this.mainComponentWeights.size() != this.variableElements.size();
        }
    }

    protected static class SensitivityFactorHolder<V extends Enum<V>, E extends Enum<E>> {
        private final Map<String, List<LfSensitivityFactor<V, E>>> additionalFactorsPerContingency = new LinkedHashMap<String, List<LfSensitivityFactor<V, E>>>();
        private final List<LfSensitivityFactor<V, E>> additionalFactorsNoContingency = new ArrayList<LfSensitivityFactor<V, E>>();
        private final List<LfSensitivityFactor<V, E>> commonFactors = new ArrayList<LfSensitivityFactor<V, E>>();

        protected SensitivityFactorHolder() {
        }

        protected List<LfSensitivityFactor<V, E>> getAllFactors() {
            ArrayList<LfSensitivityFactor<V, LfSensitivityFactor<V, E>>> allFactors = new ArrayList<LfSensitivityFactor<V, LfSensitivityFactor<V, E>>>(this.commonFactors);
            allFactors.addAll(this.additionalFactorsNoContingency);
            allFactors.addAll(this.additionalFactorsPerContingency.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new)));
            return allFactors;
        }

        protected List<LfSensitivityFactor<V, E>> getFactorsForContingency(String contingencyId) {
            return Stream.concat(this.commonFactors.stream(), this.additionalFactorsPerContingency.getOrDefault(contingencyId, Collections.emptyList()).stream()).collect(Collectors.toList());
        }

        protected List<LfSensitivityFactor<V, E>> getFactorsForContingencies(List<String> contingenciesIds) {
            return Stream.concat(this.commonFactors.stream(), contingenciesIds.stream().flatMap(contingencyId -> this.additionalFactorsPerContingency.getOrDefault(contingencyId, Collections.emptyList()).stream())).collect(Collectors.toList());
        }

        protected List<LfSensitivityFactor<V, E>> getFactorsForBaseNetwork() {
            return Stream.concat(this.commonFactors.stream(), this.additionalFactorsNoContingency.stream()).collect(Collectors.toList());
        }

        protected void addFactor(LfSensitivityFactor<V, E> factor) {
            switch (factor.getContingencyContext().getContextType()) {
                case ALL: {
                    this.commonFactors.add(factor);
                    break;
                }
                case NONE: {
                    this.additionalFactorsNoContingency.add(factor);
                    break;
                }
                case SPECIFIC: {
                    this.additionalFactorsPerContingency.computeIfAbsent(factor.getContingencyContext().getContingencyId(), k -> new ArrayList()).add(factor);
                }
            }
        }
    }

    static class InjectionVariableIdToBusIdCache {
        private final Map<String, String> variableIdToBusId = new HashMap<String, String>();

        InjectionVariableIdToBusIdCache() {
        }

        private static Injection<?> getInjection(Network network, String injectionId) {
            Generator injection = network.getGenerator(injectionId);
            if (injection == null) {
                injection = network.getLoad(injectionId);
            }
            if (injection == null) {
                injection = network.getDanglingLine(injectionId);
                if (injection != null && network.getDanglingLine(injectionId).isPaired()) {
                    throw new PowsyblException("The dangling line " + injectionId + " is paired: it cannot be a sensitivity variable");
                }
                injection = network.getDanglingLine(injectionId);
            }
            if (injection == null) {
                injection = network.getLccConverterStation(injectionId);
            }
            if (injection == null) {
                injection = network.getVscConverterStation(injectionId);
            }
            return injection;
        }

        protected static String getInjectionBusId(Network network, String injectionId, boolean breakers) {
            Injection<?> injection = InjectionVariableIdToBusIdCache.getInjection(network, injectionId);
            if (injection != null) {
                Bus bus = Networks.getBus(injection.getTerminal(), breakers);
                if (bus == null) {
                    return null;
                }
                if (injection instanceof DanglingLine) {
                    DanglingLine dl = (DanglingLine)injection;
                    return LfDanglingLineBus.getId(dl);
                }
                return bus.getId();
            }
            Bus configuredBus = network.getBusBreakerView().getBus(injectionId);
            if (configuredBus != null) {
                final ArrayList terminals = new ArrayList();
                configuredBus.visitConnectedEquipments((TopologyVisitor)new AbstractTerminalTopologyVisitor(){

                    public void visitTerminal(Terminal terminal) {
                        terminals.add(terminal);
                    }
                });
                for (Terminal terminal : terminals) {
                    Bus bus = Networks.getBus(terminal, breakers);
                    if (bus == null) continue;
                    return bus.getId();
                }
                return null;
            }
            BusbarSection busbarSection = network.getBusbarSection(injectionId);
            if (busbarSection != null) {
                Bus bus = Networks.getBus(busbarSection.getTerminal(), breakers);
                if (bus == null) {
                    return null;
                }
                return bus.getId();
            }
            throw new PowsyblException("Injection '" + injectionId + AbstractSensitivityAnalysis.NOT_FOUND);
        }

        String getBusId(Network network, String variableId, boolean breakers) {
            return this.variableIdToBusId.computeIfAbsent(variableId, variableId2 -> InjectionVariableIdToBusIdCache.getInjectionBusId(network, variableId2, breakers));
        }
    }

    protected static class SingleVariableFactorGroup<V extends Enum<V>, E extends Enum<E>>
    extends AbstractSensitivityFactorGroup<V, E> {
        private final LfElement variableElement;
        private final Equation<V, E> variableEquation;

        protected SingleVariableFactorGroup(LfElement variableElement, Equation<V, E> variableEquation, SensitivityVariableType variableType) {
            super(variableType);
            this.variableElement = Objects.requireNonNull(variableElement);
            this.variableEquation = variableEquation;
        }

        @Override
        public void fillRhs(Matrix rhs, Map<LfBus, Double> participationByBus) {
            switch (this.variableType) {
                case TRANSFORMER_PHASE: 
                case TRANSFORMER_PHASE_1: 
                case TRANSFORMER_PHASE_2: 
                case TRANSFORMER_PHASE_3: {
                    if (!this.variableEquation.isActive()) break;
                    rhs.set(this.variableEquation.getColumn(), this.getIndex(), Math.toRadians(1.0));
                    break;
                }
                case INJECTION_ACTIVE_POWER: {
                    for (Map.Entry<LfBus, Double> lfBusAndParticipationFactor : participationByBus.entrySet()) {
                        LfBus lfBus = lfBusAndParticipationFactor.getKey();
                        Double injection = lfBusAndParticipationFactor.getValue();
                        this.addBusInjection(rhs, lfBus, injection);
                    }
                    this.addBusInjection(rhs, (LfBus)this.variableElement, 1.0);
                    break;
                }
                case INJECTION_REACTIVE_POWER: {
                    this.addBusReactiveInjection(rhs, (LfBus)this.variableElement, 1.0);
                    break;
                }
                case BUS_TARGET_VOLTAGE: {
                    if (!this.variableEquation.isActive()) break;
                    rhs.set(this.variableEquation.getColumn(), this.getIndex(), 1.0);
                    break;
                }
                default: {
                    throw AbstractSensitivityAnalysis.createVariableTypeNotImplementedException(this.variableType);
                }
            }
        }
    }

    protected static abstract class AbstractSensitivityFactorGroup<V extends Enum<V>, E extends Enum<E>>
    implements SensitivityFactorGroup<V, E> {
        protected final List<LfSensitivityFactor<V, E>> factors = new ArrayList<LfSensitivityFactor<V, E>>();
        protected final SensitivityVariableType variableType;
        private int index = -1;

        AbstractSensitivityFactorGroup(SensitivityVariableType variableType) {
            this.variableType = variableType;
        }

        @Override
        public List<LfSensitivityFactor<V, E>> getFactors() {
            return this.factors;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }

        @Override
        public void addFactor(LfSensitivityFactor<V, E> factor) {
            this.factors.add(factor);
        }

        protected void addBusInjection(Matrix rhs, LfBus lfBus, double injection) {
            Equation p = (Equation)lfBus.getP();
            if (lfBus.isSlack() || !p.isActive()) {
                return;
            }
            int column = p.getColumn();
            rhs.add(column, this.getIndex(), injection);
        }

        protected void addBusReactiveInjection(Matrix rhs, LfBus lfBus, double injection) {
            Equation q = (Equation)lfBus.getQ();
            if (!q.isActive()) {
                return;
            }
            int column = q.getColumn();
            rhs.add(column, this.getIndex(), injection);
        }
    }

    protected static abstract class AbstractLfSensitivityFactor<V extends Enum<V>, E extends Enum<E>>
    implements LfSensitivityFactor<V, E> {
        private final int index;
        protected final String variableId;
        private final String functionId;
        protected final LfElement functionElement;
        protected final SensitivityFunctionType functionType;
        protected final SensitivityVariableType variableType;
        protected final ContingencyContext contingencyContext;
        private Double sensitivityValuePredefinedResult = null;
        private Double functionPredefinedResult = null;
        private double functionReference = 0.0;
        private double baseCaseSensitivityValue = Double.NaN;
        protected LfSensitivityFactor.Status status = LfSensitivityFactor.Status.VALID;
        protected SensitivityFactorGroup<V, E> group;

        protected AbstractLfSensitivityFactor(int index, String variableId, String functionId, LfElement functionElement, SensitivityFunctionType functionType, SensitivityVariableType variableType, ContingencyContext contingencyContext) {
            this.index = index;
            this.variableId = Objects.requireNonNull(variableId);
            this.functionId = Objects.requireNonNull(functionId);
            this.functionElement = functionElement;
            this.functionType = Objects.requireNonNull(functionType);
            this.variableType = Objects.requireNonNull(variableType);
            this.contingencyContext = Objects.requireNonNull(contingencyContext);
            if (functionElement == null) {
                this.status = LfSensitivityFactor.Status.ZERO;
            }
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getVariableId() {
            return this.variableId;
        }

        @Override
        public SensitivityVariableType getVariableType() {
            return this.variableType;
        }

        @Override
        public String getFunctionId() {
            return this.functionId;
        }

        @Override
        public LfElement getFunctionElement() {
            return this.functionElement;
        }

        @Override
        public SensitivityFunctionType getFunctionType() {
            return this.functionType;
        }

        @Override
        public ContingencyContext getContingencyContext() {
            return this.contingencyContext;
        }

        @Override
        public Derivable<V> getFunctionEquationTerm() {
            return switch (this.functionType) {
                case SensitivityFunctionType.BRANCH_ACTIVE_POWER_1, SensitivityFunctionType.BRANCH_ACTIVE_POWER_3 -> (Derivable)((LfBranch)this.functionElement).getP1();
                case SensitivityFunctionType.BRANCH_ACTIVE_POWER_2 -> {
                    LfBranch branch = (LfBranch)this.functionElement;
                    yield (Derivable)(branch instanceof LfLegBranch ? ((LfBranch)this.functionElement).getP1() : ((LfBranch)this.functionElement).getP2());
                }
                case SensitivityFunctionType.BRANCH_REACTIVE_POWER_1, SensitivityFunctionType.BRANCH_REACTIVE_POWER_3 -> (Derivable)((LfBranch)this.functionElement).getQ1();
                case SensitivityFunctionType.BRANCH_REACTIVE_POWER_2 -> {
                    LfBranch branch = (LfBranch)this.functionElement;
                    yield (Derivable)(branch instanceof LfLegBranch ? ((LfBranch)this.functionElement).getQ1() : ((LfBranch)this.functionElement).getQ2());
                }
                case SensitivityFunctionType.BRANCH_CURRENT_1, SensitivityFunctionType.BRANCH_CURRENT_3 -> (Derivable)((LfBranch)this.functionElement).getI1();
                case SensitivityFunctionType.BRANCH_CURRENT_2 -> {
                    LfBranch branch = (LfBranch)this.functionElement;
                    yield (Derivable)(branch instanceof LfLegBranch ? ((LfBranch)this.functionElement).getI1() : ((LfBranch)this.functionElement).getI2());
                }
                case SensitivityFunctionType.BUS_REACTIVE_POWER -> {
                    Evaluable q = ((LfBus)this.functionElement).getQ();
                    yield (Derivable)(q instanceof Equation ? new InjectionDerivable((Equation)q) : q);
                }
                case SensitivityFunctionType.BUS_VOLTAGE -> (Derivable)((LfBus)this.functionElement).getCalculatedV();
                default -> throw new UnsupportedOperationException("Function type not supported: " + this.functionType);
            };
        }

        @Override
        public Double getSensitivityValuePredefinedResult() {
            return this.sensitivityValuePredefinedResult;
        }

        @Override
        public Double getFunctionPredefinedResult() {
            return this.functionPredefinedResult;
        }

        @Override
        public void setSensitivityValuePredefinedResult(Double predefinedResult) {
            this.sensitivityValuePredefinedResult = predefinedResult;
        }

        @Override
        public void setFunctionPredefinedResult(Double predefinedResult) {
            this.functionPredefinedResult = predefinedResult;
        }

        @Override
        public double getFunctionReference() {
            return this.functionReference;
        }

        @Override
        public void setFunctionReference(double functionReference) {
            this.functionReference = functionReference;
        }

        @Override
        public double getBaseSensitivityValue() {
            return this.baseCaseSensitivityValue;
        }

        @Override
        public void setBaseCaseSensitivityValue(double baseCaseSensitivityValue) {
            this.baseCaseSensitivityValue = baseCaseSensitivityValue;
        }

        @Override
        public LfSensitivityFactor.Status getStatus() {
            return this.status;
        }

        @Override
        public void setStatus(LfSensitivityFactor.Status status) {
            this.status = status;
        }

        protected boolean isElementConnectedToSlackComponent(LfElement element, DisabledNetwork disabledNetwork) {
            if (element instanceof LfBus) {
                return !disabledNetwork.getBuses().contains(element);
            }
            if (element instanceof LfBranch) {
                return !disabledNetwork.getBranches().contains(element);
            }
            throw new PowsyblException("Cannot compute connectivity for variable element of class: " + element.getClass().getSimpleName());
        }

        @Override
        public SensitivityFactorGroup<V, E> getGroup() {
            return this.group;
        }

        @Override
        public void setGroup(SensitivityFactorGroup<V, E> group) {
            this.group = Objects.requireNonNull(group);
        }
    }
}

