/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.powsybl.contingency.ContingencyElement;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide1DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import java.util.Collection;

public final class ComputedContingencyElement {
    private int contingencyIndex = -1;
    private int localIndex = -1;
    private double alphaForSensitivityValue = Double.NaN;
    private double alphaForFunctionReference = Double.NaN;
    private final ContingencyElement element;
    private final LfBranch lfBranch;
    private final ClosedBranchSide1DcFlowEquationTerm branchEquation;

    public ComputedContingencyElement(ContingencyElement element, LfNetwork lfNetwork, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        this.element = element;
        this.lfBranch = lfNetwork.getBranchById(element.getId());
        this.branchEquation = equationSystem.getEquationTerm(ElementType.BRANCH, this.lfBranch.getNum(), ClosedBranchSide1DcFlowEquationTerm.class);
    }

    public int getContingencyIndex() {
        return this.contingencyIndex;
    }

    public void setContingencyIndex(int index) {
        this.contingencyIndex = index;
    }

    public int getLocalIndex() {
        return this.localIndex;
    }

    private void setLocalIndex(int index) {
        this.localIndex = index;
    }

    public double getAlphaForSensitivityValue() {
        return this.alphaForSensitivityValue;
    }

    public void setAlphaForSensitivityValue(double alpha) {
        this.alphaForSensitivityValue = alpha;
    }

    public double getAlphaForFunctionReference() {
        return this.alphaForFunctionReference;
    }

    public void setAlphaForFunctionReference(double alpha) {
        this.alphaForFunctionReference = alpha;
    }

    public ContingencyElement getElement() {
        return this.element;
    }

    public LfBranch getLfBranch() {
        return this.lfBranch;
    }

    public ClosedBranchSide1DcFlowEquationTerm getLfBranchEquation() {
        return this.branchEquation;
    }

    public static void setContingencyIndexes(Collection<ComputedContingencyElement> elements) {
        int index = 0;
        for (ComputedContingencyElement element : elements) {
            element.setContingencyIndex(index++);
        }
    }

    public static void setLocalIndexes(Collection<ComputedContingencyElement> elements) {
        int index = 0;
        for (ComputedContingencyElement element : elements) {
            element.setLocalIndex(index++);
        }
    }

    public static void applyToConnectivity(LfNetwork lfNetwork, GraphConnectivity<LfBus, LfBranch> connectivity, Collection<ComputedContingencyElement> breakingConnectivityElements) {
        breakingConnectivityElements.stream().map(ComputedContingencyElement::getElement).map(ContingencyElement::getId).distinct().map(lfNetwork::getBranchById).filter(b -> b.getBus1() != null && b.getBus2() != null).forEach(connectivity::removeEdge);
    }
}

