/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.BranchContingency;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.Matrix;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide1DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.sensi.AbstractSensitivityAnalysis;
import com.powsybl.openloadflow.sensi.ComputedContingencyElement;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityResultWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectivityBreakAnalysis {
    private static final double CONNECTIVITY_LOSS_THRESHOLD = 1.0E-6;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectivityBreakAnalysis.class);

    private ConnectivityBreakAnalysis() {
    }

    private static void detectPotentialConnectivityBreak(LfNetwork lfNetwork, DenseMatrix states, List<PropagatedContingency> contingencies, Map<String, ComputedContingencyElement> contingencyElementByBranch, EquationSystem<DcVariableType, DcEquationType> equationSystem, Collection<PropagatedContingency> nonLosingConnectivityContingencies, Map<Set<ComputedContingencyElement>, List<PropagatedContingency>> contingenciesByGroupOfElementsBreakingConnectivity) {
        for (PropagatedContingency contingency : contingencies) {
            List<ComputedContingencyElement> contingencyElements = contingency.getBranchIdsToOpen().keySet().stream().map(contingencyElementByBranch::get).collect(Collectors.toList());
            Set<ComputedContingencyElement> groupOfElementsBreakingConnectivity = ConnectivityBreakAnalysis.getGroupOfElementsBreakingConnectivity(lfNetwork, states, contingencyElements, equationSystem);
            if (groupOfElementsBreakingConnectivity.isEmpty()) {
                nonLosingConnectivityContingencies.add(contingency);
                continue;
            }
            contingenciesByGroupOfElementsBreakingConnectivity.computeIfAbsent(groupOfElementsBreakingConnectivity, key -> new LinkedList()).add(contingency);
        }
    }

    private static Set<ComputedContingencyElement> getGroupOfElementsBreakingConnectivity(LfNetwork lfNetwork, DenseMatrix contingenciesStates, Collection<ComputedContingencyElement> contingencyElements, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        LinkedHashSet<ComputedContingencyElement> groupOfElementsBreakingConnectivity = new LinkedHashSet<ComputedContingencyElement>();
        for (ComputedContingencyElement element : contingencyElements) {
            LinkedHashSet<ComputedContingencyElement> responsibleElements = new LinkedHashSet<ComputedContingencyElement>();
            double sum = 0.0;
            for (ComputedContingencyElement element2 : contingencyElements) {
                LfBranch branch = lfNetwork.getBranchById(element2.getElement().getId());
                ClosedBranchSide1DcFlowEquationTerm p = equationSystem.getEquationTerm(ElementType.BRANCH, branch.getNum(), ClosedBranchSide1DcFlowEquationTerm.class);
                double value = Math.abs(p.calculateSensi(contingenciesStates, element.getContingencyIndex()));
                if (value > 1.0E-6) {
                    responsibleElements.add(element2);
                }
                sum += value;
            }
            if (!(sum > 0.999999)) continue;
            groupOfElementsBreakingConnectivity.addAll(responsibleElements);
        }
        return groupOfElementsBreakingConnectivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ConnectivityAnalysisResult> computeConnectivityData(LfNetwork lfNetwork, AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> factorHolder, Map<Set<ComputedContingencyElement>, List<PropagatedContingency>> contingenciesByGroupOfElementsBreakingConnectivity, List<PropagatedContingency> nonLosingConnectivityContingencies, SensitivityResultWriter resultWriter) {
        if (contingenciesByGroupOfElementsBreakingConnectivity.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<Set, ConnectivityAnalysisResult> connectivityAnalysisResults = new LinkedHashMap<Set, ConnectivityAnalysisResult>();
        GraphConnectivity<LfBus, LfBranch> connectivity = lfNetwork.getConnectivity();
        for (Map.Entry<Set<ComputedContingencyElement>, List<PropagatedContingency>> e : contingenciesByGroupOfElementsBreakingConnectivity.entrySet()) {
            Set breakingConnectivityElements;
            Set<ComputedContingencyElement> breakingConnectivityCandidates = e.getKey();
            List<PropagatedContingency> contingencyList = e.getValue();
            connectivity.startTemporaryChanges();
            try {
                ComputedContingencyElement.applyToConnectivity(lfNetwork, connectivity, breakingConnectivityCandidates);
                breakingConnectivityElements = breakingConnectivityCandidates.stream().filter(element -> ConnectivityBreakAnalysis.isBreakingConnectivity(connectivity, element)).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            finally {
                connectivity.undoTemporaryChanges();
            }
            if (breakingConnectivityElements.isEmpty()) {
                nonLosingConnectivityContingencies.addAll(contingencyList);
                continue;
            }
            List<String> contingenciesIds = contingencyList.stream().map(contingency -> contingency.getContingency().getId()).collect(Collectors.toList());
            List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> lfFactors = factorHolder.getFactorsForContingencies(contingenciesIds);
            if (!lfFactors.isEmpty()) {
                connectivity.startTemporaryChanges();
                try {
                    ComputedContingencyElement.applyToConnectivity(lfNetwork, connectivity, breakingConnectivityElements);
                    ConnectivityAnalysisResult connectivityAnalysisResult = connectivityAnalysisResults.computeIfAbsent(breakingConnectivityElements, k -> {
                        Set<String> elementsToReconnect = ConnectivityBreakAnalysis.computeElementsToReconnect(connectivity, breakingConnectivityElements);
                        return new ConnectivityAnalysisResult(elementsToReconnect, connectivity, lfNetwork);
                    });
                    connectivityAnalysisResult.getContingencies().addAll(contingencyList);
                    continue;
                }
                finally {
                    connectivity.undoTemporaryChanges();
                    continue;
                }
            }
            for (PropagatedContingency propagatedContingency : contingencyList) {
                resultWriter.writeContingencyStatus(propagatedContingency.getIndex(), SensitivityAnalysisResult.Status.SUCCESS);
            }
        }
        return new ArrayList<ConnectivityAnalysisResult>(connectivityAnalysisResults.values());
    }

    private static boolean isBreakingConnectivity(GraphConnectivity<LfBus, LfBranch> connectivity, ComputedContingencyElement element) {
        LfBranch lfBranch = element.getLfBranch();
        return connectivity.getComponentNumber(lfBranch.getBus1()) != connectivity.getComponentNumber(lfBranch.getBus2());
    }

    private static Set<String> computeElementsToReconnect(GraphConnectivity<LfBus, LfBranch> connectivity, Set<ComputedContingencyElement> breakingConnectivityElements) {
        LinkedHashSet<String> elementsToReconnect = new LinkedHashSet<String>();
        ArrayList<Set> reconnectedCc = new ArrayList<Set>();
        for (ComputedContingencyElement element : breakingConnectivityElements) {
            Set recCc2;
            int cc1 = connectivity.getComponentNumber(element.getLfBranch().getBus1());
            int cc2 = connectivity.getComponentNumber(element.getLfBranch().getBus2());
            Set recCc1 = reconnectedCc.stream().filter(s -> s.contains(cc1)).findFirst().orElseGet(() -> new HashSet<Integer>(List.of(Integer.valueOf(cc1))));
            if (recCc1 == (recCc2 = reconnectedCc.stream().filter(s -> s.contains(cc2)).findFirst().orElseGet(() -> Set.of(Integer.valueOf(cc2))))) continue;
            elementsToReconnect.add(element.getElement().getId());
            reconnectedCc.remove(recCc2);
            if (recCc1.size() == 1) {
                reconnectedCc.add(recCc1);
            }
            recCc1.addAll(recCc2);
        }
        if (reconnectedCc.size() != 1 || ((Set)reconnectedCc.get(0)).size() != connectivity.getNbConnectedComponents()) {
            LOGGER.error("Elements to reconnect computed do not reconnect all connected components together");
        }
        return elementsToReconnect;
    }

    private static Map<String, ComputedContingencyElement> createContingencyElementsIndexByBranchId(List<PropagatedContingency> contingencies, LfNetwork lfNetwork, EquationSystem<DcVariableType, DcEquationType> equationSystem) {
        Map contingencyElementByBranch = contingencies.stream().flatMap(contingency -> contingency.getBranchIdsToOpen().keySet().stream()).map(branch -> new ComputedContingencyElement((ContingencyElement)new BranchContingency(branch), lfNetwork, equationSystem)).filter(element -> element.getLfBranchEquation() != null).collect(Collectors.toMap(computedContingencyElement -> computedContingencyElement.getElement().getId(), computedContingencyElement -> computedContingencyElement, (existing, replacement) -> existing, LinkedHashMap::new));
        ComputedContingencyElement.setContingencyIndexes(contingencyElementByBranch.values());
        return contingencyElementByBranch;
    }

    public static DenseMatrix initContingencyRhs(LfNetwork lfNetwork, EquationSystem<DcVariableType, DcEquationType> equationSystem, Collection<ComputedContingencyElement> contingencyElements) {
        int equationCount = equationSystem.getIndex().getSortedEquationsToSolve().size();
        int maxContingencyElements = Integer.MAX_VALUE / (equationCount * 8);
        if (contingencyElements.size() > maxContingencyElements) {
            throw new PowsyblException("Too many contingency elements " + contingencyElements.size() + ", maximum is " + maxContingencyElements + " for a system with " + equationCount + " equations");
        }
        DenseMatrix rhs = new DenseMatrix(equationCount, contingencyElements.size());
        ConnectivityBreakAnalysis.fillRhsContingency(lfNetwork, equationSystem, contingencyElements, (Matrix)rhs);
        return rhs;
    }

    private static DenseMatrix calculateContingenciesStates(DcLoadFlowContext loadFlowContext, Map<String, ComputedContingencyElement> contingencyElementByBranch) {
        DenseMatrix contingenciesStates = ConnectivityBreakAnalysis.initContingencyRhs(loadFlowContext.getNetwork(), loadFlowContext.getEquationSystem(), contingencyElementByBranch.values());
        loadFlowContext.getJacobianMatrix().solveTransposed(contingenciesStates);
        return contingenciesStates;
    }

    private static void fillRhsContingency(LfNetwork lfNetwork, EquationSystem<DcVariableType, DcEquationType> equationSystem, Collection<ComputedContingencyElement> contingencyElements, Matrix rhs) {
        for (ComputedContingencyElement element : contingencyElements) {
            Equation<DcVariableType, DcEquationType> p;
            LfBranch lfBranch = lfNetwork.getBranchById(element.getElement().getId());
            if (lfBranch.getBus1() == null || lfBranch.getBus2() == null) continue;
            LfBus bus1 = lfBranch.getBus1();
            LfBus bus2 = lfBranch.getBus2();
            if (bus1.isSlack()) {
                p = equationSystem.getEquation(bus2.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
                rhs.set(p.getColumn(), element.getContingencyIndex(), -1.0);
                continue;
            }
            if (bus2.isSlack()) {
                p = equationSystem.getEquation(bus1.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
                rhs.set(p.getColumn(), element.getContingencyIndex(), 1.0);
                continue;
            }
            Equation<DcVariableType, DcEquationType> p1 = equationSystem.getEquation(bus1.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
            Equation<DcVariableType, DcEquationType> p2 = equationSystem.getEquation(bus2.getNum(), DcEquationType.BUS_TARGET_P).orElseThrow(IllegalStateException::new);
            rhs.set(p1.getColumn(), element.getContingencyIndex(), 1.0);
            rhs.set(p2.getColumn(), element.getContingencyIndex(), -1.0);
        }
    }

    public static ConnectivityBreakAnalysisResults run(DcLoadFlowContext loadFlowContext, AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> factorHolder, List<PropagatedContingency> contingencies, SensitivityResultWriter resultWriter) {
        Map<String, ComputedContingencyElement> contingencyElementByBranch = ConnectivityBreakAnalysis.createContingencyElementsIndexByBranchId(contingencies, loadFlowContext.getNetwork(), loadFlowContext.getEquationSystem());
        DenseMatrix contingenciesStates = ConnectivityBreakAnalysis.calculateContingenciesStates(loadFlowContext, contingencyElementByBranch);
        ArrayList<PropagatedContingency> nonBreakingConnectivityContingencies = new ArrayList<PropagatedContingency>();
        LinkedHashMap<Set<ComputedContingencyElement>, List<PropagatedContingency>> contingenciesByGroupOfElementsPotentiallyBreakingConnectivity = new LinkedHashMap<Set<ComputedContingencyElement>, List<PropagatedContingency>>();
        ConnectivityBreakAnalysis.detectPotentialConnectivityBreak(loadFlowContext.getNetwork(), contingenciesStates, contingencies, contingencyElementByBranch, loadFlowContext.getEquationSystem(), nonBreakingConnectivityContingencies, contingenciesByGroupOfElementsPotentiallyBreakingConnectivity);
        LOGGER.info("After sensitivity based connectivity analysis, {} contingencies do not break connectivity, {} contingencies potentially break connectivity", (Object)nonBreakingConnectivityContingencies.size(), (Object)contingenciesByGroupOfElementsPotentiallyBreakingConnectivity.values().stream().mapToInt(List::size).count());
        List<ConnectivityAnalysisResult> connectivityAnalysisResults = ConnectivityBreakAnalysis.computeConnectivityData(loadFlowContext.getNetwork(), factorHolder, contingenciesByGroupOfElementsPotentiallyBreakingConnectivity, nonBreakingConnectivityContingencies, resultWriter);
        LOGGER.info("After graph based connectivity analysis, {} contingencies do not break connectivity, {} contingencies break connectivity", (Object)nonBreakingConnectivityContingencies.size(), (Object)connectivityAnalysisResults.stream().mapToInt(results -> results.getContingencies().size()).count());
        return new ConnectivityBreakAnalysisResults(nonBreakingConnectivityContingencies, connectivityAnalysisResults, contingenciesStates, contingencyElementByBranch);
    }

    public static final class ConnectivityAnalysisResult {
        private final Collection<PropagatedContingency> contingencies = new HashSet<PropagatedContingency>();
        private final Set<String> elementsToReconnect;
        private final Set<LfBus> disabledBuses;
        private final Set<LfBus> slackConnectedComponent;
        private final Set<LfBranch> partialDisabledBranches;

        private ConnectivityAnalysisResult(Set<String> elementsToReconnect, GraphConnectivity<LfBus, LfBranch> connectivity, LfNetwork lfNetwork) {
            this.elementsToReconnect = elementsToReconnect;
            this.slackConnectedComponent = connectivity.getConnectedComponent(lfNetwork.getSlackBus());
            this.disabledBuses = connectivity.getVerticesRemovedFromMainComponent();
            this.partialDisabledBranches = connectivity.getEdgesRemovedFromMainComponent();
        }

        public Collection<PropagatedContingency> getContingencies() {
            return this.contingencies;
        }

        public Set<String> getElementsToReconnect() {
            return this.elementsToReconnect;
        }

        public Set<LfBus> getDisabledBuses() {
            return this.disabledBuses;
        }

        public Set<LfBus> getSlackConnectedComponent() {
            return this.slackConnectedComponent;
        }

        public Set<LfBranch> getPartialDisabledBranches() {
            return this.partialDisabledBranches;
        }
    }

    public record ConnectivityBreakAnalysisResults(List<PropagatedContingency> nonBreakingConnectivityContingencies, List<ConnectivityAnalysisResult> connectivityAnalysisResults, DenseMatrix contingenciesStates, Map<String, ComputedContingencyElement> contingencyElementByBranch) {
    }
}

