/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.google.common.base.Stopwatch;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.dc.DcLoadFlowContext;
import com.powsybl.openloadflow.dc.DcLoadFlowEngine;
import com.powsybl.openloadflow.dc.DcLoadFlowParameters;
import com.powsybl.openloadflow.dc.equations.AbstractClosedBranchDcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.ClosedBranchSide1DcFlowEquationTerm;
import com.powsybl.openloadflow.dc.equations.DcEquationSystemCreationParameters;
import com.powsybl.openloadflow.dc.equations.DcEquationType;
import com.powsybl.openloadflow.dc.equations.DcVariableType;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.StateVector;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.network.BusState;
import com.powsybl.openloadflow.network.DisabledBranchStatus;
import com.powsybl.openloadflow.network.DisabledNetwork;
import com.powsybl.openloadflow.network.ElementState;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.NetworkSlackBusSelector;
import com.powsybl.openloadflow.network.NetworkState;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.network.SlackBusSelector;
import com.powsybl.openloadflow.network.impl.LfNetworkList;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import com.powsybl.openloadflow.sensi.AbstractSensitivityAnalysis;
import com.powsybl.openloadflow.sensi.ComputedContingencyElement;
import com.powsybl.openloadflow.sensi.ConnectivityBreakAnalysis;
import com.powsybl.openloadflow.util.Derivable;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityAnalysisResult;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityFunctionType;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityVariableSet;
import com.powsybl.sensitivity.SensitivityVariableType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DcSensitivityAnalysis
extends AbstractSensitivityAnalysis<DcVariableType, DcEquationType> {
    private static final double FUNCTION_REFERENCE_ZER0_THRESHOLD = 1.0E-13;

    public DcSensitivityAnalysis(MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory, SensitivityAnalysisParameters parameters) {
        super(matrixFactory, connectivityFactory, parameters);
    }

    private static DcLoadFlowParameters createDcLoadFlowParameters(LfNetworkParameters networkParameters, MatrixFactory matrixFactory, LoadFlowParameters lfParameters, OpenLoadFlowParameters parametersExt) {
        DcEquationSystemCreationParameters equationSystemCreationParameters = new DcEquationSystemCreationParameters().setUpdateFlows(true).setForcePhaseControlOffAndAddAngle1Var(true).setUseTransformerRatio(lfParameters.isDcUseTransformerRatio()).setDcApproximationType(parametersExt.getDcApproximationType());
        return ((DcLoadFlowParameters)((DcLoadFlowParameters)new DcLoadFlowParameters().setNetworkParameters(networkParameters)).setEquationSystemCreationParameters(equationSystemCreationParameters).setMatrixFactory(matrixFactory)).setDistributedSlack(lfParameters.isDistributedSlack()).setBalanceType(lfParameters.getBalanceType()).setSetVToNan(true).setMaxOuterLoopIterations(parametersExt.getMaxOuterLoopIterations());
    }

    private DenseMatrix calculateActivePowerFlows(DcLoadFlowContext loadFlowContext, List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> factors, List<ParticipatingElement> participatingElements, DisabledNetwork disabledNetwork, ReportNode reportNode) {
        List<Object> busStates = Collections.emptyList();
        DcLoadFlowParameters parameters = (DcLoadFlowParameters)loadFlowContext.getParameters();
        if (parameters.isDistributedSlack()) {
            busStates = ElementState.save(participatingElements.stream().map(ParticipatingElement::getLfBus).collect(Collectors.toSet()), BusState::save);
        }
        double[] dx = this.runDcLoadFlow(loadFlowContext, disabledNetwork, reportNode);
        StateVector sv = new StateVector(dx);
        for (AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType> factor : factors) {
            factor.setFunctionReference(factor.getFunctionEquationTerm().eval(sv));
        }
        if (parameters.isDistributedSlack()) {
            ElementState.restore(busStates);
        }
        return new DenseMatrix(dx.length, 1, dx);
    }

    public double[] runDcLoadFlow(DcLoadFlowContext loadFlowContext, DisabledNetwork disabledNetwork, ReportNode reportNode) {
        boolean succeeded;
        SequencedCollection<LfBus> remainingBuses;
        if (disabledNetwork.getBuses().isEmpty()) {
            remainingBuses = loadFlowContext.getNetwork().getBuses();
        } else {
            remainingBuses = new LinkedHashSet<LfBus>(loadFlowContext.getNetwork().getBuses());
            remainingBuses.removeAll(disabledNetwork.getBuses());
        }
        DcLoadFlowParameters parameters = (DcLoadFlowParameters)loadFlowContext.getParameters();
        if (parameters.isDistributedSlack()) {
            DcLoadFlowEngine.distributeSlack(remainingBuses, parameters.getBalanceType(), parameters.getNetworkParameters().isUseActiveLimits());
        }
        double[] targetVectorArray = (double[])loadFlowContext.getTargetVector().getArray().clone();
        if (!disabledNetwork.getBuses().isEmpty()) {
            disabledNetwork.getBuses().stream().flatMap(lfBus -> loadFlowContext.getEquationSystem().getEquation(lfBus.getNum(), DcEquationType.BUS_TARGET_P).stream()).map(Equation::getColumn).forEach(column -> {
                targetVectorArray[column.intValue()] = 0.0;
            });
        }
        if (!disabledNetwork.getBranches().isEmpty()) {
            disabledNetwork.getBranches().stream().flatMap(lfBranch -> loadFlowContext.getEquationSystem().getEquation(lfBranch.getNum(), DcEquationType.BRANCH_TARGET_ALPHA1).stream()).map(Equation::getColumn).forEach(column -> {
                targetVectorArray[column.intValue()] = 0.0;
            });
        }
        if (!(succeeded = DcLoadFlowEngine.solve(targetVectorArray, loadFlowContext.getJacobianMatrix(), reportNode))) {
            throw new PowsyblException("DC solver failed");
        }
        return targetVectorArray;
    }

    private void createBranchSensitivityValue(AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType> factor, DenseMatrix contingenciesStates, Collection<ComputedContingencyElement> contingencyElements, PropagatedContingency contingency, SensitivityResultWriter resultWriter, DisabledNetwork disabledNetwork) {
        Pair<Optional<Double>, Optional<Double>> predefinedResults = this.getPredefinedResults(factor, disabledNetwork, contingency);
        Optional sensitivityValuePredefinedResult = (Optional)predefinedResults.getLeft();
        Optional functionPredefinedResults = (Optional)predefinedResults.getRight();
        double sensitivityValue = sensitivityValuePredefinedResult.orElseGet(factor::getBaseSensitivityValue);
        double functionValue = functionPredefinedResults.orElseGet(factor::getFunctionReference);
        Derivable<DcVariableType> p1 = factor.getFunctionEquationTerm();
        if (!functionPredefinedResults.isPresent() || !sensitivityValuePredefinedResult.isPresent()) {
            for (ComputedContingencyElement contingencyElement : contingencyElements) {
                double contingencySensitivity = p1.calculateSensi(contingenciesStates, contingencyElement.getContingencyIndex());
                if (functionPredefinedResults.isEmpty()) {
                    functionValue += contingencyElement.getAlphaForFunctionReference() * contingencySensitivity;
                }
                if (!sensitivityValuePredefinedResult.isEmpty()) continue;
                sensitivityValue += contingencyElement.getAlphaForSensitivityValue() * contingencySensitivity;
            }
        }
        functionValue = DcSensitivityAnalysis.fixZeroFunctionReference(contingency, functionValue);
        double unscaledSensi = DcSensitivityAnalysis.unscaleSensitivity(factor, sensitivityValue);
        if (!DcSensitivityAnalysis.filterSensitivityValue(unscaledSensi, factor.getVariableType(), factor.getFunctionType(), this.parameters)) {
            resultWriter.writeSensitivityValue(factor.getIndex(), contingency != null ? contingency.getIndex() : -1, unscaledSensi, DcSensitivityAnalysis.unscaleFunction(factor, functionValue));
        }
    }

    private static double fixZeroFunctionReference(PropagatedContingency contingency, double functionValue) {
        if (contingency != null) {
            return Math.abs(functionValue) < 1.0E-13 ? 0.0 : functionValue;
        }
        return functionValue;
    }

    private void setBaseCaseSensitivityValues(AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, DenseMatrix factorsState) {
        for (AbstractSensitivityAnalysis.SensitivityFactorGroup<DcVariableType, DcEquationType> factorGroup : factorGroups.getList()) {
            for (AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType> factor : factorGroup.getFactors()) {
                factor.setBaseCaseSensitivityValue(factor.getFunctionEquationTerm().calculateSensi(factorsState, factorGroup.getIndex()));
            }
        }
    }

    private DenseMatrix calculateFactorStates(DcLoadFlowContext loadFlowContext, AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, List<ParticipatingElement> participatingElements) {
        Map<LfBus, Double> slackParticipationByBus = participatingElements.isEmpty() ? Map.of(loadFlowContext.getNetwork().getSlackBus(), -1.0) : participatingElements.stream().collect(Collectors.toMap(ParticipatingElement::getLfBus, element -> -element.getFactor(), Double::sum));
        DenseMatrix factorStates = DcSensitivityAnalysis.initFactorsRhs(loadFlowContext.getEquationSystem(), factorGroups, slackParticipationByBus);
        loadFlowContext.getJacobianMatrix().solveTransposed(factorStates);
        this.setBaseCaseSensitivityValues(factorGroups, factorStates);
        return factorStates;
    }

    private void calculateSensitivityValues(DcLoadFlowContext loadFlowContext, List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> lfFactors, DenseMatrix factorStates, DenseMatrix contingenciesStates, DenseMatrix flowStates, Collection<ComputedContingencyElement> contingencyElements, PropagatedContingency contingency, SensitivityResultWriter resultWriter, DisabledNetwork disabledNetwork) {
        if (lfFactors.isEmpty()) {
            return;
        }
        DcSensitivityAnalysis.setAlphas(loadFlowContext, contingencyElements, flowStates, contingenciesStates, 0, ComputedContingencyElement::setAlphaForFunctionReference);
        lfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID_ONLY_FOR_FUNCTION).forEach(factor -> this.createBranchSensitivityValue((AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>)factor, contingenciesStates, contingencyElements, contingency, resultWriter, disabledNetwork));
        Map factorsByGroup = lfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID).collect(Collectors.groupingBy(AbstractSensitivityAnalysis.LfSensitivityFactor::getGroup, LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry e : factorsByGroup.entrySet()) {
            AbstractSensitivityAnalysis.SensitivityFactorGroup factorGroup = (AbstractSensitivityAnalysis.SensitivityFactorGroup)e.getKey();
            List factorsForThisGroup = (List)e.getValue();
            DcSensitivityAnalysis.setAlphas(loadFlowContext, contingencyElements, factorStates, contingenciesStates, factorGroup.getIndex(), ComputedContingencyElement::setAlphaForSensitivityValue);
            for (AbstractSensitivityAnalysis.LfSensitivityFactor factor2 : factorsForThisGroup) {
                this.createBranchSensitivityValue(factor2, contingenciesStates, contingencyElements, contingency, resultWriter, disabledNetwork);
            }
        }
    }

    private static void setAlphas(DcLoadFlowContext loadFlowContext, Collection<ComputedContingencyElement> contingencyElements, DenseMatrix states, DenseMatrix contingenciesStates, int columnState, ObjDoubleConsumer<ComputedContingencyElement> setValue) {
        if (contingencyElements.size() == 1) {
            ComputedContingencyElement element2 = contingencyElements.iterator().next();
            LfBranch lfBranch = element2.getLfBranch();
            ClosedBranchSide1DcFlowEquationTerm p1 = element2.getLfBranchEquation();
            double a = 1.0 / DcSensitivityAnalysis.calculatePower(loadFlowContext, lfBranch) - (contingenciesStates.get(p1.getPh1Var().getRow(), element2.getContingencyIndex()) - contingenciesStates.get(p1.getPh2Var().getRow(), element2.getContingencyIndex()));
            double b = states.get(p1.getPh1Var().getRow(), columnState) - states.get(p1.getPh2Var().getRow(), columnState);
            setValue.accept(element2, b / a);
        } else {
            ComputedContingencyElement.setLocalIndexes(contingencyElements);
            DenseMatrix rhs = new DenseMatrix(contingencyElements.size(), 1);
            DenseMatrix matrix = new DenseMatrix(contingencyElements.size(), contingencyElements.size());
            for (ComputedContingencyElement element3 : contingencyElements) {
                LfBranch lfBranch = element3.getLfBranch();
                ClosedBranchSide1DcFlowEquationTerm p1 = element3.getLfBranchEquation();
                rhs.set(element3.getLocalIndex(), 0, states.get(p1.getPh1Var().getRow(), columnState) - states.get(p1.getPh2Var().getRow(), columnState));
                for (ComputedContingencyElement element2 : contingencyElements) {
                    double value = 0.0;
                    if (element3.equals(element2)) {
                        value = 1.0 / DcSensitivityAnalysis.calculatePower(loadFlowContext, lfBranch);
                    }
                    matrix.set(element3.getLocalIndex(), element2.getLocalIndex(), value -= contingenciesStates.get(p1.getPh1Var().getRow(), element2.getContingencyIndex()) - contingenciesStates.get(p1.getPh2Var().getRow(), element2.getContingencyIndex()));
                }
            }
            try (LUDecomposition lu = matrix.decomposeLU();){
                lu.solve(rhs);
            }
            contingencyElements.forEach(element -> setValue.accept((ComputedContingencyElement)element, rhs.get(element.getLocalIndex(), 0)));
        }
    }

    private static double calculatePower(DcLoadFlowContext loadFlowContext, LfBranch lfBranch) {
        PiModel piModel = lfBranch.getPiModel();
        DcEquationSystemCreationParameters creationParameters = ((DcLoadFlowParameters)loadFlowContext.getParameters()).getEquationSystemCreationParameters();
        return AbstractClosedBranchDcFlowEquationTerm.calculatePower(creationParameters.isUseTransformerRatio(), creationParameters.getDcApproximationType(), piModel);
    }

    private void calculateContingencySensitivityValues(PropagatedContingency contingency, AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, DenseMatrix factorStates, DenseMatrix contingenciesStates, DenseMatrix flowStates, Collection<ComputedContingencyElement> contingencyElements, SensitivityResultWriter resultWriter, DcLoadFlowContext loadFlowContext, OpenLoadFlowParameters lfParametersExt, AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> factorHolder, List<ParticipatingElement> participatingElements, DisabledNetwork disabledNetwork, ReportNode reportNode) {
        List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> factors = factorHolder.getFactorsForContingency(contingency.getContingency().getId());
        if (contingency.getGeneratorIdsToLose().isEmpty() && contingency.getLoadIdsToLoose().isEmpty()) {
            this.calculateSensitivityValues(loadFlowContext, factors, factorStates, contingenciesStates, flowStates, contingencyElements, contingency, resultWriter, disabledNetwork);
            if (contingency.hasNoImpact()) {
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.NO_IMPACT);
            } else {
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.SUCCESS);
            }
        } else {
            LfNetwork lfNetwork = loadFlowContext.getNetwork();
            DcLoadFlowParameters lfParameters = (DcLoadFlowParameters)loadFlowContext.getParameters();
            NetworkState networkState = NetworkState.save(lfNetwork);
            LfContingency lfContingency = contingency.toLfContingency(lfNetwork).orElse(null);
            DenseMatrix newFactorStates = factorStates;
            List<ParticipatingElement> newParticipatingElements = participatingElements;
            boolean participatingElementsChanged = false;
            boolean rhsChanged = false;
            if (lfContingency != null) {
                lfContingency.apply(lfParameters.getBalanceType());
                boolean bl = participatingElementsChanged = DcSensitivityAnalysis.isDistributedSlackOnGenerators(lfParameters) && !contingency.getGeneratorIdsToLose().isEmpty() || DcSensitivityAnalysis.isDistributedSlackOnLoads(lfParameters) && !contingency.getLoadIdsToLoose().isEmpty();
                if (factorGroups.hasMultiVariables()) {
                    Set<LfBus> impactedBuses = lfContingency.getLoadAndGeneratorBuses();
                    rhsChanged = this.rescaleGlsk(factorGroups, impactedBuses);
                }
                if (participatingElementsChanged) {
                    if (DcSensitivityAnalysis.isDistributedSlackOnGenerators(lfParameters)) {
                        Set<LfGenerator> participatingGeneratorsToRemove = lfContingency.getLostGenerators();
                        newParticipatingElements = participatingElements.stream().filter(participatingElement -> !participatingGeneratorsToRemove.contains(participatingElement.getElement())).map(participatingElement -> new ParticipatingElement(participatingElement.getElement(), participatingElement.getFactor())).collect(Collectors.toList());
                        ParticipatingElement.normalizeParticipationFactors(newParticipatingElements);
                    } else {
                        newParticipatingElements = this.getParticipatingElements(lfNetwork.getBuses(), lfParameters.getBalanceType(), lfParametersExt);
                    }
                }
                if (participatingElementsChanged || rhsChanged) {
                    newFactorStates = this.calculateFactorStates(loadFlowContext, factorGroups, newParticipatingElements);
                }
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.SUCCESS);
            } else {
                resultWriter.writeContingencyStatus(contingency.getIndex(), SensitivityAnalysisResult.Status.NO_IMPACT);
            }
            DenseMatrix newFlowStates = this.calculateActivePowerFlows(loadFlowContext, factors, newParticipatingElements, disabledNetwork, reportNode);
            this.calculateSensitivityValues(loadFlowContext, factors, newFactorStates, contingenciesStates, newFlowStates, contingencyElements, contingency, resultWriter, disabledNetwork);
            networkState.restore();
            if (participatingElementsChanged || rhsChanged) {
                this.setBaseCaseSensitivityValues(factorGroups, factorStates);
            }
        }
    }

    private void calculateSensitivityValuesForContingencyList(DcLoadFlowContext loadFlowContext, OpenLoadFlowParameters lfParametersExt, AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> validFactorHolder, AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, DenseMatrix factorState, DenseMatrix contingenciesStates, DenseMatrix flowStates, Collection<PropagatedContingency> contingencies, Map<String, ComputedContingencyElement> contingencyElementByBranch, Set<LfBus> disabledBuses, List<ParticipatingElement> participatingElements, Set<String> elementsToReconnect, SensitivityResultWriter resultWriter, ReportNode reportNode, Set<LfBranch> partialDisabledBranches) {
        DenseMatrix modifiedFlowStates = flowStates;
        PhaseTapChangerContingenciesIndexing phaseTapChangerContingenciesIndexing = new PhaseTapChangerContingenciesIndexing(contingencies, contingencyElementByBranch, elementsToReconnect);
        LfNetwork lfNetwork = loadFlowContext.getNetwork();
        for (PropagatedContingency propagatedContingency : phaseTapChangerContingenciesIndexing.getContingenciesWithoutPhaseTapChangerLoss()) {
            Collection contingencyElements = propagatedContingency.getBranchIdsToOpen().keySet().stream().filter(element -> !elementsToReconnect.contains(element)).map(contingencyElementByBranch::get).collect(Collectors.toList());
            Set<LfBranch> disabledBranches = propagatedContingency.getBranchIdsToOpen().keySet().stream().map(lfNetwork::getBranchById).collect(Collectors.toSet());
            disabledBranches.addAll(partialDisabledBranches);
            this.calculateContingencySensitivityValues(propagatedContingency, factorGroups, factorState, contingenciesStates, modifiedFlowStates, contingencyElements, resultWriter, loadFlowContext, lfParametersExt, validFactorHolder, participatingElements, new DisabledNetwork(disabledBuses, disabledBranches), reportNode);
        }
        for (Map.Entry entry : phaseTapChangerContingenciesIndexing.getContingenciesIndexedByPhaseTapChangers().entrySet()) {
            Set disabledPhaseTapChangers = (Set)entry.getKey();
            Collection propagatedContingencies = (Collection)entry.getValue();
            List<String> contingenciesIds = propagatedContingencies.stream().map(c -> c.getContingency().getId()).collect(Collectors.toList());
            List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> lfFactors = validFactorHolder.getFactorsForContingencies(contingenciesIds);
            if (!lfFactors.isEmpty()) {
                modifiedFlowStates = this.calculateActivePowerFlows(loadFlowContext, lfFactors, participatingElements, new DisabledNetwork(disabledBuses, disabledPhaseTapChangers), reportNode);
            }
            for (PropagatedContingency contingency : propagatedContingencies) {
                Collection contingencyElements = contingency.getBranchIdsToOpen().keySet().stream().filter(element -> !elementsToReconnect.contains(element)).map(contingencyElementByBranch::get).collect(Collectors.toList());
                Set<LfBranch> disabledBranches = contingency.getBranchIdsToOpen().keySet().stream().map(lfNetwork::getBranchById).collect(Collectors.toSet());
                disabledBranches.addAll(partialDisabledBranches);
                this.calculateContingencySensitivityValues(contingency, factorGroups, factorState, contingenciesStates, modifiedFlowStates, contingencyElements, resultWriter, loadFlowContext, lfParametersExt, validFactorHolder, participatingElements, new DisabledNetwork(disabledBuses, disabledBranches), reportNode);
            }
        }
    }

    private void processContingenciesBreakingConnectivity(ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult, DcLoadFlowContext loadFlowContext, LoadFlowParameters lfParameters, OpenLoadFlowParameters lfParametersExt, AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> validFactorHolder, AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups, List<ParticipatingElement> participatingElements, Map<String, ComputedContingencyElement> contingencyElementByBranch, DenseMatrix flowStates, DenseMatrix factorsStates, DenseMatrix contingenciesStates, SensitivityResultWriter resultWriter, ReportNode reportNode) {
        DenseMatrix modifiedFlowStates = flowStates;
        List<String> contingenciesIds = connectivityAnalysisResult.getContingencies().stream().map(c -> c.getContingency().getId()).collect(Collectors.toList());
        List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> lfFactorsForContingencies = validFactorHolder.getFactorsForContingencies(contingenciesIds);
        Set<LfBus> disabledBuses = connectivityAnalysisResult.getDisabledBuses();
        Set<LfBranch> partialDisabledBranches = connectivityAnalysisResult.getPartialDisabledBranches();
        for (LfHvdc hvdc : loadFlowContext.getNetwork().getHvdcs()) {
            if (!(Networks.isIsolatedBusForHvdc(hvdc.getBus1(), disabledBuses) ^ Networks.isIsolatedBusForHvdc(hvdc.getBus2(), disabledBuses))) continue;
            connectivityAnalysisResult.getContingencies().forEach(contingency -> {
                contingency.getGeneratorIdsToLose().add(hvdc.getConverterStation1().getId());
                contingency.getGeneratorIdsToLose().add(hvdc.getConverterStation2().getId());
            });
        }
        List<ParticipatingElement> participatingElementsForThisConnectivity = participatingElements;
        boolean rhsChanged = false;
        DenseMatrix factorStateForThisConnectivity = factorsStates;
        if (lfParameters.isDistributedSlack()) {
            rhsChanged = participatingElements.stream().anyMatch(element -> disabledBuses.contains(element.getLfBus()));
        }
        if (factorGroups.hasMultiVariables()) {
            rhsChanged |= this.rescaleGlsk(factorGroups, disabledBuses);
        }
        if (rhsChanged) {
            participatingElementsForThisConnectivity = lfParameters.isDistributedSlack() ? this.getParticipatingElements(connectivityAnalysisResult.getSlackConnectedComponent(), lfParameters.getBalanceType(), lfParametersExt) : Collections.emptyList();
            factorStateForThisConnectivity = this.calculateFactorStates(loadFlowContext, factorGroups, participatingElementsForThisConnectivity);
        }
        if (!lfFactorsForContingencies.isEmpty()) {
            modifiedFlowStates = this.calculateActivePowerFlows(loadFlowContext, lfFactorsForContingencies, participatingElementsForThisConnectivity, new DisabledNetwork(disabledBuses, Collections.emptySet()), reportNode);
        }
        this.calculateSensitivityValuesForContingencyList(loadFlowContext, lfParametersExt, validFactorHolder, factorGroups, factorStateForThisConnectivity, contingenciesStates, modifiedFlowStates, connectivityAnalysisResult.getContingencies(), contingencyElementByBranch, disabledBuses, participatingElementsForThisConnectivity, connectivityAnalysisResult.getElementsToReconnect(), resultWriter, reportNode, partialDisabledBranches);
        if (rhsChanged) {
            this.setBaseCaseSensitivityValues(factorGroups, factorsStates);
        }
    }

    protected void cleanContingencies(LfNetwork lfNetwork, List<PropagatedContingency> contingencies) {
        for (PropagatedContingency contingency : contingencies) {
            HashSet<String> branchesToRemove = new HashSet<String>();
            for (String branchId : contingency.getBranchIdsToOpen().keySet()) {
                LfBranch lfBranch = lfNetwork.getBranchById(branchId);
                if (lfBranch == null) {
                    branchesToRemove.add(branchId);
                    continue;
                }
                if (lfBranch.isConnectedAtBothSides()) continue;
                branchesToRemove.add(branchId);
            }
            branchesToRemove.forEach(branchToRemove -> contingency.getBranchIdsToOpen().remove(branchToRemove));
            String slackBusId = null;
            for (String busId : contingency.getBusIdsToLose()) {
                LfBus bus = lfNetwork.getBusById(busId);
                if (bus == null) continue;
                if (bus.isSlack()) {
                    LOGGER.error("Contingency '{}' leads to the loss of a slack bus: slack bus kept", (Object)contingency.getContingency().getId());
                    slackBusId = busId;
                    continue;
                }
                bus.getBranches().forEach(branch -> contingency.getBranchIdsToOpen().put(branch.getId(), DisabledBranchStatus.BOTH_SIDES));
            }
            if (slackBusId != null) {
                contingency.getBusIdsToLose().remove(slackBusId);
            }
            if (!contingency.hasNoImpact()) continue;
            LOGGER.warn("Contingency '{}' has no impact", (Object)contingency.getContingency().getId());
        }
    }

    @Override
    public void analyse(Network network, List<PropagatedContingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, ReportNode reportNode, LfTopoConfig topoConfig) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(contingencies);
        Objects.requireNonNull(variableSets);
        Objects.requireNonNull(factorReader);
        Objects.requireNonNull(resultWriter);
        LoadFlowParameters lfParameters = this.parameters.getLoadFlowParameters();
        OpenLoadFlowParameters lfParametersExt = OpenLoadFlowParameters.get(lfParameters);
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean breakers = topoConfig.isBreaker();
        SlackBusSelector slackBusSelector = SlackBusSelector.fromMode(lfParametersExt.getSlackBusSelectionMode(), lfParametersExt.getSlackBusesIds(), lfParametersExt.getPlausibleActivePowerLimit(), lfParametersExt.getMostMeshedSlackBusSelectorMaxNominalVoltagePercentile(), lfParametersExt.getSlackBusCountryFilter());
        if (lfParameters.isReadSlackBus()) {
            slackBusSelector = new NetworkSlackBusSelector(network, lfParametersExt.getSlackBusCountryFilter(), slackBusSelector);
        }
        LfNetworkParameters lfNetworkParameters = new LfNetworkParameters().setSlackBusSelector(slackBusSelector).setConnectivityFactory(this.connectivityFactory).setGeneratorVoltageRemoteControl(false).setMinImpedance(true).setTwtSplitShuntAdmittance(lfParameters.isTwtSplitShuntAdmittance()).setBreakers(breakers).setPlausibleActivePowerLimit(lfParametersExt.getPlausibleActivePowerLimit()).setComputeMainConnectedComponentOnly(true).setCountriesToBalance(lfParameters.getCountriesToBalance()).setDistributedOnConformLoad(lfParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setPhaseControl(false).setTransformerVoltageControl(false).setVoltagePerReactivePowerControl(false).setGeneratorReactivePowerRemoteControl(false).setTransformerReactivePowerControl(false).setLoadFlowModel(LoadFlowModel.DC).setShuntVoltageControl(false).setReactiveLimits(false).setHvdcAcEmulation(false).setCacheEnabled(false).setReferenceBusSelector(ReferenceBusSelector.DEFAULT_SELECTOR);
        try (LfNetworkList lfNetworks = Networks.load(network, lfNetworkParameters, topoConfig, reportNode);){
            LfNetwork lfNetwork = lfNetworks.getLargest().orElseThrow(() -> new PowsyblException("Empty network"));
            this.checkContingencies(contingencies);
            this.cleanContingencies(lfNetwork, contingencies);
            this.checkLoadFlowParameters(lfParameters);
            Map<String, SensitivityVariableSet> variableSetsById = variableSets.stream().collect(Collectors.toMap(SensitivityVariableSet::getId, Function.identity()));
            AbstractSensitivityAnalysis.SensitivityFactorHolder allFactorHolder = this.readAndCheckFactors(network, variableSetsById, factorReader, lfNetwork, breakers);
            List allLfFactors = allFactorHolder.getAllFactors();
            allLfFactors.stream().filter(lfFactor -> lfFactor.getFunctionType() != SensitivityFunctionType.BRANCH_ACTIVE_POWER_1 && lfFactor.getFunctionType() != SensitivityFunctionType.BRANCH_ACTIVE_POWER_2 || lfFactor.getVariableType() != SensitivityVariableType.INJECTION_ACTIVE_POWER && lfFactor.getVariableType() != SensitivityVariableType.TRANSFORMER_PHASE && lfFactor.getVariableType() != SensitivityVariableType.HVDC_LINE_ACTIVE_POWER).findFirst().ifPresent(ignored -> {
                throw new PowsyblException("Only variables of type TRANSFORMER_PHASE, INJECTION_ACTIVE_POWER and HVDC_LINE_ACTIVE_POWER, and functions of type BRANCH_ACTIVE_POWER_1 and BRANCH_ACTIVE_POWER_2 are yet supported in DC");
            });
            LOGGER.info("Running DC sensitivity analysis with {} factors and {} contingencies", (Object)allLfFactors.size(), (Object)contingencies.size());
            DcLoadFlowParameters dcLoadFlowParameters = DcSensitivityAnalysis.createDcLoadFlowParameters(lfNetworkParameters, this.matrixFactory, lfParameters, lfParametersExt);
            AbstractSensitivityAnalysis.SensitivityFactorHolder<DcVariableType, DcEquationType> validFactorHolder = this.writeInvalidFactors(allFactorHolder, resultWriter, contingencies);
            List<AbstractSensitivityAnalysis.LfSensitivityFactor<DcVariableType, DcEquationType>> validLfFactors = validFactorHolder.getAllFactors();
            LOGGER.info("{}/{} factors are valid", (Object)validLfFactors.size(), (Object)allLfFactors.size());
            try (DcLoadFlowContext loadFlowContext = new DcLoadFlowContext(lfNetwork, dcLoadFlowParameters, false);){
                VoltageInitializer voltageInitializer = lfParameters.getVoltageInitMode() == LoadFlowParameters.VoltageInitMode.PREVIOUS_VALUES ? new PreviousValueVoltageInitializer() : new UniformValueVoltageInitializer();
                DcLoadFlowEngine.initStateVector(lfNetwork, loadFlowContext.getEquationSystem(), voltageInitializer);
                AbstractSensitivityAnalysis.SensitivityFactorGroupList<DcVariableType, DcEquationType> factorGroups = this.createFactorGroups(validLfFactors.stream().filter(factor -> factor.getStatus() == AbstractSensitivityAnalysis.LfSensitivityFactor.Status.VALID).collect(Collectors.toList()));
                List<ParticipatingElement> participatingElements = lfParameters.isDistributedSlack() ? this.getParticipatingElements(lfNetwork.getBuses(), lfParameters.getBalanceType(), lfParametersExt) : Collections.emptyList();
                DenseMatrix flowStates = this.calculateActivePowerFlows(loadFlowContext, validLfFactors, participatingElements, new DisabledNetwork(), reportNode);
                DenseMatrix factorsStates = this.calculateFactorStates(loadFlowContext, factorGroups, participatingElements);
                this.calculateSensitivityValues(loadFlowContext, validFactorHolder.getFactorsForBaseNetwork(), factorsStates, null, flowStates, Collections.emptySet(), null, resultWriter, new DisabledNetwork());
                ConnectivityBreakAnalysis.ConnectivityBreakAnalysisResults connectivityBreakAnalysisResults = ConnectivityBreakAnalysis.run(loadFlowContext, validFactorHolder, contingencies, resultWriter);
                LOGGER.info("Processing contingencies with no connectivity break");
                this.calculateSensitivityValuesForContingencyList(loadFlowContext, lfParametersExt, validFactorHolder, factorGroups, factorsStates, connectivityBreakAnalysisResults.contingenciesStates(), flowStates, connectivityBreakAnalysisResults.nonBreakingConnectivityContingencies(), connectivityBreakAnalysisResults.contingencyElementByBranch(), Collections.emptySet(), participatingElements, Collections.emptySet(), resultWriter, reportNode, Collections.emptySet());
                LOGGER.info("Processing contingencies with connectivity break");
                for (ConnectivityBreakAnalysis.ConnectivityAnalysisResult connectivityAnalysisResult : connectivityBreakAnalysisResults.connectivityAnalysisResults()) {
                    this.processContingenciesBreakingConnectivity(connectivityAnalysisResult, loadFlowContext, lfParameters, lfParametersExt, validFactorHolder, factorGroups, participatingElements, connectivityBreakAnalysisResults.contingencyElementByBranch(), flowStates, factorsStates, connectivityBreakAnalysisResults.contingenciesStates(), resultWriter, reportNode);
                }
            }
            stopwatch.stop();
            LOGGER.info("DC sensitivity analysis done in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private static final class PhaseTapChangerContingenciesIndexing {
        private final List<PropagatedContingency> contingenciesWithoutTransformers = new ArrayList<PropagatedContingency>();
        private final Map<Set<LfBranch>, Collection<PropagatedContingency>> contingenciesIndexedByPhaseTapChangers = new LinkedHashMap<Set<LfBranch>, Collection<PropagatedContingency>>();

        private PhaseTapChangerContingenciesIndexing(Collection<PropagatedContingency> contingencies, Map<String, ComputedContingencyElement> contingencyElementByBranch, Collection<String> elementIdsToSkip) {
            for (PropagatedContingency contingency : contingencies) {
                Set lostTransformers = contingency.getBranchIdsToOpen().keySet().stream().filter(element -> !elementIdsToSkip.contains(element)).map(contingencyElementByBranch::get).map(ComputedContingencyElement::getLfBranch).filter(LfBranch::hasPhaseControllerCapability).collect(Collectors.toSet());
                if (lostTransformers.isEmpty()) {
                    this.contingenciesWithoutTransformers.add(contingency);
                    continue;
                }
                this.contingenciesIndexedByPhaseTapChangers.computeIfAbsent(lostTransformers, key -> new ArrayList()).add(contingency);
            }
        }

        private Collection<PropagatedContingency> getContingenciesWithoutPhaseTapChangerLoss() {
            return this.contingenciesWithoutTransformers;
        }

        private Map<Set<LfBranch>, Collection<PropagatedContingency>> getContingenciesIndexedByPhaseTapChangers() {
            return this.contingenciesIndexedByPhaseTapChangers;
        }
    }
}

