/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sensi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.auto.service.AutoService;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionJsonSerializer;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.computation.local.LocalComputationManager;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.contingency.list.ContingencyList;
import com.powsybl.contingency.contingency.list.DefaultContingencyList;
import com.powsybl.contingency.json.ContingencyJsonModule;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.serde.NetworkSerDe;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.json.LoadFlowParametersJsonModule;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.math.matrix.SparseMatrixFactory;
import com.powsybl.openloadflow.graph.EvenShiloachGraphDecrementalConnectivityFactory;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.impl.PropagatedContingency;
import com.powsybl.openloadflow.network.impl.PropagatedContingencyCreationParameters;
import com.powsybl.openloadflow.sensi.AbstractSensitivityAnalysis;
import com.powsybl.openloadflow.sensi.AcSensitivityAnalysis;
import com.powsybl.openloadflow.sensi.DcSensitivityAnalysis;
import com.powsybl.openloadflow.sensi.OpenSensitivityAnalysisParameterJsonSerializer;
import com.powsybl.openloadflow.sensi.OpenSensitivityAnalysisParameters;
import com.powsybl.openloadflow.sensi.SensitivityFactoryJsonRecorder;
import com.powsybl.openloadflow.util.DebugUtil;
import com.powsybl.openloadflow.util.Reports;
import com.powsybl.sensitivity.SensitivityAnalysisParameters;
import com.powsybl.sensitivity.SensitivityAnalysisProvider;
import com.powsybl.sensitivity.SensitivityFactor;
import com.powsybl.sensitivity.SensitivityFactorModelReader;
import com.powsybl.sensitivity.SensitivityFactorReader;
import com.powsybl.sensitivity.SensitivityResultModelWriter;
import com.powsybl.sensitivity.SensitivityResultWriter;
import com.powsybl.sensitivity.SensitivityVariableSet;
import com.powsybl.sensitivity.json.SensitivityJsonModule;
import com.powsybl.tools.PowsyblCoreVersion;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@AutoService(value={SensitivityAnalysisProvider.class})
public class OpenSensitivityAnalysisProvider
implements SensitivityAnalysisProvider {
    private final MatrixFactory matrixFactory;
    private final GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory;
    private static final String JSON_EXTENSION = ".json";

    public OpenSensitivityAnalysisProvider() {
        this((MatrixFactory)new SparseMatrixFactory());
    }

    public OpenSensitivityAnalysisProvider(MatrixFactory matrixFactory) {
        this(matrixFactory, new EvenShiloachGraphDecrementalConnectivityFactory<LfBus, LfBranch>());
    }

    public OpenSensitivityAnalysisProvider(MatrixFactory matrixFactory, GraphConnectivityFactory<LfBus, LfBranch> connectivityFactory) {
        this.matrixFactory = matrixFactory;
        this.connectivityFactory = connectivityFactory;
    }

    public String getName() {
        return "OpenLoadFlow";
    }

    public String getVersion() {
        return new PowsyblCoreVersion().getMavenProjectVersion();
    }

    public Optional<String> getLoadFlowProviderName() {
        return Optional.of("OpenLoadFlow");
    }

    public Optional<ExtensionJsonSerializer> getSpecificParametersSerializer() {
        return Optional.of(new OpenSensitivityAnalysisParameterJsonSerializer());
    }

    public Optional<Extension<SensitivityAnalysisParameters>> loadSpecificParameters(PlatformConfig platformConfig) {
        return Optional.of(OpenSensitivityAnalysisParameters.load(platformConfig));
    }

    public Optional<Extension<SensitivityAnalysisParameters>> loadSpecificParameters(Map<String, String> properties) {
        return Optional.of(OpenSensitivityAnalysisParameters.load(properties));
    }

    public List<String> getSpecificParametersNames() {
        return OpenSensitivityAnalysisParameters.SPECIFIC_PARAMETERS_NAMES;
    }

    private static OpenSensitivityAnalysisParameters getSensitivityAnalysisParametersExtension(SensitivityAnalysisParameters sensitivityAnalysisParameters) {
        OpenSensitivityAnalysisParameters sensiParametersExt = (OpenSensitivityAnalysisParameters)sensitivityAnalysisParameters.getExtension(OpenSensitivityAnalysisParameters.class);
        if (sensiParametersExt == null) {
            sensiParametersExt = new OpenSensitivityAnalysisParameters();
        }
        return sensiParametersExt;
    }

    private static ObjectMapper createObjectMapper() {
        return new ObjectMapper().registerModule((Module)new ContingencyJsonModule()).registerModule((Module)new LoadFlowParametersJsonModule()).registerModule((Module)new SensitivityJsonModule());
    }

    public CompletableFuture<Void> run(Network network, String workingVariantId, SensitivityFactorReader factorReader, SensitivityResultWriter resultWriter, List<Contingency> contingencies, List<SensitivityVariableSet> variableSets, SensitivityAnalysisParameters sensitivityAnalysisParameters, ComputationManager computationManager, ReportNode reportNode) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(contingencies);
        Objects.requireNonNull(variableSets);
        Objects.requireNonNull(sensitivityAnalysisParameters);
        Objects.requireNonNull(factorReader);
        Objects.requireNonNull(resultWriter);
        Objects.requireNonNull(computationManager);
        Objects.requireNonNull(reportNode);
        return CompletableFuture.runAsync(() -> {
            network.getVariantManager().setWorkingVariant(workingVariantId);
            ReportNode sensiReportNode = Reports.createSensitivityAnalysis(reportNode, network.getId());
            OpenSensitivityAnalysisParameters sensitivityAnalysisParametersExt = OpenSensitivityAnalysisProvider.getSensitivityAnalysisParametersExtension(sensitivityAnalysisParameters);
            LfTopoConfig topoConfig = new LfTopoConfig();
            LoadFlowParameters loadFlowParameters = sensitivityAnalysisParameters.getLoadFlowParameters();
            PropagatedContingencyCreationParameters creationParameters = new PropagatedContingencyCreationParameters().setContingencyPropagation(false).setShuntCompensatorVoltageControlOn(!loadFlowParameters.isDc() && loadFlowParameters.isShuntCompensatorVoltageControlOn()).setSlackDistributionOnConformLoad(loadFlowParameters.getBalanceType() == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD).setHvdcAcEmulation(!loadFlowParameters.isDc() && loadFlowParameters.isHvdcAcEmulation());
            List<PropagatedContingency> propagatedContingencies = PropagatedContingency.createList(network, contingencies, topoConfig, creationParameters);
            SensitivityFactorReader decoratedFactorReader = factorReader;
            if (sensitivityAnalysisParametersExt.getDebugDir() != null) {
                Path debugDir = DebugUtil.getDebugDir(sensitivityAnalysisParametersExt.getDebugDir());
                String dateStr = ZonedDateTime.now().format(DebugUtil.DATE_TIME_FORMAT);
                NetworkSerDe.write((Network)network, (Path)debugDir.resolve("network-" + dateStr + ".xiidm"));
                ObjectWriter objectWriter = OpenSensitivityAnalysisProvider.createObjectMapper().writerWithDefaultPrettyPrinter();
                try {
                    try (BufferedWriter writer = Files.newBufferedWriter(debugDir.resolve("contingencies-" + dateStr + JSON_EXTENSION), StandardCharsets.UTF_8, new OpenOption[0]);){
                        DefaultContingencyList contingencyList = new DefaultContingencyList("default", contingencies);
                        objectWriter.writeValue((Writer)writer, (Object)contingencyList);
                    }
                    writer = Files.newBufferedWriter(debugDir.resolve("variable-sets-" + dateStr + JSON_EXTENSION), StandardCharsets.UTF_8, new OpenOption[0]);
                    try {
                        objectWriter.writeValue((Writer)writer, (Object)variableSets);
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    writer = Files.newBufferedWriter(debugDir.resolve("parameters-" + dateStr + JSON_EXTENSION), StandardCharsets.UTF_8, new OpenOption[0]);
                    try {
                        objectWriter.writeValue((Writer)writer, (Object)sensitivityAnalysisParameters);
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                decoratedFactorReader = new SensitivityFactoryJsonRecorder(factorReader, debugDir.resolve("factors-" + dateStr + JSON_EXTENSION));
            }
            AbstractSensitivityAnalysis analysis = loadFlowParameters.isDc() ? new DcSensitivityAnalysis(this.matrixFactory, this.connectivityFactory, sensitivityAnalysisParameters) : new AcSensitivityAnalysis(this.matrixFactory, this.connectivityFactory, sensitivityAnalysisParameters);
            analysis.analyse(network, propagatedContingencies, variableSets, decoratedFactorReader, resultWriter, sensiReportNode, topoConfig);
        }, computationManager.getExecutor());
    }

    public <T extends SensitivityResultWriter> ReplayResult<T> replay(ZonedDateTime date, Path debugDir, Function<List<Contingency>, T> resultWriterProvider, ReportNode reportNode) {
        SensitivityAnalysisParameters sensitivityAnalysisParameters;
        List variableSets;
        List contingencies;
        List factors;
        Objects.requireNonNull(date);
        Objects.requireNonNull(debugDir);
        Objects.requireNonNull(resultWriterProvider);
        Objects.requireNonNull(reportNode);
        String dateStr = date.format(DebugUtil.DATE_TIME_FORMAT);
        Network network = NetworkSerDe.read((Path)debugDir.resolve("network-" + dateStr + ".xiidm"));
        ObjectMapper objectMapper = OpenSensitivityAnalysisProvider.createObjectMapper();
        try {
            try (BufferedReader reader = Files.newBufferedReader(debugDir.resolve("factors-" + dateStr + JSON_EXTENSION), StandardCharsets.UTF_8);){
                factors = (List)objectMapper.readValue((Reader)reader, (TypeReference)new TypeReference<List<SensitivityFactor>>(){});
            }
            reader = Files.newBufferedReader(debugDir.resolve("contingencies-" + dateStr + JSON_EXTENSION), StandardCharsets.UTF_8);
            try {
                ContingencyList contingencyList = (ContingencyList)objectMapper.readValue((Reader)reader, DefaultContingencyList.class);
                contingencies = contingencyList.getContingencies(network);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = Files.newBufferedReader(debugDir.resolve("variable-sets-" + dateStr + JSON_EXTENSION), StandardCharsets.UTF_8);
            try {
                variableSets = (List)objectMapper.readValue((Reader)reader, (TypeReference)new TypeReference<List<SensitivityVariableSet>>(){});
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = Files.newBufferedReader(debugDir.resolve("parameters-" + dateStr + JSON_EXTENSION), StandardCharsets.UTF_8);
            try {
                sensitivityAnalysisParameters = (SensitivityAnalysisParameters)objectMapper.readValue((Reader)reader, (TypeReference)new TypeReference<SensitivityAnalysisParameters>(){});
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        OpenSensitivityAnalysisParameters sensiParametersExt = (OpenSensitivityAnalysisParameters)sensitivityAnalysisParameters.getExtension(OpenSensitivityAnalysisParameters.class);
        if (sensiParametersExt != null) {
            sensiParametersExt.setDebugDir(null);
        }
        SensitivityResultWriter resultWriter = Objects.requireNonNull((SensitivityResultWriter)resultWriterProvider.apply(contingencies));
        this.run(network, "InitialState", (SensitivityFactorReader)new SensitivityFactorModelReader(factors, network), resultWriter, contingencies, variableSets, sensitivityAnalysisParameters, LocalComputationManager.getDefault(), reportNode).join();
        return new ReplayResult<SensitivityResultWriter>(resultWriter, factors, contingencies);
    }

    public <T extends SensitivityResultWriter> ReplayResult<T> replay(ZonedDateTime date, Path debugDir, Function<List<Contingency>, T> resultWriterProvider) {
        return this.replay(date, debugDir, resultWriterProvider, ReportNode.NO_OP);
    }

    public ReplayResult<SensitivityResultModelWriter> replay(ZonedDateTime date, Path debugDir) {
        return this.replay(date, debugDir, SensitivityResultModelWriter::new);
    }

    public record ReplayResult<T extends SensitivityResultWriter>(T resultWriter, List<SensitivityFactor> factors, List<Contingency> contingencies) {
    }
}

