/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;

public abstract class AbstractLoadFlowNetworkFactory {
    protected static Bus createBus(Network network, String id) {
        return AbstractLoadFlowNetworkFactory.createBus(network, id, 1.0);
    }

    protected static Bus createBus(Network network, String id, double nominalV) {
        return AbstractLoadFlowNetworkFactory.createBus(network, id + "_s", id, nominalV);
    }

    protected static Bus createBus(Network network, String substationId, String id) {
        return AbstractLoadFlowNetworkFactory.createBus(network, substationId, id, 1.0);
    }

    protected static Bus createBus(Network network, String substationId, String id, double nominalV) {
        Substation s = network.getSubstation(substationId);
        if (s == null) {
            s = ((SubstationAdder)network.newSubstation().setId(substationId)).setCountry(Country.FR).add();
        }
        VoltageLevel vl = ((VoltageLevelAdder)s.newVoltageLevel().setId(id + "_vl")).setNominalV(nominalV).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        return ((BusAdder)vl.getBusBreakerView().newBus().setId(id)).add();
    }

    protected static Bus createOtherBus(Network network, String id, String voltageLevelId) {
        VoltageLevel vl = network.getVoltageLevel(voltageLevelId);
        return ((BusAdder)vl.getBusBreakerView().newBus().setId(id)).add();
    }

    protected static Generator createGenerator(Bus b, String id, double p) {
        return AbstractLoadFlowNetworkFactory.createGenerator(b, id, p, 1.0);
    }

    protected static Generator createGenerator(Bus b, String id, double p, double v) {
        Generator g = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b.getVoltageLevel().newGenerator().setId(id)).setBus(b.getId())).setConnectableBus(b.getId())).setEnergySource(EnergySource.OTHER).setMinP(0.0).setMaxP(2.0 * p).setTargetP(p).setTargetV(v).setVoltageRegulatorOn(true).add();
        g.getTerminal().setP(-p).setQ(0.0);
        return g;
    }

    protected static Generator createGenerator2(Bus b, String id, double p, double v) {
        Generator g = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b.getVoltageLevel().newGenerator().setId(id)).setBus(b.getId())).setConnectableBus(b.getId())).setEnergySource(EnergySource.OTHER).setMinP(0.0).setMaxP(2.0 * p).add();
        return g;
    }

    protected static Load createLoad(Bus b, String id, double p) {
        return AbstractLoadFlowNetworkFactory.createLoad(b, id, p, 0.0);
    }

    protected static Load createLoad(Bus b, String id, double p, double q) {
        Load l = ((LoadAdder)((LoadAdder)((LoadAdder)b.getVoltageLevel().newLoad().setId(id)).setBus(b.getId())).setConnectableBus(b.getId())).setP0(p).setQ0(q).add();
        l.getTerminal().setP(p).setQ(q);
        return l;
    }

    protected static Line createLine(Network network, Bus b1, Bus b2, String id, double x) {
        return AbstractLoadFlowNetworkFactory.createLine(network, b1, b2, id, 0.0, x);
    }

    protected static Line createLine(Network network, Bus b1, Bus b2, String id, double r, double x) {
        return ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(id)).setBus1(b1.getId())).setConnectableBus1(b1.getId())).setBus2(b2.getId())).setConnectableBus2(b2.getId())).setR(r).setX(x).add();
    }

    protected static Switch createSwitch(Network network, Bus b1, Bus b2, String id) {
        return ((VoltageLevel.BusBreakerView.SwitchAdder)network.getVoltageLevel(b1.getVoltageLevel().getId()).getBusBreakerView().newSwitch().setId(id)).setBus1(b1.getId()).setBus2(b2.getId()).setOpen(false).add();
    }

    protected static TwoWindingsTransformer createTransformer(Network network, String substationId, Bus b1, Bus b2, String id, double x, double rho) {
        return AbstractLoadFlowNetworkFactory.createTransformer(network, substationId, b1, b2, id, 0.0, x, rho);
    }

    protected static TwoWindingsTransformer createTransformer(Network network, String substationId, Bus b1, Bus b2, String id, double r, double x, double rho) {
        return ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation(substationId).newTwoWindingsTransformer().setId(id)).setBus1(b1.getId())).setConnectableBus1(b1.getId())).setBus2(b2.getId())).setConnectableBus2(b2.getId())).setRatedU1(b1.getVoltageLevel().getNominalV()).setRatedU2(b2.getVoltageLevel().getNominalV() * rho).setR(r).setX(x).add();
    }

    protected static ThreeWindingsTransformer createThreeWindingsTransformer(Network network, String substationId, Bus b1, Bus b2, Bus b3, String id, double x1, double rho1, double x2, double rho2, double x3, double rho3) {
        return ((ThreeWindingsTransformerAdder)network.getSubstation(substationId).newThreeWindingsTransformer().setId(id)).setRatedU0(1.0).newLeg1().setBus(b1.getId()).setConnectableBus(b1.getId()).setRatedU(rho1).setR(0.0).setX(x1).add().newLeg2().setBus(b2.getId()).setConnectableBus(b2.getId()).setRatedU(rho2).setR(0.0).setX(x2).add().newLeg3().setBus(b3.getId()).setConnectableBus(b3.getId()).setRatedU(rho3).setR(0.0).setX(x3).add().add();
    }

    protected static DanglingLine createDanglingLine(Bus b, String id, double x, double p0, double q0) {
        return ((DanglingLineAdder)((DanglingLineAdder)((DanglingLineAdder)b.getVoltageLevel().newDanglingLine().setId(id)).setBus(b.getId())).setConnectableBus(b.getId())).setR(0.0).setX(x).setP0(p0).setQ0(q0).add();
    }

    protected static LccConverterStation createLcc(Bus b, String id) {
        return ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)b.getVoltageLevel().newLccConverterStation().setId(id)).setConnectableBus(b.getId())).setBus(b.getId())).setPowerFactor(0.8f).setLossFactor(1.1f)).add();
    }

    protected static VscConverterStation createVsc(Bus b, String id, double voltageSetpoint, double reactivePowerSetpoint) {
        return ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)b.getVoltageLevel().newVscConverterStation().setId(id)).setConnectableBus(b.getId())).setBus(b.getId())).setVoltageRegulatorOn(true).setVoltageSetpoint(voltageSetpoint).setReactivePowerSetpoint(reactivePowerSetpoint).setLossFactor(1.1f)).add();
    }

    protected static HvdcLine createHvdcLine(Network network, String id, HvdcConverterStation station1, HvdcConverterStation station2, double nominalV, double r, double activePowerSetpoint) {
        return ((HvdcLineAdder)network.newHvdcLine().setId(id)).setConverterStationId1(station1.getId()).setConverterStationId2(station2.getId()).setNominalV(nominalV).setR(r).setActivePowerSetpoint(activePowerSetpoint).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER).setMaxP(2.0 * activePowerSetpoint).add();
    }

    protected static ShuntCompensator createFixedShuntCompensator(Bus bus, String id, double gPerSection, double bPersection) {
        ShuntCompensator sh = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)bus.getVoltageLevel().newShuntCompensator().setId(id)).setBus(bus.getId())).setConnectableBus(bus.getId())).setSectionCount(1).newLinearModel().setGPerSection(gPerSection).setBPerSection(bPersection).setMaximumSectionCount(1).add().add();
        return sh;
    }

    protected static ShuntCompensator createShuntCompensator(Bus bus, String id, double g, double b, double v, boolean voltageControl) {
        ShuntCompensator sh = ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)bus.getVoltageLevel().newShuntCompensator().setId(id)).setBus(bus.getId())).setConnectableBus(bus.getId())).setSectionCount(1).newNonLinearModel().beginSection().setB(b).setG(g).endSection().add().add();
        sh.setTargetV(v).setRegulatingTerminal(sh.getTerminal()).setTargetDeadband(0.0).setVoltageRegulatorOn(voltageControl);
        return sh;
    }

    protected static StaticVarCompensator createStaticVarCompensator(Bus bus, String id, double qSetpoint, double vSetpoint, StaticVarCompensator.RegulationMode regulationMode) {
        StaticVarCompensator svc = ((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)bus.getVoltageLevel().newStaticVarCompensator().setId(id)).setBus(bus.getId())).setConnectableBus(bus.getId())).setBmin(-1.0).setBmax(1.0).setRegulating(false).setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE).add();
        svc.setRegulatingTerminal(svc.getTerminal()).setVoltageSetpoint(vSetpoint).setReactivePowerSetpoint(qSetpoint).setRegulationMode(regulationMode).setRegulating(true);
        return svc;
    }
}

