/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OverloadManagementSystemAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;
import java.time.ZonedDateTime;

public final class AutomationSystemNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    private AutomationSystemNetworkFactory() {
    }

    public static Network create() {
        Network network = AutomationSystemNetworkFactory.createCommonNetwork();
        Bus b3 = network.getBusBreakerView().getBus("b3");
        ((VoltageLevel.BusBreakerView.SwitchAdder)b3.getVoltageLevel().getBusBreakerView().newSwitch().setId("br1")).setBus1("b3").setBus2("b3p").setOpen(false).add();
        Substation s1 = network.getSubstation("s1");
        ((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder)s1.newOverloadManagementSystem().setId("l34_opens_br1")).setEnabled(true).setMonitoredElementId("l34").setMonitoredElementSide(ThreeSides.ONE).newSwitchTripping().setKey("br1 key")).setSwitchToOperateId("br1").setCurrentLimit(300.0)).add().add();
        return network;
    }

    public static Network createWithSwitchToClose() {
        Network network = AutomationSystemNetworkFactory.createCommonNetwork();
        Bus b3 = network.getBusBreakerView().getBus("b3");
        ((VoltageLevel.BusBreakerView.SwitchAdder)b3.getVoltageLevel().getBusBreakerView().newSwitch().setId("br1")).setBus1("b3").setBus2("b3p").setOpen(true).add();
        Substation s1 = network.getSubstation("s1");
        ((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder)s1.newOverloadManagementSystem().setId("l12_closes_br1")).setEnabled(true).setMonitoredElementId("l12").setMonitoredElementSide(ThreeSides.ONE).newSwitchTripping().setKey("br1 key")).setSwitchToOperateId("br1").setCurrentLimit(250.0)).setOpenAction(false)).add().add();
        return network;
    }

    public static Network createWithBranchTripping() {
        Network network = AutomationSystemNetworkFactory.createCommonNetwork();
        Bus b3 = network.getBusBreakerView().getBus("b3");
        Bus b3p = network.getBusBreakerView().getBus("b3p");
        AutomationSystemNetworkFactory.createLine(network, b3, b3p, "l33p", 0.1, 3.0);
        Substation s1 = network.getSubstation("s1");
        ((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder)s1.newOverloadManagementSystem().setId("l34_opens_l12")).setEnabled(true).setMonitoredElementId("l34").setMonitoredElementSide(ThreeSides.ONE).newBranchTripping().setKey("l33p key")).setBranchToOperateId("l33p").setSideToOperate(TwoSides.TWO).setCurrentLimit(200.0)).add().add();
        return network;
    }

    public static Network createWithBranchTripping2() {
        Network network = AutomationSystemNetworkFactory.createCommonNetwork();
        Bus b3 = network.getBusBreakerView().getBus("b3");
        Bus b3p = network.getBusBreakerView().getBus("b3p");
        AutomationSystemNetworkFactory.createLine(network, b3, b3p, "l33p", 0.1, 3.0);
        Substation s1 = network.getSubstation("s1");
        ((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder)s1.newOverloadManagementSystem().setId("l34_opens_l12")).setEnabled(true).setMonitoredElementId("l12").setMonitoredElementSide(ThreeSides.ONE).newBranchTripping().setKey("l33p key")).setBranchToOperateId("l33p").setSideToOperate(TwoSides.TWO).setOpenAction(false)).setCurrentLimit(200.0)).add().add();
        network.getLine("l33p").getTerminal1().disconnect();
        network.getLine("l33p").getTerminal2().disconnect();
        return network;
    }

    public static Network createWithBadAutomationSystems() {
        Network network = AutomationSystemNetworkFactory.createCommonNetwork();
        Bus b3 = network.getBusBreakerView().getBus("b3");
        Bus b3p = network.getBusBreakerView().getBus("b3p");
        AutomationSystemNetworkFactory.createLine(network, b3, b3p, "l33p", 0.1, 3.0);
        Bus b5 = AutomationSystemNetworkFactory.createBus(network, "s3", "b5", 225.0);
        Bus b6 = AutomationSystemNetworkFactory.createBus(network, "s4", "b6", 225.0);
        AutomationSystemNetworkFactory.createLine(network, b5, b6, "l56", 0.5, 3.0);
        return network;
    }

    private static Network createCommonNetwork() {
        Network network = Network.create((String)"OverloadManagementSystemTestCase", (String)"code");
        network.setCaseDate(ZonedDateTime.parse("2020-04-05T14:11:00.000+01:00"));
        Bus b1 = AutomationSystemNetworkFactory.createBus(network, "s1", "b1", 225.0);
        Bus b2 = AutomationSystemNetworkFactory.createBus(network, "s2", "b2", 225.0);
        Bus b3 = AutomationSystemNetworkFactory.createBus(network, "s1", "b3", 63.0);
        Bus b3p = ((BusAdder)b3.getVoltageLevel().getBusBreakerView().newBus().setId("b3p")).add();
        Bus b4 = AutomationSystemNetworkFactory.createBus(network, "s2", "b4", 63.0);
        AutomationSystemNetworkFactory.createGenerator(b1, "g1", 100.0, 230.0);
        AutomationSystemNetworkFactory.createLoad(b3p, "ld3", 3.0, 2.0);
        AutomationSystemNetworkFactory.createLoad(b4, "ld4", 90.0, 60.0);
        AutomationSystemNetworkFactory.createLine(network, b1, b2, "l12", 0.1, 3.0);
        AutomationSystemNetworkFactory.createLine(network, b3p, b4, "l34", 0.05, 3.2);
        AutomationSystemNetworkFactory.createTransformer(network, "s1", b1, b3, "tr1", 0.2, 2.0, 1.0);
        AutomationSystemNetworkFactory.createTransformer(network, "s2", b2, b4, "tr2", 0.3, 3.0, 1.0);
        return network;
    }
}

