/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class BoundaryFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network create() {
        Network network = Network.create((String)"dl", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(101.3664).setTargetV(390.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        ((DanglingLineAdder)((DanglingLineAdder)((DanglingLineAdder)vl2.newDanglingLine().setId("dl1")).setConnectableBus("b2")).setBus("b2")).setR(0.7).setX(1.0).setG(Math.pow(10.0, -6.0)).setB(3.0 * Math.pow(10.0, -6.0)).setP0(101.0).setQ0(150.0).newGeneration().setTargetP(0.0).setTargetQ(0.0).setTargetV(390.0).setVoltageRegulationOn(false).add().add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l1")).setBus1("b1")).setBus2("b2")).setR(1.0).setX(3.0).add();
        return network;
    }

    public static Network createWithLoad() {
        Network network = BoundaryFactory.create();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        ((LoadAdder)((LoadAdder)vl3.newLoad().setId("load3")).setBus("b3")).setP0(10.0).setQ0(5.0).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l13")).setBus1("b1")).setBus2("b3")).setR(10.0).setX(3.0).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l32")).setBus1("b3")).setBus2("b2")).setR(10.0).setX(10.0).add();
        network.getDanglingLine("dl1").setP0(91.0);
        return network;
    }

    public static Network createWithXnode() {
        Network network = Network.create((String)"xnode-network", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((LoadAdder)((LoadAdder)vl1.newLoad().setId("load1")).setBus("b1")).setP0(50.0).setQ0(50.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(100.0).setTargetV(400.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("xnode")).add();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        Substation s4 = ((SubstationAdder)network.newSubstation().setId("S4")).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)s4.newVoltageLevel().setId("vl4")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl4.getBusBreakerView().newBus().setId("b4")).add();
        ((LoadAdder)((LoadAdder)vl4.newLoad().setId("load4")).setBus("b4")).setP0(40.0).setQ0(40.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl4.newGenerator().setId("g4")).setConnectableBus("b4")).setBus("b4")).setTargetP(20.0).setTargetV(400.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l12")).setBus1("b1")).setBus2("xnode")).setR(0.0).setX(0.1).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l23")).setBus1("xnode")).setBus2("b3")).setR(0.0).setX(0.08).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l34")).setBus1("b3")).setBus2("b4")).setR(0.0).setX(1.0).add();
        return network;
    }

    public static Network createWithTieLine() {
        Network network = Network.create((String)"xnode-network", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((LoadAdder)((LoadAdder)vl1.newLoad().setId("load1")).setBus("b1")).setP0(50.0).setQ0(50.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(100.0).setTargetV(400.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        Substation s4 = ((SubstationAdder)network.newSubstation().setId("S4")).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)s4.newVoltageLevel().setId("vl4")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl4.getBusBreakerView().newBus().setId("b4")).add();
        ((LoadAdder)((LoadAdder)vl4.newLoad().setId("load4")).setBus("b4")).setP0(40.0).setQ0(40.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl4.newGenerator().setId("g4")).setConnectableBus("b4")).setBus("b4")).setTargetP(20.0).setTargetV(400.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        DanglingLine dl1 = ((DanglingLineAdder)((DanglingLineAdder)vl1.newDanglingLine().setBus("b1")).setId("h1")).setR(0.0).setX(0.1).setPairingKey("xnode").setP0(0.0).setQ0(0.0).add();
        DanglingLine dl3 = ((DanglingLineAdder)((DanglingLineAdder)vl3.newDanglingLine().setBus("b3")).setId("h2")).setR(0.0).setX(0.08).setPairingKey("xnode").setP0(0.0).setQ0(0.0).add();
        ((TieLineAdder)network.newTieLine().setId("t12")).setDanglingLine1(dl1.getId()).setDanglingLine2(dl3.getId()).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l34")).setBus1("b3")).setBus2("b4")).setR(0.0).setX(1.0).add();
        return network;
    }

    public static Network createWithTwoTieLines() {
        Network network = BoundaryFactory.createWithTieLine();
        DanglingLine dl1 = ((DanglingLineAdder)((DanglingLineAdder)network.getVoltageLevel("vl1").newDanglingLine().setBus("b1")).setId("h1bis")).setR(0.0).setX(0.1).setPairingKey("xnode2").setP0(0.0).setQ0(0.0).add();
        DanglingLine dl3 = ((DanglingLineAdder)((DanglingLineAdder)network.getVoltageLevel("vl3").newDanglingLine().setBus("b3")).setId("h2bis")).setR(0.0).setX(0.08).setPairingKey("xnode2").setP0(0.0).setQ0(0.0).add();
        ((TieLineAdder)network.newTieLine().setId("t12bis")).setDanglingLine1(dl1.getId()).setDanglingLine2(dl3.getId()).add();
        return network;
    }

    public static Network createWithoutLoads() {
        Network network = Network.create((String)"dl", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(225.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(1.0E-6).setTargetV(224.18).setMinP(0.0).setMaxP(245.0).setVoltageRegulatorOn(true).add();
        g1.newMinMaxReactiveLimits().setMinQ(-80.0).setMaxQ(86.0).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(225.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l1")).setBus1("b1")).setBus2("b2")).setR(1.316).setX(6.865).setB1(0.0017).setB2(0.0017).add();
        return network;
    }
}

