/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;

public final class BusBreakerNetworkFactory {
    private BusBreakerNetworkFactory() {
    }

    public static Network create() {
        Network network = Network.create((String)"test", (String)"test");
        Substation s = ((SubstationAdder)network.newSubstation().setId("S")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL1")).setNominalV(400.0).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("BBS11")).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("BBS1")).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("BBS2")).add();
        BusBreakerNetworkFactory.createBreaker(vl1, "C", "BBS1", "BBS2");
        BusBreakerNetworkFactory.createGenerator(vl1, "G", "BBS1", 398.0, 603.77, 301.0);
        VoltageLevel vl2 = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("BBS3")).add();
        BusBreakerNetworkFactory.createLine(network, "L1", "BBS1", "BBS3");
        BusBreakerNetworkFactory.createLine(network, "L2", "BBS2", "BBS3");
        ((LoadAdder)((LoadAdder)vl2.newLoad().setId("LD")).setBus("BBS3")).setP0(600.0).setQ0(200.0).add();
        ((CurrentLimitsAdder)network.getLine("L1").newCurrentLimits1().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine("L1").newCurrentLimits2().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine("L2").newCurrentLimits1().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine("L2").newCurrentLimits2().setPermanentLimit(940.0)).add();
        return network;
    }

    private static void createBreaker(VoltageLevel vl, String id, String bus1Id, String bus2Id) {
        ((VoltageLevel.BusBreakerView.SwitchAdder)vl.getBusBreakerView().newSwitch().setId(id)).setBus1(bus1Id).setBus2(bus2Id).add();
    }

    private static void createGenerator(VoltageLevel vl, String id, String busId, double v, double p, double q) {
        ((GeneratorAdder)((GeneratorAdder)vl.newGenerator().setId(id)).setBus(busId)).setMinP(-4999.99).setMaxP(4999.99).setVoltageRegulatorOn(true).setTargetV(v).setTargetP(p).setTargetQ(q).add();
    }

    private static void createLine(Network network, String id, String bus1Id, String bus2Id) {
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(id)).setBus1(bus1Id)).setBus2(bus2Id)).setR(3.0).setX(33.0).setB1(1.93E-4).setB2(1.93E-4).add();
        ((CurrentLimitsAdder)network.getLine(id).newCurrentLimits1().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine(id).newCurrentLimits2().setPermanentLimit(940.0)).add();
    }
}

