/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class ConnectedComponentNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network createTwoCcLinkedByASingleLine() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        return network;
    }

    public static Network createTwoCcLinkedByTwoLines() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b5, "l35", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b4, "l24", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        return network;
    }

    public static Network createTwoCcLinkedByTwoLinesWithAdditionnalGens() {
        Network network = ConnectedComponentNetworkFactory.createTwoCcLinkedByTwoLines();
        Bus b3 = network.getBusBreakerView().getBus("b3");
        ConnectedComponentNetworkFactory.createGenerator(b3, "g3", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3_bis", 2.0);
        return network;
    }

    public static Network createTwoCcWithATransformerLinkedByASingleLine() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "test_s", "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "test_s", "b6");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        TwoWindingsTransformer twt = ConnectedComponentNetworkFactory.createTransformer(network, "test_s", b5, b6, "l56", 0.1f, 1.0);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)twt.newPhaseTapChanger().setTapPosition(0)).beginStep()).setX((double)0.1f)).setAlpha(1.0)).endStep()).add();
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        return network;
    }

    public static Network createTwoCcLinkedByATransformer() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "test_s", "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "test_s", "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        TwoWindingsTransformer twt = ConnectedComponentNetworkFactory.createTransformer(network, "test_s", b3, b4, "l34", 0.1f, 1.0);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)twt.newPhaseTapChanger().setTapPosition(0)).beginStep()).setX((double)0.1f)).setAlpha(1.0)).endStep()).add();
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        return network;
    }

    public static Network createTwoComponentWithGeneratorOnOneSide() {
        Network network = ConnectedComponentNetworkFactory.createTwoCcLinkedByASingleLine();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b6 = network.getBusBreakerView().getBus("b6");
        Bus b1 = network.getBusBreakerView().getBus("b1");
        Bus b5 = network.getBusBreakerView().getBus("b5");
        Bus b3 = network.getBusBreakerView().getBus("b3");
        Bus b4 = network.getBusBreakerView().getBus("b4");
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b3, "g3", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b6, "d6", 1.0);
        return network;
    }

    public static Network createTwoComponentWithGeneratorAndLoad() {
        Network network = ConnectedComponentNetworkFactory.createTwoCcLinkedByASingleLine();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b6 = network.getBusBreakerView().getBus("b6");
        Bus b1 = network.getBusBreakerView().getBus("b1");
        Bus b5 = network.getBusBreakerView().getBus("b5");
        Bus b3 = network.getBusBreakerView().getBus("b3");
        Bus b4 = network.getBusBreakerView().getBus("b4");
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        return network;
    }

    public static Network createThreeCcLinkedByASingleBus() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        Bus b7 = ConnectedComponentNetworkFactory.createBus(network, "b7");
        Bus b8 = ConnectedComponentNetworkFactory.createBus(network, "b8");
        Bus b9 = ConnectedComponentNetworkFactory.createBus(network, "b9");
        Bus b10 = ConnectedComponentNetworkFactory.createBus(network, "b10");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b7, "l57", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b6, b7, "l67", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b8, "l48", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b8, b9, "l89", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b8, b10, "l810", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b9, b10, "l910", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createGenerator(b10, "g10", 4.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b7, "d7", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b8, "d8", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b9, "d9", 1.0);
        return network;
    }

    public static Network createThreeCcLinkedByASingleBusWithInconsistentVoltages() {
        Network network = ConnectedComponentNetworkFactory.createThreeCcLinkedByASingleBus();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2_bis", 0.0, 2.0);
        Bus b3 = network.getBusBreakerView().getBus("b3");
        Bus b3Bis = ConnectedComponentNetworkFactory.createBus(network, "b3_s", "b3_bis", 1.0);
        TwoWindingsTransformer t2wt = ConnectedComponentNetworkFactory.createTransformer(network, "b3_s", b3, b3Bis, "l35", 0.1f, 1.0);
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t2wt.newRatioTapChanger().beginStep()).setRho(1.0)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(true)).setTargetV(2.0).setTargetDeadband(0.0)).setRegulationTerminal(t2wt.getTerminal1())).add();
        return network;
    }

    public static Network createThreeCcLinkedByASingleBusWithTransformer() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "test_s", "b6");
        Bus b7 = ConnectedComponentNetworkFactory.createBus(network, "test_s", "b7");
        Bus b8 = ConnectedComponentNetworkFactory.createBus(network, "b8");
        Bus b9 = ConnectedComponentNetworkFactory.createBus(network, "b9");
        Bus b10 = ConnectedComponentNetworkFactory.createBus(network, "b10");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b7, "l57", 0.1f);
        TwoWindingsTransformer twt = ConnectedComponentNetworkFactory.createTransformer(network, "test_s", b6, b7, "l67", 0.1f, 1.0);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)twt.newPhaseTapChanger().setTapPosition(0)).beginStep()).setX((double)0.1f)).setAlpha(1.0)).endStep()).add();
        ConnectedComponentNetworkFactory.createLine(network, b4, b8, "l48", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b8, b9, "l89", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b8, b10, "l810", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b9, b10, "l910", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 4.0);
        ConnectedComponentNetworkFactory.createGenerator(b10, "g10", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b7, "d7", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b8, "d8", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b9, "d9", 1.0);
        return network;
    }

    public static Network createTwoConnectedComponentsLinkedByASerieOfTwoBranches() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        Bus b7 = ConnectedComponentNetworkFactory.createBus(network, "b7");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b7, "l57", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b6, b7, "l67", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 3.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b7, "d7", 1.0);
        return network;
    }

    public static Network createThreeCc() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        Bus b7 = ConnectedComponentNetworkFactory.createBus(network, "b7");
        Bus b8 = ConnectedComponentNetworkFactory.createBus(network, "b8");
        Bus b9 = ConnectedComponentNetworkFactory.createBus(network, "b9");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b7, "l47", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b7, b8, "l78", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b7, b9, "l79", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b8, b9, "l89", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createGenerator(b9, "g9", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b7, "d7", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b8, "d8", 2.0);
        return network;
    }

    public static Network createThreeCircularCc() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        Bus b7 = ConnectedComponentNetworkFactory.createBus(network, "b7");
        Bus b8 = ConnectedComponentNetworkFactory.createBus(network, "b8");
        Bus b9 = ConnectedComponentNetworkFactory.createBus(network, "b9");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b7, "l27", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b8, "l58", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b7, b8, "l78", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b7, b9, "l79", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b8, b9, "l89", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createGenerator(b9, "g9", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b7, "d7", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b8, "d8", 2.0);
        return network;
    }

    public static Network createAsymetricNetwork() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        Bus b7 = ConnectedComponentNetworkFactory.createBus(network, "b7");
        Bus b8 = ConnectedComponentNetworkFactory.createBus(network, "b8");
        Bus b9 = ConnectedComponentNetworkFactory.createBus(network, "b9");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b8, "l18", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b7, "l27", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b9, "l39", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b7, b8, "l78", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b7, b9, "l79", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b8, b9, "l89", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createGenerator(b9, "g9", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b7, "d7", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b8, "d8", 2.0);
        return network;
    }

    public static Network createHighlyConnectedNetwork() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        Bus b7 = ConnectedComponentNetworkFactory.createBus(network, "b7");
        Bus b8 = ConnectedComponentNetworkFactory.createBus(network, "b8");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b4, "l24", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b5, "l35", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b6, "l36", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b7, "l57", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b6, b7, "l67", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b7, b8, "l78", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b1, "g1", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 1.0);
        ConnectedComponentNetworkFactory.createGenerator(b3, "g3", 1.0);
        ConnectedComponentNetworkFactory.createGenerator(b7, "g7", 5.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b2, "d2", 4.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b6, "d6", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b8, "d8", 1.0);
        return network;
    }

    public static Network createHighlyConnectedSingleComponent() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b4, "l24", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b5, "l35", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b1, "g1", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 1.0);
        ConnectedComponentNetworkFactory.createGenerator(b3, "g3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b2, "d2", 4.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        return network;
    }

    public static Network createTwoUnconnectedCC() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b6, "g6", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b3, "d3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        return network;
    }

    public static Network createSubComp() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createBus(network, "b4");
        Bus b5 = ConnectedComponentNetworkFactory.createBus(network, "b5");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b4, "l24", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b3, b5, "l35", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createGenerator(b1, "g1", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b2, "g2", 1.0);
        ConnectedComponentNetworkFactory.createGenerator(b3, "g3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b1, "d1", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b2, "d2", 4.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b5, "d5", 2.0);
        return network;
    }

    public static Network createTwoCcLinkedBySwitches() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ConnectedComponentNetworkFactory.createBus(network, "b1");
        Bus b2 = ConnectedComponentNetworkFactory.createBus(network, "b2");
        Bus b3 = ConnectedComponentNetworkFactory.createBus(network, "b3");
        Bus b4 = ConnectedComponentNetworkFactory.createOtherBus(network, "b4", "b3_vl");
        Bus b5 = ConnectedComponentNetworkFactory.createOtherBus(network, "b5", "b2_vl");
        Bus b6 = ConnectedComponentNetworkFactory.createBus(network, "b6");
        ConnectedComponentNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        ConnectedComponentNetworkFactory.createSwitch(network, b3, b4, "s34");
        ConnectedComponentNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        ConnectedComponentNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        ConnectedComponentNetworkFactory.createSwitch(network, b2, b5, "s25");
        ConnectedComponentNetworkFactory.createGenerator(b1, "g1", 3.0);
        ConnectedComponentNetworkFactory.createGenerator(b5, "g3", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b4, "d4", 3.0);
        ConnectedComponentNetworkFactory.createLoad(b2, "d2", 1.0);
        return network;
    }

    public static Network createNoCc0Sc0() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b01 = ConnectedComponentNetworkFactory.createBus(network, "b01");
        Bus b02 = ConnectedComponentNetworkFactory.createBus(network, "b02");
        Bus b03 = ConnectedComponentNetworkFactory.createBus(network, "b03");
        Bus b04 = ConnectedComponentNetworkFactory.createBus(network, "b04");
        Bus b11 = ConnectedComponentNetworkFactory.createBus(network, "b11");
        Bus b12 = ConnectedComponentNetworkFactory.createBus(network, "b12");
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)b01.getVoltageLevel().newVscConverterStation().setId("cs1-12")).setConnectableBus(b01.getId())).setBus(b01.getId())).setVoltageRegulatorOn(true).setVoltageSetpoint(1.0).setReactivePowerSetpoint(0.0).setLossFactor(0.0f)).add();
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)b02.getVoltageLevel().newVscConverterStation().setId("cs2-12")).setConnectableBus(b02.getId())).setBus(b02.getId())).setVoltageRegulatorOn(true).setVoltageSetpoint(1.0).setReactivePowerSetpoint(0.0).setLossFactor(0.0f)).add();
        ((HvdcLineAdder)network.newHvdcLine().setId("hvdc12")).setConverterStationId1("cs1-12").setConverterStationId2("cs2-12").setNominalV(1.0).setR(0.0).setActivePowerSetpoint(1.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setMaxP(5.0).add();
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)b02.getVoltageLevel().newVscConverterStation().setId("cs1-23")).setConnectableBus(b02.getId())).setBus(b02.getId())).setVoltageRegulatorOn(true).setVoltageSetpoint(1.0).setReactivePowerSetpoint(0.0).setLossFactor(0.0f)).add();
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)b03.getVoltageLevel().newVscConverterStation().setId("cs2-23")).setConnectableBus(b03.getId())).setBus(b03.getId())).setVoltageRegulatorOn(true).setVoltageSetpoint(1.0).setReactivePowerSetpoint(0.0).setLossFactor(0.0f)).add();
        ((HvdcLineAdder)network.newHvdcLine().setId("hvdc23")).setConverterStationId1("cs1-23").setConverterStationId2("cs2-23").setNominalV(1.0).setR(0.0).setActivePowerSetpoint(2.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setMaxP(5.0).add();
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)b03.getVoltageLevel().newVscConverterStation().setId("cs1-34")).setConnectableBus(b03.getId())).setBus(b03.getId())).setVoltageRegulatorOn(true).setVoltageSetpoint(1.0).setReactivePowerSetpoint(0.0).setLossFactor(0.0f)).add();
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)b04.getVoltageLevel().newVscConverterStation().setId("cs2-34")).setConnectableBus(b04.getId())).setBus(b04.getId())).setVoltageRegulatorOn(true).setVoltageSetpoint(1.0).setReactivePowerSetpoint(0.0).setLossFactor(0.0f)).add();
        ((HvdcLineAdder)network.newHvdcLine().setId("hvdc34")).setConverterStationId1("cs1-34").setConverterStationId2("cs2-34").setNominalV(1.0).setR(0.0).setActivePowerSetpoint(3.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setMaxP(5.0).add();
        ConnectedComponentNetworkFactory.createGenerator(b01, "g01", 1.0);
        ConnectedComponentNetworkFactory.createGenerator(b02, "g02", 1.0);
        ConnectedComponentNetworkFactory.createGenerator(b03, "g03", 1.0);
        ConnectedComponentNetworkFactory.createGenerator(b04, "g04", 1.0);
        ConnectedComponentNetworkFactory.createLoad(b04, "l04", 4.0);
        ConnectedComponentNetworkFactory.createGenerator(b11, "g11", 2.0);
        ConnectedComponentNetworkFactory.createLoad(b12, "l11", 2.0);
        ConnectedComponentNetworkFactory.createLine(network, b11, b12, "l11-12", 0.1f);
        return network;
    }
}

