/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.ActivePowerControlAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class DistributedSlackNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network create() {
        Network network = Network.create((String)"distributed-generation-slack-bus", (String)"code");
        Bus b1 = DistributedSlackNetworkFactory.createBus(network, "b1", 400.0);
        Bus b2 = DistributedSlackNetworkFactory.createBus(network, "b2", 400.0);
        Bus b3 = DistributedSlackNetworkFactory.createBus(network, "b3", 400.0);
        Bus b4 = DistributedSlackNetworkFactory.createBus(network, "b4", 400.0);
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b1.getVoltageLevel().newGenerator().setId("g1")).setBus("b1")).setConnectableBus("b1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(200.0).setTargetP(100.0).setTargetV(400.0).setVoltageRegulatorOn(true).add();
        ((ActivePowerControlAdder)g1.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withDroop(4.0).add();
        Generator g2 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b2.getVoltageLevel().newGenerator().setId("g2")).setBus("b2")).setConnectableBus("b2")).setEnergySource(EnergySource.THERMAL).setMinP(100.0).setMaxP(300.0).setTargetP(200.0).setTargetQ(300.0).setVoltageRegulatorOn(false).add();
        ((ActivePowerControlAdder)g2.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withDroop(2.0).add();
        Generator g3 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b3.getVoltageLevel().newGenerator().setId("g3")).setBus("b3")).setConnectableBus("b3")).setEnergySource(EnergySource.THERMAL).setMinP(50.0).setMaxP(150.0).setTargetP(90.0).setTargetQ(130.0).setVoltageRegulatorOn(false).add();
        ((ActivePowerControlAdder)g3.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withDroop(3.0).add();
        Generator g4 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b3.getVoltageLevel().newGenerator().setId("g4")).setBus("b3")).setConnectableBus("b3")).setEnergySource(EnergySource.THERMAL).setMinP(50.0).setMaxP(150.0).setTargetP(90.0).setTargetQ(130.0).setVoltageRegulatorOn(false).add();
        ((ActivePowerControlAdder)g4.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withDroop(1.0).add();
        DistributedSlackNetworkFactory.createLoad(b4, "l1", 600.0, 400.0);
        DistributedSlackNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        DistributedSlackNetworkFactory.createLine(network, b2, b4, "l24", 0.15f);
        DistributedSlackNetworkFactory.createLine(network, b3, b4, "l34", 0.12f);
        return network;
    }

    public static Network createWithLossesAndPvPqTypeSwitch() {
        Network network = DistributedSlackNetworkFactory.create();
        network.getLineStream().forEach(l -> l.setR(0.1));
        network.getGenerator("g2").setTargetV(402.0).setVoltageRegulatorOn(true).newMinMaxReactiveLimits().setMinQ(-300.0).setMaxQ(300.0).add();
        return network;
    }

    public static Network createNetworkWithLoads() {
        Network network = Network.create((String)"distributed-load-slack-bus", (String)"code");
        Bus b1 = DistributedSlackNetworkFactory.createBus(network, "b1", 400.0);
        Bus b2 = DistributedSlackNetworkFactory.createBus(network, "b2", 400.0);
        Bus b3 = DistributedSlackNetworkFactory.createBus(network, "b3", 400.0);
        Bus b4 = DistributedSlackNetworkFactory.createBus(network, "b4", 400.0);
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b1.getVoltageLevel().newGenerator().setId("g1")).setBus("b1")).setConnectableBus("b1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(400.0).setTargetP(100.0).setTargetV(400.0).setVoltageRegulatorOn(true).add();
        Generator g2 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b2.getVoltageLevel().newGenerator().setId("g2")).setBus("b2")).setConnectableBus("b2")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(400.0).setTargetP(200.0).setTargetQ(300.0).setVoltageRegulatorOn(false).add();
        DistributedSlackNetworkFactory.createLoad(b1, "l1", 30.0, 30.0);
        DistributedSlackNetworkFactory.createLoad(b2, "l2", 60.0, 40.0);
        DistributedSlackNetworkFactory.createLoad(b3, "l3", 50.0, 35.0);
        DistributedSlackNetworkFactory.createLoad(b4, "l4", 140.0, 100.0);
        DistributedSlackNetworkFactory.createLoad(b4, "l5", 10.0, 100.0);
        DistributedSlackNetworkFactory.createLoad(b4, "l6", -50.0, 100.0);
        DistributedSlackNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        DistributedSlackNetworkFactory.createLine(network, b2, b4, "l24", 0.15f);
        DistributedSlackNetworkFactory.createLine(network, b3, b4, "l34", 0.12f);
        return network;
    }

    public static Network createNetworkWithLoads2() {
        Network network = Network.create((String)"distributed-load-slack-bus-2", (String)"code");
        Bus b1 = DistributedSlackNetworkFactory.createBus(network, "b1", 400.0);
        Bus b2 = DistributedSlackNetworkFactory.createBus(network, "b2", 400.0);
        Bus b3 = DistributedSlackNetworkFactory.createBus(network, "b3", 400.0);
        Bus b4 = DistributedSlackNetworkFactory.createBus(network, "b4", 400.0);
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b1.getVoltageLevel().newGenerator().setId("g1")).setBus("b1")).setConnectableBus("b1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(400.0).setTargetP(100.0).setTargetV(400.0).setVoltageRegulatorOn(true).add();
        Generator g2 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b2.getVoltageLevel().newGenerator().setId("g2")).setBus("b2")).setConnectableBus("b2")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(400.0).setTargetP(200.0).setTargetQ(300.0).setVoltageRegulatorOn(false).add();
        DistributedSlackNetworkFactory.createLoad(b4, "l4", 100.0, 50.0);
        DistributedSlackNetworkFactory.createLoad(b4, "l5", 300.0, 30.0);
        DistributedSlackNetworkFactory.createLine(network, b1, b4, "l14", 10.0);
        DistributedSlackNetworkFactory.createLine(network, b2, b4, "l24", 10.0);
        DistributedSlackNetworkFactory.createLine(network, b3, b4, "l34", 10.0);
        return network;
    }

    public static Network createWithBattery() {
        Network network = DistributedSlackNetworkFactory.create();
        Battery bat1 = ((BatteryAdder)((BatteryAdder)((BatteryAdder)network.getBusBreakerView().getBus("b1").getVoltageLevel().newBattery().setId("bat1")).setMinP(-10.0).setMaxP(10.0).setTargetP(2.0).setBus("b1")).setConnectableBus("b1")).setTargetQ(0.0).add();
        ((ActivePowerControlAdder)bat1.newExtension(ActivePowerControlAdder.class)).withParticipate(false).withDroop(0.0).withParticipationFactor(0.0).add();
        Battery bat2 = ((BatteryAdder)((BatteryAdder)((BatteryAdder)network.getBusBreakerView().getBus("b2").getVoltageLevel().newBattery().setId("bat2")).setMinP(-20.0).setMaxP(20.0).setTargetP(-5.0).setBus("b2")).setConnectableBus("b2")).setTargetQ(0.0).add();
        ((ActivePowerControlAdder)bat2.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withDroop(3.0).withParticipationFactor(0.5).add();
        return network;
    }

    public static Network createWithEpsilonDistribution() {
        Network network = Network.create((String)"distributed-generation-slack-bus", (String)"code");
        Bus b = DistributedSlackNetworkFactory.createBus(network, "bus");
        DistributedSlackNetworkFactory.createLoad(b, "load", 1000.15);
        for (int i = 0; i < 1000; ++i) {
            DistributedSlackNetworkFactory.createGenerator(b, "g" + i, 1.0);
        }
        return network;
    }
}

