/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControlAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class FourBusNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network createBaseNetwork() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = FourBusNetworkFactory.createBus(network, "b1");
        Bus b2 = FourBusNetworkFactory.createBus(network, "b2");
        Bus b3 = FourBusNetworkFactory.createBus(network, "b3");
        Bus b4 = FourBusNetworkFactory.createBus(network, "b4");
        FourBusNetworkFactory.createGenerator(b1, "g1", 2.0);
        FourBusNetworkFactory.createGenerator(b4, "g4", 1.0);
        FourBusNetworkFactory.createLoad(b2, "d2", 1.0);
        FourBusNetworkFactory.createLoad(b3, "d3", 4.0);
        FourBusNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        FourBusNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        FourBusNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        FourBusNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        FourBusNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        return network;
    }

    public static Network create() {
        Network network = FourBusNetworkFactory.createBaseNetwork();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        FourBusNetworkFactory.createGenerator(b2, "g2", 2.0);
        return network;
    }

    public static Network createWithPhaseTapChanger() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = FourBusNetworkFactory.createBus(network, "b1");
        Bus b2 = FourBusNetworkFactory.createBus(network, "test_s", "b2");
        Bus b3 = FourBusNetworkFactory.createBus(network, "test_s", "b3");
        Bus b4 = FourBusNetworkFactory.createBus(network, "b4");
        FourBusNetworkFactory.createGenerator(b1, "g1", 2.0);
        FourBusNetworkFactory.createGenerator(b4, "g4", 1.0);
        FourBusNetworkFactory.createLoad(b2, "d2", 1.0);
        FourBusNetworkFactory.createLoad(b3, "d3", 4.0);
        FourBusNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        FourBusNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        TwoWindingsTransformer twt = FourBusNetworkFactory.createTransformer(network, "test_s", b2, b3, "l23", 0.1f, 1.0);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)twt.newPhaseTapChanger().setTapPosition(0)).beginStep()).setX((double)0.1f)).setAlpha(1.0)).endStep()).add();
        FourBusNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        FourBusNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        return network;
    }

    public static Network createWithPhaseTapChangerAndGeneratorAtBus2() {
        Network network = FourBusNetworkFactory.createWithPhaseTapChanger();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        FourBusNetworkFactory.createGenerator(b2, "g2", 2.0);
        return network;
    }

    public static Network createWithTwoGeneratorsAtBus2() {
        Network network = FourBusNetworkFactory.create();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        FourBusNetworkFactory.createGenerator(b2, "g5", 0.5);
        return network;
    }

    public static Network createWith2GeneratorsAtBus1() {
        Network network = FourBusNetworkFactory.create();
        Bus b1 = network.getBusBreakerView().getBus("b1");
        FourBusNetworkFactory.createGenerator(b1, "g1Bis", 2.0);
        network.getLoad("d3").setQ0(1.0);
        return network;
    }

    public static Network createWithReactiveControl() {
        Network network = FourBusNetworkFactory.create();
        network.getLoad("d3").setQ0(1.0);
        Line l34 = network.getLine("l34");
        double remoteTargetQ = 2.0;
        Generator g4 = network.getGenerator("g4");
        g4.setTargetQ(0.0).setVoltageRegulatorOn(false);
        Generator g1 = network.getGenerator("g1");
        g1.setTargetQ(0.0).setVoltageRegulatorOn(false);
        ((RemoteReactivePowerControlAdder)g1.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(remoteTargetQ).withRegulatingTerminal(l34.getTerminal(TwoSides.TWO)).withEnabled(true).add();
        ((RemoteReactivePowerControlAdder)g4.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(remoteTargetQ).withRegulatingTerminal(l34.getTerminal(TwoSides.TWO)).withEnabled(true).add();
        return network;
    }

    public static Network createWithReactiveControl2GeneratorsOnSameBus() {
        Network network = FourBusNetworkFactory.create();
        network.getLoad("d3").setQ0(1.0);
        Line l34 = network.getLine("l34");
        double remoteTargetQ = 2.0;
        Bus b1 = network.getBusBreakerView().getBus("b1");
        Generator g1 = network.getGenerator("g1");
        g1.setTargetQ(0.0).setVoltageRegulatorOn(false);
        ((RemoteReactivePowerControlAdder)g1.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(remoteTargetQ).withRegulatingTerminal(l34.getTerminal(TwoSides.TWO)).withEnabled(true).add();
        Generator g1Bis = FourBusNetworkFactory.createGenerator(b1, "g1Bis", 2.0);
        g1Bis.setTargetQ(0.0).setVoltageRegulatorOn(false);
        ((RemoteReactivePowerControlAdder)g1Bis.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(remoteTargetQ).withRegulatingTerminal(l34.getTerminal(TwoSides.TWO)).withEnabled(true).add();
        return network;
    }

    public static Network createWithReactiveControl2GeneratorsOnSameBusAnd1Extra() {
        Network network = FourBusNetworkFactory.createWithReactiveControl2GeneratorsOnSameBus();
        Generator g4 = network.getGenerator("g4");
        g4.setTargetQ(0.0).setVoltageRegulatorOn(false);
        Line l34 = network.getLine("l34");
        double remoteTargetQ = 2.0;
        ((RemoteReactivePowerControlAdder)g4.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(remoteTargetQ).withRegulatingTerminal(l34.getTerminal(TwoSides.TWO)).withEnabled(true).add();
        return network;
    }

    public static Network createWithAdditionalReactiveTerms() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = FourBusNetworkFactory.createBus(network, "b1");
        Bus b2 = FourBusNetworkFactory.createBus(network, "b2");
        Bus b3 = FourBusNetworkFactory.createBus(network, "b3");
        Bus b4 = FourBusNetworkFactory.createBus(network, "b4");
        FourBusNetworkFactory.createGenerator(b2, "g2", 2.0);
        FourBusNetworkFactory.createGenerator(b3, "g3", 2.0);
        FourBusNetworkFactory.createLoad(b1, "d1", 1.0);
        FourBusNetworkFactory.createLoad(b3, "d3", 3.0);
        FourBusNetworkFactory.createLine(network, b1, b2, "l12", 0.5);
        FourBusNetworkFactory.createLine(network, b1, b3, "l13", 0.5);
        FourBusNetworkFactory.createLine(network, b2, b4, "l24", 1.0);
        FourBusNetworkFactory.createLine(network, b3, b4, "l34", 1.0);
        Generator g2 = network.getGenerator("g2");
        g2.setRegulatingTerminal(network.getLine("l24").getTerminal2());
        Generator g3 = network.getGenerator("g3");
        g3.setRegulatingTerminal(network.getLine("l24").getTerminal2());
        return network;
    }

    public static Network createWithCondenser() {
        Network network = FourBusNetworkFactory.createBaseNetwork();
        network.getGenerator("g4").setTargetP(0.0).setMaxP(0.0).setMinP(0.0);
        return network;
    }

    public static Network createWithTwoScs() {
        Network network = FourBusNetworkFactory.createBaseNetwork();
        Bus c1 = FourBusNetworkFactory.createBus(network, "c1");
        Bus c2 = FourBusNetworkFactory.createBus(network, "c2");
        FourBusNetworkFactory.createGenerator(c1, "gc1", 2.0);
        FourBusNetworkFactory.createLoad(c2, "dc2", 1.0);
        FourBusNetworkFactory.createLine(network, c1, c2, "lc12", 1.0);
        FourBusNetworkFactory.createLine(network, c1, c2, "lc12Bis", 1.0);
        return network;
    }

    public static Network createWithSeveralTransformerVoltageControls() {
        Network network = Network.create((String)"testTransformerVoltageControls", (String)"code");
        Bus b1 = FourBusNetworkFactory.createBus(network, "s", "b1", 225.0);
        Bus b2 = FourBusNetworkFactory.createBus(network, "s", "b2", 225.0);
        Bus b3 = FourBusNetworkFactory.createBus(network, "s", "b3", 225.0);
        Bus b4 = FourBusNetworkFactory.createBus(network, "s", "b4", 225.0);
        Bus b5 = FourBusNetworkFactory.createBus(network, "s", "b5", 225.0);
        Bus b6 = FourBusNetworkFactory.createBus(network, "s", "b6", 90.0);
        Bus b7 = FourBusNetworkFactory.createBus(network, "s", "b7", 90.0);
        Bus b8 = FourBusNetworkFactory.createBus(network, "s", "b8", 90.0);
        FourBusNetworkFactory.createGenerator(b1, "g1", 4.0, 230.0);
        FourBusNetworkFactory.createGenerator(b8, "g3", 3.0, 93.0);
        FourBusNetworkFactory.createLoad(b4, "d4", 2.0);
        FourBusNetworkFactory.createLoad(b6, "d6", 1.0);
        FourBusNetworkFactory.createLoad(b7, "d7", 4.0);
        FourBusNetworkFactory.createLine(network, b1, b2, "l12", 0.15);
        FourBusNetworkFactory.createLine(network, b1, b3, "l13", 0.1);
        FourBusNetworkFactory.createLine(network, b3, b5, "l35", 0.2);
        FourBusNetworkFactory.createLine(network, b2, b5, "l25", 0.16);
        FourBusNetworkFactory.createTransformer(network, "s", b3, b8, "t38", 0.15, 1.0);
        TwoWindingsTransformer twt = FourBusNetworkFactory.createTransformer(network, "s", b2, b4, "t24", 1.0, 1.0);
        ((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)twt.newRatioTapChanger().setTapPosition(0)).setRegulationTerminal(twt.getTerminal2())).setTargetV(230.0).setRegulating(true)).setTargetDeadband(0.1)).setLoadTapChangingCapabilities(true)).beginStep()).setX((double)0.1f)).setRho(1.2)).endStep()).beginStep()).setX((double)0.1f)).setRho(1.0)).endStep()).beginStep()).setX((double)0.1f)).setRho(0.8)).endStep()).add();
        TwoWindingsTransformer twt2 = FourBusNetworkFactory.createTransformer(network, "s", b5, b7, "t57", 0.2, 1.0);
        ((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)twt2.newRatioTapChanger().setTapPosition(0)).setRegulationTerminal(twt2.getTerminal2())).setTargetV(93.0).setRegulating(true)).setTargetDeadband(0.1)).setLoadTapChangingCapabilities(true)).beginStep()).setX((double)0.1f)).setRho(1.2)).endStep()).beginStep()).setX((double)0.1f)).setRho(1.0)).endStep()).beginStep()).setX((double)0.1f)).setRho(0.8)).endStep()).add();
        TwoWindingsTransformer twt3 = FourBusNetworkFactory.createTransformer(network, "s", b5, b6, "t56", 0.2, 1.0);
        ((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)twt3.newRatioTapChanger().setTapPosition(0)).setRegulationTerminal(twt3.getTerminal2())).setTargetV(93.0).setRegulating(true)).setTargetDeadband(0.1)).setLoadTapChangingCapabilities(true)).beginStep()).setX((double)0.1f)).setRho(1.2)).endStep()).beginStep()).setX((double)0.1f)).setRho(1.0)).endStep()).beginStep()).setX((double)0.1f)).setRho(0.8)).endStep()).add();
        return network;
    }
}

