/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.network.extensions.HvdcAngleDroopActivePowerControlAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class HvdcNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network createVsc() {
        Network network = Network.create((String)"vsc", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(102.56).setTargetV(390.0).setMinP(0.0).setMaxP(500.0).setVoltageRegulatorOn(true).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("ld2")).setConnectableBus("b2")).setBus("b2")).setP0(50.0).setQ0(10.0).add();
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)vl2.newVscConverterStation().setId("cs2")).setConnectableBus("b2")).setBus("b2")).setVoltageRegulatorOn(true).setVoltageSetpoint(385.0).setReactivePowerSetpoint(100.0).setLossFactor(1.1f)).add();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl3.newLoad().setId("ld3")).setConnectableBus("b3")).setBus("b3")).setP0(50.0).setQ0(10.0).add();
        ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)vl3.newVscConverterStation().setId("cs3")).setConnectableBus("b3")).setBus("b3")).setVoltageRegulatorOn(true).setVoltageSetpoint(383.0).setReactivePowerSetpoint(100.0).setLossFactor(0.2f)).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l12")).setBus1("b1")).setBus2("b2")).setR(1.0).setX(3.0).add();
        ((HvdcLineAdder)network.newHvdcLine().setId("hvdc23")).setConverterStationId1("cs2").setConverterStationId2("cs3").setNominalV(400.0).setR(0.1).setActivePowerSetpoint(50.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setMaxP(500.0).add();
        return network;
    }

    public static Network createLcc() {
        Network network = Network.create((String)"lcc", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(102.56).setTargetV(390.0).setMinP(0.0).setMaxP(500.0).setVoltageRegulatorOn(true).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("ld2")).setConnectableBus("b2")).setBus("b2")).setP0(50.0).setQ0(10.0).add();
        ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)vl2.newLccConverterStation().setId("cs2")).setConnectableBus("b2")).setBus("b2")).setPowerFactor(0.8f).setLossFactor(0.1f)).add();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl3.newLoad().setId("ld3")).setConnectableBus("b3")).setBus("b3")).setP0(50.0).setQ0(10.0).add();
        ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)vl3.newLccConverterStation().setId("cs3")).setConnectableBus("b3")).setBus("b3")).setPowerFactor(0.8f).setLossFactor(1.1f)).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl3.newGenerator().setId("g3")).setConnectableBus("b3")).setBus("b3")).setTargetP(102.56).setTargetV(380.0).setMinP(0.0).setMaxP(500.0).setVoltageRegulatorOn(true).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l12")).setBus1("b1")).setBus2("b2")).setR(1.0).setX(3.0).add();
        ((HvdcLineAdder)network.newHvdcLine().setId("hvdc23")).setConverterStationId1("cs2").setConverterStationId2("cs3").setNominalV(400.0).setR(0.1).setActivePowerSetpoint(50.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).setMaxP(500.0).add();
        return network;
    }

    public static Network createLccWithBiggerComponents() {
        Network network = HvdcNetworkFactory.createLcc();
        Bus b1 = network.getBusBreakerView().getBus("b1");
        Bus b3 = network.getBusBreakerView().getBus("b3");
        Bus b4 = HvdcNetworkFactory.createBus(network, "test_s", "b4", 400.0);
        Bus b5 = HvdcNetworkFactory.createBus(network, "test_s", "b5", 400.0);
        Bus b6 = HvdcNetworkFactory.createBus(network, "test_s", "b6", 400.0);
        HvdcNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        HvdcNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        TwoWindingsTransformer twt = HvdcNetworkFactory.createTransformer(network, "test_s", b4, b5, "l45", 0.1f, 1.0);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)twt.newPhaseTapChanger().setTapPosition(0)).beginStep()).setX((double)0.1f)).setAlpha(1.0)).endStep()).add();
        HvdcNetworkFactory.createGenerator(b6, "g6", 1.0);
        for (int i = 0; i < 10; ++i) {
            Bus b = HvdcNetworkFactory.createBus(network, "test_s", "additionnalbus_" + i, 400.0);
            HvdcNetworkFactory.createLine(network, b1, b, "additionnalline_" + i, 0.1f);
        }
        return network;
    }

    public static Network createLccWithBiggerComponentsAndAdditionalLine() {
        Network network = HvdcNetworkFactory.createLccWithBiggerComponents();
        HvdcNetworkFactory.createLine(network, network.getBusBreakerView().getBus("additionnalbus_0"), network.getBusBreakerView().getBus("additionnalbus_1"), "additionnalline_01", 0.1f);
        return network;
    }

    public static Network createLccWithBiggerComponentsAndAdditionalLine2() {
        Network network = HvdcNetworkFactory.createLccWithBiggerComponents();
        HvdcNetworkFactory.createBus(network, "test_s", "additionnalbus_10", 400.0);
        HvdcNetworkFactory.createLine(network, network.getBusBreakerView().getBus("additionnalbus_0"), network.getBusBreakerView().getBus("additionnalbus_10"), "additionnalline_10", 0.1f);
        return network;
    }

    public static Network createTwoCcLinkedByAHvdc() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1");
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2");
        Bus b3 = HvdcNetworkFactory.createBus(network, "b3");
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4");
        Bus b5 = HvdcNetworkFactory.createBus(network, "b5");
        Bus b6 = HvdcNetworkFactory.createBus(network, "b6");
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        HvdcNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        LccConverterStation cs3 = HvdcNetworkFactory.createLcc(b3, "cs3");
        LccConverterStation cs4 = HvdcNetworkFactory.createLcc(b4, "cs4");
        HvdcNetworkFactory.createHvdcLine(network, "hvdc34", (HvdcConverterStation)cs3, (HvdcConverterStation)cs4, 400.0, 0.1, 2.0);
        HvdcNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        HvdcNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        HvdcNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        return network;
    }

    public static Network createHvdcLinkedByTwoLinesAndSwitch() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1", 400.0);
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2", 400.0);
        Bus b2Bis = ((BusAdder)b2.getVoltageLevel().getBusBreakerView().newBus().setId("b2Bis")).add();
        Bus b3 = HvdcNetworkFactory.createBus(network, "b3", 400.0);
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4", 400.0);
        HvdcNetworkFactory.createGenerator(b1, "g1", 400.0, 400.0);
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b2Bis, "l12Bis", 0.1f);
        HvdcNetworkFactory.createSwitch(network, b2, b2Bis, "s2").setOpen(true);
        VscConverterStation cs2 = HvdcNetworkFactory.createVsc(b2, "cs2", 400.0, 0.0);
        VscConverterStation cs3 = HvdcNetworkFactory.createVsc(b3, "cs3", 400.0, 0.0);
        ((HvdcAngleDroopActivePowerControlAdder)HvdcNetworkFactory.createHvdcLine(network, "hvdc23", (HvdcConverterStation)cs2, (HvdcConverterStation)cs3, 400.0, 0.1, 200.0).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_RECTIFIER_SIDE_2_INVERTER).newExtension(HvdcAngleDroopActivePowerControlAdder.class)).withDroop(180.0f).withP0(200.0f).withEnabled(true).add();
        HvdcNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        HvdcNetworkFactory.createLoad(b4, "l4", 300.0, 0.0);
        return network;
    }

    public static Network createTwoCcLinkedByAHvdcVsc() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1");
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2");
        Bus b3 = HvdcNetworkFactory.createBus(network, "b3");
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4");
        Bus b5 = HvdcNetworkFactory.createBus(network, "b5");
        Bus b6 = HvdcNetworkFactory.createBus(network, "b6");
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        HvdcNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        VscConverterStation cs3 = HvdcNetworkFactory.createVsc(b3, "cs3", 1.2, 0.0);
        VscConverterStation cs4 = HvdcNetworkFactory.createVsc(b4, "cs4", 1.2, 0.0);
        HvdcNetworkFactory.createHvdcLine(network, "hvdc34", (HvdcConverterStation)cs3, (HvdcConverterStation)cs4, 400.0, 0.1, 2.0);
        HvdcNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        HvdcNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        HvdcNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        return network;
    }

    public static Network createTwoCcLinkedByAHvdcWithATransformer() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1");
        Bus b2 = HvdcNetworkFactory.createBus(network, "test_s", "b2");
        Bus b3 = HvdcNetworkFactory.createBus(network, "test_s", "b3");
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4");
        Bus b5 = HvdcNetworkFactory.createBus(network, "b5");
        Bus b6 = HvdcNetworkFactory.createBus(network, "b6");
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        TwoWindingsTransformer twt = HvdcNetworkFactory.createTransformer(network, "test_s", b2, b3, "l23", 0.1f, 1.0);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)twt.newPhaseTapChanger().setTapPosition(0)).beginStep()).setX((double)0.1f)).setAlpha(1.0)).endStep()).add();
        LccConverterStation cs3 = HvdcNetworkFactory.createLcc(b3, "cs3");
        LccConverterStation cs4 = HvdcNetworkFactory.createLcc(b4, "cs4");
        HvdcNetworkFactory.createHvdcLine(network, "hvdc34", (HvdcConverterStation)cs3, (HvdcConverterStation)cs4, 400.0, 0.1, 2.0);
        HvdcNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        HvdcNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        HvdcNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        return network;
    }

    public static Network createTwoCcLinkedByAHvdcVscWithGenerators() {
        Network network = HvdcNetworkFactory.createTwoCcLinkedByAHvdcVsc();
        Bus b1 = network.getBusBreakerView().getBus("b1");
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b6 = network.getBusBreakerView().getBus("b6");
        HvdcNetworkFactory.createGenerator(b1, "g1", 1.0);
        HvdcNetworkFactory.createGenerator(b2, "g2", 1.0);
        HvdcNetworkFactory.createLoad(b2, "d2", 4.0);
        HvdcNetworkFactory.createGenerator(b6, "g6", 1.0);
        return network;
    }

    public static Network createTwoCcLinkedByAHvdcWithGenerators() {
        Network network = HvdcNetworkFactory.createTwoCcLinkedByAHvdc();
        Bus b1 = network.getBusBreakerView().getBus("b1");
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b6 = network.getBusBreakerView().getBus("b6");
        HvdcNetworkFactory.createGenerator(b1, "g1", 1.0);
        HvdcNetworkFactory.createGenerator(b2, "g2", 1.0);
        HvdcNetworkFactory.createLoad(b2, "d2", 4.0);
        HvdcNetworkFactory.createGenerator(b6, "g6", 1.0);
        return network;
    }

    public static Network createNetworkWithGenerators() {
        Network network = HvdcNetworkFactory.createTwoCcLinkedByAHvdcWithGenerators();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b5 = network.getBusBreakerView().getBus("b5");
        HvdcNetworkFactory.createLine(network, b2, b5, "l25", 0.1f);
        HvdcNetworkFactory.createGenerator(b5, "g5", 1.0);
        return network;
    }

    public static Network createNetworkWithGenerators2() {
        Network network = HvdcNetworkFactory.createTwoCcLinkedByAHvdcVscWithGenerators();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b5 = network.getBusBreakerView().getBus("b5");
        HvdcNetworkFactory.createLine(network, b2, b5, "l25", 0.1f);
        HvdcNetworkFactory.createGenerator(b5, "g5", 1.0);
        return network;
    }

    public static Network createNetworkWithTransformer() {
        Network network = HvdcNetworkFactory.createTwoCcLinkedByAHvdcWithATransformer();
        Bus b1 = network.getBusBreakerView().getBus("b1");
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b6 = network.getBusBreakerView().getBus("b6");
        HvdcNetworkFactory.createGenerator(b1, "g1", 1.0);
        HvdcNetworkFactory.createGenerator(b2, "g2", 1.0);
        HvdcNetworkFactory.createLoad(b2, "d2", 4.0);
        HvdcNetworkFactory.createGenerator(b6, "g6", 1.0);
        return network;
    }

    public static Network createLinkedNetworkWithTransformer() {
        Network network = HvdcNetworkFactory.createNetworkWithTransformer();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b5 = network.getBusBreakerView().getBus("b5");
        HvdcNetworkFactory.createLine(network, b2, b5, "l25", 0.1f);
        HvdcNetworkFactory.createGenerator(b5, "g5", 1.0);
        return network;
    }

    public static Network createWithHvdcInAcEmulation() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1");
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2");
        Bus b3 = HvdcNetworkFactory.createBus(network, "b3");
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4");
        Bus b5 = HvdcNetworkFactory.createBus(network, "b5");
        Bus b6 = HvdcNetworkFactory.createBus(network, "b6");
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        HvdcNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        HvdcNetworkFactory.createLine(network, b2, b5, "l25", 0.05f);
        VscConverterStation cs3 = HvdcNetworkFactory.createVsc(b3, "cs3", 1.2, 0.0);
        VscConverterStation cs4 = HvdcNetworkFactory.createVsc(b4, "cs4", 1.2, 0.0);
        HvdcNetworkFactory.createHvdcLine(network, "hvdc34", (HvdcConverterStation)cs3, (HvdcConverterStation)cs4, 400.0, 0.1, 2.0);
        HvdcNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        HvdcNetworkFactory.createLine(network, b4, b6, "l46", 0.1f);
        HvdcNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        HvdcNetworkFactory.createGenerator(b1, "g1", 1.0);
        HvdcNetworkFactory.createGenerator(b5, "g5", 1.0);
        network.getGenerator("g1").setMaxP(5.0);
        network.getGenerator("g5").setMaxP(5.0);
        HvdcNetworkFactory.createLoad(b2, "d2", 4.0);
        return network;
    }

    public static Network createHvdcInAcEmulationInSymetricNetwork() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1");
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2");
        HvdcNetworkFactory.createGenerator(b1, "g1", 5.0).setMaxP(10.0);
        HvdcNetworkFactory.createGenerator(b2, "g2", 0.0).setMaxP(10.0);
        HvdcNetworkFactory.createLoad(b1, "l1", 3.0);
        HvdcNetworkFactory.createLoad(b2, "l2", 3.0);
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        VscConverterStation cs1 = HvdcNetworkFactory.createVsc(b1, "cs1", 1.2, 0.0);
        VscConverterStation cs2 = HvdcNetworkFactory.createVsc(b2, "cs2", 1.2, 0.0);
        ((HvdcAngleDroopActivePowerControlAdder)HvdcNetworkFactory.createHvdcLine(network, "hvdc12", (HvdcConverterStation)cs1, (HvdcConverterStation)cs2, 400.0, 0.1, 2.0).newExtension(HvdcAngleDroopActivePowerControlAdder.class)).withDroop(1.0f).withP0(0.0f).withEnabled(true).add();
        return network;
    }

    public static Network createHvdcLinkedByTwoLinesAndSwitch(HvdcConverterStation.HvdcType type) {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1", 400.0);
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2", 400.0);
        Bus b2Bis = ((BusAdder)b2.getVoltageLevel().getBusBreakerView().newBus().setId("b2Bis")).add();
        Bus b3 = HvdcNetworkFactory.createBus(network, "b3", 400.0);
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4", 400.0);
        HvdcNetworkFactory.createGenerator(b1, "g1", 400.0, 400.0);
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b2Bis, "l12Bis", 0.1f);
        HvdcNetworkFactory.createSwitch(network, b2, b2Bis, "s2").setOpen(true);
        LccConverterStation cs2 = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case HvdcConverterStation.HvdcType.LCC -> HvdcNetworkFactory.createLcc(b2, "cs2");
            case HvdcConverterStation.HvdcType.VSC -> HvdcNetworkFactory.createVsc(b2, "cs2", 400.0, 0.0);
        };
        LccConverterStation cs3 = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case HvdcConverterStation.HvdcType.LCC -> HvdcNetworkFactory.createLcc(b3, "cs3");
            case HvdcConverterStation.HvdcType.VSC -> HvdcNetworkFactory.createVsc(b3, "cs3", 400.0, 0.0);
        };
        ((HvdcAngleDroopActivePowerControlAdder)HvdcNetworkFactory.createHvdcLine(network, "hvdc23", (HvdcConverterStation)cs2, (HvdcConverterStation)cs3, 400.0, 0.1, 200.0).newExtension(HvdcAngleDroopActivePowerControlAdder.class)).withDroop(180.0f).withP0(200.0f).withEnabled(true).add();
        HvdcNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        HvdcNetworkFactory.createLoad(b4, "l4", 300.0, 0.0);
        return network;
    }

    public static Network createHvdcAndSwitch(HvdcConverterStation.HvdcType type) {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1", 400.0);
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2", 400.0);
        Bus b2Bis = ((BusAdder)b2.getVoltageLevel().getBusBreakerView().newBus().setId("b2Bis")).add();
        Bus b3 = HvdcNetworkFactory.createBus(network, "b3", 400.0);
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4", 400.0);
        Bus b5 = HvdcNetworkFactory.createBus(network, "b5", 400.0);
        Bus b6 = HvdcNetworkFactory.createBus(network, "b6", 400.0);
        Bus b7 = ((BusAdder)b3.getVoltageLevel().getBusBreakerView().newBus().setId("b7")).add();
        HvdcNetworkFactory.createGenerator(b1, "g1", 400.0, 400.0);
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b2Bis, "l12Bis", 0.1f);
        HvdcNetworkFactory.createSwitch(network, b2, b2Bis, "s2").setOpen(false);
        HvdcNetworkFactory.createSwitch(network, b3, b7, "s3").setOpen(false);
        LccConverterStation cs2 = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case HvdcConverterStation.HvdcType.LCC -> HvdcNetworkFactory.createLcc(b2, "cs2");
            case HvdcConverterStation.HvdcType.VSC -> HvdcNetworkFactory.createVsc(b2, "cs2", 400.0, 0.0);
        };
        LccConverterStation cs3 = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case HvdcConverterStation.HvdcType.LCC -> HvdcNetworkFactory.createLcc(b3, "cs3");
            case HvdcConverterStation.HvdcType.VSC -> HvdcNetworkFactory.createVsc(b3, "cs3", 400.0, 0.0);
        };
        ((HvdcAngleDroopActivePowerControlAdder)HvdcNetworkFactory.createHvdcLine(network, "hvdc23", (HvdcConverterStation)cs2, (HvdcConverterStation)cs3, 400.0, 0.1, 200.0).newExtension(HvdcAngleDroopActivePowerControlAdder.class)).withDroop(180.0f).withP0(200.0f).withEnabled(true).add();
        HvdcNetworkFactory.createLine(network, b3, b4, "l34", 0.1f);
        HvdcNetworkFactory.createLine(network, b4, b5, "l45", 0.1f);
        HvdcNetworkFactory.createLine(network, b5, b6, "l56", 0.1f);
        HvdcNetworkFactory.createLoad(b4, "l4", 300.0, 0.0);
        HvdcNetworkFactory.createLoad(b7, "l7", 50.0, 0.0);
        HvdcNetworkFactory.createGenerator(b6, "g6", 400.0, 400.0);
        return network;
    }

    public static Network createWithHvdcAndGenerator() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = HvdcNetworkFactory.createBus(network, "b1");
        Bus b2 = HvdcNetworkFactory.createBus(network, "b2");
        Bus b3 = HvdcNetworkFactory.createBus(network, "b3");
        Bus b4 = HvdcNetworkFactory.createBus(network, "b4");
        HvdcNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        HvdcNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        HvdcNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        VscConverterStation cs3 = HvdcNetworkFactory.createVsc(b3, "cs3", 1.2, 0.0);
        VscConverterStation cs4 = HvdcNetworkFactory.createVsc(b4, "cs4", 1.2, 0.0);
        HvdcNetworkFactory.createHvdcLine(network, "hvdc34", (HvdcConverterStation)cs3, (HvdcConverterStation)cs4, 400.0, 0.1, 2.0);
        HvdcNetworkFactory.createGenerator(b1, "g1", 1.0);
        HvdcNetworkFactory.createGenerator(b4, "g4", 2.0);
        network.getGenerator("g1").setMaxP(5.0);
        network.getGenerator("g4").setMaxP(5.0);
        HvdcNetworkFactory.createLoad(b2, "d2", 4.0);
        return network;
    }
}

