/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.ActivePowerControlAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class LinesWithDifferentNominalVoltagesNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network create() {
        Network network = Network.create((String)"lines-different-nominal-voltage", (String)"code");
        Bus b225g = LinesWithDifferentNominalVoltagesNetworkFactory.createBus(network, "b225g", 225.0);
        Bus b225l = LinesWithDifferentNominalVoltagesNetworkFactory.createBus(network, "b225l", 225.0);
        Bus b220A = LinesWithDifferentNominalVoltagesNetworkFactory.createBus(network, "b220A", 220.0);
        Bus b230A = LinesWithDifferentNominalVoltagesNetworkFactory.createBus(network, "b230A", 230.0);
        Bus b220B = LinesWithDifferentNominalVoltagesNetworkFactory.createBus(network, "b220B", 220.0);
        Bus b230B = LinesWithDifferentNominalVoltagesNetworkFactory.createBus(network, "b230B", 230.0);
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b225g.getVoltageLevel().newGenerator().setId("g1")).setBus("b225g")).setConnectableBus("b225g")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(600.0).setTargetP(500.0).setTargetV(225.0).setVoltageRegulatorOn(true).add();
        ((ActivePowerControlAdder)g1.newExtension(ActivePowerControlAdder.class)).withParticipate(true).withDroop(4.0).add();
        double pLoad = 100.0;
        double qLoad = 40.0;
        LinesWithDifferentNominalVoltagesNetworkFactory.createLoad(b225l, "l225", 100.0, 40.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLoad(b220A, "l220A", 100.0, 40.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLoad(b230A, "l230A", 100.0, 40.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLoad(b220B, "l220B", 100.0, 40.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLoad(b230B, "l230B", 100.0, 40.0);
        double r = 2.0;
        double x = 30.0;
        double halfGsh = 3.0E-5;
        double halfBsh = 2.0E-5;
        LinesWithDifferentNominalVoltagesNetworkFactory.createLine(network, b225g, b225l, "l225-225", 30.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLine(network, b225g, b220A, "l225-220", 30.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLine(network, b225g, b230A, "l225-230", 30.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLine(network, b220B, b225g, "l220-225", 30.0);
        LinesWithDifferentNominalVoltagesNetworkFactory.createLine(network, b230B, b225g, "l230-225", 30.0);
        network.getLines().forEach(l -> ((Line)((Line)((Line)((Line)l.setR(2.0)).setB1(2.0E-5)).setG1(3.0E-5)).setB2(2.0E-5)).setG2(3.0E-5));
        return network;
    }
}

