/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.test.PhaseShifterTestCaseFactory;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;
import java.util.List;
import java.util.stream.Collectors;

public class MultiAreaNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network create() {
        Network network = Network.create((String)"areas", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(100.0).setTargetV(400.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        ((LoadAdder)((LoadAdder)vl1.newLoad().setId("load1")).setBus("b1")).setP0(60.0).setQ0(10.0).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l12")).setBus1("b1")).setBus2("b2")).setR(0.0).setX(1.0).add();
        return network;
    }

    public static Network createOneAreaBase() {
        Network network = MultiAreaNetworkFactory.create();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        ((LoadAdder)((LoadAdder)vl3.newLoad().setId("load3")).setBus("b3")).setP0(10.0).setQ0(5.0).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l23")).setBus1("b2")).setBus2("b3")).setR(0.0).setX(1.0).add();
        ((AreaAdder)((AreaAdder)network.newArea().setId("a1")).setName("Area 1")).setAreaType("ControlArea").setInterchangeTarget(-10.0).addVoltageLevel(network.getVoltageLevel("vl1")).addVoltageLevel(network.getVoltageLevel("vl2")).addAreaBoundary(network.getLine("l23").getTerminal2(), true).add();
        return network;
    }

    public static Network createTwoAreasBase() {
        Network network = MultiAreaNetworkFactory.create();
        Substation s3 = ((SubstationAdder)network.newSubstation().setId("S3")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s3.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        ((LoadAdder)((LoadAdder)vl3.newLoad().setId("load3")).setBus("b3")).setP0(50.0).setQ0(5.0).add();
        ((GeneratorAdder)((GeneratorAdder)vl3.newGenerator().setId("gen3")).setBus("b3")).setTargetP(40.0).setTargetQ(0.0).setTargetV(400.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        ((AreaAdder)((AreaAdder)network.newArea().setId("a1")).setName("Area 1")).setAreaType("ControlArea").setInterchangeTarget(-50.0).addVoltageLevel(network.getVoltageLevel("vl1")).addVoltageLevel(network.getVoltageLevel("vl2")).add();
        ((AreaAdder)((AreaAdder)network.newArea().setId("a2")).setName("Area 2")).setAreaType("ControlArea").setInterchangeTarget(50.0).addVoltageLevel(network.getVoltageLevel("vl3")).add();
        return network;
    }

    public static Network createTwoAreasWithXNode() {
        Network network = MultiAreaNetworkFactory.createTwoAreasBase();
        Bus bx1 = MultiAreaNetworkFactory.createBus(network, "bx1", 400.0);
        MultiAreaNetworkFactory.createLine(network, network.getBusBreakerView().getBus("b2"), bx1, "l23_A1", 1.0);
        MultiAreaNetworkFactory.createLine(network, bx1, network.getBusBreakerView().getBus("b3"), "l23_A2", 1.0);
        network.getArea("a1").newAreaBoundary().setTerminal(network.getLine("l23_A1").getTerminal2()).setAc(true).add();
        network.getArea("a2").newAreaBoundary().setTerminal(network.getLine("l23_A2").getTerminal1()).setAc(true).add();
        return network;
    }

    public static Network createTwoAreasWithTwoXNodes() {
        Network network = MultiAreaNetworkFactory.createTwoAreasWithXNode();
        Bus bx2 = MultiAreaNetworkFactory.createBus(network, "bx2", 400.0);
        MultiAreaNetworkFactory.createLine(network, network.getBusBreakerView().getBus("b2"), bx2, "l23_A1_1", 1.0);
        MultiAreaNetworkFactory.createLine(network, bx2, network.getBusBreakerView().getBus("b3"), "l23_A2_1", 1.0);
        return network;
    }

    public static Network createTwoAreasWithDanglingLine() {
        Network network = MultiAreaNetworkFactory.createTwoAreasWithXNode();
        VoltageLevel vl2 = network.getVoltageLevel("vl2");
        ((DanglingLineAdder)((DanglingLineAdder)((DanglingLineAdder)vl2.newDanglingLine().setId("dl1")).setConnectableBus("b2")).setBus("b2")).setR(0.0).setX(1.0).setG(0.0).setB(0.0).setP0(20.0).setQ0(20.0).newGeneration().setTargetP(0.0).setTargetQ(0.0).setTargetV(400.0).setVoltageRegulationOn(false).add().add();
        Area a1 = network.getArea("a1");
        a1.newAreaBoundary().setBoundary(network.getDanglingLine("dl1").getBoundary()).setAc(true).add();
        return network;
    }

    public static Network createTwoAreasWithTieLine() {
        Network network = MultiAreaNetworkFactory.createTwoAreasBase();
        VoltageLevel vl2 = network.getVoltageLevel("vl2");
        DanglingLine dl1 = ((DanglingLineAdder)((DanglingLineAdder)((DanglingLineAdder)vl2.newDanglingLine().setId("dl1")).setConnectableBus("b2")).setBus("b2")).setR(0.0).setX(1.0).setG(0.0).setB(0.0).setP0(0.0).setQ0(0.0).setPairingKey("tlA1A2").add();
        VoltageLevel vl3 = network.getVoltageLevel("vl3");
        DanglingLine dl2 = ((DanglingLineAdder)((DanglingLineAdder)((DanglingLineAdder)vl3.newDanglingLine().setId("dl2")).setConnectableBus("b3")).setBus("b3")).setR(0.0).setX(1.0).setG(0.0).setB(0.0).setP0(0.0).setQ0(0.0).setPairingKey("tlA1A2").add();
        ((TieLineAdder)((TieLineAdder)network.newTieLine().setId("tl1")).setName("Tie Line A1-A2")).setDanglingLine1("dl1").setDanglingLine2("dl2").add();
        network.getArea("a1").newAreaBoundary().setBoundary(dl1.getBoundary()).setAc(true).add();
        network.getArea("a2").newAreaBoundary().setBoundary(dl2.getBoundary()).setAc(true).add();
        Bus b4 = MultiAreaNetworkFactory.createBus(network, "b4", 400.0);
        network.getArea("a2").addVoltageLevel(b4.getVoltageLevel());
        network.getLoad("load3").setP0(20.0);
        MultiAreaNetworkFactory.createLoad(b4, "load4", 30.0);
        MultiAreaNetworkFactory.createLine(network, network.getBusBreakerView().getBus("b3"), b4, "l34", 0.2);
        return network;
    }

    public static Network createTwoAreasWithUnconsideredTieLine() {
        Network network = MultiAreaNetworkFactory.createTwoAreasWithTieLine();
        VoltageLevel vl2 = network.getVoltageLevel("vl2");
        ((DanglingLineAdder)((DanglingLineAdder)((DanglingLineAdder)vl2.newDanglingLine().setId("dlA1_1")).setConnectableBus("b2")).setBus("b2")).setR(0.0).setX(1.0).setG(0.0).setB(0.0).setP0(0.0).setQ0(0.0).setPairingKey("tlA1A2_2").add();
        Bus b5 = MultiAreaNetworkFactory.createBus(network, "S5", "b5", 400.0);
        VoltageLevel vl5 = b5.getVoltageLevel();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl5.newGenerator().setId("gen5")).setConnectableBus("b5")).setBus("b5")).setTargetP(5.0).setTargetQ(0.0).setTargetV(400.0).setMinP(0.0).setMaxP(30.0).setVoltageRegulatorOn(true).add();
        ((DanglingLineAdder)((DanglingLineAdder)((DanglingLineAdder)vl5.newDanglingLine().setId("dlA1_2")).setConnectableBus("b5")).setBus("b5")).setR(0.0).setX(1.0).setG(0.0).setB(0.0).setP0(0.0).setQ0(0.0).setPairingKey("tlA1A2_2").add();
        ((TieLineAdder)((TieLineAdder)network.newTieLine().setId("tl2")).setName("Tie Line A1-A2 2")).setDanglingLine1("dlA1_1").setDanglingLine2("dlA1_2").add();
        network.getArea("a2").addVoltageLevel(vl5);
        return network;
    }

    public static Network createAreaTwoComponents() {
        Network network = MultiAreaNetworkFactory.createTwoAreasWithTieLine();
        Bus dummy = MultiAreaNetworkFactory.createBus(network, "dummy");
        Bus dummy2 = MultiAreaNetworkFactory.createBus(network, "dummy2");
        MultiAreaNetworkFactory.createGenerator(dummy, "dummyGen", 1.0);
        MultiAreaNetworkFactory.createLoad(dummy2, "dummyLoad", 1.1);
        MultiAreaNetworkFactory.createLine(network, dummy, dummy2, "dummyLine", 0.0);
        network.getArea("a2").addVoltageLevel(dummy.getVoltageLevel()).addVoltageLevel(dummy2.getVoltageLevel());
        return network;
    }

    public static Network createAreaTwoComponentsWithBoundaries() {
        Network network = MultiAreaNetworkFactory.createAreaTwoComponents();
        Line dummyLine = network.getLine("dummyLine");
        network.getArea("a2").newAreaBoundary().setTerminal(dummyLine.getTerminal1()).setAc(true).add();
        return network;
    }

    public static Network createWithAreaWithoutBoundariesOrTarget() {
        Network network = MultiAreaNetworkFactory.createTwoAreasBase();
        network.getArea("a2").newAreaBoundary().setTerminal(network.getLine("l12").getTerminal2()).setAc(true).add();
        MultiAreaNetworkFactory.createBus(network, "b4");
        MultiAreaNetworkFactory.createLine(network, network.getBusBreakerView().getBus("b2"), network.getBusBreakerView().getBus("b3"), "l23_A2", 1.0);
        MultiAreaNetworkFactory.createLine(network, network.getBusBreakerView().getBus("b3"), network.getBusBreakerView().getBus("b4"), "l34", 1.0);
        ((AreaAdder)((AreaAdder)network.newArea().setId("a3")).setName("Area 3")).setAreaType("ControlArea").addVoltageLevel(network.getVoltageLevel("b4_vl")).addAreaBoundary(network.getLine("l34").getTerminal2(), true).add();
        ((AreaAdder)((AreaAdder)network.newArea().setId("a4")).setName("Area 4")).setAreaType("ControlArea").addAreaBoundary(network.getLine("l34").getTerminal2(), true).add();
        return network;
    }

    public static Network createTwoAreasWithPhaseShifter() {
        Network network = PhaseShifterTestCaseFactory.create();
        VoltageLevel vl1 = network.getVoltageLevel("VL1");
        VoltageLevel vl2 = network.getVoltageLevel("VL2");
        Line l2 = network.getLine("L2");
        TwoWindingsTransformer ps1 = network.getTwoWindingsTransformer("PS1");
        ((PhaseTapChangerStep)ps1.getPhaseTapChanger().getStep(0)).setAlpha(-5.0);
        ((PhaseTapChangerStep)ps1.getPhaseTapChanger().getStep(2)).setAlpha(5.0);
        ps1.getPhaseTapChanger().setTargetDeadband(10.0);
        ps1.getPhaseTapChanger().setRegulationMode(PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL);
        ps1.getPhaseTapChanger().setRegulating(true);
        ps1.getPhaseTapChanger().setRegulationValue(-80.0);
        ((GeneratorAdder)((GeneratorAdder)vl2.newGenerator().setId("G2")).setBus("B2")).setTargetP(40.0).setTargetQ(0.0).setTargetV(400.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(false).add();
        ((LoadAdder)((LoadAdder)vl1.newLoad().setId("LD1")).setBus("B1")).setP0(40.0).setQ0(5.0).add();
        ((AreaAdder)((AreaAdder)network.newArea().setId("A1")).setName("Area 1")).setAreaType("ControlArea").setInterchangeTarget(-81.5).addVoltageLevel(vl1).addAreaBoundary(ps1.getTerminal2(), true).add();
        ((AreaAdder)((AreaAdder)network.newArea().setId("A2")).setName("Area 2")).setAreaType("ControlArea").setInterchangeTarget(81.5).addVoltageLevel(vl2).addAreaBoundary(l2.getTerminal1(), true).add();
        return network;
    }

    public static Network createTenAreas() {
        Network network = Network.create((String)"tenAreas", (String)"test");
        for (int i = 0; i < 10; ++i) {
            Bus b = MultiAreaNetworkFactory.createBus(network, "b" + i);
            DanglingLine dl0 = MultiAreaNetworkFactory.createDanglingLine(b, "dlb" + i + "_0", 0.1, 0.0, 0.0);
            DanglingLine dl1 = MultiAreaNetworkFactory.createDanglingLine(b, "dlb" + i + "_1", 0.1, 0.0, 0.0);
            dl0.setPairingKey("key_" + i);
            int key1 = i == 9 ? 0 : i + 1;
            dl1.setPairingKey("key_" + key1);
            double interchangeTarget = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(8), Integer.valueOf(9)).contains(i) ? -2.0 : 2.0;
            MultiAreaNetworkFactory.createGenerator(b, "g" + i, 5.0);
            MultiAreaNetworkFactory.createLoad(b, "l" + i, 5.0 + interchangeTarget + 0.05);
            ((AreaAdder)((AreaAdder)network.newArea().setId("A" + i)).setName("Area " + i)).setAreaType("ControlArea").setInterchangeTarget(interchangeTarget).addVoltageLevel(b.getVoltageLevel()).addAreaBoundary(dl0.getBoundary(), true).addAreaBoundary(dl1.getBoundary(), true).add();
        }
        network.getDanglingLineStream().collect(Collectors.groupingBy(DanglingLine::getPairingKey)).forEach((key, value) -> ((TieLineAdder)((TieLineAdder)network.newTieLine().setId(key)).setName(key)).setDanglingLine1(((DanglingLine)value.get(0)).getId()).setDanglingLine2(((DanglingLine)value.get(1)).getId()).add());
        return network;
    }
}

