/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;

public final class NodeBreakerNetworkFactory {
    private NodeBreakerNetworkFactory() {
    }

    public static Network create() {
        Network network = Network.create((String)"test", (String)"test");
        Substation s = ((SubstationAdder)network.newSubstation().setId("S")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL1")).setNominalV(400.0).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((BusbarSectionAdder)vl1.getNodeBreakerView().newBusbarSection().setId("BBS1")).setNode(0).add();
        ((BusbarSectionAdder)vl1.getNodeBreakerView().newBusbarSection().setId("BBS2")).setNode(1).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newDisconnector().setId("D")).setNode1(0).setNode2(6).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newBreaker().setId("C")).setNode1(6).setNode2(1).setRetained(true).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newBreaker().setId("B1")).setNode1(1).setNode2(3).add();
        vl1.getNodeBreakerView().newInternalConnection().setNode1(1).setNode2(4).add();
        vl1.getNodeBreakerView().newInternalConnection().setNode1(0).setNode2(5).add();
        ((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("G")).setNode(4)).setMinP(0.0).setMaxP(1000.0).setVoltageRegulatorOn(true).setTargetV(398.0).setTargetP(603.77).setTargetQ(301.0).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL2")).setNominalV(400.0).setTopologyKind(TopologyKind.NODE_BREAKER).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).add();
        ((BusbarSectionAdder)vl2.getNodeBreakerView().newBusbarSection().setId("BBS3")).setNode(0).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newBreaker().setId("B3")).setNode1(0).setNode2(1).setRetained(true).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl2.getNodeBreakerView().newBreaker().setId("B4")).setNode1(0).setNode2(2).add();
        vl2.getNodeBreakerView().newInternalConnection().setNode1(0).setNode2(3).add();
        ((LoadAdder)((LoadAdder)vl2.newLoad().setId("LD")).setNode(3)).setP0(600.0).setQ0(200.0).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L1")).setVoltageLevel1("VL1")).setNode1(5)).setVoltageLevel2("VL2")).setNode2(1)).setR(3.0).setX(33.0).setB1(1.93E-4).setB2(1.93E-4).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L2")).setVoltageLevel1("VL1")).setNode1(3)).setVoltageLevel2("VL2")).setNode2(2)).setR(3.0).setX(33.0).setB1(1.93E-4).setB2(1.93E-4).add();
        ((CurrentLimitsAdder)network.getLine("L1").getOrCreateSelectedOperationalLimitsGroup1().newCurrentLimits().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine("L1").getOrCreateSelectedOperationalLimitsGroup2().newCurrentLimits().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine("L2").getOrCreateSelectedOperationalLimitsGroup1().newCurrentLimits().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine("L2").getOrCreateSelectedOperationalLimitsGroup2().newCurrentLimits().setPermanentLimit(940.0)).add();
        return network;
    }

    public static Network createWith4Bars() {
        Network network = NodeBreakerNetworkFactory.create();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)network.getVoltageLevel("VL1").getNodeBreakerView().newBreaker().setId("B5")).setNode1(1).setNode2(7).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)network.getVoltageLevel("VL2").getNodeBreakerView().newBreaker().setId("B6")).setNode1(0).setNode2(4).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)network.getVoltageLevel("VL2").getNodeBreakerView().newBreaker().setId("B7")).setNode1(0).setNode2(5).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)network.getSubstation("S").newVoltageLevel().setId("VL3")).setNominalV(400.0).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((BusbarSectionAdder)vl3.getNodeBreakerView().newBusbarSection().setId("BBS4")).setNode(0).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl3.getNodeBreakerView().newBreaker().setId("B8")).setNode1(0).setNode2(1).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl3.getNodeBreakerView().newBreaker().setId("B9")).setNode1(0).setNode2(2).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl3.getNodeBreakerView().newBreaker().setId("B10")).setNode1(0).setNode2(3).add();
        vl3.getNodeBreakerView().newInternalConnection().setNode1(0).setNode2(4).add();
        ((LoadAdder)((LoadAdder)vl3.newLoad().setId("LD2")).setNode(4)).setP0(200.0).setQ0(50.0).add();
        TwoWindingsTransformer ps1 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation("S").newTwoWindingsTransformer().setId("PS1")).setVoltageLevel1("VL1")).setNode1(7)).setVoltageLevel2("VL3")).setNode2(1)).setRatedU1(400.0).setRatedU2(400.0).setR(0.0).setX(100.0).setG(0.0).setB(0.0).add();
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ps1.newPhaseTapChanger().setTapPosition(1)).setRegulationTerminal(ps1.getTerminal2())).setRegulationMode(PhaseTapChanger.RegulationMode.CURRENT_LIMITER).setRegulating(false)).setRegulationValue(200.0).beginStep()).setAlpha(-5.0)).setRho(1.0)).setR(0.0)).setX(50.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(-5.0)).setRho(1.0)).setR(0.0)).setX(100.0)).setG(0.0)).setB(0.0)).endStep()).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L3")).setVoltageLevel1("VL2")).setNode1(4)).setVoltageLevel2("VL3")).setNode2(2)).setR(3.0).setX(33.0).setB1(1.93E-4).setB2(1.93E-4).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L4")).setVoltageLevel1("VL3")).setNode1(3)).setVoltageLevel2("VL2")).setNode2(5)).setR(3.0).setX(33.0).setB1(1.93E-4).setB2(1.93E-4).add();
        return network;
    }

    private static void createBar(VoltageLevel vl, String id, int node) {
        ((BusbarSectionAdder)vl.getNodeBreakerView().newBusbarSection().setId(id)).setNode(node).add();
    }

    private static void createBreaker(VoltageLevel vl, String id, int node1, int node2) {
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl.getNodeBreakerView().newBreaker().setId(id)).setNode1(node1).setNode2(node2).add();
    }

    private static void createConnection(VoltageLevel vl, int node1, int node2) {
        vl.getNodeBreakerView().newInternalConnection().setNode1(node1).setNode2(node2).add();
    }

    private static void createGenerator(VoltageLevel vl, String id, int node, double v, double p, double q) {
        ((GeneratorAdder)((GeneratorAdder)vl.newGenerator().setId(id)).setNode(node)).setMinP(-4999.99).setMaxP(4999.99).setVoltageRegulatorOn(true).setTargetV(v).setTargetP(p).setTargetQ(q).add();
    }

    private static void createLine(Network network, String id, String vl1, int node1, String vl2, int node2) {
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(id)).setVoltageLevel1(vl1)).setNode1(node1)).setVoltageLevel2(vl2)).setNode2(node2)).setR(3.0).setX(33.0).setB1(1.93E-4).setB2(1.93E-4).add();
        ((CurrentLimitsAdder)network.getLine(id).getOrCreateSelectedOperationalLimitsGroup1().newCurrentLimits().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)network.getLine(id).getOrCreateSelectedOperationalLimitsGroup2().newCurrentLimits().setPermanentLimit(940.0)).add();
    }

    public static Network create3Bars() {
        Network network = Network.create((String)"test", (String)"test");
        Substation s = ((SubstationAdder)network.newSubstation().setId("S")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL1")).setNominalV(400.0).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        NodeBreakerNetworkFactory.createBar(vl1, "BBS1", 0);
        NodeBreakerNetworkFactory.createBar(vl1, "BBS2", 1);
        NodeBreakerNetworkFactory.createBar(vl1, "BBS3", 2);
        NodeBreakerNetworkFactory.createBreaker(vl1, "C1", 0, 1);
        NodeBreakerNetworkFactory.createBreaker(vl1, "C2", 1, 2);
        NodeBreakerNetworkFactory.createBreaker(vl1, "B1", 0, 5);
        NodeBreakerNetworkFactory.createConnection(vl1, 1, 6);
        NodeBreakerNetworkFactory.createBreaker(vl1, "B4", 2, 7);
        NodeBreakerNetworkFactory.createGenerator(vl1, "G1", 3, 400.0, 400.0, 0.0);
        NodeBreakerNetworkFactory.createConnection(vl1, 0, 3);
        NodeBreakerNetworkFactory.createGenerator(vl1, "G2", 4, 400.0, 200.0, 0.0);
        NodeBreakerNetworkFactory.createConnection(vl1, 2, 4);
        VoltageLevel vl2 = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL2")).setNominalV(400.0).setTopologyKind(TopologyKind.NODE_BREAKER).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).add();
        NodeBreakerNetworkFactory.createBar(vl2, "BBS4", 0);
        NodeBreakerNetworkFactory.createBreaker(vl2, "B2", 0, 2);
        NodeBreakerNetworkFactory.createBreaker(vl2, "B3", 0, 3);
        NodeBreakerNetworkFactory.createBreaker(vl2, "B5", 0, 4);
        ((LoadAdder)((LoadAdder)vl2.newLoad().setId("LD")).setNode(1)).setP0(600.0).setQ0(200.0).add();
        NodeBreakerNetworkFactory.createConnection(vl2, 0, 1);
        NodeBreakerNetworkFactory.createLine(network, "L1", "VL1", 5, "VL2", 2);
        NodeBreakerNetworkFactory.createLine(network, "L2", "VL1", 6, "VL2", 3);
        NodeBreakerNetworkFactory.createLine(network, "L3", "VL1", 7, "VL2", 4);
        return network;
    }

    public static Network create3barsAndJustOneVoltageLevel() {
        Network network = Network.create((String)"test", (String)"test");
        Substation s = ((SubstationAdder)network.newSubstation().setId("S")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL1")).setNominalV(400.0).setLowVoltageLimit(370.0).setHighVoltageLimit(420.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        NodeBreakerNetworkFactory.createBar(vl1, "BBS1", 0);
        NodeBreakerNetworkFactory.createBar(vl1, "BBS2", 1);
        NodeBreakerNetworkFactory.createBar(vl1, "BBS3", 2);
        NodeBreakerNetworkFactory.createBreaker(vl1, "C1", 0, 1);
        NodeBreakerNetworkFactory.createBreaker(vl1, "C2", 1, 2);
        network.getSwitch("C1").setRetained(true);
        network.getSwitch("C2").setRetained(true);
        NodeBreakerNetworkFactory.createGenerator(vl1, "G1", 3, 400.0, 400.0, 0.0);
        NodeBreakerNetworkFactory.createConnection(vl1, 0, 3);
        NodeBreakerNetworkFactory.createGenerator(vl1, "G2", 4, 400.0, 200.0, 0.0);
        NodeBreakerNetworkFactory.createConnection(vl1, 2, 4);
        ((LoadAdder)((LoadAdder)vl1.newLoad().setId("LD")).setNode(5)).setP0(600.0).setQ0(200.0).add();
        NodeBreakerNetworkFactory.createConnection(vl1, 1, 5);
        return network;
    }
}

