/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.test.PhaseShifterTestCaseFactory;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;
import java.time.ZonedDateTime;

public class PhaseControlFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network createNetworkWithT2wt() {
        Network network = PhaseShifterTestCaseFactory.create();
        TwoWindingsTransformer ps1 = network.getTwoWindingsTransformer("PS1");
        ((PhaseTapChangerStep)ps1.getPhaseTapChanger().getStep(0)).setAlpha(-5.0);
        ((PhaseTapChangerStep)ps1.getPhaseTapChanger().getStep(2)).setAlpha(5.0);
        return network;
    }

    public static Network createNetworkWithT3wt() {
        Network network = NetworkFactory.findDefault().createNetwork("three-windings-transformer", "test");
        network.setCaseDate(ZonedDateTime.parse("2020-04-05T14:11:00.000+01:00"));
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL1")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("B1")).add();
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("G1")).setConnectableBus("B1")).setBus("B1")).setVoltageRegulatorOn(true).setTargetP(100.0).setTargetV(400.0).setMinP(50.0).setMaxP(150.0).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).setCountry(Country.FR).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("VL2")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("B2")).add();
        b2.setV(385.6934).setAngle(-3.6792064);
        ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("LD2")).setConnectableBus("B2")).setBus("B2")).setP0(75.0).setQ0(50.0).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L1")).setConnectableBus1("B1")).setBus1("B1")).setConnectableBus2("B2")).setBus2("B2")).setR(4.0).setX(200.0).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL3")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b3 = ((BusAdder)vl3.getBusBreakerView().newBus().setId("B3")).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL4")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b4 = ((BusAdder)vl4.getBusBreakerView().newBus().setId("B4")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl4.newLoad().setId("LD3")).setConnectableBus("B4")).setBus("B4")).setP0(25.0).setQ0(50.0).add();
        ThreeWindingsTransformer ps1 = ((ThreeWindingsTransformerAdder)s1.newThreeWindingsTransformer().setId("PS1")).setRatedU0(400.0).newLeg1().setR(2.0).setX(100.0).setRatedU(380.0).setConnectableBus(b1.getId()).setBus(b1.getId()).add().newLeg2().setR(2.0).setX(100.0).setRatedU(380.0).setConnectableBus(b3.getId()).setBus(b3.getId()).add().newLeg3().setR(2.0).setX(100.0).setRatedU(380.0).setConnectableBus(b4.getId()).setBus(b4.getId()).add().add();
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ps1.getLeg2().newPhaseTapChanger().setTapPosition(1)).setRegulationTerminal(ps1.getLeg2().getTerminal())).setRegulationMode(PhaseTapChanger.RegulationMode.CURRENT_LIMITER).setRegulating(false)).setRegulationValue(200.0).beginStep()).setAlpha(-5.0)).endStep()).beginStep()).setAlpha(0.0)).endStep()).beginStep()).setAlpha(5.0)).endStep()).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L2")).setConnectableBus1("B3")).setBus1("B3")).setConnectableBus2("B2")).setBus2("B2")).setR(2.0).setX(100.0).add();
        return network;
    }

    public static Network createWithOneT2wtTwoLines() {
        Network network = NetworkFactory.findDefault().createNetwork("phaseShifterTestCase", "code");
        network.setCaseDate(ZonedDateTime.parse("2016-10-18T10:06:00.000+02:00"));
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("B1")).add();
        b1.setV(400.0).setAngle(0.0);
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("G1")).setConnectableBus("B1")).setBus("B1")).setVoltageRegulatorOn(true).setTargetP(100.0).setTargetV(400.0).setMinP(50.0).setMaxP(150.0).add();
        g1.getTerminal().setP(-100.16797).setQ(-58.402832);
        VoltageLevel vl2 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("B2")).add();
        b2.setV(400.0).setAngle(-3.6792064);
        Load ld2 = ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("LD2")).setConnectableBus("B2")).setBus("B2")).setP0(100.0).setQ0(50.0).add();
        ld2.getTerminal().setP(100.0).setQ(50.0);
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L1")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setR(0.0).setX(200.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L2")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setR(0.0).setX(200.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
        TwoWindingsTransformer ps1 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s1.newTwoWindingsTransformer().setId("PS1")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setRatedU1(400.0).setRatedU2(400.0).setR(0.0).setX(100.0).setG(0.0).setB(0.0).add();
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ps1.newPhaseTapChanger().setTapPosition(1)).setRegulationTerminal(ps1.getTerminal2())).setRegulationMode(PhaseTapChanger.RegulationMode.CURRENT_LIMITER).setRegulating(false)).setRegulationValue(200.0).beginStep()).setAlpha(-5.0)).setRho(1.0)).setR(0.0)).setX(50.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(0.0)).setRho(1.0)).setR(0.0)).setX(100.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(5.0)).setRho(1.0)).setR(0.0)).setX(200.0)).setG(0.0)).setB(0.0)).endStep()).add();
        return network;
    }

    public static Network createWithTwoT2wtTwoLines() {
        Network network = NetworkFactory.findDefault().createNetwork("two-phase-tap-changers-test", "test");
        network.setCaseDate(ZonedDateTime.parse("2016-10-18T10:06:00.000+02:00"));
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL1")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("B1")).add();
        b1.setV(400.0).setAngle(0.0);
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("G1")).setConnectableBus("B1")).setBus("B1")).setVoltageRegulatorOn(true).setTargetP(100.0).setTargetV(400.0).setMinP(50.0).setMaxP(150.0).add();
        g1.getTerminal().setP(-100.16797).setQ(-58.402832);
        VoltageLevel vl2 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL2")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("B2")).add();
        b2.setV(385.6934).setAngle(-3.6792064);
        Load ld2 = ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("LD2")).setConnectableBus("B2")).setBus("B2")).setP0(100.0).setQ0(50.0).add();
        ld2.getTerminal().setP(100.0).setQ(50.0);
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L1")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setR(4.0).setX(200.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L2")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setR(4.0).setX(200.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL3")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b3 = ((BusAdder)vl3.getBusBreakerView().newBus().setId("B3")).add();
        b3.setV(392.6443).setAngle(-1.8060945);
        TwoWindingsTransformer ps1 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s1.newTwoWindingsTransformer().setId("PS1")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL3")).setConnectableBus2("B3")).setBus2("B3")).setRatedU1(380.0).setRatedU2(380.0).setR(2.0).setX(50.0).setG(0.0).setB(0.0).add();
        ps1.getTerminal1().setP(50.08403).setQ(29.201416);
        ps1.getTerminal2().setP(-50.042015).setQ(-27.100708);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ps1.newPhaseTapChanger().setTapPosition(1)).setRegulationTerminal(ps1.getTerminal2())).setRegulationMode(PhaseTapChanger.RegulationMode.CURRENT_LIMITER).setRegulating(false)).setRegulationValue(200.0).beginStep()).setAlpha(-20.0)).setRho(1.0)).setR(0.0)).setX(25.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(0.0)).setRho(1.0)).setR(0.0)).setX(50.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(20.0)).setRho(1.0)).setR(0.0)).setX(75.0)).setG(0.0)).setB(0.0)).endStep()).add();
        TwoWindingsTransformer ps2 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s1.newTwoWindingsTransformer().setId("PS2")).setVoltageLevel1("VL3")).setConnectableBus1("B3")).setBus1("B3")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setRatedU1(400.0).setRatedU2(400.0).setR(2.0).setX(50.0).setG(0.0).setB(0.0).add();
        ps2.getTerminal1().setP(50.08403).setQ(29.201416);
        ps2.getTerminal2().setP(-50.042015).setQ(-27.100708);
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ps2.newPhaseTapChanger().setTapPosition(1)).setRegulationTerminal(ps2.getTerminal2())).setRegulationMode(PhaseTapChanger.RegulationMode.CURRENT_LIMITER).setRegulating(false)).setRegulationValue(200.0).beginStep()).setAlpha(-10.0)).setRho(1.0)).setR(0.0)).setX(25.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(0.0)).setRho(1.0)).setR(0.0)).setX(50.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(10.0)).setRho(1.0)).setR(0.0)).setX(75.0)).setG(0.0)).setB(0.0)).endStep()).add();
        return network;
    }

    public static Network createNetworkWith3Buses() {
        Network network = NetworkFactory.findDefault().createNetwork("phaseShifterTestCase", "code");
        network.setCaseDate(ZonedDateTime.parse("2016-10-18T10:06:00.000+02:00"));
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("B1")).add();
        b1.setV(400.0).setAngle(0.0);
        Generator g1 = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("G1")).setConnectableBus("B1")).setBus("B1")).setVoltageRegulatorOn(true).setTargetP(100.0).setTargetV(400.0).setMinP(50.0).setMaxP(200.0).add();
        g1.getTerminal().setP(-100.16797).setQ(-58.402832);
        VoltageLevel vl2 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("B2")).add();
        b2.setV(400.0).setAngle(-3.6792064);
        Load ld2 = ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("LD2")).setConnectableBus("B2")).setBus("B2")).setP0(100.0).setQ0(50.0).add();
        ld2.getTerminal().setP(100.0).setQ(50.0);
        VoltageLevel vl3 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b3 = ((BusAdder)vl3.getBusBreakerView().newBus().setId("B3")).add();
        b3.setV(400.0).setAngle(-3.6792064);
        Load ld3 = ((LoadAdder)((LoadAdder)((LoadAdder)vl3.newLoad().setId("LD3")).setConnectableBus("B3")).setBus("B3")).setP0(100.0).setQ0(50.0).add();
        ld3.getTerminal().setP(100.0).setQ(50.0);
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L12")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setR(0.0).setX(200.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L23")).setVoltageLevel1("VL2")).setConnectableBus1("B2")).setBus1("B2")).setVoltageLevel2("VL3")).setConnectableBus2("B3")).setBus2("B3")).setR(0.0).setX(200.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
        TwoWindingsTransformer ps1 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s1.newTwoWindingsTransformer().setId("PS1")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setRatedU1(400.0).setRatedU2(400.0).setR(0.0).setX(100.0).setG(0.0).setB(0.0).add();
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)((PhaseTapChangerAdder)ps1.newPhaseTapChanger().setTapPosition(1)).setRegulationTerminal(ps1.getTerminal2())).setRegulationMode(PhaseTapChanger.RegulationMode.CURRENT_LIMITER).setRegulating(false)).setRegulationValue(200.0).beginStep()).setAlpha(-5.0)).setRho(1.0)).setR(0.0)).setX(50.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(-5.0)).setRho(1.0)).setR(0.0)).setX(100.0)).setG(0.0)).setB(0.0)).endStep()).beginStep()).setAlpha(5.0)).setRho(1.0)).setR(0.0)).setX(200.0)).setG(0.0)).setB(0.0)).endStep()).add();
        return network;
    }
}

