/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class ReactiveInjectionNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    static Generator createGeneratorPQ(Bus b, String id, double p, double q) {
        Generator g = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b.getVoltageLevel().newGenerator().setId(id)).setBus(b.getId())).setConnectableBus(b.getId())).setEnergySource(EnergySource.OTHER).setMinP(0.0).setMaxP(2.0 * p).setTargetP(p).setTargetQ(q).setVoltageRegulatorOn(false).add();
        g.getTerminal().setP(-p).setQ(-q);
        return g;
    }

    public static Network createTwoGensOneLoad() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ReactiveInjectionNetworkFactory.createBus(network, "b1", 10.0);
        Bus b2 = ReactiveInjectionNetworkFactory.createBus(network, "b2", 10.0);
        Bus b3 = ReactiveInjectionNetworkFactory.createBus(network, "b3", 10.0);
        Generator g1 = ReactiveInjectionNetworkFactory.createGenerator(b1, "g1", 10.0, 10.0);
        Generator g2 = ReactiveInjectionNetworkFactory.createGeneratorPQ(b2, "g2", 10.0, 10.0);
        Line l13 = ReactiveInjectionNetworkFactory.createLine(network, b1, b3, "l13", 0.1);
        Line l23 = ReactiveInjectionNetworkFactory.createLine(network, b2, b3, "l23", 0.1);
        Load l3 = ReactiveInjectionNetworkFactory.createLoad(b3, "l3", 20.0, 0.0);
        return network;
    }
}

