/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControlAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;
import com.powsybl.openloadflow.network.FourBusNetworkFactory;

public class ReactivePowerControlNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network createWithGeneratorRemoteControl() {
        Network network = FourBusNetworkFactory.createBaseNetwork();
        Generator g1 = network.getGenerator("g1");
        Generator g4 = network.getGenerator("g4");
        Line l34 = network.getLine("l34");
        g1.setMaxP(10.0);
        g4.setMaxP(10.0);
        g4.setTargetQ(0.0).setVoltageRegulatorOn(false);
        ((RemoteReactivePowerControlAdder)g4.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(4.0).withRegulatingTerminal(l34.getTerminal(TwoSides.TWO)).withEnabled(true).add();
        return network;
    }

    public static Network createWithGeneratorRemoteControl2() {
        Network network = FourBusNetworkFactory.createBaseNetwork();
        Generator g1 = network.getGenerator("g1");
        Generator g4 = network.getGenerator("g4");
        Line l12 = network.getLine("l12");
        g1.setMaxP(10.0);
        g4.setMaxP(10.0);
        g4.setTargetQ(0.0).setVoltageRegulatorOn(false);
        ((RemoteReactivePowerControlAdder)g4.newExtension(RemoteReactivePowerControlAdder.class)).withTargetQ(1.0).withRegulatingTerminal(l12.getTerminal(TwoSides.TWO)).withEnabled(true).add();
        return network;
    }

    public static Network createWithGeneratorsRemoteControlShared() {
        Network network = FourBusNetworkFactory.createWithReactiveControl2GeneratorsOnSameBusAnd1Extra();
        Generator g1 = network.getGenerator("g1");
        Generator g1Bis = network.getGenerator("g1Bis");
        Generator g4 = network.getGenerator("g4");
        g1.setMaxP(10.0);
        g1Bis.setMaxP(10.0);
        g4.setMaxP(10.0);
        return network;
    }

    public static Network create4BusNetworkWithRatioTapChanger() {
        Network network = Network.create((String)"test", (String)"code");
        Bus b1 = ReactivePowerControlNetworkFactory.createBus(network, "b1");
        Bus b2 = ReactivePowerControlNetworkFactory.createBus(network, "b2");
        Bus b3 = ReactivePowerControlNetworkFactory.createBus(network, "test_s", "b3");
        Bus b4 = ReactivePowerControlNetworkFactory.createBus(network, "test_s", "b4");
        ReactivePowerControlNetworkFactory.createGenerator(b1, "g1", 2.0);
        ReactivePowerControlNetworkFactory.createGenerator(b4, "g4", 1.0);
        ReactivePowerControlNetworkFactory.createLoad(b2, "d2", 1.0);
        ReactivePowerControlNetworkFactory.createLoad(b3, "d3", 4.0);
        ReactivePowerControlNetworkFactory.createLine(network, b1, b4, "l14", 0.1f);
        ReactivePowerControlNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        ReactivePowerControlNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        TwoWindingsTransformer twt = ReactivePowerControlNetworkFactory.createTransformer(network, "test_s", b3, b4, "l34", 0.1f, 1.0);
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)twt.newRatioTapChanger().beginStep()).setRho(0.8)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(0.9)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.0)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).setTapPosition(1)).setRegulationValue(0.0).setRegulationMode(RatioTapChanger.RegulationMode.REACTIVE_POWER).add();
        ReactivePowerControlNetworkFactory.createLine(network, b1, b3, "l13", 0.1f);
        return network;
    }
}

