/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;

public final class ShuntNetworkFactory {
    private ShuntNetworkFactory() {
    }

    public static Network create() {
        Network network = Network.create((String)"svc", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(101.3664).setTargetV(390.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("ld1")).setConnectableBus("b2")).setBus("b2")).setP0(101.0).setQ0(150.0).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl3")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl3.newShuntCompensator().setId("SHUNT")).setBus("b3")).setConnectableBus("b3")).setSectionCount(0).setVoltageRegulatorOn(true).setTargetV(393.0).setTargetDeadband(5.0).newNonLinearModel().beginSection().setB(0.001).setG(0.0).endSection().beginSection().setB(0.003).setG(0.0).endSection().add().add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l1")).setBus1("b1")).setBus2("b2")).setR(1.0).setX(3.0).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l2")).setBus1("b3")).setBus2("b2")).setR(1.0).setX(3.0).add();
        return network;
    }

    public static Network createWithTwoShuntCompensators() {
        Network network = ShuntNetworkFactory.create();
        VoltageLevel vl3 = network.getVoltageLevel("vl3");
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl3.newShuntCompensator().setId("SHUNT2")).setBus("b3")).setConnectableBus("b3")).setSectionCount(0).setVoltageRegulatorOn(false).setTargetV(393.0).setTargetDeadband(5.0).newNonLinearModel().beginSection().setB(0.001).setG(0.0).endSection().beginSection().setB(0.003).setG(0.0).endSection().add().add();
        return network;
    }

    public static Network createWithGeneratorAndShunt() {
        Network network = ShuntNetworkFactory.create();
        VoltageLevel vl3 = network.getVoltageLevel("vl3");
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl3.newGenerator().setId("g2")).setConnectableBus("b3")).setBus("b3")).setTargetP(0.0).setTargetV(393.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        return network;
    }

    public static Network createWithGeneratorAndShuntNonImpedant() {
        Network network = ShuntNetworkFactory.createWithGeneratorAndShunt();
        VoltageLevel vl3 = network.getVoltageLevel("vl3");
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("b4")).add();
        ((VoltageLevel.BusBreakerView.SwitchAdder)vl3.getBusBreakerView().newSwitch().setBus1("b3").setBus2("b4").setId("switch")).add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl3.newShuntCompensator().setId("SHUNT2")).setBus("b4")).setConnectableBus("b4")).setSectionCount(0).setVoltageRegulatorOn(true).setTargetV(393.0).setTargetDeadband(2.0).newNonLinearModel().beginSection().setB(0.001).setG(0.0).endSection().beginSection().setB(0.003).setG(0.0).endSection().add().add();
        return network;
    }
}

