/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;

public class TwoBusNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network create() {
        Network network = Network.create((String)"2-bus", (String)"code");
        Bus b1 = TwoBusNetworkFactory.createBus(network, "b1");
        Bus b2 = TwoBusNetworkFactory.createBus(network, "b2");
        TwoBusNetworkFactory.createGenerator(b1, "g1", 2.0, 1.0);
        TwoBusNetworkFactory.createLoad(b2, "l1", 2.0, 1.0);
        TwoBusNetworkFactory.createLine(network, b1, b2, "l12", 0.1f);
        return network;
    }

    public static Network createZeroImpedanceToShuntCompensator() {
        Network network = TwoBusNetworkFactory.create();
        Bus b2 = network.getBusBreakerView().getBus("b2");
        Bus b3 = TwoBusNetworkFactory.createOtherBus(network, "b3", b2.getVoltageLevel().getId());
        TwoBusNetworkFactory.createLine(network, b2, b3, "l23", 0.0);
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)b3.getVoltageLevel().newShuntCompensator().setId("sc")).setName("sc")).setConnectableBus(b3.getId())).setBus(b3.getId())).setSectionCount(1).newLinearModel().setBPerSection(-2.0).setMaximumSectionCount(1).add().add();
        return network;
    }

    public static Network createWithAThirdBus() {
        Network network = TwoBusNetworkFactory.create();
        Bus b3 = TwoBusNetworkFactory.createBus(network, "b3", 1.5);
        Bus b2 = network.getBusBreakerView().getBus("b2");
        TwoBusNetworkFactory.createLine(network, b2, b3, "l23", 0.1f);
        return network;
    }
}

