/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.openloadflow.network.AbstractLoadFlowNetworkFactory;
import com.powsybl.openloadflow.network.FourBusNetworkFactory;

public class VoltageControlNetworkFactory
extends AbstractLoadFlowNetworkFactory {
    public static Network createWithGeneratorRemoteControl() {
        Network network = Network.create((String)"generator-remote-control-test", (String)"code");
        Substation s = ((SubstationAdder)network.newSubstation().setId("s")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl1")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl2")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl3")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b3 = ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl4")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b4 = ((BusAdder)vl4.getBusBreakerView().newBus().setId("b4")).add();
        Load l4 = ((LoadAdder)((LoadAdder)((LoadAdder)vl4.newLoad().setId("l4")).setBus("b4")).setConnectableBus("b4")).setP0(299.6).setQ0(200.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b1.getVoltageLevel().newGenerator().setId("g1")).setBus("b1")).setConnectableBus("b1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(200.0).setTargetP(100.0).setTargetV(413.4).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b2.getVoltageLevel().newGenerator().setId("g2")).setBus("b2")).setConnectableBus("b2")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(200.0).setTargetP(100.0).setTargetV(413.4).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b3.getVoltageLevel().newGenerator().setId("g3")).setBus("b3")).setConnectableBus("b3")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(200.0).setTargetP(100.0).setTargetV(413.4).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr1")).setBus1(b1.getId())).setConnectableBus1(b1.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr2")).setBus1(b2.getId())).setConnectableBus1(b2.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.2).setRatedU2(398.0).setR(1.0).setX(36.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr3")).setBus1(b3.getId())).setConnectableBus1(b3.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(21.3).setRatedU2(397.0).setR(2.0).setX(50.0).add();
        return network;
    }

    public static Network createWithIdenticalTransformers() {
        Network network = Network.create((String)"generator-remote-control-test", (String)"code");
        Substation s = ((SubstationAdder)network.newSubstation().setId("s")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl1")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl2")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl3")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b3 = ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl4")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b4 = ((BusAdder)vl4.getBusBreakerView().newBus().setId("b4")).add();
        Load l4 = ((LoadAdder)((LoadAdder)((LoadAdder)vl4.newLoad().setId("l4")).setBus("b4")).setConnectableBus("b4")).setP0(299.6).setQ0(200.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b1.getVoltageLevel().newGenerator().setId("g1")).setBus("b1")).setConnectableBus("b1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(200.0).setTargetP(100.0).setTargetV(413.4).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b2.getVoltageLevel().newGenerator().setId("g2")).setBus("b2")).setConnectableBus("b2")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(200.0).setTargetP(100.0).setTargetV(413.4).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b3.getVoltageLevel().newGenerator().setId("g3")).setBus("b3")).setConnectableBus("b3")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(200.0).setTargetP(100.0).setTargetV(413.4).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr1")).setBus1(b1.getId())).setConnectableBus1(b1.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr2")).setBus1(b2.getId())).setConnectableBus1(b2.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr3")).setBus1(b3.getId())).setConnectableBus1(b3.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        return network;
    }

    public static Network createTransformerBaseNetwork(String id) {
        Network network = Network.create((String)id, (String)"test");
        Substation substation1 = ((SubstationAdder)network.newSubstation().setId("SUBSTATION1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)substation1.newVoltageLevel().setId("VL_1")).setNominalV(132.0).setLowVoltageLimit(118.8).setHighVoltageLimit(145.2).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("BUS_1")).add();
        ((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("GEN_1")).setBus("BUS_1")).setMinP(0.0).setMaxP(140.0).setTargetP(25.0).setTargetV(135.0).setVoltageRegulatorOn(true).add();
        Substation substation = ((SubstationAdder)network.newSubstation().setId("SUBSTATION")).setCountry(Country.FR).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)substation.newVoltageLevel().setId("VL_2")).setNominalV(132.0).setLowVoltageLimit(118.8).setHighVoltageLimit(145.2).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("BUS_2")).add();
        ((LoadAdder)((LoadAdder)vl2.newLoad().setId("LOAD_2")).setBus("BUS_2")).setP0(11.2).setQ0(7.5).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)substation.newVoltageLevel().setId("VL_3")).setNominalV(33.0).setLowVoltageLimit(0.0).setHighVoltageLimit(100.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("BUS_3")).add();
        ((LoadAdder)((LoadAdder)vl3.newLoad().setId("LOAD_3")).setBus("BUS_3")).setQ0(0.0).setP0(5.0).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("LINE_12")).setBus1("BUS_1")).setBus2("BUS_2")).setR(1.05).setX(10.0).setG1(5.0E-7).add();
        return network;
    }

    public static Network createNetworkWithT2wt() {
        Network network = VoltageControlNetworkFactory.createTransformerBaseNetwork("two-windings-transformer-control");
        TwoWindingsTransformer t2wt = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation("SUBSTATION").newTwoWindingsTransformer().setId("T2wT")).setRatedU1(132.0).setRatedU2(33.0).setR(17.0).setX(10.0).setG(0.00573921028466483).setB(5.73921028466483E-4).setBus1("BUS_2")).setBus2("BUS_3")).add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t2wt.newRatioTapChanger().beginStep()).setRho(0.9)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.0)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.05)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(false)).setTargetV(33.0).setRegulationTerminal(network.getLoad("LOAD_3").getTerminal())).add();
        return network;
    }

    public static Network createNetworkWith2T2wtAndSwitch() {
        Network network = VoltageControlNetworkFactory.createNetworkWithT2wt();
        VoltageLevel vl3 = network.getVoltageLevel("VL_3");
        ((BusAdder)vl3.getBusBreakerView().newBus().setId("BUS_4")).add();
        ((VoltageLevel.BusBreakerView.SwitchAdder)vl3.getBusBreakerView().newSwitch().setId("SWITCH")).setBus1("BUS_3").setBus2("BUS_4").add();
        ((LoadAdder)((LoadAdder)vl3.newLoad().setId("LOAD_4")).setBus("BUS_4")).setQ0(0.0).setP0(2.0).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)network.getSubstation("SUBSTATION").newVoltageLevel().setId("VL_4")).setNominalV(132.0).setLowVoltageLimit(0.0).setHighVoltageLimit(100.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl4.getBusBreakerView().newBus().setId("BUS_5")).add();
        ((GeneratorAdder)((GeneratorAdder)vl4.newGenerator().setId("GEN_5")).setBus("BUS_5")).setMinP(0.0).setMaxP(150.0).setTargetP(23.0).setTargetQ(0.0).setTargetV(33.0).setVoltageRegulatorOn(true).setRegulatingTerminal(network.getLoad("LOAD_4").getTerminal()).add();
        ((LoadAdder)((LoadAdder)vl4.newLoad().setId("LOAD_5")).setBus("BUS_5")).setQ0(0.0).setP0(2.0).add();
        TwoWindingsTransformer t2wt2 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation("SUBSTATION").newTwoWindingsTransformer().setId("T2wT2")).setRatedU1(33.0).setRatedU2(132.0).setR(17.0).setX(10.0).setG(0.00573921028466483).setB(5.73921028466483E-4).setBus1("BUS_4")).setBus2("BUS_5")).add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t2wt2.newRatioTapChanger().beginStep()).setRho(0.9)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.0)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.05)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(false)).setTargetV(33.0).setRegulationTerminal(network.getLoad("LOAD_4").getTerminal())).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("LINE_15")).setBus1("BUS_1")).setBus2("BUS_5")).setR(1.05).setX(10.0).setG1(5.0E-7).add();
        return network;
    }

    public static Network createNetworkWithT2wt2() {
        Network network = VoltageControlNetworkFactory.createTransformerBaseNetwork("two-windings-transformer-control");
        TwoWindingsTransformer t2wt = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation("SUBSTATION").newTwoWindingsTransformer().setId("T2wT")).setRatedU1(132.0).setRatedU2(33.0).setR(17.0).setX(10.0).setG(0.00573921028466483).setB(5.73921028466483E-4).setBus1("BUS_2")).setBus2("BUS_3")).add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t2wt.newRatioTapChanger().beginStep()).setRho(1.75)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.7)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.5)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.2)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.05)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.0)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(0.9)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(false)).setTargetV(33.0).setRegulationTerminal(network.getLoad("LOAD_3").getTerminal())).add();
        return network;
    }

    public static Network createNetworkWith2T2wt() {
        Network network = VoltageControlNetworkFactory.createTransformerBaseNetwork("two-windings-transformer-control");
        TwoWindingsTransformer t2wt1 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation("SUBSTATION").newTwoWindingsTransformer().setId("T2wT1")).setRatedU1(132.0).setRatedU2(33.0).setR(17.0).setX(10.0).setG(0.00573921028466483).setB(5.73921028466483E-4).setBus1("BUS_2")).setBus2("BUS_3")).add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t2wt1.newRatioTapChanger().beginStep()).setRho(0.9)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.0)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.05)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(false)).setTargetV(33.0).setRegulationTerminal(network.getLoad("LOAD_3").getTerminal())).add();
        TwoWindingsTransformer t2wt2 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation("SUBSTATION").newTwoWindingsTransformer().setId("T2wT2")).setRatedU1(132.0).setRatedU2(33.0).setR(17.0).setX(10.0).setG(0.00573921028466483).setB(5.73921028466483E-4).setBus1("BUS_2")).setBus2("BUS_3")).add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t2wt2.newRatioTapChanger().beginStep()).setRho(0.9)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.0)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.05)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(false)).setTargetV(33.0).setRegulationTerminal(network.getLoad("LOAD_3").getTerminal())).add();
        return network;
    }

    public static Network createNetworkWithT3wt() {
        Network network = VoltageControlNetworkFactory.createTransformerBaseNetwork("three-windings-transformer-control");
        VoltageLevel vl4 = ((VoltageLevelAdder)network.getSubstation("SUBSTATION").newVoltageLevel().setId("VL_4")).setNominalV(10.0).setLowVoltageLimit(5.0).setHighVoltageLimit(15.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl4.getBusBreakerView().newBus().setId("BUS_4")).add();
        ((LoadAdder)((LoadAdder)vl4.newLoad().setId("LOAD_4")).setBus("BUS_4")).setQ0(0.0).setP0(5.0).add();
        ThreeWindingsTransformer t3wt = ((ThreeWindingsTransformerAdder)network.getSubstation("SUBSTATION").newThreeWindingsTransformer().setId("T3wT")).setRatedU0(200.0).newLeg1().setR(2.0).setX(10.0).setRatedU(130.0).setConnectableBus("BUS_2").setBus("BUS_2").add().newLeg2().setR(2.0).setX(10.0).setRatedU(30.0).setConnectableBus("BUS_3").setBus("BUS_3").add().newLeg3().setR(2.0).setX(10.0).setRatedU(10.0).setConnectableBus("BUS_4").setBus("BUS_4").add().add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t3wt.getLeg2().newRatioTapChanger().beginStep()).setRho(0.9)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.0)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(false)).setTargetV(33.0).setRegulationTerminal(network.getLoad("LOAD_3").getTerminal())).add();
        return network;
    }

    public static Network createWithTransformerSharedRemoteControl() {
        Network network = VoltageControlNetworkFactory.createNetworkWithT2wt();
        TwoWindingsTransformer t2wt2 = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)network.getSubstation("SUBSTATION").newTwoWindingsTransformer().setId("T2wT2")).setRatedU1(132.0).setRatedU2(33.0).setR(17.0).setX(10.0).setG(0.00573921028466483).setB(5.73921028466483E-4).setBus1("BUS_2")).setBus2("BUS_3")).add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)t2wt2.newRatioTapChanger().beginStep()).setRho(0.9)).setR(0.1089)).setX(0.01089)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.0)).setR(0.121)).setX(0.0121)).setG(0.8264462809917356)).setB(0.08264462809917356)).endStep()).beginStep()).setRho(1.05)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).beginStep()).setRho(1.1)).setR(0.1331)).setX(0.01331)).setG(0.9090909090909092)).setB(0.09090909090909093)).endStep()).setTapPosition(0)).setLoadTapChangingCapabilities(true)).setRegulating(true)).setTargetV(34.0).setTargetDeadband(0.0)).setRegulationTerminal(t2wt2.getTerminal2())).add();
        TwoWindingsTransformer t2wt = network.getTwoWindingsTransformer("T2wT");
        ((RatioTapChanger)((RatioTapChanger)((RatioTapChanger)((RatioTapChanger)t2wt.getRatioTapChanger().setTargetDeadband(0.0)).setRegulating(true)).setTapPosition(0)).setRegulationTerminal(t2wt.getTerminal2())).setTargetV(34.0);
        return network;
    }

    public static Network createWithShuntSharedRemoteControl() {
        Network network = Network.create((String)"shunt-remote-control-test", (String)"code");
        Substation s = ((SubstationAdder)network.newSubstation().setId("s")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl1")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl2")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl3")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b3 = ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl4")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b4 = ((BusAdder)vl4.getBusBreakerView().newBus().setId("b4")).add();
        Load l4 = ((LoadAdder)((LoadAdder)((LoadAdder)vl4.newLoad().setId("l4")).setBus("b4")).setConnectableBus("b4")).setP0(299.6).setQ0(0.0).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b1.getVoltageLevel().newGenerator().setId("g1")).setBus("b1")).setConnectableBus("b1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(350.0).setTargetP(100.0).setTargetV(21.0).setVoltageRegulatorOn(true).add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)b2.getVoltageLevel().newShuntCompensator().setId("SHUNT2")).setBus("b2")).setConnectableBus("b2")).setSectionCount(0).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).setTargetV(400.0).setTargetDeadband(5.0).newLinearModel().setMaximumSectionCount(50).setBPerSection(-0.01).setGPerSection(0.0).add().add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)b3.getVoltageLevel().newShuntCompensator().setId("SHUNT3")).setBus("b3")).setConnectableBus("b3")).setSectionCount(0).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).setTargetV(400.0).setTargetDeadband(5.0).newLinearModel().setMaximumSectionCount(50).setBPerSection(-0.01).setGPerSection(0.0).add().add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr1")).setBus1(b1.getId())).setConnectableBus1(b1.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr2")).setBus1(b2.getId())).setConnectableBus1(b2.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr3")).setBus1(b3.getId())).setConnectableBus1(b3.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        return network;
    }

    public static Network createWithStaticVarCompensator() {
        Network network = Network.create((String)"svc", (String)"test");
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("vl1")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("g1")).setConnectableBus("b1")).setBus("b1")).setTargetP(101.3664).setTargetV(390.0).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("vl2")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("ld1")).setConnectableBus("b2")).setBus("b2")).setP0(101.0).setQ0(150.0).add();
        ((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)vl2.newStaticVarCompensator().setId("svc1")).setConnectableBus("b2")).setBus("b2")).setRegulating(false).setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE).setBmin(-0.008).setBmax(0.008).add();
        ((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("l1")).setBus1("b1")).setBus2("b2")).setR(1.0).setX(3.0).add();
        return network;
    }

    public static Network createWithSimpleRemoteControl() {
        Network network = Network.create((String)"remoteControl", (String)"code");
        Bus b1 = VoltageControlNetworkFactory.createBus(network, "b1");
        Bus b2 = VoltageControlNetworkFactory.createBus(network, "b2");
        Bus b3 = VoltageControlNetworkFactory.createBus(network, "b3");
        Bus b4 = VoltageControlNetworkFactory.createBus(network, "b4");
        VoltageControlNetworkFactory.createGenerator(b2, "g2", 2.0, 1.0);
        VoltageControlNetworkFactory.createGenerator(b3, "g3", 2.0, 1.0);
        VoltageControlNetworkFactory.createGenerator(b4, "g4", 2.0, 1.0);
        VoltageControlNetworkFactory.createLoad(b3, "l3", 5.0, 1.0);
        VoltageControlNetworkFactory.createLoad(b1, "l1", 1.0, 1.0);
        VoltageControlNetworkFactory.createLine(network, b1, b2, "l12", 0.0);
        VoltageControlNetworkFactory.createLine(network, b2, b4, "l24", 0.01);
        VoltageControlNetworkFactory.createLine(network, b4, b3, "l43", 0.01);
        VoltageControlNetworkFactory.createLine(network, b3, b1, "l31", 0.0);
        network.getGenerator("g4").setRegulatingTerminal(network.getLoad("l1").getTerminal());
        return network;
    }

    public static Network createWithTwoVoltageControls() {
        Network network = Network.create((String)"twoVoltageControls", (String)"code");
        Bus b1 = VoltageControlNetworkFactory.createBus(network, "b1");
        Bus b2 = VoltageControlNetworkFactory.createBus(network, "b2");
        Bus b3 = VoltageControlNetworkFactory.createBus(network, "b3");
        Bus b4 = VoltageControlNetworkFactory.createBus(network, "b4");
        Bus b5 = VoltageControlNetworkFactory.createBus(network, "b5");
        VoltageControlNetworkFactory.createGenerator(b2, "g2", 2.0, 1.0);
        VoltageControlNetworkFactory.createGenerator(b3, "g3", 2.0, 1.0);
        VoltageControlNetworkFactory.createGenerator(b5, "g5", 2.0, 1.0);
        VoltageControlNetworkFactory.createLoad(b4, "l4", 5.0, 1.0);
        VoltageControlNetworkFactory.createLoad(b5, "l5", 1.0, 1.0);
        VoltageControlNetworkFactory.createLine(network, b1, b2, "l12", 0.01);
        VoltageControlNetworkFactory.createLine(network, b1, b3, "l13", 0.01);
        VoltageControlNetworkFactory.createLine(network, b1, b4, "l14", 0.01);
        VoltageControlNetworkFactory.createLine(network, b4, b5, "l45", 0.01);
        network.getGenerator("g2").setRegulatingTerminal(network.getLine("l12").getTerminal1());
        network.getGenerator("g3").setRegulatingTerminal(network.getLine("l13").getTerminal1());
        return network;
    }

    public static Network createWithShuntAndGeneratorVoltageControl() {
        Network network = Network.create((String)"shuntAndGeneratorVoltageControl", (String)"code");
        Bus b1 = VoltageControlNetworkFactory.createBus(network, "b1");
        Bus b2 = VoltageControlNetworkFactory.createBus(network, "b2");
        Bus b3 = VoltageControlNetworkFactory.createBus(network, "b3");
        VoltageControlNetworkFactory.createLine(network, b1, b2, "l12", 0.01);
        VoltageControlNetworkFactory.createLine(network, b1, b3, "l13", 0.01);
        VoltageControlNetworkFactory.createGenerator(b2, "g1", 2.0, 1.0);
        VoltageControlNetworkFactory.createLoad(b1, "l1", 2.5, 1.0);
        VoltageControlNetworkFactory.createGenerator(b3, "g3", 1.0, 1.0);
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)b3.getVoltageLevel().newShuntCompensator().setId("SHUNT")).setBus("b3")).setConnectableBus("b3")).setSectionCount(0).setVoltageRegulatorOn(true).setTargetV(1.0).setTargetDeadband(0.1).newLinearModel().setMaximumSectionCount(50).setBPerSection(0.001).setGPerSection(0.0).add().add();
        network.getGenerator("g1").setRegulatingTerminal(network.getLine("l12").getTerminal1());
        return network;
    }

    public static Network createWithDependentVoltageControls() {
        Network network = Network.create((String)"withDependantVoltageControls", (String)"code");
        Bus b1 = VoltageControlNetworkFactory.createBus(network, "b1");
        Bus b2 = VoltageControlNetworkFactory.createBus(network, "b2");
        Bus b3 = VoltageControlNetworkFactory.createBus(network, "b3");
        Bus b01 = VoltageControlNetworkFactory.createBus(network, "b01");
        Bus b02 = VoltageControlNetworkFactory.createBus(network, "b02");
        Bus b03 = VoltageControlNetworkFactory.createBus(network, "b03");
        VoltageControlNetworkFactory.createLine(network, b01, b1, "l011", 0.01);
        VoltageControlNetworkFactory.createLine(network, b02, b2, "l022", 0.01);
        VoltageControlNetworkFactory.createLine(network, b03, b3, "l033", 0.01);
        VoltageControlNetworkFactory.createGenerator(b01, "g1", 2.0, 1.0);
        VoltageControlNetworkFactory.createGenerator(b02, "g2", 2.0, 1.0);
        VoltageControlNetworkFactory.createGenerator(b03, "g3", 2.0, 1.0);
        VoltageControlNetworkFactory.createLoad(b2, "l", 6.0, 1.0);
        VoltageControlNetworkFactory.createLine(network, b1, b2, "l12", 0.0);
        VoltageControlNetworkFactory.createLine(network, b2, b3, "l23", 0.0);
        network.getGenerator("g1").setRegulatingTerminal(network.getLine("l011").getTerminal2());
        network.getGenerator("g2").setRegulatingTerminal(network.getLine("l022").getTerminal2());
        network.getGenerator("g3").setRegulatingTerminal(network.getLine("l033").getTerminal2());
        return network;
    }

    public static Network createWithShuntSharedRemoteControl2() {
        Network network = Network.create((String)"shunt-remote-control-test", (String)"code");
        Substation s = ((SubstationAdder)network.newSubstation().setId("s")).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl1")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b1 = ((BusAdder)vl1.getBusBreakerView().newBus().setId("b1")).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl2")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b2 = ((BusAdder)vl2.getBusBreakerView().newBus().setId("b2")).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl3")).setNominalV(20.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b3 = ((BusAdder)vl3.getBusBreakerView().newBus().setId("b3")).add();
        VoltageLevel vl4 = ((VoltageLevelAdder)s.newVoltageLevel().setId("vl4")).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b4 = ((BusAdder)vl4.getBusBreakerView().newBus().setId("b4")).add();
        Load l4 = ((LoadAdder)((LoadAdder)((LoadAdder)vl4.newLoad().setId("l4")).setBus("b4")).setConnectableBus("b4")).setP0(150.0).setQ0(0.0).add();
        Bus b5 = ((BusAdder)vl4.getBusBreakerView().newBus().setId("b5")).add();
        Load l5 = ((LoadAdder)((LoadAdder)((LoadAdder)vl4.newLoad().setId("l5")).setBus("b5")).setConnectableBus("b5")).setP0(150.0).setQ0(0.0).add();
        ((VoltageLevel.BusBreakerView.SwitchAdder)vl4.getBusBreakerView().newSwitch().setId("S")).setBus1("b4").setBus2("b5").setOpen(true).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)b1.getVoltageLevel().newGenerator().setId("g1")).setBus("b1")).setConnectableBus("b1")).setEnergySource(EnergySource.THERMAL).setMinP(0.0).setMaxP(400.0).setTargetP(100.0).setTargetV(400.0).setRegulatingTerminal(l5.getTerminal()).setVoltageRegulatorOn(true).add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)b2.getVoltageLevel().newShuntCompensator().setId("SHUNT2")).setBus("b2")).setConnectableBus("b2")).setSectionCount(0).setVoltageRegulatorOn(false).setRegulatingTerminal(l4.getTerminal()).setTargetV(380.0).setTargetDeadband(5.0).newLinearModel().setMaximumSectionCount(50).setBPerSection(-0.01).setGPerSection(0.0).add().add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)b3.getVoltageLevel().newShuntCompensator().setId("SHUNT3")).setBus("b3")).setConnectableBus("b3")).setSectionCount(0).setVoltageRegulatorOn(true).setRegulatingTerminal(l4.getTerminal()).setTargetV(380.0).setTargetDeadband(5.0).newLinearModel().setMaximumSectionCount(50).setBPerSection(-0.01).setGPerSection(0.0).add().add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr1")).setBus1(b1.getId())).setConnectableBus1(b1.getId())).setBus2(b5.getId())).setConnectableBus2(b5.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr2")).setBus1(b2.getId())).setConnectableBus1(b2.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("tr3")).setBus1(b3.getId())).setConnectableBus1(b3.getId())).setBus2(b4.getId())).setConnectableBus2(b4.getId())).setRatedU1(20.5).setRatedU2(399.0).setR(1.0).setX(30.0).add();
        VoltageControlNetworkFactory.createLine(network, b1, b2, "l12", 0.0);
        return network;
    }

    public static Network createFourBusNetworkWithSharedVoltageControl() {
        Network network = FourBusNetworkFactory.createWith2GeneratorsAtBus1();
        Generator g1 = network.getGenerator("g1");
        Generator g2 = network.getGenerator("g2");
        Generator g1Bis = network.getGenerator("g1Bis");
        Generator g4 = network.getGenerator("g4");
        Terminal regTerminal = network.getLine("l34").getTerminal2();
        g1.setMaxP(10.0).setRegulatingTerminal(regTerminal).setTargetV(1.2);
        g2.setMaxP(10.0);
        g1Bis.setMaxP(10.0).setRegulatingTerminal(regTerminal).setTargetV(1.2);
        g4.setMaxP(10.0).setRegulatingTerminal(regTerminal).setTargetV(1.2);
        return network;
    }
}

