/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.sa;

import com.powsybl.action.Action;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.computation.ComputationManager;
import com.powsybl.contingency.BranchContingency;
import com.powsybl.contingency.ContingenciesProvider;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyContext;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.loadflow.LoadFlow;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.loadflow.LoadFlowProvider;
import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.math.matrix.DenseMatrixFactory;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.OpenLoadFlowProvider;
import com.powsybl.openloadflow.graph.EvenShiloachGraphDecrementalConnectivityFactory;
import com.powsybl.openloadflow.graph.GraphConnectivityFactory;
import com.powsybl.openloadflow.network.NodeBreakerNetworkFactory;
import com.powsybl.openloadflow.network.SlackBusSelectionMode;
import com.powsybl.openloadflow.sa.OpenSecurityAnalysisProvider;
import com.powsybl.security.LimitViolationFilter;
import com.powsybl.security.SecurityAnalysisParameters;
import com.powsybl.security.SecurityAnalysisReport;
import com.powsybl.security.SecurityAnalysisResult;
import com.powsybl.security.SecurityAnalysisRunParameters;
import com.powsybl.security.limitreduction.LimitReduction;
import com.powsybl.security.monitor.StateMonitor;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.BusResult;
import com.powsybl.security.results.OperatorStrategyResult;
import com.powsybl.security.results.PostContingencyResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import com.powsybl.security.strategy.OperatorStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

public abstract class AbstractOpenSecurityAnalysisTest {
    protected ComputationManager computationManager;
    protected MatrixFactory matrixFactory;
    protected OpenSecurityAnalysisProvider securityAnalysisProvider;
    protected OpenLoadFlowProvider loadFlowProvider;
    protected LoadFlow.Runner loadFlowRunner;

    @BeforeEach
    void setUp() {
        this.computationManager = (ComputationManager)Mockito.mock(ComputationManager.class);
        Mockito.when((Object)this.computationManager.getExecutor()).thenReturn((Object)ForkJoinPool.commonPool());
        this.matrixFactory = new DenseMatrixFactory();
        EvenShiloachGraphDecrementalConnectivityFactory connectivityFactory = new EvenShiloachGraphDecrementalConnectivityFactory();
        this.securityAnalysisProvider = new OpenSecurityAnalysisProvider(this.matrixFactory, (GraphConnectivityFactory)connectivityFactory);
        this.loadFlowProvider = new OpenLoadFlowProvider(this.matrixFactory, (GraphConnectivityFactory)connectivityFactory);
        this.loadFlowRunner = new LoadFlow.Runner((LoadFlowProvider)this.loadFlowProvider);
    }

    protected static Network createNodeBreakerNetwork() {
        Network network = NodeBreakerNetworkFactory.create();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)network.getLine("L1").newCurrentLimits1().setPermanentLimit(940.0)).beginTemporaryLimit().setName("60").setAcceptableDuration(60).setValue(1000.0).endTemporaryLimit()).add();
        ((CurrentLimitsAdder)network.getLine("L1").newCurrentLimits2().setPermanentLimit(940.0)).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)network.getLine("L2").newCurrentLimits1().setPermanentLimit(940.0)).beginTemporaryLimit().setName("60").setAcceptableDuration(60).setValue(950.0).endTemporaryLimit()).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)network.getLine("L2").newCurrentLimits2().setPermanentLimit(940.0)).beginTemporaryLimit().setName("600").setAcceptableDuration(600).setValue(945.0).endTemporaryLimit()).beginTemporaryLimit().setName("60").setAcceptableDuration(60).setValue(970.0).endTemporaryLimit()).add();
        return network;
    }

    protected LoadFlowResult runLoadFlow(Network network, LoadFlowParameters parameters) {
        return (LoadFlowResult)this.loadFlowProvider.run(network, this.computationManager, network.getVariantManager().getWorkingVariantId(), parameters, ReportNode.NO_OP).join();
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies, List<StateMonitor> monitors, LoadFlowParameters lfParameters) {
        SecurityAnalysisParameters securityAnalysisParameters = new SecurityAnalysisParameters();
        securityAnalysisParameters.setLoadFlowParameters(lfParameters);
        return this.runSecurityAnalysis(network, contingencies, monitors, securityAnalysisParameters);
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies, List<StateMonitor> monitors, SecurityAnalysisParameters saParameters) {
        return this.runSecurityAnalysis(network, contingencies, monitors, saParameters, ReportNode.NO_OP);
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies, List<StateMonitor> monitors, SecurityAnalysisParameters saParameters, ReportNode reportNode) {
        ContingenciesProvider provider = n -> contingencies;
        SecurityAnalysisRunParameters runParameters = (SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)new SecurityAnalysisRunParameters().setFilter(new LimitViolationFilter())).setComputationManager(this.computationManager)).setSecurityAnalysisParameters(saParameters).setMonitors(monitors)).setReportNode(reportNode);
        SecurityAnalysisReport report = (SecurityAnalysisReport)this.securityAnalysisProvider.run(network, network.getVariantManager().getWorkingVariantId(), provider, runParameters).join();
        return report.getResult();
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies, List<StateMonitor> monitors, List<LimitReduction> limitReductions, SecurityAnalysisParameters saParameters) {
        ContingenciesProvider provider = n -> contingencies;
        SecurityAnalysisRunParameters runParameters = ((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)new SecurityAnalysisRunParameters().setFilter(new LimitViolationFilter())).setComputationManager(this.computationManager)).setSecurityAnalysisParameters(saParameters).setMonitors(monitors)).setLimitReductions(limitReductions);
        SecurityAnalysisReport report = (SecurityAnalysisReport)this.securityAnalysisProvider.run(network, network.getVariantManager().getWorkingVariantId(), provider, runParameters).join();
        return report.getResult();
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies, List<StateMonitor> monitors, SecurityAnalysisParameters saParameters, List<OperatorStrategy> operatorStrategies, List<Action> actions, ReportNode reportNode) {
        ContingenciesProvider provider = n -> contingencies;
        SecurityAnalysisRunParameters runParameters = (SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)((SecurityAnalysisRunParameters)new SecurityAnalysisRunParameters().setFilter(new LimitViolationFilter())).setComputationManager(this.computationManager)).setSecurityAnalysisParameters(saParameters).setOperatorStrategies(operatorStrategies)).setActions(actions)).setMonitors(monitors)).setReportNode(reportNode);
        SecurityAnalysisReport report = (SecurityAnalysisReport)this.securityAnalysisProvider.run(network, network.getVariantManager().getWorkingVariantId(), provider, runParameters).join();
        return report.getResult();
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies, List<StateMonitor> monitors) {
        return this.runSecurityAnalysis(network, contingencies, monitors, new LoadFlowParameters());
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies, LoadFlowParameters loadFlowParameters) {
        return this.runSecurityAnalysis(network, contingencies, Collections.emptyList(), loadFlowParameters);
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network, List<Contingency> contingencies) {
        return this.runSecurityAnalysis(network, contingencies, Collections.emptyList());
    }

    protected SecurityAnalysisResult runSecurityAnalysis(Network network) {
        return this.runSecurityAnalysis(network, Collections.emptyList(), Collections.emptyList());
    }

    protected static List<StateMonitor> createAllBranchesMonitors(Network network) {
        Set allBranchIds = network.getBranchStream().map(Identifiable::getId).collect(Collectors.toSet());
        return List.of(new StateMonitor(ContingencyContext.all(), allBranchIds, Collections.emptySet(), Collections.emptySet()));
    }

    protected static List<StateMonitor> createNetworkMonitors(Network network) {
        Set allBranchIds = network.getBranchStream().map(Identifiable::getId).collect(Collectors.toSet());
        Set allVoltageLevelIds = network.getVoltageLevelStream().map(Identifiable::getId).collect(Collectors.toSet());
        allBranchIds.addAll(network.getTieLineStream().map(Identifiable::getId).collect(Collectors.toSet()));
        return List.of(new StateMonitor(ContingencyContext.all(), allBranchIds, allVoltageLevelIds, Collections.emptySet()));
    }

    protected static List<Contingency> createAllBranchesContingencies(Network network) {
        return network.getBranchStream().map(b -> new Contingency(b.getId(), new ContingencyElement[]{new BranchContingency(b.getId())})).collect(Collectors.toList());
    }

    protected static void setSlackBusId(LoadFlowParameters lfParameters, String slackBusId) {
        OpenLoadFlowParameters.create((LoadFlowParameters)lfParameters).setSlackBusSelectionMode(SlackBusSelectionMode.NAME).setSlackBusId(slackBusId);
    }

    protected static Optional<PostContingencyResult> getOptionalPostContingencyResult(SecurityAnalysisResult result, String contingencyId) {
        return result.getPostContingencyResults().stream().filter(r -> r.getContingency().getId().equals(contingencyId)).findFirst();
    }

    protected static PostContingencyResult getPostContingencyResult(SecurityAnalysisResult result, String contingencyId) {
        return AbstractOpenSecurityAnalysisTest.getOptionalPostContingencyResult(result, contingencyId).orElseThrow();
    }

    protected static Optional<OperatorStrategyResult> getOptionalOperatorStrategyResult(SecurityAnalysisResult result, String operatorStrategyId) {
        return result.getOperatorStrategyResults().stream().filter(r -> r.getOperatorStrategy().getId().equals(operatorStrategyId)).findFirst();
    }

    protected static OperatorStrategyResult getOperatorStrategyResult(SecurityAnalysisResult result, String operatorStrategyId) {
        return AbstractOpenSecurityAnalysisTest.getOptionalOperatorStrategyResult(result, operatorStrategyId).orElseThrow();
    }

    protected static void assertAlmostEquals(BusResult expected, BusResult actual, double epsilon) {
        Assertions.assertEquals((Object)expected.getVoltageLevelId(), (Object)actual.getVoltageLevelId());
        Assertions.assertEquals((Object)expected.getBusId(), (Object)actual.getBusId());
        Assertions.assertEquals((double)expected.getV(), (double)actual.getV(), (double)epsilon);
        Assertions.assertEquals((double)expected.getAngle(), (double)actual.getAngle(), (double)epsilon);
    }

    protected static void assertAlmostEquals(BranchResult expected, BranchResult actual, double epsilon) {
        Assertions.assertEquals((Object)expected.getBranchId(), (Object)actual.getBranchId());
        Assertions.assertEquals((double)expected.getP1(), (double)actual.getP1(), (double)epsilon);
        Assertions.assertEquals((double)expected.getQ1(), (double)actual.getQ1(), (double)epsilon);
        Assertions.assertEquals((double)expected.getI1(), (double)actual.getI1(), (double)epsilon);
        Assertions.assertEquals((double)expected.getP2(), (double)actual.getP2(), (double)epsilon);
        Assertions.assertEquals((double)expected.getQ2(), (double)actual.getQ2(), (double)epsilon);
        Assertions.assertEquals((double)expected.getI2(), (double)actual.getI2(), (double)epsilon);
    }

    protected static void assertAlmostEquals(ThreeWindingsTransformerResult expected, ThreeWindingsTransformerResult actual, double epsilon) {
        Assertions.assertEquals((Object)expected.getThreeWindingsTransformerId(), (Object)actual.getThreeWindingsTransformerId());
        Assertions.assertEquals((double)expected.getP1(), (double)actual.getP1(), (double)epsilon);
        Assertions.assertEquals((double)expected.getQ1(), (double)actual.getQ1(), (double)epsilon);
        Assertions.assertEquals((double)expected.getI1(), (double)actual.getI1(), (double)epsilon);
        Assertions.assertEquals((double)expected.getP2(), (double)actual.getP2(), (double)epsilon);
        Assertions.assertEquals((double)expected.getQ2(), (double)actual.getQ2(), (double)epsilon);
        Assertions.assertEquals((double)expected.getI2(), (double)actual.getI2(), (double)epsilon);
        Assertions.assertEquals((double)expected.getP3(), (double)actual.getP3(), (double)epsilon);
        Assertions.assertEquals((double)expected.getQ3(), (double)actual.getQ3(), (double)epsilon);
        Assertions.assertEquals((double)expected.getI3(), (double)actual.getI3(), (double)epsilon);
    }
}

