/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.util;

import com.google.common.io.ByteStreams;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.test.TestUtil;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.loadflow.LoadFlowResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;

public final class LoadFlowAssert {
    public static final double DELTA_ANGLE = 1.0E-6;
    public static final double DELTA_V = 0.01;
    public static final double DELTA_POWER = 0.001;
    public static final double DELTA_RHO = 1.0E-6;
    public static final double DELTA_I = 1.0 / Math.sqrt(3.0);
    public static final double DELTA_MISMATCH = 1.0E-4;
    public static final double DELTA_SENSITIVITY_VALUE = 1.0E-4;

    private LoadFlowAssert() {
    }

    public static void assertVoltageEquals(double v, Bus bus) {
        Assertions.assertEquals((double)v, (double)bus.getV(), (double)0.01);
    }

    public static void assertAngleEquals(double a, Bus bus) {
        Assertions.assertEquals((double)a, (double)bus.getAngle(), (double)1.0E-6);
    }

    public static void assertActivePowerEquals(double p, Terminal terminal) {
        Assertions.assertEquals((double)p, (double)terminal.getP(), (double)0.001);
    }

    public static void assertReactivePowerEquals(double q, Terminal terminal) {
        Assertions.assertEquals((double)q, (double)terminal.getQ(), (double)0.001);
    }

    public static void assertCurrentEquals(double i, Terminal terminal) {
        Assertions.assertEquals((double)i, (double)terminal.getI(), (double)DELTA_I);
    }

    public static void assertUndefinedActivePower(Terminal terminal) {
        Assertions.assertTrue((boolean)Double.isNaN(terminal.getP()));
    }

    public static void assertUndefinedReactivePower(Terminal terminal) {
        Assertions.assertTrue((boolean)Double.isNaN(terminal.getQ()));
    }

    public static void assertLoadFlowResultsEquals(LoadFlowResult loadFlowResultExpected, LoadFlowResult loadFlowResult) {
        Assertions.assertEquals((Object)loadFlowResultExpected.getStatus(), (Object)loadFlowResult.getStatus(), (String)"Wrong load flow status");
        Assertions.assertEquals((int)loadFlowResultExpected.getComponentResults().size(), (int)loadFlowResult.getComponentResults().size(), (String)"Wrong sub network count");
        Iterator componentResultIteratorExpected = loadFlowResultExpected.getComponentResults().iterator();
        Iterator componentResultIterator = loadFlowResult.getComponentResults().iterator();
        while (componentResultIteratorExpected.hasNext()) {
            LoadFlowResult.ComponentResult componentResultExpected = (LoadFlowResult.ComponentResult)componentResultIteratorExpected.next();
            LoadFlowResult.ComponentResult componentResult = (LoadFlowResult.ComponentResult)componentResultIterator.next();
            Assertions.assertEquals((Object)componentResultExpected.getStatus(), (Object)componentResult.getStatus(), (String)"Wrong load flow result status");
            Assertions.assertEquals((int)componentResultExpected.getIterationCount(), (int)componentResult.getIterationCount(), (String)"Wrong iteration count");
            Assertions.assertEquals((int)componentResultExpected.getSlackBusResults().size(), (int)componentResult.getSlackBusResults().size(), (String)"Wrong slack bus results size");
            if (componentResult.getSlackBusResults().isEmpty()) continue;
            Assertions.assertEquals((double)((LoadFlowResult.SlackBusResult)componentResultExpected.getSlackBusResults().get(0)).getActivePowerMismatch(), (double)((LoadFlowResult.SlackBusResult)componentResult.getSlackBusResults().get(0)).getActivePowerMismatch(), (double)1.0E-4, (String)"Wrong active power mismatch");
        }
    }

    public static void assertReportEquals(String refResourceName, ReportNode reportNode) throws IOException {
        LoadFlowAssert.assertReportEquals(LoadFlowAssert.class.getResourceAsStream(refResourceName), reportNode);
    }

    private static String reportToString(ReportNode reportNode) throws IOException {
        StringWriter sw = new StringWriter();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("#.######", symbols);
        reportNode.print((Writer)sw, typedValue -> {
            if (typedValue.getValue() instanceof Double) {
                return decimalFormat.format(typedValue.getValue());
            }
            return typedValue.toString();
        });
        return sw.toString();
    }

    public static void assertReportEquals(InputStream ref, ReportNode reportNode) throws IOException {
        String refLogExport = TestUtil.normalizeLineSeparator((String)new String(ByteStreams.toByteArray((InputStream)ref), StandardCharsets.UTF_8));
        String logExport = TestUtil.normalizeLineSeparator((String)LoadFlowAssert.reportToString(reportNode));
        Assertions.assertEquals((Object)refLogExport, (Object)logExport);
    }

    public static void assertTxtReportEquals(String reportTxt, ReportNode reportNode) throws IOException {
        String refLogExport = TestUtil.normalizeLineSeparator((String)reportTxt);
        String logExport = TestUtil.normalizeLineSeparator((String)LoadFlowAssert.reportToString(reportNode));
        Assertions.assertEquals((Object)refLogExport, (Object)logExport);
    }

    public static void assertReportEqualsString(String expected, ReportNode reportNode) throws IOException {
        LoadFlowAssert.assertReportEquals(new ByteArrayInputStream(expected.getBytes()), reportNode);
    }

    public static Stream<ReportNode> streamReportNodes(ReportNode node) {
        return Stream.concat(Stream.of(node), node.getChildren().stream().flatMap(LoadFlowAssert::streamReportNodes));
    }

    public static void assertReportContains(String regex, ReportNode reportNode) {
        List<ReportNode> matching = LoadFlowAssert.streamReportNodes(reportNode).filter(node -> node.getMessage().matches(regex)).toList();
        Assertions.assertFalse((boolean)matching.isEmpty(), () -> {
            StringWriter sw = new StringWriter();
            try {
                reportNode.print((Writer)sw);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String txtReport = TestUtil.normalizeLineSeparator((String)sw.toString());
            return "Report does not contain '" + regex + "': \n-----\n" + txtReport;
        });
    }
}

