/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.DefaultNetworkListener;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkListener;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.extensions.ControlUnit;
import com.powsybl.iidm.network.extensions.ControlZone;
import com.powsybl.iidm.network.extensions.PilotPoint;
import com.powsybl.iidm.network.extensions.SecondaryVoltageControl;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfSecondaryVoltageControl;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.action.AbstractLfBranchAction;
import com.powsybl.openloadflow.network.impl.AbstractLfGenerator;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NetworkCache {
    INSTANCE;

    private static final Logger LOGGER;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final Lock lock = new ReentrantLock();

    private void evictDeadEntries() {
        Iterator<Entry> it = this.entries.iterator();
        while (it.hasNext()) {
            Entry entry = it.next();
            if (entry.getNetworkRef().get() != null) continue;
            entry.close();
            it.remove();
            LOGGER.info("Dead network removed from cache ({} remains)", (Object)this.entries.size());
        }
    }

    public int getEntryCount() {
        this.lock.lock();
        try {
            this.evictDeadEntries();
            int n = this.entries.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Optional<Entry> findEntry(Network network) {
        String variantId = network.getVariantManager().getWorkingVariantId();
        return this.entries.stream().filter(e -> e.getNetworkRef().get() == network && e.getWorkingVariantId().equals(variantId)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry get(Network network, LoadFlowParameters parameters) {
        Entry entry;
        Objects.requireNonNull(network);
        Objects.requireNonNull(parameters);
        this.lock.lock();
        try {
            this.evictDeadEntries();
            entry = this.findEntry(network).orElse(null);
            if (entry != null && !OpenLoadFlowParameters.equals(parameters, entry.getParameters())) {
                entry.close();
                this.entries.remove((Object)entry);
                entry = null;
                LOGGER.info("Network cache evicted because of parameters change");
            }
            if (entry == null) {
                entry = new Entry(network, OpenLoadFlowParameters.clone(parameters));
                this.entries.add(entry);
                network.addListener((NetworkListener)entry);
                LOGGER.info("Network cache created for network '{}' and variant '{}'", (Object)network.getId(), (Object)network.getVariantManager().getWorkingVariantId());
                Entry entry2 = entry;
                return entry2;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (entry.getContexts() != null) {
            LOGGER.info("Network cache reused for network '{}' and variant '{}'", (Object)network.getId(), (Object)network.getVariantManager().getWorkingVariantId());
            for (AcLoadFlowContext context : entry.getContexts()) {
                AcLoadFlowResult result = context.getResult();
                if (result == null || result.getSolverStatus() != AcSolverStatus.CONVERGED) continue;
                ((AcLoadFlowParameters)context.getParameters()).setVoltageInitializer(new PreviousValueVoltageInitializer(true));
            }
        } else {
            LOGGER.info("Network cache cannot be reused for network '{}' because invalided", (Object)network.getId());
        }
        return entry;
    }

    public void clear() {
        this.lock.lock();
        try {
            for (Entry entry : this.entries) {
                entry.close();
            }
            this.entries.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(NetworkCache.class);
    }

    public static class Entry
    extends DefaultNetworkListener {
        private final WeakReference<Network> networkRef;
        private final String workingVariantId;
        private String tmpVariantId;
        private final LoadFlowParameters parameters;
        private List<AcLoadFlowContext> contexts;
        private boolean pause = false;

        public Entry(Network network, LoadFlowParameters parameters) {
            Objects.requireNonNull(network);
            this.networkRef = new WeakReference<Network>(network);
            this.workingVariantId = network.getVariantManager().getWorkingVariantId();
            this.parameters = Objects.requireNonNull(parameters);
        }

        public WeakReference<Network> getNetworkRef() {
            return this.networkRef;
        }

        public String getWorkingVariantId() {
            return this.workingVariantId;
        }

        public void setTmpVariantId(String tmpVariantId) {
            this.tmpVariantId = tmpVariantId;
        }

        public List<AcLoadFlowContext> getContexts() {
            return this.contexts;
        }

        public void setContexts(List<AcLoadFlowContext> contexts) {
            this.contexts = contexts;
        }

        public LoadFlowParameters getParameters() {
            return this.parameters;
        }

        public void setPause(boolean pause) {
            this.pause = pause;
        }

        private void reset() {
            if (this.contexts != null) {
                for (AcLoadFlowContext context : this.contexts) {
                    context.close();
                }
                this.contexts = null;
            }
        }

        private void onStructureChange() {
            this.reset();
        }

        public void onCreation(Identifiable identifiable) {
            this.onStructureChange();
        }

        public void afterRemoval(String s) {
            this.onStructureChange();
        }

        private static Optional<Bus> getBus(Injection<?> injection, AcLoadFlowContext context) {
            return Optional.ofNullable(((AcLoadFlowParameters)context.getParameters()).getNetworkParameters().isBreakers() ? injection.getTerminal().getBusBreakerView().getBus() : injection.getTerminal().getBusView().getBus());
        }

        private static Optional<LfBus> getLfBus(Injection<?> injection, AcLoadFlowContext context) {
            return Entry.getBus(injection, context).map(bus -> context.getNetwork().getBusById(bus.getId()));
        }

        private CacheUpdateResult onInjectionUpdate(Injection<?> injection, BiFunction<AcLoadFlowContext, LfBus, CacheUpdateResult> handler) {
            for (AcLoadFlowContext context : this.contexts) {
                LfBus lfBus = Entry.getLfBus(injection, context).orElse(null);
                if (lfBus == null) continue;
                return handler.apply(context, lfBus);
            }
            return CacheUpdateResult.elementNotFound();
        }

        private static CacheUpdateResult updateLfGeneratorTargetP(String id, double oldValue, double newValue, AcLoadFlowContext context, LfBus lfBus) {
            double valueShift = newValue - oldValue;
            LfGenerator lfGenerator = lfBus.getNetwork().getGeneratorById(id);
            double newTargetP = lfGenerator.getInitialTargetP() + valueShift / 100.0;
            lfGenerator.setTargetP(newTargetP);
            lfGenerator.setInitialTargetP(newTargetP);
            lfGenerator.reApplyActivePowerControlChecks(((AcLoadFlowParameters)context.getParameters()).getNetworkParameters(), null);
            return CacheUpdateResult.elementUpdated(context);
        }

        private CacheUpdateResult onGeneratorUpdate(Generator generator, String attribute, Object oldValue, Object newValue) {
            return this.onInjectionUpdate((Injection<?>)generator, (context, lfBus) -> {
                if (attribute.equals("targetV")) {
                    double valueShift = (Double)newValue - (Double)oldValue;
                    GeneratorVoltageControl voltageControl = lfBus.getGeneratorVoltageControl().orElseThrow();
                    double nominalV = voltageControl.getControlledBus().getNominalV();
                    double newTargetV = voltageControl.getTargetValue() + valueShift / nominalV;
                    LfNetworkParameters networkParameters = ((AcLoadFlowParameters)context.getParameters()).getNetworkParameters();
                    if (AbstractLfGenerator.checkTargetV(generator.getId(), newTargetV, nominalV, networkParameters, null)) {
                        voltageControl.setTargetValue(newTargetV);
                    } else {
                        context.getNetwork().getGeneratorById(generator.getId()).setGeneratorControlType(LfGenerator.GeneratorControlType.OFF);
                        if (lfBus.getGenerators().stream().noneMatch(gen -> gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.VOLTAGE)) {
                            lfBus.setGeneratorVoltageControlEnabled(false);
                        }
                    }
                    context.getNetwork().validate(LoadFlowModel.AC, null);
                    return CacheUpdateResult.elementUpdated(context);
                }
                if (attribute.equals("targetP")) {
                    return Entry.updateLfGeneratorTargetP(generator.getId(), (Double)oldValue, (Double)newValue, context, lfBus);
                }
                return CacheUpdateResult.unsupportedUpdate();
            });
        }

        private CacheUpdateResult onBatteryUpdate(Battery battery, String attribute, Object oldValue, Object newValue) {
            return this.onInjectionUpdate((Injection<?>)battery, (context, lfBus) -> {
                if (attribute.equals("targetP")) {
                    return Entry.updateLfGeneratorTargetP(battery.getId(), (Double)oldValue, (Double)newValue, context, lfBus);
                }
                return CacheUpdateResult.unsupportedUpdate();
            });
        }

        private CacheUpdateResult onShuntUpdate(ShuntCompensator shunt, String attribute) {
            return this.onInjectionUpdate((Injection<?>)shunt, (context, lfBus) -> {
                if (attribute.equals("sectionCount")) {
                    if (lfBus.getControllerShunt().isEmpty()) {
                        LfShunt lfShunt = lfBus.getShunt().orElseThrow();
                        lfShunt.reInit();
                        return CacheUpdateResult.elementUpdated(context);
                    }
                    LOGGER.info("Shunt compensator {} is controlling voltage or connected to a bus containing a shunt compensatorwith an active voltage control: not supported", (Object)shunt.getId());
                    return CacheUpdateResult.unsupportedUpdate();
                }
                return CacheUpdateResult.unsupportedUpdate();
            });
        }

        private CacheUpdateResult onSwitchUpdate(String switchId, boolean open) {
            for (AcLoadFlowContext context : this.contexts) {
                LfNetwork lfNetwork = context.getNetwork();
                LfBranch lfBranch = lfNetwork.getBranchById(switchId);
                if (lfBranch == null) continue;
                Entry.updateSwitch(open, lfNetwork, lfBranch);
                return CacheUpdateResult.elementUpdated(context);
            }
            return CacheUpdateResult.elementNotFound();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void updateSwitch(boolean open, LfNetwork lfNetwork, LfBranch lfBranch) {
            GraphConnectivity<LfBus, LfBranch> connectivity = lfNetwork.getConnectivity();
            connectivity.startTemporaryChanges();
            try {
                if (open) {
                    connectivity.removeEdge(lfBranch);
                } else {
                    connectivity.addEdge(lfBranch.getBus1(), lfBranch.getBus2(), lfBranch);
                }
                AbstractLfBranchAction.updateBusesAndBranchStatus(connectivity);
            }
            finally {
                connectivity.undoTemporaryChanges();
            }
        }

        private CacheUpdateResult onTransformerTargetVoltageUpdate(String twtId, double newValue) {
            for (AcLoadFlowContext context : this.contexts) {
                LfNetwork lfNetwork = context.getNetwork();
                LfBranch lfBranch = lfNetwork.getBranchById(twtId);
                if (lfBranch == null) continue;
                TransformerVoltageControl vc = lfBranch.getVoltageControl().orElseThrow();
                vc.setTargetValue(newValue / vc.getControlledBus().getNominalV());
                return CacheUpdateResult.elementUpdated(context);
            }
            return CacheUpdateResult.elementNotFound();
        }

        private CacheUpdateResult onTransformerTapPositionUpdate(String twtId, int newTapPosition) {
            for (AcLoadFlowContext context : this.contexts) {
                LfNetwork lfNetwork = context.getNetwork();
                LfBranch lfBranch = lfNetwork.getBranchById(twtId);
                if (lfBranch == null) continue;
                lfBranch.getPiModel().setTapPosition(newTapPosition);
                return CacheUpdateResult.elementUpdated(context);
            }
            return CacheUpdateResult.elementNotFound();
        }

        void processUpdateResult(Identifiable<?> identifiable, String attribute, CacheUpdateResult result) {
            switch (result.status) {
                case UNSUPPORTED_UPDATE: {
                    this.reset();
                    break;
                }
                case ELEMENT_UPDATED: {
                    result.context.setNetworkUpdated(true);
                    break;
                }
                case IGNORE_UPDATE: {
                    break;
                }
                case ELEMENT_NOT_FOUND: {
                    LOGGER.warn("Cannot update attribute '{}' of element '{}' (type={})", new Object[]{attribute, identifiable.getId(), identifiable.getType()});
                }
            }
        }

        public void onUpdate(Identifiable identifiable, String attribute, String variantId, Object oldValue, Object newValue) {
            if (this.contexts == null || this.pause) {
                return;
            }
            CacheUpdateResult result = CacheUpdateResult.unsupportedUpdate();
            block12 : switch (attribute) {
                case "v": 
                case "angle": 
                case "p": 
                case "q": 
                case "p1": 
                case "q1": 
                case "p2": 
                case "q2": 
                case "p3": 
                case "q3": {
                    result = CacheUpdateResult.ignoreUpdate();
                    break;
                }
                default: {
                    if (identifiable.getType() == IdentifiableType.GENERATOR) {
                        Generator generator = (Generator)identifiable;
                        if (!attribute.equals("targetV") && !attribute.equals("targetP")) break;
                        result = this.onGeneratorUpdate(generator, attribute, oldValue, newValue);
                        break;
                    }
                    if (identifiable.getType() == IdentifiableType.BATTERY) {
                        Battery battery = (Battery)identifiable;
                        if (!attribute.equals("targetP")) break;
                        result = this.onBatteryUpdate(battery, attribute, oldValue, newValue);
                        break;
                    }
                    if (identifiable.getType() == IdentifiableType.SHUNT_COMPENSATOR) {
                        ShuntCompensator shunt = (ShuntCompensator)identifiable;
                        if (!attribute.equals("sectionCount")) break;
                        result = this.onShuntUpdate(shunt, attribute);
                        break;
                    }
                    if (identifiable.getType() == IdentifiableType.SWITCH && attribute.equals("open")) {
                        result = this.onSwitchUpdate(identifiable.getId(), (Boolean)newValue);
                        break;
                    }
                    if (identifiable.getType() == IdentifiableType.TWO_WINDINGS_TRANSFORMER) {
                        if (attribute.equals("ratioTapChanger.regulationValue")) {
                            result = this.onTransformerTargetVoltageUpdate(identifiable.getId(), (Double)newValue);
                            break;
                        }
                        if (!attribute.equals("ratioTapChanger.tapPosition")) break;
                        result = this.onTransformerTapPositionUpdate(identifiable.getId(), (Integer)newValue);
                        break;
                    }
                    if (identifiable.getType() != IdentifiableType.THREE_WINDINGS_TRANSFORMER) break;
                    for (ThreeSides side : ThreeSides.values()) {
                        if (attribute.equals("ratioTapChanger" + side.getNum() + ".regulationValue")) {
                            result = this.onTransformerTargetVoltageUpdate(LfLegBranch.getId(identifiable.getId(), side.getNum()), (Double)newValue);
                            break block12;
                        }
                        if (!attribute.equals("ratioTapChanger" + side.getNum() + ".tapPosition")) continue;
                        result = this.onTransformerTapPositionUpdate(LfLegBranch.getId(identifiable.getId(), side.getNum()), (Integer)newValue);
                        break block12;
                    }
                }
            }
            this.processUpdateResult(identifiable, attribute, result);
        }

        public void onExtensionUpdate(Extension<?> extension, String attribute, String variantId, Object oldValue, Object newValue) {
            if (this.contexts == null || this.pause) {
                return;
            }
            CacheUpdateResult result = CacheUpdateResult.unsupportedUpdate();
            if ("secondaryVoltageControl".equals(extension.getName())) {
                SecondaryVoltageControl svc = (SecondaryVoltageControl)extension;
                result = this.onSecondaryVoltageControlExtensionUpdate(svc, attribute, newValue);
            }
            this.processUpdateResult((Identifiable)extension.getExtendable(), attribute, result);
        }

        private CacheUpdateResult onSecondaryVoltageControlExtensionUpdate(SecondaryVoltageControl svc, String attribute, Object newValue) {
            if ("pilotPointTargetV".equals(attribute)) {
                PilotPoint.TargetVoltageEvent event = (PilotPoint.TargetVoltageEvent)newValue;
                ControlZone controlZone = (ControlZone)svc.getControlZone(event.controlZoneName()).orElseThrow();
                for (AcLoadFlowContext context : this.contexts) {
                    LfNetwork lfNetwork = context.getNetwork();
                    LfSecondaryVoltageControl lfSvc = lfNetwork.getSecondaryVoltageControl(controlZone.getName()).orElse(null);
                    if (lfSvc == null) continue;
                    lfSvc.setTargetValue(event.value() / lfSvc.getPilotBus().getNominalV());
                    return CacheUpdateResult.elementUpdated(context);
                }
                return CacheUpdateResult.elementNotFound();
            }
            if ("controlUnitParticipate".equals(attribute)) {
                ControlUnit.ParticipateEvent event = (ControlUnit.ParticipateEvent)newValue;
                ControlZone controlZone = (ControlZone)svc.getControlZone(event.controlZoneName()).orElseThrow();
                for (AcLoadFlowContext context : this.contexts) {
                    LfNetwork lfNetwork = context.getNetwork();
                    LfSecondaryVoltageControl lfSvc = lfNetwork.getSecondaryVoltageControl(controlZone.getName()).orElse(null);
                    if (lfSvc == null) continue;
                    if (event.value()) {
                        lfSvc.addParticipatingControlUnit(event.controlUnitId());
                    } else {
                        lfSvc.removeParticipatingControlUnit(event.controlUnitId());
                    }
                    return CacheUpdateResult.elementUpdated(context);
                }
                return CacheUpdateResult.elementNotFound();
            }
            return CacheUpdateResult.unsupportedUpdate();
        }

        private void onPropertyChange() {
        }

        public void onPropertyAdded(Identifiable identifiable, String attribute, Object newValue) {
            this.onPropertyChange();
        }

        public void onPropertyReplaced(Identifiable identifiable, String attribute, Object oldValue, Object newValue) {
            this.onPropertyChange();
        }

        public void onPropertyRemoved(Identifiable identifiable, String attribute, Object oldValue) {
            this.onPropertyChange();
        }

        private void onVariantChange() {
            this.reset();
        }

        public void onVariantCreated(String sourceVariantId, String targetVariantId) {
            this.onVariantChange();
        }

        public void onVariantOverwritten(String sourceVariantId, String targetVariantId) {
            this.onVariantChange();
        }

        public void onVariantRemoved(String variantId) {
            this.onVariantChange();
        }

        public void close() {
            this.reset();
            Network network = (Network)this.networkRef.get();
            if (network != null && this.tmpVariantId != null) {
                network.getVariantManager().removeVariant(this.tmpVariantId);
            }
        }

        record CacheUpdateResult(CacheUpdateStatus status, AcLoadFlowContext context) {
            static CacheUpdateResult unsupportedUpdate() {
                return new CacheUpdateResult(CacheUpdateStatus.UNSUPPORTED_UPDATE, null);
            }

            static CacheUpdateResult elementUpdated(AcLoadFlowContext context) {
                return new CacheUpdateResult(CacheUpdateStatus.ELEMENT_UPDATED, context);
            }

            static CacheUpdateResult ignoreUpdate() {
                return new CacheUpdateResult(CacheUpdateStatus.IGNORE_UPDATE, null);
            }

            static CacheUpdateResult elementNotFound() {
                return new CacheUpdateResult(CacheUpdateStatus.ELEMENT_NOT_FOUND, null);
            }
        }

        static enum CacheUpdateStatus {
            UNSUPPORTED_UPDATE,
            ELEMENT_UPDATED,
            IGNORE_UPDATE,
            ELEMENT_NOT_FOUND;

        }
    }
}

