/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.powsybl.openloadflow.ac.AcJacobianMatrix;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.AcTargetVector;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreator;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.asym.AsymmetricalAcEquationSystemCreator;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationVector;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.lf.AbstractLoadFlowContext;
import com.powsybl.openloadflow.network.LfNetwork;

public class AcLoadFlowContext
extends AbstractLoadFlowContext<AcVariableType, AcEquationType, AcLoadFlowParameters> {
    private AcTargetVector targetVector;
    private EquationVector<AcVariableType, AcEquationType> equationVector;
    private AcLoadFlowResult result;
    private boolean networkUpdated = true;

    public AcLoadFlowContext(LfNetwork network, AcLoadFlowParameters parameters) {
        super(network, parameters);
    }

    @Override
    public JacobianMatrix<AcVariableType, AcEquationType> getJacobianMatrix() {
        if (this.jacobianMatrix == null) {
            this.jacobianMatrix = new AcJacobianMatrix(this.getEquationSystem(), ((AcLoadFlowParameters)this.parameters).getMatrixFactory(), this.network);
        }
        return this.jacobianMatrix;
    }

    @Override
    public EquationSystem<AcVariableType, AcEquationType> getEquationSystem() {
        if (this.equationSystem == null) {
            AcEquationSystemCreator creator = ((AcLoadFlowParameters)this.parameters).isAsymmetrical() ? new AsymmetricalAcEquationSystemCreator(this.network, ((AcLoadFlowParameters)this.parameters).getEquationSystemCreationParameters()) : new AcEquationSystemCreator(this.network, ((AcLoadFlowParameters)this.parameters).getEquationSystemCreationParameters());
            this.equationSystem = creator.create();
        }
        return this.equationSystem;
    }

    @Override
    public TargetVector<AcVariableType, AcEquationType> getTargetVector() {
        if (this.targetVector == null) {
            this.targetVector = new AcTargetVector(this.network, this.getEquationSystem());
        }
        return this.targetVector;
    }

    public EquationVector<AcVariableType, AcEquationType> getEquationVector() {
        if (this.equationVector == null) {
            this.equationVector = new EquationVector<AcVariableType, AcEquationType>(this.getEquationSystem());
        }
        return this.equationVector;
    }

    public AcLoadFlowResult getResult() {
        return this.result;
    }

    public void setResult(AcLoadFlowResult result) {
        this.result = result;
    }

    public boolean isNetworkUpdated() {
        return this.networkUpdated;
    }

    public void setNetworkUpdated(boolean networkUpdated) {
        this.networkUpdated = networkUpdated;
    }

    @Override
    public void close() {
        super.close();
        if (this.targetVector != null) {
            this.targetVector.close();
        }
        if (this.equationVector != null) {
            this.equationVector.close();
        }
    }
}

