/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreationParameters;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.ac.solver.AcSolverFactory;
import com.powsybl.openloadflow.ac.solver.AcSolverParameters;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonFactory;
import com.powsybl.openloadflow.ac.solver.NewtonRaphsonParameters;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.network.util.UniformValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class AcLoadFlowParameters
extends AbstractLoadFlowParameters<AcLoadFlowParameters> {
    public static final double DEFAULT_MIN_REALISTIC_VOLTAGE = 0.5;
    public static final double DEFAULT_MAX_REALISTIC_VOLTAGE = 2.0;
    public static final double DEFAULT_MIN_NOMINAL_VOLTAGE_REALISTIC_VOLTAGE_CHECK = 0.0;
    private AcEquationSystemCreationParameters equationSystemCreationParameters = new AcEquationSystemCreationParameters();
    private AcSolverParameters acSolverParameters = new NewtonRaphsonParameters();
    private List<AcOuterLoop> outerLoops = Collections.emptyList();
    private int maxOuterLoopIterations = 20;
    private VoltageInitializer voltageInitializer = new UniformValueVoltageInitializer();
    private boolean asymmetrical = false;
    private AcSolverFactory solverFactory = new NewtonRaphsonFactory();
    private boolean detailedReport = false;
    private boolean voltageRemoteControlRobustMode = true;
    private double minRealisticVoltage = 0.5;
    private double maxRealisticVoltage = 2.0;
    private double minNominalVoltageRealisticVoltageCheck = 0.0;

    public AcEquationSystemCreationParameters getEquationSystemCreationParameters() {
        return this.equationSystemCreationParameters;
    }

    public AcLoadFlowParameters setEquationSystemCreationParameters(AcEquationSystemCreationParameters equationSystemCreationParameters) {
        this.equationSystemCreationParameters = Objects.requireNonNull(equationSystemCreationParameters);
        return this;
    }

    public AcSolverParameters getAcSolverParameters() {
        return this.acSolverParameters;
    }

    public List<AcOuterLoop> getOuterLoops() {
        return this.outerLoops;
    }

    public AcLoadFlowParameters setOuterLoops(List<AcOuterLoop> outerLoops) {
        this.outerLoops = Objects.requireNonNull(outerLoops);
        return this;
    }

    public int getMaxOuterLoopIterations() {
        return this.maxOuterLoopIterations;
    }

    public AcLoadFlowParameters setMaxOuterLoopIterations(int maxOuterLoopIterations) {
        this.maxOuterLoopIterations = maxOuterLoopIterations;
        return this;
    }

    public VoltageInitializer getVoltageInitializer() {
        return this.voltageInitializer;
    }

    public AcLoadFlowParameters setVoltageInitializer(VoltageInitializer voltageInitializer) {
        this.voltageInitializer = Objects.requireNonNull(voltageInitializer);
        return this;
    }

    public boolean isAsymmetrical() {
        return this.asymmetrical;
    }

    public AcLoadFlowParameters setAsymmetrical(boolean asymmetrical) {
        this.asymmetrical = asymmetrical;
        return this;
    }

    public AcSolverFactory getSolverFactory() {
        return this.solverFactory;
    }

    public AcLoadFlowParameters setSolverFactory(AcSolverFactory solverFactory, LoadFlowParameters parameters) {
        this.solverFactory = Objects.requireNonNull(solverFactory);
        this.acSolverParameters = solverFactory.createParameters(parameters);
        return this;
    }

    public boolean isDetailedReport() {
        return this.detailedReport;
    }

    public AcLoadFlowParameters setDetailedReport(boolean detailedReport) {
        this.detailedReport = detailedReport;
        return this;
    }

    public boolean isVoltageRemoteControlRobustMode() {
        return this.voltageRemoteControlRobustMode;
    }

    public AcLoadFlowParameters setVoltageRemoteControlRobustMode(boolean voltageRemoteControlRobustMode) {
        this.voltageRemoteControlRobustMode = voltageRemoteControlRobustMode;
        return this;
    }

    public double getMinRealisticVoltage() {
        return this.minRealisticVoltage;
    }

    public AcLoadFlowParameters setMinRealisticVoltage(double minRealisticVoltage) {
        this.minRealisticVoltage = minRealisticVoltage;
        return this;
    }

    public double getMaxRealisticVoltage() {
        return this.maxRealisticVoltage;
    }

    public AcLoadFlowParameters setMaxRealisticVoltage(double maxRealisticVoltage) {
        this.maxRealisticVoltage = maxRealisticVoltage;
        return this;
    }

    public double getMinNominalVoltageRealisticVoltageCheck() {
        return this.minNominalVoltageRealisticVoltageCheck;
    }

    public AcLoadFlowParameters setMinNominalVoltageRealisticVoltageCheck(double minNominalVoltageRealisticVoltageCheck) {
        this.minNominalVoltageRealisticVoltageCheck = minNominalVoltageRealisticVoltageCheck;
        return this;
    }

    public String toString() {
        return "AcLoadFlowParameters(networkParameters=" + this.networkParameters + ", equationSystemCreationParameters=" + this.equationSystemCreationParameters + ", acSolverParameters=" + this.acSolverParameters + ", outerLoops=" + this.outerLoops.stream().map(outerLoop -> outerLoop.getClass().getSimpleName()).toList() + ", maxOuterLoopIterations=" + this.maxOuterLoopIterations + ", matrixFactory=" + this.matrixFactory.getClass().getSimpleName() + ", voltageInitializer=" + this.voltageInitializer.getClass().getSimpleName() + ", asymmetrical=" + this.asymmetrical + ", slackDistributionFailureBehavior=" + this.slackDistributionFailureBehavior.name() + ", solverFactory=" + this.solverFactory.getClass().getSimpleName() + ", detailedReport=" + this.detailedReport + ", voltageRemoteControlRobustMode=" + this.voltageRemoteControlRobustMode + ", minRealisticVoltage=" + this.minRealisticVoltage + ", maxRealisticVoltage=" + this.maxRealisticVoltage + ", minNominalVoltageRealisticVoltageCheck=" + this.minNominalVoltageRealisticVoltageCheck + ")";
    }
}

