/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.powsybl.loadflow.LoadFlowResult;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.lf.AbstractLoadFlowResult;
import com.powsybl.openloadflow.lf.LoadFlowResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfNetwork;
import java.util.Objects;

public class AcLoadFlowResult
extends AbstractLoadFlowResult {
    private final int solverIterations;
    private final AcSolverStatus solverStatus;

    public static AcLoadFlowResult createNoCalculationResult(LfNetwork network) {
        return new AcLoadFlowResult(network, 0, 0, AcSolverStatus.NO_CALCULATION, OuterLoopResult.stable(), Double.NaN, Double.NaN);
    }

    public AcLoadFlowResult(LfNetwork network, int outerLoopIterations, int solverIterations, AcSolverStatus solverStatus, OuterLoopResult outerLoopResult, double slackBusActivePowerMismatch, double distributedActivePower) {
        super(network, slackBusActivePowerMismatch, outerLoopIterations, outerLoopResult, distributedActivePower);
        this.solverIterations = solverIterations;
        this.solverStatus = Objects.requireNonNull(solverStatus);
    }

    public int getSolverIterations() {
        return this.solverIterations;
    }

    public AcSolverStatus getSolverStatus() {
        return this.solverStatus;
    }

    @Override
    public boolean isSuccess() {
        return this.solverStatus == AcSolverStatus.CONVERGED && this.getOuterLoopResult().status() == OuterLoopStatus.STABLE;
    }

    public boolean isWithNetworkUpdate() {
        return this.isSuccess() && this.solverIterations > 0;
    }

    @Override
    public LoadFlowResult.Status toComponentResultStatus() {
        if (this.network.getValidity() == LfNetwork.Validity.INVALID_NO_GENERATOR || this.network.getValidity() == LfNetwork.Validity.INVALID_NO_GENERATOR_VOLTAGE_CONTROL) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.NO_CALCULATION, this.network.getValidity().toString());
        }
        if (this.getOuterLoopResult().status() == OuterLoopStatus.UNSTABLE) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.MAX_ITERATION_REACHED, "Reached outer loop max iterations limit. Last outer loop name: " + this.getOuterLoopResult().outerLoopName());
        }
        if (this.getOuterLoopResult().status() == OuterLoopStatus.FAILED) {
            return new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.FAILED, "Outer loop failed: " + this.getOuterLoopResult().statusText());
        }
        return switch (this.getSolverStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case AcSolverStatus.CONVERGED -> new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.CONVERGED, "Converged");
            case AcSolverStatus.MAX_ITERATION_REACHED -> new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.MAX_ITERATION_REACHED, "Reached Newton-Raphson max iterations limit");
            case AcSolverStatus.SOLVER_FAILED -> new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.FAILED, "Solver failed");
            case AcSolverStatus.UNREALISTIC_STATE -> new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.FAILED, "Unrealistic state");
            case AcSolverStatus.NO_CALCULATION -> new LoadFlowResult.Status(LoadFlowResult.ComponentResult.Status.NO_CALCULATION, "No calculation");
        };
    }

    public String toString() {
        return "AcLoadFlowResult(outerLoopIterations=" + this.outerLoopIterations + ", newtonRaphsonIterations=" + this.solverIterations + ", solverStatus=" + this.solverStatus + ", outerLoopStatus=" + this.outerLoopResult.status() + ", slackBusActivePowerMismatch=" + this.slackBusActivePowerMismatch * 100.0 + ", distributedActivePower=" + this.distributedActivePower * 100.0 + ")";
    }
}

