/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.google.common.collect.Lists;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.openloadflow.ac.AcLoadFlowContext;
import com.powsybl.openloadflow.ac.AcLoadFlowParameters;
import com.powsybl.openloadflow.ac.AcLoadFlowResult;
import com.powsybl.openloadflow.ac.AcOuterLoopContext;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.outerloop.AcActivePowerDistributionOuterLoop;
import com.powsybl.openloadflow.ac.outerloop.AcOuterLoop;
import com.powsybl.openloadflow.ac.solver.AcSolver;
import com.powsybl.openloadflow.ac.solver.AcSolverFactory;
import com.powsybl.openloadflow.ac.solver.AcSolverResult;
import com.powsybl.openloadflow.ac.solver.AcSolverStatus;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.lf.LoadFlowEngine;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopResult;
import com.powsybl.openloadflow.lf.outerloop.OuterLoopStatus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.PreviousValueVoltageInitializer;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import com.powsybl.openloadflow.util.Reports;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcloadFlowEngine
implements LoadFlowEngine<AcVariableType, AcEquationType, AcLoadFlowParameters, AcLoadFlowResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcloadFlowEngine.class);
    private final AcLoadFlowContext context;
    private final AcSolverFactory solverFactory;

    public AcloadFlowEngine(AcLoadFlowContext context) {
        this.context = Objects.requireNonNull(context);
        this.solverFactory = ((AcLoadFlowParameters)context.getParameters()).getSolverFactory();
    }

    public AcLoadFlowContext getContext() {
        return this.context;
    }

    private void runOuterLoop(AcOuterLoop outerLoop, AcOuterLoopContext outerLoopContext, AcSolver solver, RunningContext runningContext, boolean checkUnrealistic) {
        boolean isStateUnrealistic;
        OuterLoopResult outerLoopResult;
        ReportNode olReportNode = Reports.createOuterLoopReporter(outerLoopContext.getNetwork().getReportNode(), outerLoop.getName());
        do {
            MutableInt outerLoopIteration = runningContext.outerLoopIterationByType.computeIfAbsent(outerLoop.getName(), k -> new MutableInt());
            outerLoopContext.setIteration(outerLoopIteration.getValue());
            outerLoopContext.setOuterLoopTotalIterations(runningContext.outerLoopTotalIterations);
            outerLoopContext.setLastSolverResult(runningContext.lastSolverResult);
            outerLoopContext.setLoadFlowContext(this.context);
            runningContext.lastOuterLoopResult = outerLoopResult = outerLoop.check(outerLoopContext, olReportNode);
            if (outerLoopResult.status() != OuterLoopStatus.UNSTABLE) continue;
            LOGGER.debug("Start outer loop '{}' iteration {}", (Object)outerLoop.getName(), (Object)runningContext.outerLoopTotalIterations);
            ReportNode reportNode = this.context.getNetwork().getReportNode();
            if (((AcLoadFlowParameters)this.context.getParameters()).isDetailedReport()) {
                reportNode = Reports.createDetailedSolverReporterOuterLoop(reportNode, solver.getName(), this.context.getNetwork().getNumCC(), this.context.getNetwork().getNumSC(), runningContext.outerLoopTotalIterations + 1, outerLoop.getName());
            }
            runningContext.lastSolverResult = this.runAcSolverAndCheckRealisticState(solver, new PreviousValueVoltageInitializer(), reportNode, checkUnrealistic, (AcLoadFlowParameters)((AcLoadFlowContext)outerLoopContext.getLoadFlowContext()).getParameters());
            runningContext.nrTotalIterations.add(runningContext.lastSolverResult.getIterations());
            ++runningContext.outerLoopTotalIterations;
            outerLoopIteration.increment();
        } while (outerLoopResult.status() == OuterLoopStatus.UNSTABLE && runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED && runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations());
        if (!checkUnrealistic && runningContext.lastUnrealisticStateFixingLoop == outerLoop && runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED && (isStateUnrealistic = this.isStateUnrealistic(this.context.getNetwork().getReportNode(), ((AcLoadFlowParameters)((AcLoadFlowContext)outerLoopContext.getLoadFlowContext()).getParameters()).getMinNominalVoltageRealisticVoltageCheck()))) {
            runningContext.lastSolverResult = new AcSolverResult(AcSolverStatus.UNREALISTIC_STATE, runningContext.lastSolverResult.getIterations(), runningContext.lastSolverResult.getSlackBusActivePowerMismatch());
        }
        if (outerLoopResult.status() != OuterLoopStatus.STABLE) {
            Reports.reportUnsuccessfulOuterLoop(olReportNode, outerLoopResult.status().name());
        }
    }

    private boolean isStateUnrealistic(ReportNode reportNode, double minNominalVoltageRealisticVoltageCheck) {
        EquationSystem<AcVariableType, AcEquationType> equationSystem = this.context.getEquationSystem();
        AcLoadFlowParameters parameters = (AcLoadFlowParameters)this.context.getParameters();
        LfNetwork network = this.context.getNetwork();
        LinkedHashMap<String, Double> busesOutOfNormalVoltageRange = new LinkedHashMap<String, Double>();
        for (Variable<AcVariableType> variable : equationSystem.getIndex().getSortedVariablesToFind()) {
            double value;
            if (variable.getType() != AcVariableType.BUS_V || network.getBus(variable.getElementNum()).isFictitious() || !((value = equationSystem.getStateVector().get(variable.getRow())) < parameters.getMinRealisticVoltage()) && !(value > parameters.getMaxRealisticVoltage()) || !(network.getBus(variable.getElementNum()).getNominalV() >= minNominalVoltageRealisticVoltageCheck)) continue;
            busesOutOfNormalVoltageRange.put(network.getBus(variable.getElementNum()).getId(), value);
        }
        if (!busesOutOfNormalVoltageRange.isEmpty()) {
            if (LOGGER.isTraceEnabled()) {
                for (Map.Entry entry : busesOutOfNormalVoltageRange.entrySet()) {
                    LOGGER.trace("Bus '{}' has an unrealistic voltage magnitude: {} pu", entry.getKey(), entry.getValue());
                }
            }
            LOGGER.error("{} buses have a voltage magnitude out of range [{}, {}]: {}", new Object[]{busesOutOfNormalVoltageRange.size(), parameters.getMinRealisticVoltage(), parameters.getMaxRealisticVoltage(), busesOutOfNormalVoltageRange});
            Reports.reportNewtonRaphsonBusesOutOfRealisticVoltageRange(reportNode, busesOutOfNormalVoltageRange, parameters.getMinRealisticVoltage(), parameters.getMaxRealisticVoltage());
        }
        return !busesOutOfNormalVoltageRange.isEmpty();
    }

    private AcSolverResult runAcSolverAndCheckRealisticState(AcSolver solver, VoltageInitializer voltageInitializer, ReportNode reportNode, boolean checkUnrealistic, AcLoadFlowParameters parameters) {
        AcSolverResult result = solver.run(voltageInitializer, reportNode);
        if (checkUnrealistic && result.getStatus() == AcSolverStatus.CONVERGED && this.isStateUnrealistic(reportNode, parameters.getMinNominalVoltageRealisticVoltageCheck())) {
            result = new AcSolverResult(AcSolverStatus.UNREALISTIC_STATE, result.getIterations(), result.getSlackBusActivePowerMismatch());
        }
        return result;
    }

    @Override
    public AcLoadFlowResult run() {
        LOGGER.info("Start AC loadflow on network {}", (Object)this.context.getNetwork());
        VoltageInitializer voltageInitializer = ((AcLoadFlowParameters)this.context.getParameters()).getVoltageInitializer();
        voltageInitializer.prepare(this.context.getNetwork());
        RunningContext runningContext = new RunningContext();
        double distributedActivePower = 0.0;
        ReportNode reportNode = this.context.getNetwork().getReportNode();
        boolean hasVoltageRegulatedBus = this.context.getNetwork().getBuses().stream().anyMatch(b -> b.isGeneratorVoltageControlEnabled() && !b.isDisabled() && !b.getGeneratorVoltageControl().orElseThrow().isDisabled());
        if (!hasVoltageRegulatedBus) {
            LOGGER.info("Network must have at least one bus with generator voltage control enabled");
            Reports.reportNetworkMustHaveAtLeastOneBusGeneratorVoltageControlEnabled(reportNode);
            runningContext.lastSolverResult = new AcSolverResult(AcSolverStatus.SOLVER_FAILED, 0, Double.NaN);
            return this.buildAcLoadFlowResult(runningContext, OuterLoopResult.stable(), distributedActivePower);
        }
        AcSolver solver = this.solverFactory.create(this.context.getNetwork(), (AcLoadFlowParameters)this.context.getParameters(), this.context.getEquationSystem(), this.context.getJacobianMatrix(), this.context.getTargetVector(), this.context.getEquationVector());
        List<AcOuterLoop> outerLoops = ((AcLoadFlowParameters)this.context.getParameters()).getOuterLoops();
        List<Pair> outerLoopsAndContexts = outerLoops.stream().map(outerLoop -> Pair.of((Object)outerLoop, (Object)new AcOuterLoopContext(this.context.getNetwork()))).toList();
        for (Pair outerLoopAndContext : outerLoopsAndContexts) {
            AcOuterLoop outerLoop2 = (AcOuterLoop)outerLoopAndContext.getLeft();
            AcOuterLoopContext outerLoopContext = (AcOuterLoopContext)outerLoopAndContext.getRight();
            outerLoop2.initialize(outerLoopContext);
        }
        if (((AcLoadFlowParameters)this.context.getParameters()).isDetailedReport()) {
            reportNode = Reports.createDetailedSolverReporter(reportNode, solver.getName(), this.context.getNetwork().getNumCC(), this.context.getNetwork().getNumSC());
        }
        runningContext.lastUnrealisticStateFixingLoop = ((AcLoadFlowParameters)this.context.getParameters()).isVoltageRemoteControlRobustMode() ? (AcOuterLoop)outerLoopsAndContexts.stream().map(Pair::getLeft).filter(AcOuterLoop::canFixUnrealisticState).reduce((first, second) -> second).orElse(null) : null;
        boolean checkUnrealisticStates = runningContext.lastUnrealisticStateFixingLoop == null;
        runningContext.lastSolverResult = this.runAcSolverAndCheckRealisticState(solver, voltageInitializer, reportNode, checkUnrealisticStates, (AcLoadFlowParameters)this.context.getParameters());
        runningContext.nrTotalIterations.add(runningContext.lastSolverResult.getIterations());
        if (runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED) {
            int oldNrTotalIterations;
            block1: do {
                checkUnrealisticStates = runningContext.lastUnrealisticStateFixingLoop == null;
                oldNrTotalIterations = runningContext.nrTotalIterations.getValue();
                for (Pair outerLoopAndContext : outerLoopsAndContexts) {
                    this.runOuterLoop((AcOuterLoop)outerLoopAndContext.getLeft(), (AcOuterLoopContext)outerLoopAndContext.getRight(), solver, runningContext, checkUnrealisticStates);
                    if (outerLoopAndContext.getLeft() == runningContext.lastUnrealisticStateFixingLoop) {
                        checkUnrealisticStates = true;
                    }
                    if (runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED && runningContext.lastOuterLoopResult.status() != OuterLoopStatus.FAILED && runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations()) continue;
                    continue block1;
                }
            } while (runningContext.nrTotalIterations.getValue() > oldNrTotalIterations && runningContext.lastSolverResult.getStatus() == AcSolverStatus.CONVERGED && runningContext.lastOuterLoopResult.status() != OuterLoopStatus.FAILED && runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations());
        }
        for (Pair outerLoopAndContext : Lists.reverse(outerLoopsAndContexts)) {
            AcOuterLoop outerLoop3 = (AcOuterLoop)outerLoopAndContext.getLeft();
            AcOuterLoopContext outerLoopContext = (AcOuterLoopContext)outerLoopAndContext.getRight();
            if (outerLoop3 instanceof AcActivePowerDistributionOuterLoop) {
                AcActivePowerDistributionOuterLoop activePowerDistributionOuterLoop = (AcActivePowerDistributionOuterLoop)((Object)outerLoop3);
                distributedActivePower = activePowerDistributionOuterLoop.getDistributedActivePower(outerLoopContext);
            }
            outerLoop3.cleanup(outerLoopContext);
        }
        if (runningContext.outerLoopTotalIterations >= ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations()) {
            Reports.reportMaxOuterLoopIterations(reportNode, runningContext.outerLoopTotalIterations, true, LOGGER);
        }
        OuterLoopResult outerLoopFinalResult = runningContext.lastOuterLoopResult.status() == OuterLoopStatus.FAILED ? runningContext.lastOuterLoopResult : (runningContext.outerLoopTotalIterations < ((AcLoadFlowParameters)this.context.getParameters()).getMaxOuterLoopIterations() ? new OuterLoopResult(runningContext.lastOuterLoopResult.outerLoopName(), OuterLoopStatus.STABLE, runningContext.lastOuterLoopResult.statusText()) : new OuterLoopResult(runningContext.lastOuterLoopResult.outerLoopName(), OuterLoopStatus.UNSTABLE, runningContext.lastOuterLoopResult.statusText()));
        return this.buildAcLoadFlowResult(runningContext, outerLoopFinalResult, distributedActivePower);
    }

    private AcLoadFlowResult buildAcLoadFlowResult(RunningContext runningContext, OuterLoopResult outerLoopFinalResult, double distributedActivePower) {
        AcLoadFlowResult result = new AcLoadFlowResult(this.context.getNetwork(), runningContext.outerLoopTotalIterations, runningContext.nrTotalIterations.getValue(), runningContext.lastSolverResult.getStatus(), outerLoopFinalResult, runningContext.lastSolverResult.getSlackBusActivePowerMismatch(), distributedActivePower);
        LOGGER.info("AC loadflow complete on network {} (result={})", (Object)this.context.getNetwork(), (Object)result);
        Reports.reportAcLfComplete(this.context.getNetwork().getReportNode(), result.isSuccess(), result.getSolverStatus().name(), result.getOuterLoopResult().status().name());
        this.context.setResult(result);
        return result;
    }

    public static List<AcLoadFlowResult> run(List<LfNetwork> lfNetworks, AcLoadFlowParameters parameters) {
        return lfNetworks.stream().map(n -> {
            if (n.getValidity() == LfNetwork.Validity.VALID) {
                try (AcLoadFlowContext context = new AcLoadFlowContext((LfNetwork)n, parameters);){
                    AcLoadFlowResult acLoadFlowResult = new AcloadFlowEngine(context).run();
                    return acLoadFlowResult;
                }
            }
            return AcLoadFlowResult.createNoCalculationResult(n);
        }).toList();
    }

    private static class RunningContext {
        private AcSolverResult lastSolverResult;
        private final Map<String, MutableInt> outerLoopIterationByType = new HashMap<String, MutableInt>();
        private int outerLoopTotalIterations = 0;
        private final MutableInt nrTotalIterations = new MutableInt();
        private OuterLoopResult lastOuterLoopResult = OuterLoopResult.stable();
        private AcOuterLoop lastUnrealisticStateFixingLoop;

        private RunningContext() {
        }
    }
}

