/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac;

import com.google.common.base.Stopwatch;
import com.powsybl.commons.PowsyblException;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.equations.Quantity;
import com.powsybl.openloadflow.equations.TargetVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.util.VoltageInitializer;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoltageMagnitudeInitializer
implements VoltageInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltageMagnitudeInitializer.class);
    private final double lowImpedanceThreshold;
    private final boolean transformerVoltageControlOn;
    private final MatrixFactory matrixFactory;

    public VoltageMagnitudeInitializer(boolean transformerVoltageControlOn, MatrixFactory matrixFactory, double lowImpedanceThreshold) {
        this.transformerVoltageControlOn = transformerVoltageControlOn;
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        this.lowImpedanceThreshold = lowImpedanceThreshold;
    }

    private static void initTarget(Equation<InitVmVariableType, InitVmEquationType> equation, LfNetwork network, double[] targets) {
        switch (equation.getType()) {
            case BUS_TARGET_V: {
                LfBus bus = network.getBus(equation.getElementNum());
                targets[equation.getColumn()] = bus.getGeneratorVoltageControl().map(Control::getTargetValue).orElseGet(() -> bus.getTransformerVoltageControl().map(Control::getTargetValue).orElseThrow());
                break;
            }
            case BUS_ZERO: {
                targets[equation.getColumn()] = 0.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown equation type: " + equation.getType());
            }
        }
    }

    @Override
    public void prepare(LfNetwork network) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        EquationSystem<InitVmVariableType, InitVmEquationType> equationSystem = new EquationSystem<InitVmVariableType, InitVmEquationType>();
        for (LfBus bus : network.getBuses()) {
            EquationTerm v = equationSystem.getVariable(bus.getNum(), InitVmVariableType.BUS_V).createTerm();
            if (bus.isGeneratorVoltageControlled() || this.transformerVoltageControlOn && bus.isTransformerVoltageControlled()) {
                equationSystem.createEquation(bus.getNum(), InitVmEquationType.BUS_TARGET_V).addTerm(v);
                continue;
            }
            equationSystem.createEquation(bus.getNum(), InitVmEquationType.BUS_ZERO).addTerm(new InitVmBusEquationTerm(bus, equationSystem.getVariableSet(), this.lowImpedanceThreshold)).addTerm(v.minus());
        }
        try (JacobianMatrix j = new JacobianMatrix(equationSystem, this.matrixFactory);){
            double[] targets = TargetVector.createArray(network, equationSystem, VoltageMagnitudeInitializer::initTarget);
            j.solveTransposed(targets);
            for (Variable variable : equationSystem.getIndex().getSortedVariablesToFind()) {
                LfBus bus = network.getBus(variable.getElementNum());
                bus.setV(targets[variable.getRow()]);
            }
        }
        stopwatch.stop();
        LOGGER.info("Initial voltage magnitude solved in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    public double getMagnitude(LfBus bus) {
        return bus.getV();
    }

    @Override
    public double getAngle(LfBus bus) {
        return 0.0;
    }

    public static enum InitVmEquationType implements Quantity
    {
        BUS_TARGET_V("v", ElementType.BUS),
        BUS_ZERO("bus_z", ElementType.BUS);

        private final String symbol;
        private final ElementType elementType;

        private InitVmEquationType(String symbol, ElementType elementType) {
            this.symbol = symbol;
            this.elementType = elementType;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public ElementType getElementType() {
            return this.elementType;
        }
    }

    public static enum InitVmVariableType implements Quantity
    {
        BUS_V("v", ElementType.BUS);

        private final String symbol;
        private final ElementType elementType;

        private InitVmVariableType(String symbol, ElementType elementType) {
            this.symbol = symbol;
            this.elementType = elementType;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public ElementType getElementType() {
            return this.elementType;
        }
    }

    public static final class InitVmBusEquationTerm
    extends AbstractElementEquationTerm<LfBus, InitVmVariableType, InitVmEquationType> {
        private final List<Variable<InitVmVariableType>> variables;
        private final TDoubleArrayList der;

        public InitVmBusEquationTerm(LfBus bus, VariableSet<InitVmVariableType> variableSet, double lowImpedanceThreshold) {
            super(bus);
            Map<LfBus, List<LfBranch>> neighbors = bus.findNeighbors();
            if (neighbors.isEmpty()) {
                throw new PowsyblException("Isolated bus");
            }
            this.variables = new ArrayList<Variable<InitVmVariableType>>(neighbors.size());
            this.der = new TDoubleArrayList(neighbors.size());
            double bs = 0.0;
            for (Map.Entry<LfBus, List<LfBranch>> e : neighbors.entrySet()) {
                LfBus neighborBus = e.getKey();
                List<LfBranch> neighborBranches = e.getValue();
                double b = 0.0;
                double r = 0.0;
                for (LfBranch neighborBranch : neighborBranches) {
                    PiModel piModel = neighborBranch.getPiModel();
                    double x = Math.max(Math.abs(piModel.getX()), lowImpedanceThreshold);
                    b += 1.0 / x;
                    r += neighborBranch.getBus1() == bus ? 1.0 / piModel.getR1() : piModel.getR1();
                }
                bs += b;
                this.der.add(b * (r /= (double)neighborBranches.size()));
                this.variables.add(variableSet.getVariable(neighborBus.getNum(), InitVmVariableType.BUS_V));
            }
            if (bs == 0.0) {
                throw new PowsyblException("Susceptance sum is zero");
            }
            for (int i = 0; i < this.der.size(); ++i) {
                this.der.setQuick(i, this.der.getQuick(i) / bs);
            }
        }

        @Override
        public List<Variable<InitVmVariableType>> getVariables() {
            return this.variables;
        }

        @Override
        public double eval() {
            throw new IllegalStateException("Useless");
        }

        @Override
        public double der(Variable<InitVmVariableType> variable) {
            int i = this.variables.indexOf(variable);
            if (i == -1) {
                throw new IllegalStateException("Unknown variable: " + variable);
            }
            return this.der.getQuick(i);
        }

        @Override
        protected String getName() {
            return "v_distr";
        }
    }
}

