/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.iidm.network.util.HvdcUtils;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;
import java.util.List;

public abstract class AbstractHvdcAcEmulationFlowEquationTerm
extends AbstractElementEquationTerm<LfHvdc, AcVariableType, AcEquationType> {
    protected final Variable<AcVariableType> ph1Var;
    protected final Variable<AcVariableType> ph2Var;
    protected final List<Variable<AcVariableType>> variables;
    protected final double k;
    protected final double p0;
    protected final double r;
    protected final double lossFactor1;
    protected final double lossFactor2;
    protected final double pMaxFromCS1toCS2;
    protected final double pMaxFromCS2toCS1;

    protected AbstractHvdcAcEmulationFlowEquationTerm(LfHvdc hvdc, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet) {
        super(hvdc);
        this.ph1Var = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_PHI);
        this.ph2Var = variableSet.getVariable(bus2.getNum(), AcVariableType.BUS_PHI);
        this.variables = List.of(this.ph1Var, this.ph2Var);
        this.k = hvdc.getDroop() * 180.0 / Math.PI;
        this.p0 = hvdc.getP0();
        this.r = hvdc.getR();
        this.lossFactor1 = hvdc.getConverterStation1().getLossFactor() / 100.0;
        this.lossFactor2 = hvdc.getConverterStation2().getLossFactor() / 100.0;
        this.pMaxFromCS1toCS2 = hvdc.getPMaxFromCS1toCS2();
        this.pMaxFromCS2toCS1 = hvdc.getPMaxFromCS2toCS1();
    }

    protected double rawP(double ph1, double ph2) {
        return this.p0 + this.k * (ph1 - ph2);
    }

    protected double boundedP(double rawP) {
        if (rawP >= 0.0) {
            return Math.min(rawP, this.pMaxFromCS1toCS2);
        }
        return Math.max(rawP, -this.pMaxFromCS2toCS1);
    }

    protected double ph1() {
        return this.sv.get(this.ph1Var.getRow());
    }

    protected double ph2() {
        return this.sv.get(this.ph2Var.getRow());
    }

    protected double getVscLossMultiplier() {
        return (1.0 - this.lossFactor1) * (1.0 - this.lossFactor2);
    }

    protected double getAbsActivePowerWithLosses(double boundedP, double lossController, double lossNonController) {
        double lineInputPower = (1.0 - lossController) * Math.abs(boundedP);
        return (1.0 - lossNonController) * (lineInputPower - AbstractHvdcAcEmulationFlowEquationTerm.getHvdcLineLosses(lineInputPower, this.r));
    }

    protected static double getHvdcLineLosses(double lineInputPower, double r) {
        return HvdcUtils.getHvdcLineLosses((double)lineInputPower, (double)1.0, (double)r);
    }

    @Override
    public List<Variable<AcVariableType>> getVariables() {
        return this.variables;
    }

    @Override
    public boolean hasRhs() {
        return false;
    }
}

