/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.AbstractElementEquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfLoadModel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class AbstractLoadModelEquationTerm
extends AbstractElementEquationTerm<LfBus, AcVariableType, AcEquationType> {
    protected final LfLoadModel loadModel;
    protected final LfLoad load;
    private final Variable<AcVariableType> vVar;
    private final List<Variable<AcVariableType>> variables;

    protected AbstractLoadModelEquationTerm(LfBus bus, LfLoadModel loadModel, LfLoad load, VariableSet<AcVariableType> variableSet) {
        super(bus);
        this.loadModel = Objects.requireNonNull(loadModel);
        this.load = Objects.requireNonNull(load);
        this.vVar = variableSet.getVariable(bus.getNum(), AcVariableType.BUS_V);
        this.variables = List.of(this.vVar);
    }

    @Override
    public List<Variable<AcVariableType>> getVariables() {
        return this.variables;
    }

    private double v() {
        return this.sv.get(this.vVar.getRow());
    }

    protected abstract Collection<LfLoadModel.ExpTerm> getExpTerms();

    protected abstract double getTarget();

    @Override
    public double eval() {
        double value = 0.0;
        double v = this.v();
        for (LfLoadModel.ExpTerm expTerm : this.getExpTerms()) {
            if (expTerm.n() == 0.0) continue;
            value += expTerm.c() * Math.pow(v, expTerm.n());
        }
        return value * this.getTarget();
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        double value = 0.0;
        double v = this.v();
        for (LfLoadModel.ExpTerm expTerm : this.getExpTerms()) {
            if (expTerm.n() == 0.0) continue;
            value += expTerm.c() * expTerm.n() * Math.pow(v, expTerm.n() - 1.0);
        }
        return value * this.getTarget();
    }
}

