/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.ac.equations.AbstractBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemCreationParameters;
import com.powsybl.openloadflow.ac.equations.AcEquationSystemUpdater;
import com.powsybl.openloadflow.ac.equations.AcEquationType;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide1ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide1CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide1ReactiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide2ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide2CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.equations.ClosedBranchSide2ReactiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.HvdcAcEmulationSide1ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.HvdcAcEmulationSide2ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.LoadModelActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.LoadModelReactiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.OpenBranchSide1ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.OpenBranchSide1CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.equations.OpenBranchSide1ReactiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.OpenBranchSide2ActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.OpenBranchSide2CurrentMagnitudeEquationTerm;
import com.powsybl.openloadflow.ac.equations.OpenBranchSide2ReactiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ShuntCompensatorActiveFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.ShuntCompensatorReactiveFlowEquationTerm;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationSystemPostProcessor;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.GeneratorReactivePowerControl;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfLoadModel;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListenerTracer;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.EvaluableConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AcEquationSystemCreator {
    protected final LfNetwork network;
    protected final AcEquationSystemCreationParameters creationParameters;

    public AcEquationSystemCreator(LfNetwork network) {
        this(network, new AcEquationSystemCreationParameters());
    }

    public AcEquationSystemCreator(LfNetwork network, AcEquationSystemCreationParameters creationParameters) {
        this.network = Objects.requireNonNull(network);
        this.creationParameters = Objects.requireNonNull(creationParameters);
    }

    protected void createBusEquation(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        Equation<AcVariableType, AcEquationType> p = equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_P);
        bus.setP(p);
        Equation<AcVariableType, AcEquationType> q = equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_Q);
        bus.setQ(q);
        if (bus.isReference()) {
            equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_PHI).addTerm(equationSystem.getVariable(bus.getNum(), AcVariableType.BUS_PHI).createTerm());
        }
        if (bus.isSlack()) {
            p.setActive(false);
        }
        EquationTerm vTerm = equationSystem.getVariable(bus.getNum(), AcVariableType.BUS_V).createTerm();
        equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_V).addTerm(vTerm).setActive(false);
        bus.setCalculatedV(vTerm);
        AcEquationSystemCreator.createShuntEquations(bus, equationSystem);
        this.createLoadEquations(bus, equationSystem);
    }

    private void createLoadEquations(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        for (LfLoad load : bus.getLoads()) {
            load.getLoadModel().ifPresent(loadModel -> {
                LoadModelActiveFlowEquationTerm p = new LoadModelActiveFlowEquationTerm(bus, (LfLoadModel)loadModel, load, equationSystem.getVariableSet());
                equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_P).addTerm(p);
                load.setP(p);
                LoadModelReactiveFlowEquationTerm q = new LoadModelReactiveFlowEquationTerm(bus, (LfLoadModel)loadModel, load, equationSystem.getVariableSet());
                equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_Q).addTerm(q);
                load.setQ(q);
            });
        }
    }

    private void createVoltageControlEquations(EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        for (LfBus bus : this.network.getBuses()) {
            this.createGeneratorVoltageControlEquations(bus, equationSystem);
            AcEquationSystemCreator.createTransformerVoltageControlEquations(bus, equationSystem);
            AcEquationSystemCreator.createShuntVoltageControlEquations(bus, equationSystem);
        }
    }

    private void createBusesEquations(EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        for (LfBus bus : this.network.getBuses()) {
            this.createBusEquation(bus, equationSystem);
        }
    }

    private void createGeneratorVoltageControlEquations(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        bus.getGeneratorVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> {
            if (bus.isGeneratorVoltageControlled()) {
                if (voltageControl.isLocalControl()) {
                    this.createGeneratorLocalVoltageControlEquation(bus, equationSystem);
                } else {
                    AcEquationSystemCreator.createGeneratorReactivePowerDistributionEquations(voltageControl, equationSystem, this.creationParameters);
                }
                AcEquationSystemCreator.updateGeneratorVoltageControl(voltageControl, equationSystem);
            }
        });
    }

    private void createGeneratorLocalVoltageControlEquation(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        if (bus.hasGeneratorsWithSlope()) {
            double slope = bus.getGeneratorsControllingVoltageWithSlope().get(0).getSlope();
            equationSystem.getEquation(bus.getNum(), AcEquationType.BUS_TARGET_V).orElseThrow().addTerms(AcEquationSystemCreator.createReactiveTerms(bus, equationSystem.getVariableSet(), this.creationParameters).stream().map(term -> term.multiply(slope)).collect(Collectors.toList()));
            for (LfBranch branch : bus.getBranches()) {
                AcEquationSystemCreator.updateBranchEquations(branch);
            }
        }
    }

    protected void createGeneratorReactivePowerControlBranchEquation(LfBranch branch, LfBus bus1, LfBus bus2, EquationSystem<AcVariableType, AcEquationType> equationSystem, boolean deriveA1, boolean deriveR1) {
        if (bus1 != null && bus2 != null) {
            branch.getGeneratorReactivePowerControl().ifPresent(rpc -> {
                AbstractClosedBranchAcFlowEquationTerm q = rpc.getControlledSide() == TwoSides.ONE ? new ClosedBranchSide1ReactiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1) : new ClosedBranchSide2ReactiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
                equationSystem.createEquation(branch, AcEquationType.BRANCH_TARGET_Q).addTerm(q);
                AcEquationSystemCreator.createGeneratorReactivePowerDistributionEquations(rpc, equationSystem, this.creationParameters);
                AcEquationSystemCreator.updateGeneratorReactivePowerControlBranchEquations(rpc, equationSystem);
            });
        }
    }

    public static void updateGeneratorReactivePowerControlBranchEquations(GeneratorReactivePowerControl generatorReactivePowerControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        LfBranch controlledBranch = generatorReactivePowerControl.getControlledBranch();
        List<LfBus> controllerBuses = generatorReactivePowerControl.getControllerBuses().stream().filter(b -> !b.isDisabled()).toList();
        Equation<AcVariableType, AcEquationType> qEq = equationSystem.getEquation(controlledBranch.getNum(), AcEquationType.BRANCH_TARGET_Q).orElseThrow();
        if (controlledBranch.isDisabled()) {
            qEq.setActive(false);
            for (LfBus controllerBus : controllerBuses) {
                equationSystem.getEquation(controllerBus.getNum(), AcEquationType.DISTR_Q).ifPresent(eq -> eq.setActive(false));
                equationSystem.getEquation(controllerBus.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().setActive(true);
            }
        } else {
            List<LfBus> enabledControllerBuses = controllerBuses.stream().filter(LfBus::isGeneratorReactivePowerControlEnabled).toList();
            List<LfBus> disabledControllerBuses = controllerBuses.stream().filter(Predicate.not(LfBus::isGeneratorReactivePowerControlEnabled)).toList();
            generatorReactivePowerControl.updateReactiveKeys();
            qEq.setActive(!enabledControllerBuses.isEmpty());
            for (LfBus controllerElement : disabledControllerBuses) {
                equationSystem.getEquation(controllerElement.getNum(), AcEquationType.DISTR_Q).ifPresent(eq -> eq.setActive(false));
                equationSystem.getEquation(controllerElement.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().setActive(true);
            }
            for (int i = 0; i < enabledControllerBuses.size(); ++i) {
                boolean active = i != 0;
                LfBus controllerElement = enabledControllerBuses.get(i);
                equationSystem.getEquation(controllerElement.getNum(), AcEquationType.DISTR_Q).ifPresent(eq -> eq.setActive(active));
                equationSystem.getEquation(controllerElement.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().setActive(false);
            }
        }
    }

    private static void createShuntEquation(LfShunt shunt, LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem, boolean deriveB) {
        ShuntCompensatorReactiveFlowEquationTerm q = new ShuntCompensatorReactiveFlowEquationTerm(shunt, bus, equationSystem.getVariableSet(), deriveB);
        equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_Q).addTerm(q);
        shunt.setQ(q);
        ShuntCompensatorActiveFlowEquationTerm p = new ShuntCompensatorActiveFlowEquationTerm(shunt, bus, equationSystem.getVariableSet());
        equationSystem.createEquation(bus, AcEquationType.BUS_TARGET_P).addTerm(p);
        shunt.setP(p);
    }

    private static void createShuntEquations(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        bus.getShunt().ifPresent(shunt -> AcEquationSystemCreator.createShuntEquation(shunt, bus, equationSystem, false));
        bus.getControllerShunt().ifPresent(shunt -> AcEquationSystemCreator.createShuntEquation(shunt, bus, equationSystem, shunt.hasVoltageControlCapability()));
        bus.getSvcShunt().ifPresent(shunt -> AcEquationSystemCreator.createShuntEquation(shunt, bus, equationSystem, false));
    }

    private static void createGeneratorReactivePowerDistributionEquations(Control control, EquationSystem<AcVariableType, AcEquationType> equationSystem, AcEquationSystemCreationParameters creationParameters) {
        List<Object> controllerBuses = null;
        if (control instanceof GeneratorVoltageControl) {
            GeneratorVoltageControl generatorVoltageControl = (GeneratorVoltageControl)control;
            controllerBuses = generatorVoltageControl.getMergedControllerElements();
        } else if (control instanceof GeneratorReactivePowerControl) {
            GeneratorReactivePowerControl generatorReactivePowerControl = (GeneratorReactivePowerControl)control;
            controllerBuses = generatorReactivePowerControl.getControllerBuses();
        } else {
            throw new PowsyblException("Control has to be of type GeneratorVoltageControl or ReactivePowerControl to create Q distribution equations");
        }
        for (LfBus lfBus : controllerBuses) {
            Equation<AcVariableType, AcEquationType> zero = equationSystem.createEquation(lfBus, AcEquationType.DISTR_Q).addTerms(AcEquationSystemCreator.createReactiveTerms(lfBus, equationSystem.getVariableSet(), creationParameters).stream().map(term -> term.multiply(() -> controllerBus.getRemoteControlReactivePercent() - 1.0)).collect(Collectors.toList()));
            for (LfBranch lfBranch : lfBus.getBranches()) {
                AcEquationSystemCreator.updateBranchEquations(lfBranch);
            }
            for (LfBus lfBus2 : controllerBuses) {
                if (lfBus2 != lfBus) {
                    zero.addTerms(AcEquationSystemCreator.createReactiveTerms(lfBus2, equationSystem.getVariableSet(), creationParameters).stream().map(term -> term.multiply(controllerBus::getRemoteControlReactivePercent)).collect(Collectors.toList()));
                }
                for (LfBranch branch : lfBus2.getBranches()) {
                    AcEquationSystemCreator.updateBranchEquations(branch);
                }
            }
        }
    }

    private static void removeEquationAndCleanElement(LfNetwork network, EquationSystem<AcVariableType, AcEquationType> equationSystem, int elementNum, AcEquationType equationType) {
        Equation<AcVariableType, AcEquationType> removedEq = equationSystem.removeEquation(elementNum, equationType);
        if (removedEq != null) {
            for (EquationTerm<AcVariableType, AcEquationType> term : removedEq.getLeafTerms()) {
                LfElement element = network.getElement(term.getElementType(), term.getElementNum());
                element.removeEvaluable(term);
            }
        }
    }

    public static void recreateReactivePowerDistributionEquations(LfNetwork network, GeneratorVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem, AcEquationSystemCreationParameters parameters) {
        for (LfBus controllerBus : voltageControl.getMergedControllerElements()) {
            AcEquationSystemCreator.removeEquationAndCleanElement(network, equationSystem, controllerBus.getNum(), AcEquationType.DISTR_Q);
        }
        if (!voltageControl.isLocalControl()) {
            AcEquationSystemCreator.createGeneratorReactivePowerDistributionEquations(voltageControl, equationSystem, parameters);
        }
        AcEquationSystemCreator.updateGeneratorVoltageControl(voltageControl, equationSystem);
    }

    static <T extends LfElement> void updateRemoteVoltageControlEquations(VoltageControl<T> voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem, AcEquationType distrEqType, AcEquationType ctrlEqType) {
        AcEquationSystemCreator.checkNotDependentVoltageControl(voltageControl);
        LfBus controlledBus = voltageControl.getControlledBus();
        List<LfElement> controllerElements = voltageControl.getMergedControllerElements().stream().filter(b -> !b.isDisabled()).toList();
        Equation<AcVariableType, AcEquationType> vEq = equationSystem.getEquation(controlledBus.getNum(), AcEquationType.BUS_TARGET_V).orElseThrow();
        List<Equation> vEqMergedList = voltageControl.getMergedDependentVoltageControls().stream().map(vc -> equationSystem.getEquation(vc.getControlledBus().getNum(), AcEquationType.BUS_TARGET_V).orElseThrow()).toList();
        if (voltageControl.isHidden()) {
            voltageControl.findMainVisibleControlledBus().ifPresentOrElse(mainVisibleControlledBus -> {
                if (mainVisibleControlledBus != voltageControl.getControlledBus()) {
                    vEq.setActive(false);
                }
            }, () -> vEq.setActive(false));
            for (LfElement controllerElement : controllerElements) {
                equationSystem.getEquation(controllerElement.getNum(), distrEqType).ifPresent(eq -> eq.setActive(false));
                equationSystem.getEquation(controllerElement.getNum(), ctrlEqType).orElseThrow().setActive(true);
            }
        } else {
            List<LfElement> enabledControllerElements = controllerElements.stream().filter(voltageControl::isControllerEnabled).toList();
            List<LfElement> disabledControllerElements = controllerElements.stream().filter(Predicate.not(voltageControl::isControllerEnabled)).toList();
            vEq.setActive(!enabledControllerElements.isEmpty());
            for (Equation vEqMerged : vEqMergedList) {
                vEqMerged.setActive(false);
            }
            for (LfElement controllerElement : disabledControllerElements) {
                equationSystem.getEquation(controllerElement.getNum(), distrEqType).ifPresent(eq -> eq.setActive(false));
                equationSystem.getEquation(controllerElement.getNum(), ctrlEqType).orElseThrow().setActive(true);
            }
            for (int i = 0; i < enabledControllerElements.size(); ++i) {
                boolean active = i != 0;
                LfElement controllerElement = enabledControllerElements.get(i);
                equationSystem.getEquation(controllerElement.getNum(), distrEqType).ifPresent(eq -> eq.setActive(active));
                equationSystem.getEquation(controllerElement.getNum(), ctrlEqType).orElseThrow().setActive(false);
            }
        }
    }

    private static List<EquationTerm<AcVariableType, AcEquationType>> createReactiveTerms(LfBus controllerBus, VariableSet<AcVariableType> variableSet, AcEquationSystemCreationParameters creationParameters) {
        ArrayList<EquationTerm<AcVariableType, AcEquationType>> terms = new ArrayList<EquationTerm<AcVariableType, AcEquationType>>();
        for (LfBranch branch : controllerBus.getBranches()) {
            EquationTerm<AcVariableType, AcEquationType> q;
            AbstractBranchAcFlowEquationTerm openQ = null;
            if (branch.isZeroImpedance(LoadFlowModel.AC)) {
                if (!branch.isSpanningTreeEdge(LoadFlowModel.AC)) continue;
                q = branch.getBus1() == controllerBus ? variableSet.getVariable(branch.getNum(), AcVariableType.DUMMY_Q).createTerm() : variableSet.getVariable(branch.getNum(), AcVariableType.DUMMY_Q).createTerm().minus();
            } else {
                boolean deriveA1 = AcEquationSystemCreator.isDeriveA1(branch, creationParameters);
                boolean deriveR1 = AcEquationSystemCreator.isDeriveR1(branch);
                if (branch.getBus1() == controllerBus) {
                    otherSideBus = branch.getBus2();
                    if (otherSideBus != null) {
                        q = new ClosedBranchSide1ReactiveFlowEquationTerm(branch, controllerBus, otherSideBus, variableSet, deriveA1, deriveR1);
                        branch.addAdditionalClosedQ1(q);
                        if (branch.isDisconnectionAllowedSide2()) {
                            openQ = new OpenBranchSide2ReactiveFlowEquationTerm(branch, controllerBus, variableSet);
                            branch.addAdditionalOpenQ1(openQ);
                        }
                    } else {
                        q = new OpenBranchSide2ReactiveFlowEquationTerm(branch, controllerBus, variableSet);
                        branch.addAdditionalOpenQ1(q);
                    }
                } else {
                    otherSideBus = branch.getBus1();
                    if (otherSideBus != null) {
                        q = new ClosedBranchSide2ReactiveFlowEquationTerm(branch, otherSideBus, controllerBus, variableSet, deriveA1, deriveR1);
                        branch.addAdditionalClosedQ2(q);
                        if (branch.isDisconnectionAllowedSide1()) {
                            openQ = new OpenBranchSide1ReactiveFlowEquationTerm(branch, controllerBus, variableSet);
                            branch.addAdditionalOpenQ2(openQ);
                        }
                    } else {
                        q = new OpenBranchSide1ReactiveFlowEquationTerm(branch, controllerBus, variableSet);
                        branch.addAdditionalOpenQ2(q);
                    }
                }
            }
            terms.add(q);
            if (openQ == null) continue;
            terms.add(openQ);
        }
        controllerBus.getShunt().ifPresent(shunt -> {
            ShuntCompensatorReactiveFlowEquationTerm q = new ShuntCompensatorReactiveFlowEquationTerm((LfShunt)shunt, controllerBus, variableSet, false);
            terms.add(q);
        });
        controllerBus.getControllerShunt().ifPresent(shunt -> {
            ShuntCompensatorReactiveFlowEquationTerm q = new ShuntCompensatorReactiveFlowEquationTerm((LfShunt)shunt, controllerBus, variableSet, false);
            terms.add(q);
        });
        return terms;
    }

    public static void updateGeneratorVoltageControl(GeneratorVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        AcEquationSystemCreator.checkNotDependentVoltageControl(voltageControl);
        voltageControl.updateReactiveKeys();
        AcEquationSystemCreator.updateRemoteVoltageControlEquations(voltageControl, equationSystem, AcEquationType.DISTR_Q, AcEquationType.BUS_TARGET_Q);
    }

    private static <T extends LfElement> void checkNotDependentVoltageControl(VoltageControl<T> voltageControl) {
        if (voltageControl.getMergeStatus() == VoltageControl.MergeStatus.DEPENDENT) {
            throw new IllegalArgumentException("Cannot update a merged dependent voltage control");
        }
    }

    private static void createNonImpedantBranch(LfBranch branch, LfBus bus1, LfBus bus2, EquationSystem<AcVariableType, AcEquationType> equationSystem, boolean spanningTreeEdge) {
        if (bus1 != null && bus2 != null) {
            boolean enabled;
            Optional<Equation<AcVariableType, AcEquationType>> v1 = equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_V);
            Optional<Equation<AcVariableType, AcEquationType>> v2 = equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_V);
            boolean hasV1 = v1.isPresent() && v1.get().isActive();
            boolean hasV2 = v2.isPresent() && v2.get().isActive();
            boolean bl = enabled = !branch.isDisabled() && spanningTreeEdge;
            if (!hasV1 || !hasV2) {
                PiModel piModel = branch.getPiModel();
                double rho = 1.0 / piModel.getR1();
                EquationTerm vTerm = equationSystem.getVariable(bus1.getNum(), AcVariableType.BUS_V).createTerm();
                EquationTerm bus2vTerm = equationSystem.getVariable(bus2.getNum(), AcVariableType.BUS_V).createTerm();
                equationSystem.createEquation(branch, AcEquationType.ZERO_V).addTerm(vTerm).addTerm(bus2vTerm.multiply(-rho)).setActive(enabled);
                Variable<AcVariableType> dummyQ = equationSystem.getVariable(branch.getNum(), AcVariableType.DUMMY_Q);
                equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().addTerm(dummyQ.createTerm());
                equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().addTerm(dummyQ.createTerm().minus());
                equationSystem.createEquation(branch, AcEquationType.DUMMY_TARGET_Q).addTerm(dummyQ.createTerm()).setActive(!enabled);
            }
            boolean hasPhi1 = equationSystem.hasEquation(bus1.getNum(), AcEquationType.BUS_TARGET_PHI);
            boolean hasPhi2 = equationSystem.hasEquation(bus2.getNum(), AcEquationType.BUS_TARGET_PHI);
            if (!hasPhi1 || !hasPhi2) {
                equationSystem.createEquation(branch, AcEquationType.ZERO_PHI).addTerm(equationSystem.getVariable(bus1.getNum(), AcVariableType.BUS_PHI).createTerm()).addTerm(equationSystem.getVariable(bus2.getNum(), AcVariableType.BUS_PHI).createTerm().minus()).setActive(enabled);
                Variable<AcVariableType> dummyP = equationSystem.getVariable(branch.getNum(), AcVariableType.DUMMY_P);
                equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(dummyP.createTerm());
                equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(dummyP.createTerm().minus());
                equationSystem.createEquation(branch, AcEquationType.DUMMY_TARGET_P).addTerm(dummyP.createTerm()).setActive(!enabled);
            } else {
                throw new IllegalStateException("Cannot happen because only there is one slack bus per model");
            }
        }
    }

    protected static void createTransformerPhaseControlEquations(LfBranch branch, LfBus bus1, LfBus bus2, EquationSystem<AcVariableType, AcEquationType> equationSystem, boolean deriveA1, boolean deriveR1) {
        TransformerPhaseControl phaseControl;
        if (deriveA1) {
            EquationTerm a1 = equationSystem.getVariable(branch.getNum(), AcVariableType.BRANCH_ALPHA1).createTerm();
            branch.setA1(a1);
            equationSystem.createEquation(branch, AcEquationType.BRANCH_TARGET_ALPHA1).addTerm(a1);
        }
        if (branch.isPhaseControlled() && (phaseControl = branch.getPhaseControl().orElseThrow()).getMode() == TransformerPhaseControl.Mode.CONTROLLER) {
            if (phaseControl.getUnit() == TransformerPhaseControl.Unit.A) {
                throw new PowsyblException("Phase control in A is not yet supported");
            }
            AbstractClosedBranchAcFlowEquationTerm p = phaseControl.getControlledSide() == TwoSides.ONE ? new ClosedBranchSide1ActiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1) : new ClosedBranchSide2ActiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
            equationSystem.createEquation(branch, AcEquationType.BRANCH_TARGET_P).addTerm(p).setActive(false);
        }
    }

    protected static void createTransformerReactivePowerControlEquations(LfBranch branch, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        if (branch.isTransformerReactivePowerController()) {
            EquationTerm r1 = equationSystem.getVariable(branch.getNum(), AcVariableType.BRANCH_RHO1).createTerm();
            equationSystem.createEquation(branch, AcEquationType.BRANCH_TARGET_RHO1).addTerm(r1);
        }
    }

    public static void updateTransformerPhaseControlEquations(TransformerPhaseControl phaseControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        LfBranch controllerBranch = phaseControl.getControllerBranch();
        LfBranch controlledBranch = phaseControl.getControlledBranch();
        if (phaseControl.getMode() == TransformerPhaseControl.Mode.CONTROLLER) {
            boolean controlEnabled = !controllerBranch.isDisabled() && !controlledBranch.isDisabled() && controllerBranch.isPhaseControlEnabled();
            equationSystem.getEquation(controlledBranch.getNum(), AcEquationType.BRANCH_TARGET_P).orElseThrow().setActive(controlEnabled);
            equationSystem.getEquation(controllerBranch.getNum(), AcEquationType.BRANCH_TARGET_ALPHA1).orElseThrow().setActive(!controlEnabled && !controllerBranch.isDisabled());
        } else {
            equationSystem.getEquation(controllerBranch.getNum(), AcEquationType.BRANCH_TARGET_ALPHA1).orElseThrow().setActive(!controllerBranch.isDisabled());
        }
    }

    private static void createTransformerVoltageControlEquations(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        bus.getTransformerVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> {
            AcEquationSystemCreator.createR1DistributionEquations(voltageControl, equationSystem);
            for (LfBranch controllerBranch : voltageControl.getMergedControllerElements()) {
                equationSystem.createEquation(controllerBranch, AcEquationType.BRANCH_TARGET_RHO1).addTerm(equationSystem.getVariable(controllerBranch.getNum(), AcVariableType.BRANCH_RHO1).createTerm());
            }
            AcEquationSystemCreator.updateTransformerVoltageControlEquations(voltageControl, equationSystem);
        });
    }

    public static void createR1DistributionEquations(TransformerVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        List controllerBranches = voltageControl.getMergedControllerElements();
        for (int i = 0; i < controllerBranches.size(); ++i) {
            LfBranch controllerBranch = (LfBranch)controllerBranches.get(i);
            EquationTerm r1 = equationSystem.getVariable(controllerBranch.getNum(), AcVariableType.BRANCH_RHO1).createTerm();
            Equation<AcVariableType, AcEquationType> zero = equationSystem.createEquation(controllerBranch, AcEquationType.DISTR_RHO).addTerm(r1.multiply(() -> 1.0 / (double)controllerBranches.stream().filter(b -> !b.isDisabled()).count() - 1.0));
            for (LfBranch otherControllerBranch : controllerBranches) {
                if (otherControllerBranch == controllerBranch) continue;
                EquationTerm otherR1 = equationSystem.getVariable(otherControllerBranch.getNum(), AcVariableType.BRANCH_RHO1).createTerm();
                zero.addTerm(otherR1.multiply(() -> 1.0 / (double)controllerBranches.stream().filter(b -> !b.isDisabled()).count()));
            }
        }
    }

    static void updateTransformerVoltageControlEquations(TransformerVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        AcEquationSystemCreator.updateRemoteVoltageControlEquations(voltageControl, equationSystem, AcEquationType.DISTR_RHO, AcEquationType.BRANCH_TARGET_RHO1);
    }

    public static void recreateR1DistributionEquations(LfNetwork network, TransformerVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        for (LfBranch controllerBranch : voltageControl.getMergedControllerElements()) {
            AcEquationSystemCreator.removeEquationAndCleanElement(network, equationSystem, controllerBranch.getNum(), AcEquationType.DISTR_RHO);
        }
        AcEquationSystemCreator.createR1DistributionEquations(voltageControl, equationSystem);
        AcEquationSystemCreator.updateTransformerVoltageControlEquations(voltageControl, equationSystem);
    }

    private static void createShuntVoltageControlEquations(LfBus bus, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        bus.getShuntVoltageControl().filter(voltageControl -> voltageControl.getMergeStatus() == VoltageControl.MergeStatus.MAIN).ifPresent(voltageControl -> {
            AcEquationSystemCreator.createShuntSusceptanceDistributionEquations(voltageControl, equationSystem);
            for (LfShunt controllerShunt : voltageControl.getMergedControllerElements()) {
                equationSystem.createEquation(controllerShunt, AcEquationType.SHUNT_TARGET_B).addTerm(equationSystem.getVariable(controllerShunt.getNum(), AcVariableType.SHUNT_B).createTerm());
            }
            AcEquationSystemCreator.updateShuntVoltageControlEquations(voltageControl, equationSystem);
        });
    }

    public static void createShuntSusceptanceDistributionEquations(ShuntVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        List controllerShunts = voltageControl.getMergedControllerElements();
        for (LfShunt controllerShunt : controllerShunts) {
            EquationTerm shuntB = equationSystem.getVariable(controllerShunt.getNum(), AcVariableType.SHUNT_B).createTerm();
            Equation<AcVariableType, AcEquationType> zero = equationSystem.createEquation(controllerShunt, AcEquationType.DISTR_SHUNT_B).addTerm(shuntB.multiply(() -> 1.0 / (double)controllerShunts.stream().filter(b -> !b.isDisabled()).count() - 1.0));
            for (LfShunt otherControllerShunt : controllerShunts) {
                if (otherControllerShunt == controllerShunt) continue;
                EquationTerm otherShuntB = equationSystem.getVariable(otherControllerShunt.getNum(), AcVariableType.SHUNT_B).createTerm();
                zero.addTerm(otherShuntB.multiply(() -> 1.0 / (double)controllerShunts.stream().filter(b -> !b.isDisabled()).count()));
            }
        }
    }

    static void updateShuntVoltageControlEquations(ShuntVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        AcEquationSystemCreator.updateRemoteVoltageControlEquations(voltageControl, equationSystem, AcEquationType.DISTR_SHUNT_B, AcEquationType.SHUNT_TARGET_B);
    }

    public static void recreateShuntSusceptanceDistributionEquations(LfNetwork network, ShuntVoltageControl voltageControl, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        for (LfShunt controllerShunt : voltageControl.getMergedControllerElements()) {
            AcEquationSystemCreator.removeEquationAndCleanElement(network, equationSystem, controllerShunt.getNum(), AcEquationType.DISTR_SHUNT_B);
        }
        AcEquationSystemCreator.createShuntSusceptanceDistributionEquations(voltageControl, equationSystem);
        AcEquationSystemCreator.updateShuntVoltageControlEquations(voltageControl, equationSystem);
    }

    protected static boolean isDeriveA1(LfBranch branch, AcEquationSystemCreationParameters creationParameters) {
        return branch.isPhaseController() || creationParameters.isForceA1Var() && branch.hasPhaseControllerCapability() && branch.isConnectedAtBothSides();
    }

    protected static boolean isDeriveR1(LfBranch branch) {
        return branch.isVoltageController() || branch.isTransformerReactivePowerController();
    }

    protected void createImpedantBranch(LfBranch branch, LfBus bus1, LfBus bus2, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        Evaluable p1 = null;
        Evaluable q1 = null;
        Evaluable p2 = null;
        Evaluable q2 = null;
        Evaluable i1 = null;
        Evaluable i2 = null;
        ClosedBranchSide1ActiveFlowEquationTerm closedP1 = null;
        ClosedBranchSide1ReactiveFlowEquationTerm closedQ1 = null;
        ClosedBranchSide1CurrentMagnitudeEquationTerm closedI1 = null;
        ClosedBranchSide2ActiveFlowEquationTerm closedP2 = null;
        ClosedBranchSide2ReactiveFlowEquationTerm closedQ2 = null;
        ClosedBranchSide2CurrentMagnitudeEquationTerm closedI2 = null;
        OpenBranchSide2ActiveFlowEquationTerm openP1 = null;
        OpenBranchSide2ReactiveFlowEquationTerm openQ1 = null;
        OpenBranchSide2CurrentMagnitudeEquationTerm openI1 = null;
        OpenBranchSide1ActiveFlowEquationTerm openP2 = null;
        OpenBranchSide1ReactiveFlowEquationTerm openQ2 = null;
        OpenBranchSide1CurrentMagnitudeEquationTerm openI2 = null;
        boolean deriveA1 = AcEquationSystemCreator.isDeriveA1(branch, this.creationParameters);
        boolean deriveR1 = AcEquationSystemCreator.isDeriveR1(branch);
        if (bus1 != null && bus2 != null) {
            closedP1 = new ClosedBranchSide1ActiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
            closedQ1 = new ClosedBranchSide1ReactiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
            closedP2 = new ClosedBranchSide2ActiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
            closedQ2 = new ClosedBranchSide2ReactiveFlowEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
            closedI1 = new ClosedBranchSide1CurrentMagnitudeEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
            closedI2 = new ClosedBranchSide2CurrentMagnitudeEquationTerm(branch, bus1, bus2, equationSystem.getVariableSet(), deriveA1, deriveR1);
            if (branch.isDisconnectionAllowedSide1()) {
                openP2 = new OpenBranchSide1ActiveFlowEquationTerm(branch, bus2, equationSystem.getVariableSet());
                openQ2 = new OpenBranchSide1ReactiveFlowEquationTerm(branch, bus2, equationSystem.getVariableSet());
                openI2 = new OpenBranchSide1CurrentMagnitudeEquationTerm(branch, bus2, equationSystem.getVariableSet());
            }
            if (branch.isDisconnectionAllowedSide2()) {
                openP1 = new OpenBranchSide2ActiveFlowEquationTerm(branch, bus1, equationSystem.getVariableSet());
                openQ1 = new OpenBranchSide2ReactiveFlowEquationTerm(branch, bus1, equationSystem.getVariableSet());
                openI1 = new OpenBranchSide2CurrentMagnitudeEquationTerm(branch, bus1, equationSystem.getVariableSet(), deriveR1);
            }
            p1 = closedP1;
            q1 = closedQ1;
            i1 = closedI1;
            p2 = closedP2;
            q2 = closedQ2;
            i2 = closedI2;
        } else if (bus1 != null) {
            openP1 = new OpenBranchSide2ActiveFlowEquationTerm(branch, bus1, equationSystem.getVariableSet());
            openQ1 = new OpenBranchSide2ReactiveFlowEquationTerm(branch, bus1, equationSystem.getVariableSet());
            openI1 = new OpenBranchSide2CurrentMagnitudeEquationTerm(branch, bus1, equationSystem.getVariableSet(), deriveR1);
            p1 = openP1;
            q1 = openQ1;
            i1 = openI1;
            p2 = EvaluableConstants.ZERO;
            q2 = EvaluableConstants.ZERO;
            i2 = EvaluableConstants.ZERO;
        } else if (bus2 != null) {
            openP2 = new OpenBranchSide1ActiveFlowEquationTerm(branch, bus2, equationSystem.getVariableSet());
            openQ2 = new OpenBranchSide1ReactiveFlowEquationTerm(branch, bus2, equationSystem.getVariableSet());
            openI2 = new OpenBranchSide1CurrentMagnitudeEquationTerm(branch, bus2, equationSystem.getVariableSet());
            p1 = EvaluableConstants.ZERO;
            q1 = EvaluableConstants.ZERO;
            i1 = EvaluableConstants.ZERO;
            p2 = openP2;
            q2 = openQ2;
            i2 = openI2;
        }
        AcEquationSystemCreator.createImpedantBranchEquations(branch, bus1, bus2, equationSystem, p1, q1, i1, p2, q2, i2, closedP1, closedQ1, closedI1, closedP2, closedQ2, closedI2, openP1, openQ1, openI1, openP2, openQ2, openI2);
        this.createGeneratorReactivePowerControlBranchEquation(branch, bus1, bus2, equationSystem, deriveA1, deriveR1);
        AcEquationSystemCreator.createTransformerPhaseControlEquations(branch, bus1, bus2, equationSystem, deriveA1, deriveR1);
        AcEquationSystemCreator.updateBranchEquations(branch);
        AcEquationSystemCreator.createTransformerReactivePowerControlEquations(branch, equationSystem);
    }

    protected static void createImpedantBranchEquations(LfBranch branch, LfBus bus1, LfBus bus2, EquationSystem<AcVariableType, AcEquationType> equationSystem, Evaluable p1, Evaluable q1, Evaluable i1, Evaluable p2, Evaluable q2, Evaluable i2, EquationTerm<AcVariableType, AcEquationType> closedP1, EquationTerm<AcVariableType, AcEquationType> closedQ1, EquationTerm<AcVariableType, AcEquationType> closedI1, EquationTerm<AcVariableType, AcEquationType> closedP2, EquationTerm<AcVariableType, AcEquationType> closedQ2, EquationTerm<AcVariableType, AcEquationType> closedI2, EquationTerm<AcVariableType, AcEquationType> openP1, EquationTerm<AcVariableType, AcEquationType> openQ1, EquationTerm<AcVariableType, AcEquationType> openI1, EquationTerm<AcVariableType, AcEquationType> openP2, EquationTerm<AcVariableType, AcEquationType> openQ2, EquationTerm<AcVariableType, AcEquationType> openI2) {
        if (closedP1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(closedP1);
            branch.setClosedP1(closedP1);
        }
        if (openP1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(openP1);
            branch.setOpenP1(openP1);
        }
        if (p1 != null) {
            branch.setP1(p1);
        }
        if (closedQ1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().addTerm(closedQ1);
            branch.setClosedQ1(closedQ1);
        }
        if (openQ1 != null) {
            equationSystem.getEquation(bus1.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().addTerm(openQ1);
            branch.setOpenQ1(openQ1);
        }
        if (q1 != null) {
            branch.setQ1(q1);
        }
        if (closedP2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(closedP2);
            branch.setClosedP2(closedP2);
        }
        if (openP2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(openP2);
            branch.setOpenP2(openP2);
        }
        if (p2 != null) {
            branch.setP2(p2);
        }
        if (closedQ2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().addTerm(closedQ2);
            branch.setClosedQ2(closedQ2);
        }
        if (openQ2 != null) {
            equationSystem.getEquation(bus2.getNum(), AcEquationType.BUS_TARGET_Q).orElseThrow().addTerm(openQ2);
            branch.setOpenQ2(openQ2);
        }
        if (q2 != null) {
            branch.setQ2(q2);
        }
        if (closedI1 != null) {
            equationSystem.attach(closedI1);
            branch.setClosedI1(closedI1);
        }
        if (openI1 != null) {
            equationSystem.attach(openI1);
            branch.setOpenI1(openI1);
        }
        if (i1 != null) {
            branch.setI1(i1);
        }
        if (closedI2 != null) {
            equationSystem.attach(closedI2);
            branch.setClosedI2(closedI2);
        }
        if (openI2 != null) {
            equationSystem.attach(openI2);
            branch.setOpenI2(openI2);
        }
        if (i2 != null) {
            branch.setI2(i2);
        }
    }

    static void updateBranchEquations(LfBranch branch) {
        if (!branch.isDisabled() && !branch.isZeroImpedance(LoadFlowModel.AC)) {
            if (branch.isConnectedSide1() && branch.isConnectedSide2()) {
                EquationTerm.setActive(branch.getOpenP1(), false);
                EquationTerm.setActive(branch.getOpenQ1(), false);
                EquationTerm.setActive(branch.getClosedP1(), true);
                EquationTerm.setActive(branch.getClosedQ1(), true);
                EquationTerm.setActive(branch.getOpenP2(), false);
                EquationTerm.setActive(branch.getOpenQ2(), false);
                EquationTerm.setActive(branch.getClosedP2(), true);
                EquationTerm.setActive(branch.getClosedQ2(), true);
                branch.getAdditionalOpenP1().forEach(openP1 -> EquationTerm.setActive(openP1, false));
                branch.getAdditionalOpenQ1().forEach(openQ1 -> EquationTerm.setActive(openQ1, false));
                branch.getAdditionalClosedP1().forEach(closedP1 -> EquationTerm.setActive(closedP1, true));
                branch.getAdditionalClosedQ1().forEach(closedQ1 -> EquationTerm.setActive(closedQ1, true));
                branch.getAdditionalOpenP2().forEach(openP2 -> EquationTerm.setActive(openP2, false));
                branch.getAdditionalOpenQ2().forEach(openQ2 -> EquationTerm.setActive(openQ2, false));
                branch.getAdditionalClosedP2().forEach(closedP2 -> EquationTerm.setActive(closedP2, true));
                branch.getAdditionalClosedQ2().forEach(closedQ2 -> EquationTerm.setActive(closedQ2, true));
            } else if (branch.isConnectedSide1() && !branch.isConnectedSide2()) {
                EquationTerm.setActive(branch.getOpenP1(), true);
                EquationTerm.setActive(branch.getOpenQ1(), true);
                EquationTerm.setActive(branch.getClosedP1(), false);
                EquationTerm.setActive(branch.getClosedQ1(), false);
                EquationTerm.setActive(branch.getOpenP2(), false);
                EquationTerm.setActive(branch.getOpenQ2(), false);
                EquationTerm.setActive(branch.getClosedP2(), false);
                EquationTerm.setActive(branch.getClosedQ2(), false);
                branch.getAdditionalOpenP1().forEach(openP1 -> EquationTerm.setActive(openP1, true));
                branch.getAdditionalOpenQ1().forEach(openQ1 -> EquationTerm.setActive(openQ1, true));
                branch.getAdditionalClosedP1().forEach(closedP1 -> EquationTerm.setActive(closedP1, false));
                branch.getAdditionalClosedQ1().forEach(closedQ1 -> EquationTerm.setActive(closedQ1, false));
                branch.getAdditionalOpenP2().forEach(openP2 -> EquationTerm.setActive(openP2, false));
                branch.getAdditionalOpenQ2().forEach(openQ2 -> EquationTerm.setActive(openQ2, false));
                branch.getAdditionalClosedP2().forEach(closedP2 -> EquationTerm.setActive(closedP2, false));
                branch.getAdditionalClosedQ2().forEach(closedQ2 -> EquationTerm.setActive(closedQ2, false));
            } else if (!branch.isConnectedSide1() && branch.isConnectedSide2()) {
                EquationTerm.setActive(branch.getOpenP2(), true);
                EquationTerm.setActive(branch.getOpenQ2(), true);
                EquationTerm.setActive(branch.getClosedP2(), false);
                EquationTerm.setActive(branch.getClosedQ2(), false);
                EquationTerm.setActive(branch.getOpenP1(), false);
                EquationTerm.setActive(branch.getOpenQ1(), false);
                EquationTerm.setActive(branch.getClosedP1(), false);
                EquationTerm.setActive(branch.getClosedQ1(), false);
                branch.getAdditionalOpenP1().forEach(openP1 -> EquationTerm.setActive(openP1, false));
                branch.getAdditionalOpenQ1().forEach(openQ1 -> EquationTerm.setActive(openQ1, false));
                branch.getAdditionalClosedP1().forEach(closedP1 -> EquationTerm.setActive(closedP1, false));
                branch.getAdditionalClosedQ1().forEach(closedQ1 -> EquationTerm.setActive(closedQ1, false));
                branch.getAdditionalOpenP2().forEach(openP2 -> EquationTerm.setActive(openP2, true));
                branch.getAdditionalOpenQ2().forEach(openQ2 -> EquationTerm.setActive(openQ2, true));
                branch.getAdditionalClosedP2().forEach(closedP2 -> EquationTerm.setActive(closedP2, false));
                branch.getAdditionalClosedQ2().forEach(closedQ2 -> EquationTerm.setActive(closedQ2, false));
            } else {
                EquationTerm.setActive(branch.getOpenP1(), false);
                EquationTerm.setActive(branch.getOpenQ1(), false);
                EquationTerm.setActive(branch.getClosedP1(), false);
                EquationTerm.setActive(branch.getClosedQ1(), false);
                EquationTerm.setActive(branch.getOpenP2(), false);
                EquationTerm.setActive(branch.getOpenQ2(), false);
                EquationTerm.setActive(branch.getClosedP2(), false);
                EquationTerm.setActive(branch.getClosedQ2(), false);
                branch.getAdditionalOpenP1().forEach(openP1 -> EquationTerm.setActive(openP1, false));
                branch.getAdditionalOpenQ1().forEach(openQ1 -> EquationTerm.setActive(openQ1, false));
                branch.getAdditionalClosedP1().forEach(closedP1 -> EquationTerm.setActive(closedP1, false));
                branch.getAdditionalClosedQ1().forEach(closedQ1 -> EquationTerm.setActive(closedQ1, false));
                branch.getAdditionalOpenP2().forEach(openP2 -> EquationTerm.setActive(openP2, false));
                branch.getAdditionalOpenQ2().forEach(openQ2 -> EquationTerm.setActive(openQ2, false));
                branch.getAdditionalClosedP2().forEach(closedP2 -> EquationTerm.setActive(closedP2, false));
                branch.getAdditionalClosedQ2().forEach(closedQ2 -> EquationTerm.setActive(closedQ2, false));
            }
        }
    }

    private static void createHvdcAcEmulationEquations(LfHvdc hvdc, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        HvdcAcEmulationSide1ActiveFlowEquationTerm p1 = null;
        HvdcAcEmulationSide2ActiveFlowEquationTerm p2 = null;
        if (hvdc.getBus1() != null && hvdc.getBus2() != null && hvdc.isAcEmulation()) {
            p1 = new HvdcAcEmulationSide1ActiveFlowEquationTerm(hvdc, hvdc.getBus1(), hvdc.getBus2(), equationSystem.getVariableSet());
            p2 = new HvdcAcEmulationSide2ActiveFlowEquationTerm(hvdc, hvdc.getBus1(), hvdc.getBus2(), equationSystem.getVariableSet());
        }
        if (p1 != null) {
            equationSystem.getEquation(hvdc.getBus1().getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(p1);
            hvdc.setP1(p1);
        }
        if (p2 != null) {
            equationSystem.getEquation(hvdc.getBus2().getNum(), AcEquationType.BUS_TARGET_P).orElseThrow().addTerm(p2);
            hvdc.setP2(p2);
        }
    }

    private void createImpedantBranchEquations(LfBranch branch, EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        branch.getAdditionalOpenP1().clear();
        branch.getAdditionalOpenQ1().clear();
        branch.getAdditionalClosedP1().clear();
        branch.getAdditionalClosedQ1().clear();
        branch.getAdditionalOpenP2().clear();
        branch.getAdditionalOpenQ2().clear();
        branch.getAdditionalClosedP2().clear();
        branch.getAdditionalClosedQ2().clear();
        if (branch.isZeroImpedance(LoadFlowModel.AC)) {
            AcEquationSystemCreator.createNonImpedantBranch(branch, branch.getBus1(), branch.getBus2(), equationSystem, branch.isSpanningTreeEdge(LoadFlowModel.AC));
        } else {
            this.createImpedantBranch(branch, branch.getBus1(), branch.getBus2(), equationSystem);
        }
    }

    private void createBranchesEquations(EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        for (LfBranch branch : this.network.getBranches()) {
            this.createImpedantBranchEquations(branch, equationSystem);
        }
    }

    private List<EquationTerm<AcVariableType, AcEquationType>> createActiveInjectionTerms(LfBus bus, VariableSet<AcVariableType> variableSet) {
        ArrayList<EquationTerm<AcVariableType, AcEquationType>> terms = new ArrayList<EquationTerm<AcVariableType, AcEquationType>>();
        for (LfBranch branch : bus.getBranches()) {
            AbstractBranchAcFlowEquationTerm p;
            if (branch.isZeroImpedance(LoadFlowModel.AC)) {
                if (!branch.isSpanningTreeEdge(LoadFlowModel.AC)) continue;
                EquationTerm p2 = variableSet.getVariable(branch.getNum(), AcVariableType.DUMMY_P).createTerm();
                if (branch.getBus2() == bus) {
                    p2 = p2.minus();
                }
                terms.add(p2);
                continue;
            }
            boolean deriveA1 = AcEquationSystemCreator.isDeriveA1(branch, this.creationParameters);
            boolean deriveR1 = AcEquationSystemCreator.isDeriveR1(branch);
            AbstractBranchAcFlowEquationTerm openP = null;
            if (branch.getBus1() == bus) {
                otherSideBus = branch.getBus2();
                if (otherSideBus != null) {
                    p = new ClosedBranchSide1ActiveFlowEquationTerm(branch, bus, otherSideBus, variableSet, deriveA1, deriveR1);
                    branch.addAdditionalClosedP1(p);
                    if (branch.isDisconnectionAllowedSide2()) {
                        openP = new OpenBranchSide2ActiveFlowEquationTerm(branch, bus, variableSet);
                        branch.addAdditionalOpenP1(openP);
                    }
                } else {
                    p = new OpenBranchSide2ActiveFlowEquationTerm(branch, bus, variableSet);
                    branch.addAdditionalOpenP1(p);
                }
            } else {
                otherSideBus = branch.getBus1();
                if (otherSideBus != null) {
                    p = new ClosedBranchSide2ActiveFlowEquationTerm(branch, otherSideBus, bus, variableSet, deriveA1, deriveR1);
                    branch.addAdditionalClosedP2(p);
                    if (branch.isDisconnectionAllowedSide1()) {
                        openP = new OpenBranchSide1ActiveFlowEquationTerm(branch, bus, variableSet);
                        branch.addAdditionalOpenP2(openP);
                    }
                } else {
                    p = new OpenBranchSide1ActiveFlowEquationTerm(branch, bus, variableSet);
                    branch.addAdditionalOpenP2(p);
                }
            }
            terms.add(p);
            if (openP == null) continue;
            terms.add(openP);
        }
        return terms;
    }

    private void createMultipleSlackBusesEquations(EquationSystem<AcVariableType, AcEquationType> equationSystem) {
        List<LfBus> slackBuses = this.network.getSlackBuses();
        if (slackBuses.size() > 1) {
            LfBus firstSlackBus = slackBuses.get(0);
            for (int i = 1; i < slackBuses.size(); ++i) {
                LfBus slackBus = slackBuses.get(i);
                equationSystem.createEquation(slackBus, AcEquationType.BUS_DISTR_SLACK_P).addTerms(this.createActiveInjectionTerms(firstSlackBus, equationSystem.getVariableSet()).stream().map(EquationTerm::minus).toList()).addTerms(this.createActiveInjectionTerms(slackBus, equationSystem.getVariableSet()));
                for (LfBranch branch : slackBus.getBranches()) {
                    AcEquationSystemCreator.updateBranchEquations(branch);
                }
            }
        }
    }

    public EquationSystem<AcVariableType, AcEquationType> create() {
        EquationSystem<AcVariableType, AcEquationType> equationSystem = new EquationSystem<AcVariableType, AcEquationType>();
        this.createBusesEquations(equationSystem);
        this.createMultipleSlackBusesEquations(equationSystem);
        this.createBranchesEquations(equationSystem);
        for (LfHvdc hvdc : this.network.getHvdcs()) {
            AcEquationSystemCreator.createHvdcAcEmulationEquations(hvdc, equationSystem);
        }
        this.createVoltageControlEquations(equationSystem);
        EquationSystemPostProcessor.findAll().forEach(pp -> pp.onCreate(equationSystem));
        this.network.addListener(LfNetworkListenerTracer.trace(new AcEquationSystemUpdater(equationSystem, this.creationParameters)));
        return equationSystem;
    }
}

