/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchSide1CurrentMagnitudeEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchSide1CurrentMagnitudeEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
    }

    public static double calculateSensi(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2, double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        if (dr1 != 0.0) {
            throw new IllegalArgumentException("Derivative with respect to r1 not implemented");
        }
        return ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dph1(y, ksi, g1, b1, v1, ph1, r1, a1, v2, ph2) * dph1 + ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dph2(y, ksi, g1, b1, v1, ph1, r1, a1, v2, ph2) * dph2 + ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dv1(y, ksi, g1, b1, v1, ph1, r1, a1, v2, ph2) * dv1 + ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dv2(y, ksi, g1, b1, v1, ph1, r1, a1, v2, ph2) * dv2 + ClosedBranchSide1CurrentMagnitudeEquationTerm.di1da1(y, ksi, g1, b1, v1, ph1, r1, a1, v2, ph2) * da1;
    }

    @Override
    protected double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return ClosedBranchSide1CurrentMagnitudeEquationTerm.calculateSensi(this.y, this.ksi, this.g1, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2(), dph1, dph2, dv1, dv2, da1, dr1);
    }

    private static double theta(double ksi, double a1, double ph2) {
        return ksi - a1 + 0.0 + ph2;
    }

    private static double interReI1(double y, double ksi, double g1, double b1, double ph1) {
        return g1 * FastMath.cos((double)ph1) - b1 * FastMath.sin((double)ph1) + y * FastMath.sin((double)(ph1 + ksi));
    }

    private static double interImI1(double y, double ksi, double g1, double b1, double ph1) {
        return g1 * FastMath.sin((double)ph1) + b1 * FastMath.cos((double)ph1) - y * FastMath.cos((double)(ph1 + ksi));
    }

    private static double reI1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double v2, double theta) {
        return r1 * (r1 * v1 * ClosedBranchSide1CurrentMagnitudeEquationTerm.interReI1(y, ksi, g1, b1, ph1) - y * 1.0 * v2 * FastMath.sin((double)theta));
    }

    private static double imI1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double v2, double theta) {
        return r1 * (r1 * v1 * ClosedBranchSide1CurrentMagnitudeEquationTerm.interImI1(y, ksi, g1, b1, ph1) + y * 1.0 * v2 * FastMath.cos((double)theta));
    }

    private static double i1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double v2, double theta) {
        return FastMath.hypot((double)ClosedBranchSide1CurrentMagnitudeEquationTerm.reI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta), (double)ClosedBranchSide1CurrentMagnitudeEquationTerm.imI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta));
    }

    public static double i1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2);
        return ClosedBranchSide1CurrentMagnitudeEquationTerm.i1(y, ksi, g1, b1, v1, ph1, r1, v2, theta);
    }

    private static double dreI1dv1(double y, double ksi, double g1, double b1, double ph1, double r1) {
        return r1 * r1 * ClosedBranchSide1CurrentMagnitudeEquationTerm.interReI1(y, ksi, g1, b1, ph1);
    }

    private static double dreI1dv2(double y, double ksi, double r1, double a1, double ph2) {
        return r1 * (-y * 1.0 * FastMath.sin((double)ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2)));
    }

    private static double dreI1dph1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1) {
        return r1 * r1 * v1 * (-g1 * FastMath.sin((double)ph1) - b1 * FastMath.cos((double)ph1) + y * FastMath.cos((double)(ph1 + ksi)));
    }

    private static double dreI1dph2(double y, double ksi, double r1, double a1, double v2, double ph2) {
        return r1 * (-y * 1.0 * v2 * FastMath.cos((double)ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2)));
    }

    private static double dimI1dv1(double y, double ksi, double g1, double b1, double ph1, double r1) {
        return r1 * r1 * ClosedBranchSide1CurrentMagnitudeEquationTerm.interImI1(y, ksi, g1, b1, ph1);
    }

    private static double dimI1dv2(double y, double ksi, double r1, double a1, double ph2) {
        return r1 * (y * 1.0 * FastMath.cos((double)ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2)));
    }

    private static double dimI1dph1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1) {
        return r1 * r1 * v1 * ClosedBranchSide1CurrentMagnitudeEquationTerm.interReI1(y, ksi, g1, b1, ph1);
    }

    private static double dimI1dph2(double y, double ksi, double r1, double a1, double v2, double ph2) {
        return r1 * (-y * 1.0 * v2 * FastMath.sin((double)ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2)));
    }

    public static double di1dv1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2);
        return (ClosedBranchSide1CurrentMagnitudeEquationTerm.reI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dreI1dv1(y, ksi, g1, b1, ph1, r1) + ClosedBranchSide1CurrentMagnitudeEquationTerm.imI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dimI1dv1(y, ksi, g1, b1, ph1, r1)) / ClosedBranchSide1CurrentMagnitudeEquationTerm.i1(y, ksi, g1, b1, v1, ph1, r1, v2, theta);
    }

    public static double di1dv2(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2);
        return (ClosedBranchSide1CurrentMagnitudeEquationTerm.reI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dreI1dv2(y, ksi, r1, a1, ph2) + ClosedBranchSide1CurrentMagnitudeEquationTerm.imI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dimI1dv2(y, ksi, r1, a1, ph2)) / ClosedBranchSide1CurrentMagnitudeEquationTerm.i1(y, ksi, g1, b1, v1, ph1, r1, v2, theta);
    }

    public static double di1dph1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2);
        return (ClosedBranchSide1CurrentMagnitudeEquationTerm.reI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dreI1dph1(y, ksi, g1, b1, v1, ph1, r1) + ClosedBranchSide1CurrentMagnitudeEquationTerm.imI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dimI1dph1(y, ksi, g1, b1, v1, ph1, r1)) / ClosedBranchSide1CurrentMagnitudeEquationTerm.i1(y, ksi, g1, b1, v1, ph1, r1, v2, theta);
    }

    public static double di1dph2(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide1CurrentMagnitudeEquationTerm.theta(ksi, a1, ph2);
        return (ClosedBranchSide1CurrentMagnitudeEquationTerm.reI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dreI1dph2(y, ksi, r1, a1, v2, ph2) + ClosedBranchSide1CurrentMagnitudeEquationTerm.imI1(y, ksi, g1, b1, v1, ph1, r1, v2, theta) * ClosedBranchSide1CurrentMagnitudeEquationTerm.dimI1dph2(y, ksi, r1, a1, v2, ph2)) / ClosedBranchSide1CurrentMagnitudeEquationTerm.i1(y, ksi, g1, b1, v1, ph1, r1, v2, theta);
    }

    public static double di1da1(double y, double ksi, double g1, double b1, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        return -ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dph2(y, ksi, g1, b1, v1, ph1, r1, a1, v2, ph2);
    }

    @Override
    public double eval() {
        return ClosedBranchSide1CurrentMagnitudeEquationTerm.i1(this.y, this.ksi, this.g1, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var)) {
            return ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dv1(this.y, this.ksi, this.g1, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dv2(this.y, this.ksi, this.g1, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dph1(this.y, this.ksi, this.g1, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchSide1CurrentMagnitudeEquationTerm.di1dph2(this.y, this.ksi, this.g1, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.a1Var)) {
            return ClosedBranchSide1CurrentMagnitudeEquationTerm.di1da1(this.y, this.ksi, this.g1, this.b1, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.r1Var)) {
            throw new IllegalArgumentException("Derivative with respect to r1 not implemented");
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_i_closed_1";
    }
}

