/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchSide2CurrentMagnitudeEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchSide2CurrentMagnitudeEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
    }

    public static double calculateSensi(double y, double ksi, double g2, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2, double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        if (dr1 != 0.0) {
            throw new IllegalArgumentException("Derivative with respect to r1 not implemented");
        }
        return ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dph1(y, ksi, g2, b2, v1, ph1, r1, a1, v2, ph2) * dph1 + ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dph2(y, ksi, g2, b2, v1, ph1, r1, a1, v2, ph2) * dph2 + ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dv1(y, ksi, g2, b2, v1, ph1, r1, a1, v2, ph2) * dv1 + ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dv2(y, ksi, g2, b2, v1, ph1, r1, a1, v2, ph2) * dv2 + ClosedBranchSide2CurrentMagnitudeEquationTerm.di2da1(y, ksi, g2, b2, v1, ph1, r1, a1, v2, ph2) * da1;
    }

    @Override
    protected double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return ClosedBranchSide2CurrentMagnitudeEquationTerm.calculateSensi(this.y, this.ksi, this.g2, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2(), dph1, dph2, dv1, dv2, da1, dr1);
    }

    private static double theta(double ksi, double ph1, double a1) {
        return ksi + a1 - 0.0 + ph1;
    }

    private static double interReI2(double y, double ksi, double g2, double b2, double ph2) {
        return g2 * FastMath.cos((double)ph2) - b2 * FastMath.sin((double)ph2) + y * FastMath.sin((double)(ph2 + ksi));
    }

    private static double interImI2(double y, double ksi, double g2, double b2, double ph2) {
        return g2 * FastMath.sin((double)ph2) + b2 * FastMath.cos((double)ph2) - y * FastMath.cos((double)(ph2 + ksi));
    }

    private static double reI2(double y, double ksi, double g2, double b2, double v1, double r1, double v2, double ph2, double theta) {
        return 1.0 * (1.0 * v2 * ClosedBranchSide2CurrentMagnitudeEquationTerm.interReI2(y, ksi, g2, b2, ph2) - y * r1 * v1 * FastMath.sin((double)theta));
    }

    private static double imI2(double y, double ksi, double g2, double b2, double v1, double r1, double v2, double ph2, double theta) {
        return 1.0 * (1.0 * v2 * ClosedBranchSide2CurrentMagnitudeEquationTerm.interImI2(y, ksi, g2, b2, ph2) + y * r1 * v1 * FastMath.cos((double)theta));
    }

    private static double i2(double y, double ksi, double g2, double b2, double v1, double r1, double v2, double ph2, double theta) {
        return FastMath.hypot((double)ClosedBranchSide2CurrentMagnitudeEquationTerm.reI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta), (double)ClosedBranchSide2CurrentMagnitudeEquationTerm.imI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta));
    }

    public static double i2(double y, double ksi, double g2, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide2CurrentMagnitudeEquationTerm.theta(ksi, ph1, a1);
        return ClosedBranchSide2CurrentMagnitudeEquationTerm.i2(y, ksi, g2, b2, v1, r1, v2, ph2, theta);
    }

    private static double dreI2dv2(double y, double ksi, double g2, double b2, double ph2) {
        return 1.0 * ClosedBranchSide2CurrentMagnitudeEquationTerm.interReI2(y, ksi, g2, b2, ph2);
    }

    private static double dreI2dv1(double y, double r1, double theta) {
        return 1.0 * (-y * r1 * FastMath.sin((double)theta));
    }

    private static double dreI2dph2(double y, double ksi, double g2, double b2, double v2, double ph2) {
        return 1.0 * v2 * (-g2 * FastMath.sin((double)ph2) - b2 * FastMath.cos((double)ph2) + y * FastMath.cos((double)(ph2 + ksi)));
    }

    private static double dreI2dph1(double y, double ksi, double v1, double ph1, double r1, double a1) {
        return 1.0 * (-y * r1 * v1 * FastMath.cos((double)ClosedBranchSide2CurrentMagnitudeEquationTerm.theta(ksi, ph1, a1)));
    }

    private static double dimI2dv2(double y, double ksi, double g2, double b2, double ph2) {
        return 1.0 * ClosedBranchSide2CurrentMagnitudeEquationTerm.interImI2(y, ksi, g2, b2, ph2);
    }

    private static double dimI2dv1(double y, double ksi, double ph1, double r1, double a1) {
        return 1.0 * (y * r1 * FastMath.cos((double)ClosedBranchSide2CurrentMagnitudeEquationTerm.theta(ksi, ph1, a1)));
    }

    private static double dimI2dph2(double y, double ksi, double g2, double b2, double v2, double ph2) {
        return 1.0 * v2 * ClosedBranchSide2CurrentMagnitudeEquationTerm.interReI2(y, ksi, g2, b2, ph2);
    }

    private static double dimI2dph1(double y, double v1, double r1, double theta) {
        return 1.0 * (-y * r1 * v1 * FastMath.sin((double)theta));
    }

    public static double di2dv2(double y, double ksi, double g2, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide2CurrentMagnitudeEquationTerm.theta(ksi, ph1, a1);
        return (ClosedBranchSide2CurrentMagnitudeEquationTerm.reI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dreI2dv2(y, ksi, g2, b2, ph2) + ClosedBranchSide2CurrentMagnitudeEquationTerm.imI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dimI2dv2(y, ksi, g2, b2, ph2)) / ClosedBranchSide2CurrentMagnitudeEquationTerm.i2(y, ksi, g2, b2, v1, r1, v2, ph2, theta);
    }

    public static double di2dv1(double y, double ksi, double g2, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide2CurrentMagnitudeEquationTerm.theta(ksi, ph1, a1);
        return (ClosedBranchSide2CurrentMagnitudeEquationTerm.reI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dreI2dv1(y, r1, theta) + ClosedBranchSide2CurrentMagnitudeEquationTerm.imI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dimI2dv1(y, ksi, ph1, r1, a1)) / ClosedBranchSide2CurrentMagnitudeEquationTerm.i2(y, ksi, g2, b2, v1, r1, v2, ph2, theta);
    }

    public static double di2dph2(double y, double ksi, double g2, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide2CurrentMagnitudeEquationTerm.theta(ksi, ph1, a1);
        return (ClosedBranchSide2CurrentMagnitudeEquationTerm.reI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dreI2dph2(y, ksi, g2, b2, v2, ph2) + ClosedBranchSide2CurrentMagnitudeEquationTerm.imI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dimI2dph2(y, ksi, g2, b2, v2, ph2)) / ClosedBranchSide2CurrentMagnitudeEquationTerm.i2(y, ksi, g2, b2, v1, r1, v2, ph2, theta);
    }

    public static double di2dph1(double y, double ksi, double g2, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        double theta = ClosedBranchSide2CurrentMagnitudeEquationTerm.theta(ksi, ph1, a1);
        return (ClosedBranchSide2CurrentMagnitudeEquationTerm.reI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dreI2dph1(y, ksi, v1, ph1, r1, a1) + ClosedBranchSide2CurrentMagnitudeEquationTerm.imI2(y, ksi, g2, b2, v1, r1, v2, ph2, theta) * ClosedBranchSide2CurrentMagnitudeEquationTerm.dimI2dph1(y, v1, r1, theta)) / ClosedBranchSide2CurrentMagnitudeEquationTerm.i2(y, ksi, g2, b2, v1, r1, v2, ph2, theta);
    }

    public static double di2da1(double y, double ksi, double g2, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2) {
        return ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dph1(y, ksi, g2, b2, v1, ph1, r1, a1, v2, ph2);
    }

    @Override
    public double eval() {
        return ClosedBranchSide2CurrentMagnitudeEquationTerm.i2(this.y, this.ksi, this.g2, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var)) {
            return ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dv1(this.y, this.ksi, this.g2, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dv2(this.y, this.ksi, this.g2, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dph1(this.y, this.ksi, this.g2, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchSide2CurrentMagnitudeEquationTerm.di2dph2(this.y, this.ksi, this.g2, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.a1Var)) {
            return ClosedBranchSide2CurrentMagnitudeEquationTerm.di2da1(this.y, this.ksi, this.g2, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2());
        }
        if (variable.equals(this.r1Var)) {
            throw new IllegalArgumentException("Derivative with respect to r1 not implemented");
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_i_closed_2";
    }
}

