/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractClosedBranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Fortescue;
import java.util.Objects;
import net.jafama.FastMath;

public class ClosedBranchSide2ReactiveFlowEquationTerm
extends AbstractClosedBranchAcFlowEquationTerm {
    public ClosedBranchSide2ReactiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, Fortescue.SequenceType.POSITIVE);
    }

    public ClosedBranchSide2ReactiveFlowEquationTerm(LfBranch branch, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet, boolean deriveA1, boolean deriveR1, Fortescue.SequenceType sequenceType) {
        super(branch, bus1, bus2, variableSet, deriveA1, deriveR1, sequenceType);
    }

    public static double calculateSensi(double y, double ksi, double b2, double v1, double ph1, double r1, double a1, double v2, double ph2, double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        double theta = ClosedBranchSide2ReactiveFlowEquationTerm.theta2(ksi, ph1, a1, ph2);
        double cosTheta = FastMath.cos((double)theta);
        double sinTheta = FastMath.sin((double)theta);
        return ClosedBranchSide2ReactiveFlowEquationTerm.dq2dph1(y, v1, r1, v2, sinTheta) * dph1 + ClosedBranchSide2ReactiveFlowEquationTerm.dq2dph2(y, v1, r1, v2, sinTheta) * dph2 + ClosedBranchSide2ReactiveFlowEquationTerm.dq2dv1(y, r1, v2, cosTheta) * dv1 + ClosedBranchSide2ReactiveFlowEquationTerm.dq2dv2(y, FastMath.cos((double)ksi), b2, v1, r1, v2, cosTheta) * dv2 + ClosedBranchSide2ReactiveFlowEquationTerm.dq2da1(y, v1, r1, v2, sinTheta) * da1 + ClosedBranchSide2ReactiveFlowEquationTerm.dq2dr1(y, v1, v2, cosTheta) * dr1;
    }

    @Override
    protected double calculateSensi(double dph1, double dph2, double dv1, double dv2, double da1, double dr1) {
        return ClosedBranchSide2ReactiveFlowEquationTerm.calculateSensi(this.y, this.ksi, this.b2, this.v1(), this.ph1(), this.r1(), this.a1(), this.v2(), this.ph2(), dph1, dph2, dv1, dv2, da1, dr1);
    }

    public static double q2(double y, double cosKsi, double b2, double v1, double r1, double v2, double cosTheta) {
        return 1.0 * v2 * (-b2 * 1.0 * v2 - y * r1 * v1 * cosTheta + y * 1.0 * v2 * cosKsi);
    }

    public static double dq2dv1(double y, double r1, double v2, double cosTheta) {
        return -y * r1 * 1.0 * v2 * cosTheta;
    }

    public static double dq2dv2(double y, double cosKsi, double b2, double v1, double r1, double v2, double cosTheta) {
        return 1.0 * (-2.0 * b2 * 1.0 * v2 - y * r1 * v1 * cosTheta + 2.0 * y * 1.0 * v2 * cosKsi);
    }

    public static double dq2dph1(double y, double v1, double r1, double v2, double sinTheta) {
        return y * r1 * 1.0 * v1 * v2 * sinTheta;
    }

    public static double dq2dph2(double y, double v1, double r1, double v2, double sinTheta) {
        return -ClosedBranchSide2ReactiveFlowEquationTerm.dq2dph1(y, v1, r1, v2, sinTheta);
    }

    public static double dq2da1(double y, double v1, double r1, double v2, double sinTheta) {
        return ClosedBranchSide2ReactiveFlowEquationTerm.dq2dph1(y, v1, r1, v2, sinTheta);
    }

    public static double dq2dr1(double y, double v1, double v2, double cosTheta) {
        return -y * 1.0 * v1 * v2 * cosTheta;
    }

    @Override
    public double eval() {
        return ClosedBranchSide2ReactiveFlowEquationTerm.q2(this.y, FastMath.cos((double)this.ksi), this.b2, this.v1(), this.r1(), this.v2(), FastMath.cos((double)ClosedBranchSide2ReactiveFlowEquationTerm.theta2(this.ksi, this.ph1(), this.a1(), this.ph2())));
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        double theta = ClosedBranchSide2ReactiveFlowEquationTerm.theta2(this.ksi, this.ph1(), this.a1(), this.ph2());
        if (variable.equals(this.v1Var)) {
            return ClosedBranchSide2ReactiveFlowEquationTerm.dq2dv1(this.y, this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.v2Var)) {
            return ClosedBranchSide2ReactiveFlowEquationTerm.dq2dv2(this.y, FastMath.cos((double)this.ksi), this.b2, this.v1(), this.r1(), this.v2(), FastMath.cos((double)theta));
        }
        if (variable.equals(this.ph1Var)) {
            return ClosedBranchSide2ReactiveFlowEquationTerm.dq2dph1(this.y, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.ph2Var)) {
            return ClosedBranchSide2ReactiveFlowEquationTerm.dq2dph2(this.y, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.a1Var)) {
            return ClosedBranchSide2ReactiveFlowEquationTerm.dq2da1(this.y, this.v1(), this.r1(), this.v2(), FastMath.sin((double)theta));
        }
        if (variable.equals(this.r1Var)) {
            return ClosedBranchSide2ReactiveFlowEquationTerm.dq2dr1(this.y, this.v1(), this.v2(), FastMath.cos((double)theta));
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_q_closed_2";
    }
}

