/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractHvdcAcEmulationFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;
import java.util.Objects;

public class HvdcAcEmulationSide1ActiveFlowEquationTerm
extends AbstractHvdcAcEmulationFlowEquationTerm {
    public HvdcAcEmulationSide1ActiveFlowEquationTerm(LfHvdc hvdc, LfBus bus1, LfBus bus2, VariableSet<AcVariableType> variableSet) {
        super(hvdc, bus1, bus2, variableSet);
    }

    private double p1(double ph1, double ph2) {
        double rawP = this.rawP(ph1, ph2);
        return HvdcAcEmulationSide1ActiveFlowEquationTerm.isController(rawP) ? this.boundedP(rawP) : -this.getAbsActivePowerWithLosses(this.boundedP(rawP), this.lossFactor1, this.lossFactor2);
    }

    private static boolean isController(double rawP) {
        return rawP >= 0.0;
    }

    private boolean isInOperatingRange(double rawP) {
        return rawP < this.pMaxFromCS1toCS2 && rawP > -this.pMaxFromCS2toCS1;
    }

    protected double dp1dph1(double ph1, double ph2) {
        double rawP = this.rawP(ph1, ph2);
        if (this.isInOperatingRange(rawP)) {
            return (HvdcAcEmulationSide1ActiveFlowEquationTerm.isController(rawP) ? 1.0 : this.getVscLossMultiplier()) * this.k;
        }
        return 0.0;
    }

    protected double dp1dph2(double ph1, double ph2) {
        return -this.dp1dph1(ph1, ph2);
    }

    @Override
    public double eval() {
        return this.p1(this.ph1(), this.ph2());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.ph1Var)) {
            return this.dp1dph1(this.ph1(), this.ph2());
        }
        if (variable.equals(this.ph2Var)) {
            return this.dp1dph2(this.ph1(), this.ph2());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_emulation_p_1";
    }
}

