/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractOpenSide2BranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import java.util.Objects;
import net.jafama.FastMath;

public class OpenBranchSide2ActiveFlowEquationTerm
extends AbstractOpenSide2BranchAcFlowEquationTerm {
    private final Variable<AcVariableType> v1Var;

    public OpenBranchSide2ActiveFlowEquationTerm(LfBranch branch, LfBus bus1, VariableSet<AcVariableType> variableSet) {
        super(branch, AcVariableType.BUS_V, bus1, variableSet);
        this.v1Var = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_V);
    }

    private double v1() {
        return this.sv.get(this.v1Var.getRow());
    }

    private double r1() {
        return ((LfBranch)this.element).getPiModel().getR1();
    }

    public static double p1(double y, double cosKsi, double sinKsi, double g1, double g2, double b2, double v1, double r1) {
        double shunt = OpenBranchSide2ActiveFlowEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return r1 * r1 * v1 * v1 * (g1 + y * y * g2 / shunt + (b2 * b2 + g2 * g2) * y * sinKsi / shunt);
    }

    public static double dp1dv1(double y, double cosKsi, double sinKsi, double g1, double g2, double b2, double v1, double r1) {
        double shunt = OpenBranchSide2ActiveFlowEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return 2.0 * r1 * r1 * v1 * (g1 + y * y * g2 / shunt + (b2 * b2 + g2 * g2) * y * sinKsi / shunt);
    }

    @Override
    public double eval() {
        return OpenBranchSide2ActiveFlowEquationTerm.p1(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.g2, this.b2, this.v1(), this.r1());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var)) {
            return OpenBranchSide2ActiveFlowEquationTerm.dp1dv1(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.g2, this.b2, this.v1(), this.r1());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_p_open_2";
    }
}

