/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractOpenSide2BranchAcFlowEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import java.util.Objects;
import net.jafama.FastMath;

public class OpenBranchSide2CurrentMagnitudeEquationTerm
extends AbstractOpenSide2BranchAcFlowEquationTerm {
    private final Variable<AcVariableType> v1Var;
    private final Variable<AcVariableType> ph1Var;
    private Variable<AcVariableType> r1Var;

    public OpenBranchSide2CurrentMagnitudeEquationTerm(LfBranch branch, LfBus bus1, VariableSet<AcVariableType> variableSet, boolean deriveR1) {
        super(branch, AcVariableType.BUS_V, bus1, variableSet);
        this.v1Var = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_V);
        this.ph1Var = variableSet.getVariable(bus1.getNum(), AcVariableType.BUS_PHI);
        if (deriveR1) {
            this.r1Var = variableSet.getVariable(branch.getNum(), AcVariableType.BRANCH_RHO1);
        }
    }

    private double v1() {
        return this.sv.get(this.v1Var.getRow());
    }

    private double ph1() {
        return this.sv.get(this.ph1Var.getRow());
    }

    private double r1() {
        return this.r1Var != null ? this.sv.get(this.r1Var.getRow()) : ((LfBranch)this.element).getPiModel().getR1();
    }

    private static double gres(double y, double sinksi, double g1, double g2, double b2, double shunt) {
        return g1 + (y * y * g2 + (b2 * b2 + g2 * g2) * y * sinksi) / shunt;
    }

    private static double bres(double y, double cosKsi, double b1, double g2, double b2, double shunt) {
        return b1 + (y * y * b2 - (b2 * b2 + g2 * g2) * y * cosKsi) / shunt;
    }

    private static double reI1(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v1, double ph1, double r1) {
        double shunt = OpenBranchSide2CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return r1 * r1 * v1 * (OpenBranchSide2CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, g2, b2, shunt) * FastMath.cos((double)ph1) - OpenBranchSide2CurrentMagnitudeEquationTerm.bres(y, cosKsi, b1, g2, b2, shunt) * FastMath.sin((double)ph1));
    }

    private static double imI1(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v1, double ph1, double r1) {
        double shunt = OpenBranchSide2CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return r1 * r1 * v1 * (OpenBranchSide2CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, g2, b2, shunt) * FastMath.sin((double)ph1) + OpenBranchSide2CurrentMagnitudeEquationTerm.bres(y, cosKsi, b1, g2, b2, shunt) * FastMath.cos((double)ph1));
    }

    private static double i1(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v1, double ph1, double r1) {
        return FastMath.hypot((double)OpenBranchSide2CurrentMagnitudeEquationTerm.reI1(y, cosKsi, sinKsi, g1, b1, g2, b2, v1, ph1, r1), (double)OpenBranchSide2CurrentMagnitudeEquationTerm.imI1(y, cosKsi, sinKsi, g1, b1, g2, b2, v1, ph1, r1));
    }

    private static double dreI1dv1(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double ph1, double r1) {
        double shunt = OpenBranchSide2CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return r1 * r1 * (OpenBranchSide2CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, g2, b2, shunt) * FastMath.cos((double)ph1) - OpenBranchSide2CurrentMagnitudeEquationTerm.bres(y, cosKsi, b1, g2, b2, shunt) * FastMath.sin((double)ph1));
    }

    private static double dimI1dv1(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double ph1, double r1) {
        double shunt = OpenBranchSide2CurrentMagnitudeEquationTerm.shunt(y, cosKsi, sinKsi, g2, b2);
        return r1 * r1 * (OpenBranchSide2CurrentMagnitudeEquationTerm.gres(y, sinKsi, g1, g2, b2, shunt) * FastMath.sin((double)ph1) + OpenBranchSide2CurrentMagnitudeEquationTerm.bres(y, cosKsi, b1, g2, b2, shunt) * FastMath.cos((double)ph1));
    }

    public static double di1dv1(double y, double cosKsi, double sinKsi, double g1, double b1, double g2, double b2, double v1, double ph1, double r1) {
        return (OpenBranchSide2CurrentMagnitudeEquationTerm.reI1(y, cosKsi, sinKsi, g1, b1, g2, b2, v1, ph1, r1) * OpenBranchSide2CurrentMagnitudeEquationTerm.dreI1dv1(y, cosKsi, sinKsi, g1, b1, g2, b2, ph1, r1) + OpenBranchSide2CurrentMagnitudeEquationTerm.imI1(y, cosKsi, sinKsi, g1, b1, g2, b2, v1, ph1, r1) * OpenBranchSide2CurrentMagnitudeEquationTerm.dimI1dv1(y, cosKsi, sinKsi, g1, b1, g2, b2, ph1, r1)) / OpenBranchSide2CurrentMagnitudeEquationTerm.i1(y, cosKsi, sinKsi, g1, b1, g2, b2, v1, ph1, r1);
    }

    @Override
    public double eval() {
        return OpenBranchSide2CurrentMagnitudeEquationTerm.i1(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.b1, this.g2, this.b2, this.v1(), this.ph1(), this.r1());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.v1Var)) {
            return OpenBranchSide2CurrentMagnitudeEquationTerm.di1dv1(this.y, FastMath.cos((double)this.ksi), FastMath.sin((double)this.ksi), this.g1, this.b1, this.g2, this.b2, this.v1(), this.ph1(), this.r1());
        }
        if (variable.equals(this.ph1Var) || variable.equals(this.r1Var)) {
            throw new IllegalArgumentException("Derivative with respect to ph1 or r1 not implemented");
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_i_open_2";
    }
}

