/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.ac.equations;

import com.powsybl.openloadflow.ac.equations.AbstractShuntCompensatorEquationTerm;
import com.powsybl.openloadflow.ac.equations.AcVariableType;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfShunt;
import java.util.List;
import java.util.Objects;

public class ShuntCompensatorActiveFlowEquationTerm
extends AbstractShuntCompensatorEquationTerm {
    private final List<Variable<AcVariableType>> variables;

    public ShuntCompensatorActiveFlowEquationTerm(LfShunt shunt, LfBus bus, VariableSet<AcVariableType> variableSet) {
        super(shunt, bus, variableSet);
        this.variables = List.of(this.vVar);
    }

    @Override
    public List<Variable<AcVariableType>> getVariables() {
        return this.variables;
    }

    private double g() {
        return ((LfShunt)this.element).getG();
    }

    public static double p(double v, double g) {
        return g * v * v;
    }

    public static double dpdv(double v, double g) {
        return 2.0 * g * v;
    }

    @Override
    public double eval() {
        return ShuntCompensatorActiveFlowEquationTerm.p(this.v(), this.g());
    }

    @Override
    public double der(Variable<AcVariableType> variable) {
        Objects.requireNonNull(variable);
        if (variable.equals(this.vVar)) {
            return ShuntCompensatorActiveFlowEquationTerm.dpdv(this.v(), this.g());
        }
        throw new IllegalStateException("Unknown variable: " + variable);
    }

    @Override
    protected String getName() {
        return "ac_p_shunt";
    }
}

